/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ForStatementImpl
extends PyTree
implements ForStatement {
    private final Token forKeyword;
    private final List<Expression> expressions;
    private final List<Token> expressionsCommas;
    private final Token inKeyword;
    private final List<Expression> testExpressions;
    private final List<Token> testExpressionsCommas;
    private final Token colon;
    private final Token firstNewLine;
    private final Token firstIndent;
    private final StatementList body;
    private final Token firstDedent;
    private final ElseClause elseClause;
    private final Token asyncKeyword;
    private final boolean isAsync;

    public ForStatementImpl(Token forKeyword, List<Expression> expressions, List<Token> expressionsCommas, Token inKeyword, List<Expression> testExpressions, List<Token> testExpressionsCommas, Token colon, @Nullable Token firstNewLine, @Nullable Token firstIndent, StatementList body, @Nullable Token firstDedent, @Nullable ElseClause elseClause, @Nullable Token asyncKeyword) {
        this.forKeyword = forKeyword;
        this.expressions = expressions;
        this.expressionsCommas = expressionsCommas;
        this.inKeyword = inKeyword;
        this.testExpressions = testExpressions;
        this.testExpressionsCommas = testExpressionsCommas;
        this.colon = colon;
        this.firstNewLine = firstNewLine;
        this.firstIndent = firstIndent;
        this.body = body;
        this.firstDedent = firstDedent;
        this.elseClause = elseClause;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Token forKeyword() {
        return this.forKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Token inKeyword() {
        return this.inKeyword;
    }

    @Override
    public List<Expression> testExpressions() {
        return this.testExpressions;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public ElseClause elseClause() {
        return this.elseClause;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public List<Tree> computeChildren() {
        List<Tree> expressionsWithCommas = ForStatementImpl.addCommas(this.expressions, this.expressionsCommas);
        List<Tree> testExpressionsWithCommas = ForStatementImpl.addCommas(this.testExpressions, this.testExpressionsCommas);
        return Stream.of(Arrays.asList(this.asyncKeyword, this.forKeyword), expressionsWithCommas, Collections.singletonList(this.inKeyword), testExpressionsWithCommas, Arrays.asList(this.colon, this.firstNewLine, this.firstIndent, this.body, this.firstDedent, this.elseClause)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<Tree> addCommas(List<Expression> expressions, List<Token> commas) {
        ArrayList<Tree> expressionsWithSeparator = new ArrayList<Tree>();
        int index = 0;
        for (Expression expression : expressions) {
            expressionsWithSeparator.add(expression);
            if (index < commas.size()) {
                expressionsWithSeparator.add(commas.get(index));
            }
            ++index;
        }
        return expressionsWithSeparator;
    }
}

