/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

public abstract class PyTree
implements Tree {
    protected Token firstToken;
    protected Token lastToken;
    private List<Tree> childs;
    private Tree parent = null;

    protected PyTree() {
    }

    @Override
    public boolean is(Tree.Kind ... kinds) {
        Tree.Kind treeKind = this.getKind();
        for (Tree.Kind kindIter : kinds) {
            if (treeKind != kindIter) continue;
            return true;
        }
        return false;
    }

    @Override
    public Token firstToken() {
        if (this.firstToken == null) {
            List<Tree> children = this.children();
            if (children.isEmpty()) {
                this.firstToken = null;
            } else {
                Tree first = children.get(0);
                this.firstToken = first.is(Tree.Kind.TOKEN) ? (Token)first : first.firstToken();
            }
        }
        return this.firstToken;
    }

    @Override
    public Token lastToken() {
        if (this.lastToken == null) {
            List<Tree> children = this.children();
            if (children.isEmpty()) {
                this.firstToken = null;
            } else {
                Tree last = children.get(children.size() - 1);
                this.lastToken = last.is(Tree.Kind.TOKEN) ? (Token)last : last.lastToken();
            }
        }
        return this.lastToken;
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    protected void setParent(Tree parent) {
        this.parent = parent;
    }

    abstract List<Tree> computeChildren();

    @Override
    public List<Tree> children() {
        if (this.childs == null) {
            this.childs = this.computeChildren();
        }
        return this.childs;
    }
}

