/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.tree.SliceList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class SliceListImpl
extends PyTree
implements SliceList {
    private final List<Tree> slices;
    private final List<Token> separators;

    public SliceListImpl(List<Tree> slices, List<Token> separators) {
        this.slices = slices;
        this.separators = separators;
    }

    @Override
    public List<Tree> slices() {
        return this.slices;
    }

    @Override
    public List<Token> separators() {
        return this.separators;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSliceList(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        int i = 0;
        for (Tree argument : this.slices) {
            children.add(argument);
            if (i < this.separators.size()) {
                children.add(this.separators.get(i));
            }
            ++i;
        }
        return children;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SLICE_LIST;
    }
}

