/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.cfg.fixpoint.ProgramState;

public class TypeInferenceProgramState
implements ProgramState {
    private final Map<Symbol, Set<InferredType>> inferredTypesBySymbol = new HashMap<Symbol, Set<InferredType>>();

    TypeInferenceProgramState() {
    }

    void setTypes(Symbol symbol, Set<InferredType> types) {
        this.inferredTypesBySymbol.put(symbol, types);
    }

    Set<InferredType> getTypes(@Nullable Symbol symbol) {
        return this.inferredTypesBySymbol.getOrDefault(symbol, Collections.emptySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInferenceProgramState that = (TypeInferenceProgramState)o;
        return Objects.equals(this.inferredTypesBySymbol, that.inferredTypesBySymbol);
    }

    public int hashCode() {
        return Objects.hash(this.inferredTypesBySymbol);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Symbol, Set<InferredType>> entry : this.inferredTypesBySymbol.entrySet()) {
            Symbol symbol = entry.getKey();
            Set<InferredType> inferredTypes = entry.getValue();
            result.append(symbol.name()).append(" = ").append(inferredTypes.stream().map(Objects::toString).collect(Collectors.joining(", "))).append(System.lineSeparator());
        }
        return result.toString();
    }

    @Override
    public ProgramState join(ProgramState otherState) {
        TypeInferenceProgramState result = new TypeInferenceProgramState();
        ((TypeInferenceProgramState)otherState).inferredTypesBySymbol.forEach((symbol, types) -> {
            HashSet<InferredType> union = new HashSet<InferredType>((Collection<InferredType>)types);
            union.addAll(this.inferredTypesBySymbol.getOrDefault(symbol, Collections.emptySet()));
            result.setTypes((Symbol)symbol, (Set<InferredType>)union);
        });
        this.inferredTypesBySymbol.forEach((symbol, types) -> {
            if (!result.inferredTypesBySymbol.containsKey(symbol)) {
                result.setTypes((Symbol)symbol, (Set<InferredType>)types);
            }
        });
        return result;
    }

    @Override
    public ProgramState copy() {
        return this.join(new TypeInferenceProgramState());
    }
}

