/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.ObjectArrayList;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;

public class CollectionUtils {
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static void sortAndDedup(ObjectArrayList<byte[]> array) {
        int len = array.size();
        if (len > 1) {
            CollectionUtils.sort(array);
            int uniqueCount = 1;
            for (int i = 1; i < len; ++i) {
                if (Arrays.equals((byte[])array.get(i), (byte[])array.get(i - 1))) continue;
                array.set(uniqueCount++, (Object)((byte[])array.get(i)));
            }
            array.elementsCount = uniqueCount;
        }
    }

    public static void sort(final ObjectArrayList<byte[]> array) {
        new IntroSorter(){
            byte[] pivot;

            protected void swap(int i, int j) {
                byte[] tmp = (byte[])array.get(i);
                array.set(i, (Object)((byte[])array.get(j)));
                array.set(j, (Object)tmp);
            }

            protected int compare(int i, int j) {
                return this.compare((byte[])array.get(i), (byte[])array.get(j));
            }

            protected void setPivot(int i) {
                this.pivot = (byte[])array.get(i);
            }

            protected int comparePivot(int j) {
                return this.compare(this.pivot, (byte[])array.get(j));
            }

            private int compare(byte[] left, byte[] right) {
                int i = 0;
                for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                    int a = left[i] & 0xFF;
                    int b = right[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return left.length - right.length;
            }
        }.sort(0, array.size());
    }

    public static int[] toArray(Collection<Integer> ints) {
        Objects.requireNonNull(ints);
        return ints.stream().mapToInt(s -> s).toArray();
    }

    public static void ensureNoSelfReferences(Object value, String messageHint) {
        Iterable<?> it = CollectionUtils.convert(value);
        if (it != null) {
            CollectionUtils.ensureNoSelfReferences(it, value, Collections.newSetFromMap(new IdentityHashMap()), messageHint);
        }
    }

    private static Iterable<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return () -> Iterators.concat(map.keySet().iterator(), map.values().iterator());
        }
        if (value instanceof Iterable && !(value instanceof Path)) {
            return (Iterable)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    private static void ensureNoSelfReferences(Iterable<?> value, Object originalReference, Set<Object> ancestors, String messageHint) {
        if (value != null) {
            if (!ancestors.add(originalReference)) {
                String suffix = Strings.isNullOrEmpty(messageHint) ? "" : String.format(Locale.ROOT, " (%s)", messageHint);
                throw new IllegalArgumentException("Iterable object is self-referencing itself" + suffix);
            }
            for (Object o : value) {
                CollectionUtils.ensureNoSelfReferences(CollectionUtils.convert(o), o, ancestors, messageHint);
            }
            ancestors.remove(originalReference);
        }
    }

    public static <R, T> Map<R, T> copyMap(Map<R, T> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<R, T>(map));
    }

    public static void sort(BytesRefArray bytes, int[] indices) {
        CollectionUtils.sort(new BytesRefBuilder(), new BytesRefBuilder(), bytes, indices);
    }

    private static void sort(final BytesRefBuilder scratch, final BytesRefBuilder scratch1, final BytesRefArray bytes, final int[] indices) {
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues > 1) {
            new InPlaceMergeSorter(){
                final Comparator<BytesRef> comparator = Comparator.naturalOrder();

                protected int compare(int i, int j) {
                    return this.comparator.compare(bytes.get(scratch, indices[i]), bytes.get(scratch1, indices[j]));
                }

                protected void swap(int i, int j) {
                    int value_i = indices[i];
                    indices[i] = indices[j];
                    indices[j] = value_i;
                }
            }.sort(0, numValues);
        }
    }

    public static int sortAndDedup(BytesRefArray bytes, int[] indices) {
        BytesRefBuilder scratch = new BytesRefBuilder();
        BytesRefBuilder scratch1 = new BytesRefBuilder();
        int numValues = bytes.size();
        assert (indices.length >= numValues);
        if (numValues <= 1) {
            return numValues;
        }
        CollectionUtils.sort(scratch, scratch1, bytes, indices);
        int uniqueCount = 1;
        BytesRefBuilder previous = scratch;
        BytesRefBuilder current = scratch1;
        bytes.get(previous, indices[0]);
        for (int i = 1; i < numValues; ++i) {
            bytes.get(current, indices[i]);
            if (!previous.get().equals((Object)current.get())) {
                indices[uniqueCount++] = indices[i];
            }
            BytesRefBuilder tmp = previous;
            previous = current;
            current = tmp;
        }
        return uniqueCount;
    }

    public static <E> ArrayList<E> iterableAsArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> arrayAsArrayList(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <E> ArrayList<E> asArrayList(E first, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(1 + other.length);
        list.add(first);
        list.addAll(Arrays.asList(other));
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> asArrayList(E first, E second, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(2 + other.length);
        list.add(first);
        list.add(second);
        list.addAll(Arrays.asList(other));
        return list;
    }

    public static <E> List<E> appendToCopy(Collection<E> collection, E element) {
        int size = collection.size() + 1;
        Object[] array = collection.toArray(new Object[size]);
        array[size - 1] = element;
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static <E> ArrayList<E> newSingletonArrayList(E element) {
        return new ArrayList<E>(Collections.singletonList(element));
    }

    public static <E> List<List<E>> eagerPartition(List<E> list, int size) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        ArrayList result = new ArrayList((int)Math.ceil(list.size() / size));
        ArrayList<E> accumulator = new ArrayList<E>(size);
        int count = 0;
        for (E element : list) {
            if (count == size) {
                result.add(accumulator);
                accumulator = new ArrayList(size);
                count = 0;
            }
            accumulator.add(element);
            ++count;
        }
        if (count > 0) {
            result.add(accumulator);
        }
        return result;
    }

    public static <E> List<E> concatLists(List<E> listA, List<E> listB) {
        ArrayList<E> concatList = new ArrayList<E>(listA.size() + listB.size());
        concatList.addAll(listA);
        concatList.addAll(listB);
        return concatList;
    }

    public static <E> List<E> wrapUnmodifiableOrEmptySingleton(List<E> list) {
        return list.isEmpty() ? org.elasticsearch.core.List.of() : Collections.unmodifiableList(list);
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

