/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class KeySetPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final Collection<? extends PublicKey> keySet;
    private final Object id;

    public KeySetPublickeyAuthenticator(Object id, Collection<? extends PublicKey> keySet) {
        this.id = id;
        this.keySet = keySet == null ? Collections.emptyList() : keySet;
    }

    public Object getId() {
        return this.id;
    }

    public final Collection<? extends PublicKey> getKeySet() {
        return this.keySet;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        return this.authenticate(username, key, session, this.getKeySet());
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session, Collection<? extends PublicKey> keys2) {
        boolean matchFound;
        if (GenericUtils.isEmpty(keys2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no keys", (Object)username, (Object)session);
            }
            return false;
        }
        PublicKey matchKey = KeyUtils.findMatchingKey(key, keys2);
        boolean bl = matchFound = matchKey != null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({})[{}] match found={}", username, session, matchFound);
        }
        return matchFound;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

