/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.IndexedFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.utils.PathUtils;

@Immutable
public class DefaultIndexedFile
extends DefaultInputComponent
implements IndexedFile {
    private static final Integer MAX_KEY_LENGTH = 400;
    private static final AtomicInteger intGenerator = new AtomicInteger(0);
    private final String projectRelativePath;
    private final String moduleRelativePath;
    private final String projectKey;
    private final String language;
    private final InputFile.Type type;
    private final Path absolutePath;
    private final SensorStrategy sensorStrategy;
    private final String oldRelativeFilePath;

    public DefaultIndexedFile(String projectKey, Path baseDir, String relativePath, @Nullable String language) {
        this(baseDir.resolve(relativePath), projectKey, relativePath, relativePath, InputFile.Type.MAIN, language, intGenerator.getAndIncrement(), new SensorStrategy(), null);
    }

    public DefaultIndexedFile(Path absolutePath, String projectKey, String projectRelativePath, String moduleRelativePath, InputFile.Type type, @Nullable String language, int batchId, SensorStrategy sensorStrategy) {
        this(absolutePath, projectKey, projectRelativePath, moduleRelativePath, type, language, batchId, sensorStrategy, null);
    }

    public DefaultIndexedFile(Path absolutePath, String projectKey, String projectRelativePath, String moduleRelativePath, InputFile.Type type, @Nullable String language, int batchId, SensorStrategy sensorStrategy, @Nullable String oldRelativeFilePath) {
        super(batchId);
        this.projectKey = projectKey;
        this.projectRelativePath = PathUtils.sanitize(projectRelativePath);
        this.moduleRelativePath = PathUtils.sanitize(moduleRelativePath);
        this.type = type;
        this.language = language;
        this.sensorStrategy = sensorStrategy;
        this.absolutePath = absolutePath;
        this.oldRelativeFilePath = oldRelativeFilePath;
        this.validateKeyLength();
    }

    private void validateKeyLength() {
        String key = this.key();
        if (key.length() > MAX_KEY_LENGTH) {
            throw new IllegalStateException(String.format("Component key (%s) length (%s) is longer than the maximum authorized (%s)", key, key.length(), MAX_KEY_LENGTH));
        }
    }

    @Override
    public String relativePath() {
        return this.sensorStrategy.isGlobal() ? this.projectRelativePath : this.moduleRelativePath;
    }

    public String getModuleRelativePath() {
        return this.moduleRelativePath;
    }

    public String getProjectRelativePath() {
        return this.projectRelativePath;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        return this.absolutePath;
    }

    @CheckForNull
    public String oldRelativePath() {
        return this.oldRelativeFilePath;
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path(), new OpenOption[0]);
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public String key() {
        return String.join((CharSequence)":", this.projectKey, this.projectRelativePath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DefaultIndexedFile that = (DefaultIndexedFile)o;
        return this.projectRelativePath.equals(that.projectRelativePath);
    }

    @Override
    public int hashCode() {
        return this.projectRelativePath.hashCode();
    }

    @Override
    public String toString() {
        return this.projectRelativePath;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public String filename() {
        return this.path().getFileName().toString();
    }

    @Override
    public URI uri() {
        return this.path().toUri();
    }
}

