/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.NewMessageFormatting;
import org.sonar.api.batch.sensor.issue.internal.DefaultMessageFormatting;
import org.sonar.api.utils.Preconditions;

public class DefaultIssueLocation
implements NewIssueLocation,
IssueLocation {
    private InputComponent component;
    private TextRange textRange;
    private String message;
    private final List<MessageFormatting> messageFormattings = new ArrayList<MessageFormatting>();

    @Override
    public DefaultIssueLocation on(InputComponent component) {
        Preconditions.checkArgument(component != null, "Component can't be null");
        Preconditions.checkState(this.component == null, "on() already called");
        this.component = component;
        return this;
    }

    @Override
    public DefaultIssueLocation at(TextRange location) {
        Preconditions.checkState(this.component != null, "at() should be called after on()");
        Preconditions.checkState(this.component.isFile(), "at() should be called only for an InputFile.");
        DefaultInputFile file = (DefaultInputFile)this.component;
        file.validate(location);
        this.textRange = location;
        return this;
    }

    @Override
    public DefaultIssueLocation message(String message) {
        this.validateMessage(message);
        this.message = StringUtils.abbreviate(StringUtils.trim(message), 1333);
        return this;
    }

    @Override
    public DefaultIssueLocation message(String message, List<NewMessageFormatting> newMessageFormattings) {
        this.validateMessage(message);
        DefaultIssueLocation.validateFormattings(newMessageFormattings, message);
        this.message = StringUtils.abbreviate(message, 1333);
        for (NewMessageFormatting newMessageFormatting : newMessageFormattings) {
            DefaultMessageFormatting messageFormatting = (DefaultMessageFormatting)newMessageFormatting;
            if (messageFormatting.start() > 1333) continue;
            if (messageFormatting.end() > 1333) {
                messageFormatting = new DefaultMessageFormatting().start(messageFormatting.start()).end(1333).type(messageFormatting.type());
            }
            this.messageFormattings.add(messageFormatting);
        }
        return this;
    }

    private static void validateFormattings(List<NewMessageFormatting> newMessageFormattings, String message) {
        Preconditions.checkArgument(newMessageFormattings != null, "messageFormattings can't be null");
        newMessageFormattings.stream().map(DefaultMessageFormatting.class::cast).forEach(e -> e.validate(message));
    }

    private void validateMessage(String message) {
        Objects.requireNonNull(message, "Message can't be null");
        if (message.contains("\u0000")) {
            throw new IllegalArgumentException(DefaultIssueLocation.unsupportedCharacterError(message, this.component));
        }
    }

    @Override
    public NewMessageFormatting newMessageFormatting() {
        return new DefaultMessageFormatting();
    }

    private static String unsupportedCharacterError(String message, @Nullable InputComponent component) {
        String error = "Character \\u0000 is not supported in issue message '" + message + "'";
        if (component != null) {
            error = error + ", on component: " + component.toString();
        }
        return error;
    }

    @Override
    public InputComponent inputComponent() {
        return this.component;
    }

    @Override
    public TextRange textRange() {
        return this.textRange;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<MessageFormatting> messageFormattings() {
        return this.messageFormattings;
    }
}

