/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.symbol.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.utils.Preconditions;

public class DefaultSymbolTable
extends DefaultStorable
implements NewSymbolTable {
    private final Map<TextRange, Set<TextRange>> referencesBySymbol = new LinkedHashMap<TextRange, Set<TextRange>>();
    private DefaultInputFile inputFile;

    public DefaultSymbolTable(SensorStorage storage) {
        super(storage);
    }

    public Map<TextRange, Set<TextRange>> getReferencesBySymbol() {
        return this.referencesBySymbol;
    }

    @Override
    public DefaultSymbolTable onFile(InputFile inputFile) {
        Objects.requireNonNull(inputFile, "file can't be null");
        this.inputFile = (DefaultInputFile)inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public NewSymbol newSymbol(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        TextRange declarationRange;
        this.checkInputFileNotNull();
        try {
            declarationRange = this.inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create symbol on file " + this.inputFile, e);
        }
        return this.newSymbol(declarationRange);
    }

    @Override
    public NewSymbol newSymbol(TextRange range) {
        this.checkInputFileNotNull();
        TreeSet<TextRange> references = new TreeSet<TextRange>((o1, o2) -> o1.start().compareTo(o2.start()));
        this.referencesBySymbol.put(range, references);
        return new DefaultSymbol(this.inputFile, range, references);
    }

    @Override
    protected void doSave() {
        this.checkInputFileNotNull();
        this.storage.store(this);
    }

    private void checkInputFileNotNull() {
        Preconditions.checkState(this.inputFile != null, "Call onFile() first");
    }

    private static class DefaultSymbol
    implements NewSymbol {
        private final Collection<TextRange> references;
        private final DefaultInputFile inputFile;
        private final TextRange declaration;

        public DefaultSymbol(DefaultInputFile inputFile, TextRange declaration, Collection<TextRange> references) {
            this.inputFile = inputFile;
            this.declaration = declaration;
            this.references = references;
        }

        @Override
        public NewSymbol newReference(int startLine, int startLineOffset, int endLine, int endLineOffset) {
            TextRange referenceRange;
            try {
                referenceRange = this.inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create symbol reference on file " + this.inputFile, e);
            }
            return this.newReference(referenceRange);
        }

        @Override
        public NewSymbol newReference(TextRange range) {
            Objects.requireNonNull(range, "Provided range is null");
            Preconditions.checkArgument(!this.declaration.overlap(range), "Overlapping symbol declaration and reference for symbol at %s", this.declaration);
            this.references.add(range);
            return this;
        }
    }
}

