/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.core.platform.Container;
import org.sonar.core.platform.ExtensionContainer;
import org.sonar.core.platform.Module;
import org.sonar.core.platform.PluginInfo;

public class ListContainer
implements ExtensionContainer {
    private final List<Object> objects = new ArrayList<Object>();

    @Override
    public Container add(Object ... objects) {
        for (Object o : objects) {
            if (o instanceof Module) {
                ((Module)o).configure(this);
                continue;
            }
            if (o instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)o, Object.class));
                continue;
            }
            this.objects.add(o);
        }
        return this;
    }

    public List<Object> getAddedObjects() {
        return Collections.unmodifiableList(new ArrayList<Object>(this.objects));
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Optional<T> getOptionalComponentByType(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> getComponentsByType(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtensionContainer addExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.add(extension);
        return this;
    }

    @Override
    public ExtensionContainer addExtension(@Nullable String defaultCategory, Object extension) {
        this.add(extension);
        return this;
    }

    @Override
    public ExtensionContainer declareExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        return this;
    }

    @Override
    public ExtensionContainer declareExtension(@Nullable String defaultCategory, Object extension) {
        return this;
    }

    @Override
    public ExtensionContainer getParent() {
        throw new UnsupportedOperationException();
    }
}

