/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.BlockChunker;
import org.sonar.duplications.java.JavaStatementBuilder;
import org.sonar.duplications.java.JavaTokenProducer;
import org.sonar.duplications.statement.Statement;
import org.sonar.duplications.statement.StatementChunker;
import org.sonar.duplications.token.TokenChunker;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;

@Phase(name=Phase.Name.POST)
public class JavaCpdBlockIndexerSensor
implements ProjectSensor {
    private static final int BLOCK_SIZE = 10;
    private static final Logger LOG = LoggerFactory.getLogger(JavaCpdBlockIndexerSensor.class);
    private final SonarCpdBlockIndex index;

    public JavaCpdBlockIndexerSensor(SonarCpdBlockIndex index) {
        this.index = index;
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Java CPD Block Indexer").onlyOnLanguage("java");
    }

    @Override
    public void execute(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        List<InputFile> sourceFiles = StreamSupport.stream(context.fileSystem().inputFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("java"))).spliterator(), false).filter(f -> !((DefaultInputFile)f).isExcludedForDuplication()).collect(Collectors.toList());
        if (sourceFiles.isEmpty()) {
            return;
        }
        this.createIndex(sourceFiles);
    }

    private void createIndex(Iterable<InputFile> sourceFiles) {
        TokenChunker tokenChunker = JavaTokenProducer.build();
        StatementChunker statementChunker = JavaStatementBuilder.build();
        BlockChunker blockChunker = new BlockChunker(10);
        for (InputFile inputFile : sourceFiles) {
            List<Block> blocks;
            List<Statement> statements;
            LOG.debug("Populating index from {}", (Object)inputFile);
            String resourceEffectiveKey = inputFile.key();
            try (InputStream is = inputFile.inputStream();
                 InputStreamReader reader = new InputStreamReader(is, inputFile.charset());){
                statements = statementChunker.chunk(tokenChunker.chunk(reader));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find file " + inputFile.file(), e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception handling file: " + inputFile.file(), e);
            }
            try {
                blocks = blockChunker.chunk(resourceEffectiveKey, statements);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot process file " + inputFile.file(), e);
            }
            this.index.insert(inputFile, blocks);
        }
    }
}

