/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Preconditions;
import org.sonar.core.sarif.ArtifactLocation;
import org.sonar.core.sarif.Location;
import org.sonar.core.sarif.PhysicalLocation;
import org.sonar.core.sarif.Result;
import org.sonar.scanner.externalissue.sarif.RegionMapper;

@ScannerSide
public class LocationMapper {
    private final SensorContext sensorContext;
    private final RegionMapper regionMapper;

    LocationMapper(SensorContext sensorContext, RegionMapper regionMapper) {
        this.sensorContext = sensorContext;
        this.regionMapper = regionMapper;
    }

    NewIssueLocation fillIssueInProjectLocation(Result result, NewIssueLocation newIssueLocation) {
        return newIssueLocation.message(LocationMapper.getResultMessageOrThrow(result)).on(this.sensorContext.project());
    }

    @CheckForNull
    NewIssueLocation fillIssueInFileLocation(Result result, NewIssueLocation newIssueLocation, Location location) {
        newIssueLocation.message(LocationMapper.getResultMessageOrThrow(result));
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        String fileUri = LocationMapper.getFileUriOrThrow(location);
        InputFile file = LocationMapper.findFile(this.sensorContext, fileUri);
        if (file == null) {
            return null;
        }
        newIssueLocation.on(file);
        this.regionMapper.mapRegion(physicalLocation.getRegion(), file).ifPresent(newIssueLocation::at);
        return newIssueLocation;
    }

    private static String getResultMessageOrThrow(Result result) {
        Objects.requireNonNull(result.getMessage(), "No messages found for issue thrown by rule " + result.getRuleId());
        return Objects.requireNonNull(result.getMessage().getText(), "No text found for messages in issue thrown by rule " + result.getRuleId());
    }

    private static String getFileUriOrThrow(Location location) {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        Preconditions.checkArgument(LocationMapper.hasUriFieldPopulated(physicalLocation), "The field location.physicalLocation.artifactLocation.uri is not set.");
        return physicalLocation.getArtifactLocation().getUri();
    }

    private static boolean hasUriFieldPopulated(@Nullable PhysicalLocation location) {
        return Optional.ofNullable(location).map(PhysicalLocation::getArtifactLocation).map(ArtifactLocation::getUri).isPresent();
    }

    @CheckForNull
    private static InputFile findFile(SensorContext context, String filePath) {
        FilePredicates predicates = context.fileSystem().predicates();
        return context.fileSystem().inputFile(predicates.is(LocationMapper.getFileFromAbsoluteUriOrPath(filePath)));
    }

    private static File getFileFromAbsoluteUriOrPath(String filePath) {
        URI uri = URI.create(filePath);
        if (uri.isAbsolute()) {
            return new File(uri);
        }
        return new File(filePath);
    }
}

