/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.rule.QualityProfiles;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class QProfileVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QProfileVerifier.class);
    private final InputComponentStore store;
    private final QualityProfiles profiles;

    public QProfileVerifier(InputComponentStore store, QualityProfiles profiles) {
        this.store = store;
        this.profiles = profiles;
    }

    public void execute() {
        this.execute(LOG);
    }

    void execute(Logger logger) {
        for (String lang : this.store.languages()) {
            QProfile profile2 = this.profiles.findByLanguage(lang);
            if (profile2 == null) {
                logger.warn("No Quality profile found for language {}", (Object)lang);
                continue;
            }
            logger.info("Quality profile for {}: {}", (Object)lang, (Object)profile2.getName());
        }
    }
}

