/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;

public class ScanProperties {
    public static final String METADATA_FILE_PATH_KEY = "sonar.scanner.metadataFilePath";
    public static final String KEEP_REPORT_PROP_KEY = "sonar.scanner.keepReport";
    public static final String VERBOSE_KEY = "sonar.verbose";
    public static final String METADATA_DUMP_FILENAME = "report-task.txt";
    public static final String SONAR_REPORT_EXPORT_PATH = "sonar.report.export.path";
    public static final String PRELOAD_FILE_METADATA_KEY = "sonar.preloadFileMetadata";
    public static final String FORCE_RELOAD_KEY = "sonar.scm.forceReloadAll";
    public static final String SCM_REVISION = "sonar.scm.revision";
    public static final String QUALITY_GATE_WAIT = "sonar.qualitygate.wait";
    public static final String QUALITY_GATE_TIMEOUT_IN_SEC = "sonar.qualitygate.timeout";
    public static final String REPORT_PUBLISH_TIMEOUT_IN_SEC = "sonar.ws.report.timeout";
    private final Configuration configuration;
    private final DefaultInputProject project;

    public ScanProperties(Configuration configuration, DefaultInputProject project) {
        this.configuration = configuration;
        this.project = project;
    }

    public boolean shouldKeepReport() {
        return this.configuration.getBoolean(KEEP_REPORT_PROP_KEY).orElse(false) != false || this.configuration.getBoolean(VERBOSE_KEY).orElse(false) != false;
    }

    public boolean preloadFileMetadata() {
        return this.configuration.getBoolean(PRELOAD_FILE_METADATA_KEY).orElse(false);
    }

    public Optional<String> branch() {
        return this.configuration.get("sonar.branch.name");
    }

    public Optional<String> get(String propertyKey) {
        return this.configuration.get(propertyKey);
    }

    public Path metadataFilePath() {
        Optional<String> metadataFilePath = this.configuration.get(METADATA_FILE_PATH_KEY);
        if (metadataFilePath.isPresent()) {
            Path metadataPath = Paths.get(metadataFilePath.get(), new String[0]);
            if (!metadataPath.isAbsolute()) {
                throw MessageException.of(String.format("Property '%s' must point to an absolute path: %s", METADATA_FILE_PATH_KEY, metadataFilePath.get()));
            }
            return this.project.getBaseDir().resolve(metadataPath);
        }
        return this.project.getWorkDir().resolve(METADATA_DUMP_FILENAME);
    }

    public boolean shouldWaitForQualityGate() {
        return this.configuration.getBoolean(QUALITY_GATE_WAIT).orElse(false);
    }

    public int qualityGateWaitTimeout() {
        return this.configuration.getInt(QUALITY_GATE_TIMEOUT_IN_SEC).orElse(300);
    }

    public int reportPublishTimeout() {
        return this.configuration.getInt(REPORT_PUBLISH_TIMEOUT_IN_SEC).orElse(60);
    }

    public long fileSizeLimit() {
        return this.configuration.getInt("sonar.filesize.limit").orElse(20).intValue();
    }

    public void validate() {
        this.metadataFilePath();
    }
}

