/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import javax.annotation.Priority;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.core.platform.SpringComponentContainer;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.scan.ModuleConfigurationProvider;
import org.sonar.scanner.scan.MutableModuleSettings;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.ModuleInputComponentStore;
import org.sonar.scanner.sensor.ModuleSensorContext;
import org.sonar.scanner.sensor.ModuleSensorExtensionDictionary;
import org.sonar.scanner.sensor.ModuleSensorOptimizer;
import org.sonar.scanner.sensor.ModuleSensorsExecutor;

@Priority(value=1)
public class SpringModuleScanContainer
extends SpringComponentContainer {
    private final DefaultInputModule module;

    public SpringModuleScanContainer(SpringComponentContainer parent, DefaultInputModule module) {
        super(parent);
        this.module = module;
    }

    @Override
    protected void doBeforeStart() {
        this.addCoreComponents();
        this.addExtensions();
    }

    private void addCoreComponents() {
        this.add(this.module.definition(), this.module, MutableModuleSettings.class, SonarGlobalPropertiesFilter.class, ModuleConfigurationProvider.class, ModuleSensorsExecutor.class, ModuleInputComponentStore.class, FileExclusions.class, DefaultModuleFileSystem.class, ModuleSensorOptimizer.class, ModuleSensorContext.class, ModuleSensorExtensionDictionary.class);
    }

    private void addExtensions() {
        ExtensionInstaller pluginInstaller = this.parent.getComponentByType(ExtensionInstaller.class);
        pluginInstaller.install(this, e -> ExtensionUtils.isDeprecatedScannerSide(e) && ExtensionUtils.isInstantiationStrategy(e, "PER_PROJECT"));
    }

    @Override
    protected void doAfterStart() {
        this.getComponentByType(ModuleSensorsExecutor.class).execute();
    }
}

