/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.ProjectConfiguration;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationLoader;
import org.sonar.scanner.scan.branch.DefaultBranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.springframework.context.annotation.Bean;

public class BranchConfigurationProvider {
    private static final Logger LOG = Loggers.get(BranchConfigurationProvider.class);
    private static final String LOG_MSG = "Load branch configuration";

    @Bean(value={"BranchConfiguration"})
    public BranchConfiguration provide(@Nullable BranchConfigurationLoader loader, ProjectConfiguration projectConfiguration, ProjectBranches branches) {
        if (loader == null) {
            return new DefaultBranchConfiguration();
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        BranchConfiguration branchConfiguration = loader.load(projectConfiguration.getProperties(), branches);
        profiler.stopInfo();
        return branchConfiguration;
    }
}

