/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesRepository;

@ThreadSafe
public class LanguageDetection {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetection.class);
    private final Map<Language, PathPattern[]> patternsByLanguage;
    private final List<Language> languagesToConsider;

    public LanguageDetection(Configuration settings, LanguagesRepository languages) {
        LinkedHashMap<Language, PathPattern[]> patternsByLanguageBuilder = new LinkedHashMap<Language, PathPattern[]>();
        for (Language language : languages.all()) {
            String[] filePatterns = settings.getStringArray(LanguageDetection.getFileLangPatternPropKey(language.key()));
            PathPattern[] pathPatterns = PathPattern.create(filePatterns);
            if (pathPatterns.length > 0) {
                patternsByLanguageBuilder.put(language, pathPatterns);
                continue;
            }
            String[] patterns = language.fileSuffixes().toArray(new String[0]);
            for (int i = 0; i < patterns.length; ++i) {
                String suffix = patterns[i];
                String extension = LanguageDetection.sanitizeExtension(suffix);
                patterns[i] = "**/*." + extension;
            }
            PathPattern[] defaultLanguagePatterns = PathPattern.create(patterns);
            patternsByLanguageBuilder.put(language, defaultLanguagePatterns);
            LOG.debug("Declared extensions of language {} were converted to {}", (Object)language, (Object)LanguageDetection.getDetails(language, defaultLanguagePatterns));
        }
        this.languagesToConsider = List.copyOf(patternsByLanguageBuilder.keySet());
        this.patternsByLanguage = Collections.unmodifiableMap(patternsByLanguageBuilder);
    }

    @CheckForNull
    Language language(Path absolutePath, Path relativePath) {
        Language detectedLanguage = null;
        for (Language language : this.languagesToConsider) {
            if (!this.isCandidateForLanguage(absolutePath, relativePath, language)) continue;
            if (detectedLanguage == null) {
                detectedLanguage = language;
                continue;
            }
            throw MessageException.of(MessageFormat.format("Language of file ''{0}'' can not be decided as the file matches patterns of both {1} and {2}", relativePath, this.getDetails(detectedLanguage), this.getDetails(language)));
        }
        return detectedLanguage;
    }

    private boolean isCandidateForLanguage(Path absolutePath, Path relativePath, Language language) {
        PathPattern[] patterns = this.patternsByLanguage.get(language);
        if (patterns != null) {
            for (PathPattern pathPattern : patterns) {
                if (!pathPattern.match(absolutePath, relativePath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFileLangPatternPropKey(String languageKey) {
        return "sonar.lang.patterns." + languageKey;
    }

    private String getDetails(Language detectedLanguage) {
        return LanguageDetection.getDetails(detectedLanguage, this.patternsByLanguage.get(detectedLanguage));
    }

    private static String getDetails(Language detectedLanguage, PathPattern[] patterns) {
        return LanguageDetection.getFileLangPatternPropKey(detectedLanguage.key()) + " : " + Arrays.stream(patterns).map(Object::toString).collect(Collectors.joining(","));
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

