/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.predicates.ChangedFilePredicate;

public class MutableFileSystem
extends DefaultFileSystem {
    private boolean restrictToChangedFiles = false;

    public MutableFileSystem(Path baseDir, DefaultFileSystem.Cache cache, FilePredicates filePredicates) {
        super(baseDir, cache, filePredicates);
    }

    public MutableFileSystem(Path baseDir) {
        super(baseDir);
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate requestPredicate) {
        if (this.restrictToChangedFiles) {
            return super.inputFiles(new ChangedFilePredicate(requestPredicate));
        }
        return super.inputFiles(requestPredicate);
    }

    @Override
    public InputFile inputFile(FilePredicate requestPredicate) {
        if (this.restrictToChangedFiles) {
            return super.inputFile(new ChangedFilePredicate(requestPredicate));
        }
        return super.inputFile(requestPredicate);
    }

    public void setRestrictToChangedFiles(boolean restrictToChangedFiles) {
        this.restrictToChangedFiles = restrictToChangedFiles;
    }
}

