/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.scm.git.ChangedFile;

@Immutable
public class ScmChangedFiles {
    @Nullable
    private final Collection<ChangedFile> changedFiles;
    private final Map<Path, ChangedFile> changedFilesByPath;

    public ScmChangedFiles(@Nullable Collection<ChangedFile> changedFiles) {
        this.changedFiles = changedFiles;
        this.changedFilesByPath = ScmChangedFiles.toChangedFilesByPathMap(changedFiles);
    }

    public boolean isChanged(Path file) {
        if (!this.isValid()) {
            throw new IllegalStateException("Scm didn't provide valid data");
        }
        return this.getChangedFile(file).isPresent();
    }

    public boolean isValid() {
        return this.changedFiles != null;
    }

    @CheckForNull
    public Collection<ChangedFile> get() {
        return this.changedFiles;
    }

    @CheckForNull
    public String getOldRelativeFilePath(Path absoluteFilePath) {
        return this.getChangedFile(absoluteFilePath).filter(ChangedFile::isMovedFile).map(ChangedFile::getOldRelativeFilePathReference).orElse(null);
    }

    private Optional<ChangedFile> getChangedFile(Path absoluteFilePath) {
        return Optional.ofNullable(this.changedFilesByPath.get(absoluteFilePath));
    }

    private static Map<Path, ChangedFile> toChangedFilesByPathMap(@Nullable Collection<ChangedFile> changedFiles) {
        return Optional.ofNullable(changedFiles).map(files -> files.stream().collect(Collectors.toMap(ChangedFile::getAbsolutFilePath, Function.identity()))).orElse(Collections.emptyMap());
    }
}

