/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.scm.git.IncludedFilesRepository;

@ScannerSide
public class GitIgnoreCommand
implements IgnoreCommand {
    private IncludedFilesRepository includedFilesRepository;

    @Override
    public void init(Path baseDir) {
        try {
            this.includedFilesRepository = new IncludedFilesRepository(baseDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error while indexing ignored files.", e);
        }
    }

    @Override
    public boolean isIgnored(Path absolutePath) {
        return !Objects.requireNonNull(this.includedFilesRepository, "Call init first").contains(absolutePath);
    }

    @Override
    public void clean() {
        this.includedFilesRepository = null;
    }
}

