/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeRecord
implements ISqlJetBtreeRecord {
    private ISqlJetBtreeCursor cursor;
    private boolean isIndex;
    private int fieldsCount = 0;
    private List<Integer> aType = new ArrayList<Integer>();
    private List<Integer> aOffset = new ArrayList<Integer>();
    private List<ISqlJetVdbeMem> fields = new ArrayList<ISqlJetVdbeMem>();
    private int file_format = ISqlJetOptions.SQLJET_DEFAULT_FILE_FORMAT;

    @Override
    public List<ISqlJetVdbeMem> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public SqlJetBtreeRecord(ISqlJetBtreeCursor cursor, boolean isIndex, int fileFormat) throws SqlJetException {
        this.cursor = cursor;
        this.isIndex = isIndex;
        this.file_format = fileFormat;
        this.read();
    }

    public SqlJetBtreeRecord(List<ISqlJetVdbeMem> values2) {
        this.fields.addAll(values2);
        this.fieldsCount = values2.size();
    }

    public SqlJetBtreeRecord(ISqlJetVdbeMem ... values2) {
        this.initFields(values2);
    }

    private void initFields(ISqlJetVdbeMem[] values2) {
        this.fields.addAll(Arrays.asList(values2));
        this.fieldsCount = values2.length;
    }

    public static ISqlJetBtreeRecord getRecord(SqlJetEncoding encoding, Object ... values2) throws SqlJetException {
        ArrayList<ISqlJetVdbeMem> fields = new ArrayList<ISqlJetVdbeMem>(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            Object value = values2[i];
            SqlJetVdbeMem mem = SqlJetVdbeMem.obtainInstance();
            if (null == value) {
                mem.setNull();
            } else if (value instanceof String) {
                mem.setStr(SqlJetUtility.fromString((String)value, encoding), encoding);
            } else if (value instanceof Boolean) {
                mem.setInt64((Boolean)value != false ? 1L : 0L);
            } else if (value instanceof Byte) {
                mem.setInt64(((Byte)value).byteValue());
            } else if (value instanceof Short) {
                mem.setInt64(((Short)value).shortValue());
            } else if (value instanceof Integer) {
                mem.setInt64(((Integer)value).intValue());
            } else if (value instanceof Long) {
                mem.setInt64((Long)value);
            } else if (value instanceof Float) {
                mem.setDouble(((Float)value).floatValue());
            } else if (value instanceof Double) {
                mem.setDouble((Double)value);
            } else if (value instanceof ByteBuffer) {
                mem.setStr(SqlJetUtility.fromByteBuffer((ByteBuffer)value), encoding);
                mem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if (value instanceof InputStream) {
                mem.setStr(SqlJetUtility.streamToBuffer((InputStream)value), encoding);
                mem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if ("byte[]".equalsIgnoreCase(value.getClass().getCanonicalName())) {
                mem.setStr(SqlJetUtility.wrapPtr((byte[])value), encoding);
                mem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if (value instanceof SqlJetMemoryPointer) {
                mem.setStr((SqlJetMemoryPointer)value, encoding);
                mem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad value #" + i + " " + value.toString());
            }
            fields.add(mem);
        }
        return new SqlJetBtreeRecord(fields);
    }

    @Override
    public int getFieldsCount() {
        return this.fieldsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws SqlJetException {
        this.cursor.enterCursor();
        try {
            long payloadSize = this.isIndex ? this.cursor.getKeySize() : (long)this.cursor.getDataSize();
            if (payloadSize == 0L) {
                Object var13_2 = null;
                this.cursor.leaveCursor();
                return;
            }
            SqlJetVdbeMem sMem = SqlJetVdbeMem.obtainInstance();
            int[] offset = new int[]{0};
            int[] avail = new int[]{0};
            assert (this.aType != null);
            assert (this.aOffset != null);
            ISqlJetMemoryPointer zData = this.isIndex ? this.cursor.keyFetch(avail) : this.cursor.dataFetch(avail);
            byte szHdrSz = SqlJetUtility.getVarint32(zData, offset);
            if (avail[0] < offset[0]) {
                sMem.fromBtree(this.cursor, 0, offset[0], this.isIndex);
                zData = sMem.z;
            }
            ISqlJetMemoryPointer zEndHdr = SqlJetUtility.pointer(zData, offset[0]);
            ISqlJetMemoryPointer zIdx = SqlJetUtility.pointer(zData, szHdrSz);
            this.fieldsCount = 0;
            int i = 0;
            while (i < 2000 && zIdx.getPointer() < zEndHdr.getPointer() && (long)offset[0] <= payloadSize) {
                this.aOffset.add(i, offset[0]);
                int[] a = new int[]{0};
                SqlJetUtility.movePtr(zIdx, SqlJetUtility.getVarint32(zIdx, a));
                this.aType.add(i, a[0]);
                offset[0] = offset[0] + SqlJetVdbeSerialType.serialTypeLen(a[0]);
                this.fields.add(i, this.getField(i));
                ++i;
                ++this.fieldsCount;
            }
            sMem.release();
            if (zIdx.getPointer() > zEndHdr.getPointer() || (long)offset[0] > payloadSize || zIdx.getPointer() == zEndHdr.getPointer() && (long)offset[0] != payloadSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
        }
        catch (Throwable throwable) {
            Object var13_4 = null;
            this.cursor.leaveCursor();
            throw throwable;
        }
        Object var13_3 = null;
        this.cursor.leaveCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetVdbeMem getField(int column) throws SqlJetException {
        SqlJetVdbeMem pDest;
        SqlJetVdbeMem sMem;
        block8: {
            sMem = SqlJetVdbeMem.obtainInstance();
            pDest = SqlJetVdbeMem.obtainInstance();
            pDest.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
            this.cursor.enterCursor();
            try {
                long payloadSize = this.isIndex ? this.cursor.getKeySize() : (long)this.cursor.getDataSize();
                if (payloadSize != 0L) break block8;
                sMem.release();
                SqlJetVdbeMem sqlJetVdbeMem = pDest;
                Object var11_7 = null;
                this.cursor.leaveCursor();
                return sqlJetVdbeMem;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                this.cursor.leaveCursor();
                throw throwable;
            }
        }
        Integer aOffsetColumn = this.aOffset.get(column);
        Integer aTypeColumn = this.aType.get(column);
        if (aOffsetColumn != null && aTypeColumn != null && aOffsetColumn != 0) {
            int len = SqlJetVdbeSerialType.serialTypeLen(aTypeColumn);
            sMem.fromBtree(this.cursor, this.aOffset.get(column), len, this.isIndex);
            ISqlJetMemoryPointer zData = sMem.z;
            SqlJetVdbeSerialType.serialGet(zData, aTypeColumn, pDest);
            pDest.enc = this.cursor.getCursorDb().getOptions().getEncoding();
        }
        Object var11_8 = null;
        this.cursor.leaveCursor();
        if (sMem.zMalloc != null) {
            assert (sMem.z == sMem.zMalloc);
            assert (!pDest.flags.contains((Object)SqlJetVdbeMemFlags.Dyn));
            assert (!pDest.flags.contains((Object)SqlJetVdbeMemFlags.Blob) && !pDest.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pDest.z.getBuffer() == sMem.z.getBuffer());
            pDest.flags.remove((Object)SqlJetVdbeMemFlags.Ephem);
            pDest.flags.remove((Object)SqlJetVdbeMemFlags.Static);
            pDest.flags.add(SqlJetVdbeMemFlags.Term);
        }
        pDest.makeWriteable();
        sMem.release();
        return pDest;
    }

    @Override
    public String getStringField(int field, SqlJetEncoding enc) throws SqlJetException {
        ISqlJetVdbeMem f = this.fields.get(field);
        if (null == f) {
            return null;
        }
        ISqlJetMemoryPointer v = f.valueText(enc);
        if (null == v) {
            return null;
        }
        return SqlJetUtility.toString(v, enc);
    }

    @Override
    public long getIntField(int field) {
        ISqlJetVdbeMem f = this.fields.get(field);
        if (null == f) {
            return 0L;
        }
        return f.intValue();
    }

    @Override
    public double getRealField(int field) {
        ISqlJetVdbeMem f = this.fields.get(field);
        if (null == f) {
            return 0.0;
        }
        return f.realValue();
    }

    @Override
    public ISqlJetMemoryPointer getRawRecord() {
        int serial_type;
        SqlJetVdbeMem pRec;
        int nData = 0;
        int nHdr = 0;
        int nByte = 0;
        int nZero = 0;
        for (ISqlJetVdbeMem value : this.fields) {
            pRec = (SqlJetVdbeMem)value;
            if (pRec.flags.contains((Object)SqlJetVdbeMemFlags.Zero) && pRec.n > 0) {
                pRec.expandBlob();
            }
            serial_type = SqlJetVdbeSerialType.serialType(pRec, this.file_format);
            int len = SqlJetVdbeSerialType.serialTypeLen(serial_type);
            nData += len;
            nHdr += SqlJetUtility.varintLen(serial_type);
            if (pRec.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                nZero += pRec.nZero;
                continue;
            }
            if (len == 0) continue;
            nZero = 0;
        }
        int nVarint = SqlJetUtility.varintLen(nHdr);
        if (nVarint < SqlJetUtility.varintLen(nHdr += nVarint)) {
            ++nHdr;
        }
        nByte = nHdr + nData - nZero;
        ISqlJetMemoryPointer zNewRecord = SqlJetUtility.allocatePtr(nByte);
        int i = SqlJetUtility.putVarint32(zNewRecord, nHdr);
        for (ISqlJetVdbeMem value : this.fields) {
            pRec = (SqlJetVdbeMem)value;
            serial_type = SqlJetVdbeSerialType.serialType(pRec, this.file_format);
            i += SqlJetUtility.putVarint32(SqlJetUtility.pointer(zNewRecord, i), serial_type);
        }
        for (ISqlJetVdbeMem value : this.fields) {
            pRec = (SqlJetVdbeMem)value;
            i += SqlJetVdbeSerialType.serialPut(SqlJetUtility.pointer(zNewRecord, i), nByte - i, pRec, this.file_format);
        }
        assert (i == nByte);
        return zNewRecord;
    }

    @Override
    public void release() {
        for (ISqlJetVdbeMem field : this.fields) {
            field.release();
        }
    }
}

