/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.KeyPair;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHPrivateKeyUtil {
    private static final String TRILEAD_AGENT_PROXY_CLASS = "com.jcraft.jsch.agentproxy.TrileadAgentProxy";
    private static final String CONNECTOR_FACTORY_CLASS = "com.jcraft.jsch.agentproxy.ConnectorFactory";
    private static final String CONNECTOR_CLASS = "com.jcraft.jsch.agentproxy.Connector";

    public static AgentProxy createOptionalSSHAgentProxy() {
        try {
            Class<?> connectorClass = Class.forName(CONNECTOR_CLASS);
            Method connectorFactoryGetDefault = Class.forName(CONNECTOR_FACTORY_CLASS).getMethod("getDefault", new Class[0]);
            Method connectorFactoryCreateConnector = Class.forName(CONNECTOR_FACTORY_CLASS).getMethod("createConnector", new Class[0]);
            Object connectorFactory = connectorFactoryGetDefault.invoke(null, new Object[0]);
            Object connector = connectorFactoryCreateConnector.invoke(connectorFactory, new Object[0]);
            Class<?> proxyClass = Class.forName(TRILEAD_AGENT_PROXY_CLASS);
            return (AgentProxy)proxyClass.getConstructor(connectorClass).newInstance(connector);
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to load TrileadAgentProxy");
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readPrivateKey(File privateKey) {
        if (!(privateKey != null && privateKey.exists() && privateKey.isFile() && privateKey.canRead())) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Can not read private key from '" + privateKey + "'");
            return null;
        }
        BufferedReader reader = null;
        StringWriter buffer = new StringWriter();
        try {
            int ch;
            reader = new BufferedReader(new FileReader(privateKey));
            while ((ch = ((Reader)reader).read()) >= 0) {
                buffer.write(ch);
            }
        }
        catch (IOException e) {
            char[] cArray;
            try {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                cArray = null;
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
            return cArray;
        }
        SVNFileUtil.closeFile(reader);
        return buffer.toString().toCharArray();
    }

    public static boolean isValidPrivateKey(char[] privateKey, String passphrase) {
        return SVNSSHPrivateKeyUtil.isValidPrivateKey(privateKey, passphrase != null ? passphrase.toCharArray() : null);
    }

    public static boolean isValidPrivateKey(char[] privateKey, char[] passphrase) {
        try {
            byte[] pkBytes = new String(privateKey).getBytes(Charset.defaultCharset());
            String password = passphrase != null ? new String(passphrase) : null;
            Iterable<KeyPair> keyPairs = SecurityUtils.loadKeyPairIdentities(null, () -> "byte array", new ByteArrayInputStream(pkBytes), FilePasswordProvider.of(password));
            return keyPairs.iterator().hasNext();
        }
        catch (Exception e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            return false;
        }
    }
}

