/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.Closeable;
import java.io.IOException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSpillBufferReader
implements Closeable {
    private final SVNSpillBuffer buffer;
    private byte[] saveBuffer;
    private int savePointer;
    private int savePosition;
    private int saveLength;
    private byte[] sbBuffer;
    private int sbPointer;
    private int sbLength;

    public SVNSpillBufferReader(SVNSpillBuffer buffer) {
        this.buffer = buffer;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        int amt = 0;
        while (length > 0) {
            int copyAmt;
            if (this.saveLength > 0) {
                copyAmt = length < this.saveLength ? length : this.saveLength;
                System.arraycopy(this.saveBuffer, this.savePointer + this.savePosition, data, offset, copyAmt);
                this.savePointer += copyAmt;
                this.saveLength -= copyAmt;
            } else {
                if (this.sbLength == 0) {
                    SVNSpillBuffer.MemoryBlock block = this.buffer.read();
                    if (block == null) {
                        this.sbBuffer = null;
                        this.sbPointer = 0;
                        this.sbLength = 0;
                        this.sbLength = 0;
                        return amt == 0 ? -1 : amt;
                    }
                    this.sbBuffer = block.data;
                    this.sbPointer = 0;
                    this.sbLength = block.length;
                }
                copyAmt = length < this.sbLength ? length : this.sbLength;
                System.arraycopy(this.sbBuffer, this.sbPointer, data, offset, copyAmt);
                this.sbPointer += copyAmt;
                this.sbLength -= copyAmt;
            }
            offset += copyAmt;
            length -= copyAmt;
            amt += copyAmt;
        }
        return amt == 0 ? -1 : amt;
    }

    public char readChar() throws SVNException {
        byte[] bytes = new byte[1];
        try {
            int read = this.read(bytes, 0, 1);
            if (read < 0) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            return (char)bytes[0];
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return '\uffff';
        }
    }

    public void write(byte[] data, int offset, int length) {
        if (this.sbLength > 0) {
            if (this.saveBuffer == null) {
                this.saveBuffer = new byte[this.buffer.getBlockSize()];
                this.savePointer = 0;
            }
            System.arraycopy(this.sbBuffer, this.sbPointer, this.saveBuffer, this.savePointer, this.sbLength);
            this.saveLength = this.sbLength;
            this.savePosition = 0;
            this.sbLength = 0;
        }
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

