/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnMerge
extends SvnOperation<Void> {
    public static final boolean EMULATE_AUTOMATIC_MERGE = true;
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private boolean ignoreMergeInfo;
    private boolean ignoreAncestry;
    private boolean force;
    private boolean recordOnly;
    private boolean dryRun;
    private boolean allowMixedRevisions;
    private SvnTarget source;
    private boolean reintegrate;
    private Collection<SvnRevisionRange> ranges;
    private SVNDiffOptions mergeOptions;

    protected SvnMerge(SvnOperationFactory factory2) {
        super(factory2);
    }

    public void addRevisionRange(SvnRevisionRange range) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<SvnRevisionRange>();
        }
        SVNRevision start = range.getStart();
        SVNRevision end = range.getEnd();
        if (start == SVNRevision.UNDEFINED && end == SVNRevision.UNDEFINED) {
            start = SVNRevision.create(0L);
            end = this.getSource().getResolvedPegRevision();
            range = SvnRevisionRange.create(start, end);
        }
        this.ranges.add(range);
    }

    public Collection<SvnRevisionRange> getRevisionRanges() {
        if (this.ranges == null) {
            SvnTarget source2 = this.getSource();
            SVNRevision startRevision = SVNRevision.create(1L);
            SVNRevision endRevision = source2.getPegRevision();
            if (endRevision == null || endRevision == SVNRevision.UNDEFINED) {
                endRevision = source2.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            ArrayList<SvnRevisionRange> revisionRanges = new ArrayList<SvnRevisionRange>();
            revisionRanges.add(SvnRevisionRange.create(startRevision, endRevision));
            return revisionRanges;
        }
        return this.ranges;
    }

    public void setSource(SvnTarget source2, boolean reintegrate) {
        this.source = source2;
        this.reintegrate = reintegrate;
        if (source2 != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget source1, SvnTarget source2) {
        this.firstSource = source1;
        this.secondSource = source2;
        if (this.firstSource != null) {
            this.setSource(null, false);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public boolean isReintegrate() {
        return this.reintegrate;
    }

    public boolean isIgnoreMergeInfo() {
        return this.ignoreMergeInfo;
    }

    public void setIgnoreMergeInfo(boolean ignoreMergeInfo) {
        this.ignoreMergeInfo = ignoreMergeInfo;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isRecordOnly() {
        return this.recordOnly;
    }

    public void setRecordOnly(boolean recordOnly) {
        this.recordOnly = recordOnly;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isAllowMixedRevisions() {
        return this.allowMixedRevisions;
    }

    public void setAllowMixedRevisions(boolean allowMixedRevisions) {
        this.allowMixedRevisions = allowMixedRevisions;
    }

    public SVNDiffOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public void setMergeOptions(SVNDiffOptions mergeOptions) {
        this.mergeOptions = mergeOptions;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

