﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/athena/model/CapacityReservation.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListCapacityReservationsResult
  {
  public:
    AWS_ATHENA_API ListCapacityReservationsResult();
    AWS_ATHENA_API ListCapacityReservationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListCapacityReservationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListCapacityReservationsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListCapacityReservationsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListCapacityReservationsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline const Aws::Vector<CapacityReservation>& GetCapacityReservations() const{ return m_capacityReservations; }

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline void SetCapacityReservations(const Aws::Vector<CapacityReservation>& value) { m_capacityReservations = value; }

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline void SetCapacityReservations(Aws::Vector<CapacityReservation>&& value) { m_capacityReservations = std::move(value); }

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline ListCapacityReservationsResult& WithCapacityReservations(const Aws::Vector<CapacityReservation>& value) { SetCapacityReservations(value); return *this;}

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline ListCapacityReservationsResult& WithCapacityReservations(Aws::Vector<CapacityReservation>&& value) { SetCapacityReservations(std::move(value)); return *this;}

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline ListCapacityReservationsResult& AddCapacityReservations(const CapacityReservation& value) { m_capacityReservations.push_back(value); return *this; }

    /**
     * <p>The capacity reservations for the current account.</p>
     */
    inline ListCapacityReservationsResult& AddCapacityReservations(CapacityReservation&& value) { m_capacityReservations.push_back(std::move(value)); return *this; }


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListCapacityReservationsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListCapacityReservationsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListCapacityReservationsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::String m_nextToken;

    Aws::Vector<CapacityReservation> m_capacityReservations;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
