import { Client, OnDrag, GestoOptions, GestoEvents } from "./types";
import EventEmitter, { TargetParam } from "@scena/event-emitter";
import { IObject } from "@daybrush/utils";
declare class Gesto extends EventEmitter<GestoEvents> {
    options: GestoOptions;
    private flag;
    private pinchFlag;
    private data;
    private isDrag;
    private isPinch;
    private isMouse;
    private isTouch;
    private clientStores;
    private targets;
    private prevTime;
    private doubleFlag;
    private _dragFlag;
    private _isMouseEvent;
    private _isSecondaryButton;
    private _preventMouseEvent;
    constructor(targets: Array<Element | Window> | Element | Window, options?: GestoOptions);
    stop(): void;
    getMovement(clients?: Client[]): number;
    isDragging(): boolean;
    isFlag(): boolean;
    isPinchFlag(): boolean;
    isDoubleFlag(): boolean;
    isPinching(): boolean;
    scrollBy(deltaX: number, deltaY: number, e: any, isCallDrag?: boolean): void;
    move([deltaX, deltaY]: number[], inputEvent: any): TargetParam<OnDrag>;
    triggerDragStart(e: any): void;
    setEventData(data: IObject<any>): this;
    setEventDatas(data: IObject<any>): this;
    getCurrentEvent(inputEvent?: any): {
        movement: number;
        isDrag: boolean;
        isPinch: boolean;
        isScroll: boolean;
        inputEvent: any;
        distX: number;
        distY: number;
        clientX: number;
        clientY: number;
        originalClientX?: number | undefined;
        originalClientY?: number | undefined;
        deltaX: number;
        deltaY: number;
        data: IObject<any>;
        datas: IObject<any>;
    };
    getEventData(): IObject<any>;
    getEventDatas(): IObject<any>;
    unset(): void;
    onDragStart: (e: any, isTrusted?: boolean) => false | undefined;
    onDrag: (e: any, isScroll?: boolean | undefined) => void;
    onDragEnd: (e?: any) => void;
    onPinchStart(e: TouchEvent): void;
    onPinch(e: TouchEvent, clients: Client[]): void;
    onPinchEnd(e: TouchEvent): void;
    private getCurrentStore;
    private moveClients;
    private onBlur;
    private _addStore;
    private _getPosition;
    private _allowClickEvent;
    private _attchDragEvent;
    private _dettachDragEvent;
    private _onClick;
    private _onContextMenu;
    private _passCallback;
}
export default Gesto;
