"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfig = getConfig;
exports.replaceRootDir = replaceRootDir;
exports.fallbackLanguageMigration = fallbackLanguageMigration;
exports.catalogMigration = catalogMigration;
exports.configValidation = exports.defaultConfig = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var _chalk = _interopRequireDefault(require("chalk"));

var _cosmiconfig = require("cosmiconfig");

var _jestValidate = require("jest-validate");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

// Enforce posix path delimiters internally
var pathJoinPosix = function pathJoinPosix() {
  return _path.default // normalize double slashes
  .join.apply(_path.default, arguments) // convert platform specific path.sep to posix
  .split(_path.default.sep).join("/");
};

var defaultConfig = {
  catalogs: [{
    path: pathJoinPosix("<rootDir>", "locale", "{locale}", "messages"),
    include: ["<rootDir>"],
    exclude: ["*/node_modules/*"]
  }],
  catalogsMergePath: "",
  compileNamespace: "cjs",
  compilerBabelOptions: {
    minified: true,
    jsescOption: {
      minimal: true
    }
  },
  extractBabelOptions: {
    plugins: [],
    presets: []
  },
  fallbackLocales: {},
  format: "po",
  formatOptions: {
    origins: true,
    lineNumbers: true
  },
  locales: [],
  orderBy: "messageId",
  pseudoLocale: "",
  rootDir: ".",
  runtimeConfigModule: ["@lingui/core", "i18n"],
  sourceLocale: "",
  service: {
    name: "",
    apiKey: ""
  }
};
exports.defaultConfig = defaultConfig;

function configExists(path) {
  return path && _fs.default.existsSync(path);
}

function getConfig() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      cwd = _ref.cwd,
      configPath = _ref.configPath,
      _ref$skipValidation = _ref.skipValidation,
      skipValidation = _ref$skipValidation === void 0 ? false : _ref$skipValidation;

  var defaultRootDir = cwd || process.cwd();
  var moduleName = "lingui";
  var configExplorer = (0, _cosmiconfig.cosmiconfigSync)(moduleName, {
    searchPlaces: ["package.json", ".".concat(moduleName, "rc"), ".".concat(moduleName, "rc.json"), ".".concat(moduleName, "rc.yaml"), ".".concat(moduleName, "rc.yml"), ".".concat(moduleName, "rc.ts"), ".".concat(moduleName, "rc.js"), "".concat(moduleName, ".config.ts"), "".concat(moduleName, ".config.js")],
    loaders: {
      ".ts": TypeScriptLoader
    }
  });
  var result = configExists(configPath) ? configExplorer.load(configPath) : configExplorer.search(defaultRootDir);
  var userConfig = result ? result.config : {};

  var config = _objectSpread(_objectSpread({}, defaultConfig), {}, {
    rootDir: result ? _path.default.dirname(result.filepath) : defaultRootDir
  }, userConfig);

  if (!skipValidation) {
    (0, _jestValidate.validate)(config, configValidation);
    return pipe( // List config migrations from oldest to newest
    fallbackLanguageMigration, catalogMigration, // Custom validation
    validateLocales, // `replaceRootDir` should always be the last
    function (config) {
      return replaceRootDir(config, config.rootDir);
    })(config);
  } else {
    return replaceRootDir(config, config.rootDir);
  }
}

var exampleConfig = _objectSpread(_objectSpread({}, defaultConfig), {}, {
  extractors: (0, _jestValidate.multipleValidOptions)([], ["babel"], [{
    match: function match(fileName) {
      return false;
    },
    extract: function extract(filename, targetDir, options) {}
  }]),
  runtimeConfigModule: (0, _jestValidate.multipleValidOptions)({
    i18n: ["@lingui/core", "i18n"],
    Trans: ["@lingui/react", "Trans"]
  }, ["@lingui/core", "i18n"]),
  fallbackLocales: (0, _jestValidate.multipleValidOptions)({}, {
    "en-US": "en"
  }, {
    "en-US": ["en"]
  }, {
    default: "en"
  }, false),
  extractBabelOptions: {
    extends: "babelconfig.js",
    rootMode: "rootmode",
    plugins: ["plugin"],
    presets: ["preset"],
    targets: (0, _jestValidate.multipleValidOptions)({}, '> 0.5%', ['> 0.5%', 'not dead'], undefined),
    assumptions: (0, _jestValidate.multipleValidOptions)({}, undefined),
    browserslistConfigFile: (0, _jestValidate.multipleValidOptions)(true, undefined),
    browserslistEnv: (0, _jestValidate.multipleValidOptions)('.browserslistrc', undefined)
  }
});

var deprecatedConfig = {
  fallbackLocale: function fallbackLocale(config) {
    return " Option ".concat(_chalk.default.bold("fallbackLocale"), " was replaced by ").concat(_chalk.default.bold("fallbackLocales"), "\n\n    You can find more information here: https://github.com/lingui/js-lingui/issues/791\n\n    @lingui/cli now treats your current configuration as:\n    {\n      ").concat(_chalk.default.bold('"fallbackLocales"'), ": {\n        default: ").concat(_chalk.default.bold("\"".concat(config.fallbackLocale, "\"")), "\n      }\n    }\n\n    Please update your configuration.\n    ");
  },
  localeDir: function localeDir(config) {
    return " Option ".concat(_chalk.default.bold("localeDir"), " is deprecated. Configure source paths using ").concat(_chalk.default.bold("catalogs"), " instead.\n\n    @lingui/cli now treats your current configuration as:\n\n    {\n      ").concat(_chalk.default.bold('"catalogs"'), ": ").concat(JSON.stringify(catalogMigration(config).catalogs, null, 2), "\n    }\n\n    Please update your configuration.\n    ");
  },
  srcPathDirs: function srcPathDirs(config) {
    return " Option ".concat(_chalk.default.bold("srcPathDirs"), " is deprecated. Configure source paths using ").concat(_chalk.default.bold("catalogs"), " instead.\n\n    @lingui/cli now treats your current configuration as:\n\n    {\n      ").concat(_chalk.default.bold('"catalogs"'), ": ").concat(JSON.stringify(catalogMigration(config).catalogs, null, 2), "\n    }\n\n    Please update your configuration.\n    ");
  },
  srcPathIgnorePatterns: function srcPathIgnorePatterns(config) {
    return " Option ".concat(_chalk.default.bold("srcPathIgnorePatterns"), " is deprecated. Configure excluded source paths using ").concat(_chalk.default.bold("catalogs"), " instead.\n\n    @lingui/cli now treats your current configuration as:\n\n    {\n      ").concat(_chalk.default.bold('"catalogs"'), ": ").concat(JSON.stringify(catalogMigration(config).catalogs, null, 2), "\n    }\n\n    Please update your configuration.\n    ");
  }
};
var configValidation = {
  exampleConfig: exampleConfig,
  deprecatedConfig: deprecatedConfig,
  comment: "Documentation: https://lingui.js.org/ref/conf.html"
};
exports.configValidation = configValidation;

function validateLocales(config) {
  if (!Array.isArray(config.locales) || !config.locales.length) {
    console.error("No locales defined!\n");
    console.error("Add ".concat(_chalk.default.yellow("'locales'"), " to your configuration. See ").concat(_chalk.default.underline("https://lingui.js.org/ref/conf.html#locales")));
  }

  return config;
}

function replaceRootDir(config, rootDir) {
  return function replaceDeep(value, rootDir) {
    var replace = function replace(s) {
      return s.replace("<rootDir>", rootDir);
    };

    if (value == null) {
      return value;
    } else if (typeof value === "string") {
      return replace(value);
    } else if (Array.isArray(value)) {
      return value.map(function (item) {
        return replaceDeep(item, rootDir);
      });
    } else if ((0, _typeof2.default)(value) === "object") {
      Object.keys(value).forEach(function (key) {
        var newKey = replaceDeep(key, rootDir);
        value[newKey] = replaceDeep(value[key], rootDir);
        if (key !== newKey) delete value[key];
      });
    }

    return value;
  }(config, rootDir);
}
/**
 * Replace fallbackLocale, by the new standard fallbackLocales
 * - https://github.com/lingui/js-lingui/issues/791
 * - Remove anytime after 4.x
 */


function fallbackLanguageMigration(config) {
  var fallbackLocale = config.fallbackLocale,
      fallbackLocales = config.fallbackLocales;
  if (fallbackLocales === false) return _objectSpread(_objectSpread({}, config), {}, {
    fallbackLocales: null
  });
  var DEFAULT_FALLBACK = (fallbackLocales === null || fallbackLocales === void 0 ? void 0 : fallbackLocales.default) || fallbackLocale;

  if (DEFAULT_FALLBACK) {
    if (!config.fallbackLocales) config.fallbackLocales = {};
    config.fallbackLocales.default = DEFAULT_FALLBACK;
  }

  if (config.fallbackLocales !== false && !config.fallbackLocales.default) {
    config.locales.forEach(function (locale) {
      var fl = getCldrParentLocale(locale.toLowerCase());

      if (fl && !config.fallbackLocales[locale]) {
        config.fallbackLocales = _objectSpread(_objectSpread({}, config.fallbackLocales), {}, (0, _defineProperty2.default)({}, locale, fl));
      }
    });
  }

  return config;
}

function getCldrParentLocale(sourceLocale) {
  return {
    "en-ag": "en",
    "en-ai": "en",
    "en-au": "en",
    "en-bb": "en",
    "en-bm": "en",
    "en-bs": "en",
    "en-bw": "en",
    "en-bz": "en",
    "en-ca": "en",
    "en-cc": "en",
    "en-ck": "en",
    "en-cm": "en",
    "en-cx": "en",
    "en-cy": "en",
    "en-dg": "en",
    "en-dm": "en",
    "en-er": "en",
    "en-fj": "en",
    "en-fk": "en",
    "en-fm": "en",
    "en-gb": "en",
    "en-gd": "en",
    "en-gg": "en",
    "en-gh": "en",
    "en-gi": "en",
    "en-gm": "en",
    "en-gy": "en",
    "en-hk": "en",
    "en-ie": "en",
    "en-il": "en",
    "en-im": "en",
    "en-in": "en",
    "en-io": "en",
    "en-je": "en",
    "en-jm": "en",
    "en-ke": "en",
    "en-ki": "en",
    "en-kn": "en",
    "en-ky": "en",
    "en-lc": "en",
    "en-lr": "en",
    "en-ls": "en",
    "en-mg": "en",
    "en-mo": "en",
    "en-ms": "en",
    "en-mt": "en",
    "en-mu": "en",
    "en-mw": "en",
    "en-my": "en",
    "en-na": "en",
    "en-nf": "en",
    "en-ng": "en",
    "en-nr": "en",
    "en-nu": "en",
    "en-nz": "en",
    "en-pg": "en",
    "en-ph": "en",
    "en-pk": "en",
    "en-pn": "en",
    "en-pw": "en",
    "en-rw": "en",
    "en-sb": "en",
    "en-sc": "en",
    "en-sd": "en",
    "en-sg": "en",
    "en-sh": "en",
    "en-sl": "en",
    "en-ss": "en",
    "en-sx": "en",
    "en-sz": "en",
    "en-tc": "en",
    "en-tk": "en",
    "en-to": "en",
    "en-tt": "en",
    "en-tv": "en",
    "en-tz": "en",
    "en-ug": "en",
    "en-us": "en",
    "en-vc": "en",
    "en-vg": "en",
    "en-vu": "en",
    "en-ws": "en",
    "en-za": "en",
    "en-zm": "en",
    "en-zw": "en",
    "en-at": "en",
    "en-be": "en",
    "en-ch": "en",
    "en-de": "en",
    "en-dk": "en",
    "en-fi": "en",
    "en-nl": "en",
    "en-se": "en",
    "en-si": "en",
    "es-ar": "es",
    "es-bo": "es",
    "es-br": "es",
    "es-bz": "es",
    "es-cl": "es",
    "es-co": "es",
    "es-cr": "es",
    "es-cu": "es",
    "es-do": "es",
    "es-ec": "es",
    "es-es": "es",
    "es-gt": "es",
    "es-hn": "es",
    "es-mx": "es",
    "es-ni": "es",
    "es-pa": "es",
    "es-pe": "es",
    "es-pr": "es",
    "es-py": "es",
    "es-sv": "es",
    "es-us": "es",
    "es-uy": "es",
    "es-ve": "es",
    "pt-ao": "pt",
    "pt-ch": "pt",
    "pt-cv": "pt",
    "pt-fr": "pt",
    "pt-gq": "pt",
    "pt-gw": "pt",
    "pt-lu": "pt",
    "pt-mo": "pt",
    "pt-mz": "pt",
    "pt-pt": "pt",
    "pt-st": "pt",
    "pt-tl": "pt",
    "az-arab": "az",
    "az-cyrl": "az",
    "blt-latn": "blt",
    "bm-nkoo": "bm",
    "bs-cyrl": "bs",
    "byn-latn": "byn",
    "cu-glag": "cu",
    "dje-arab": "dje",
    "dyo-arab": "dyo",
    "en-dsrt": "en",
    "en-shaw": "en",
    "ff-adlm": "ff",
    "ff-arab": "ff",
    "ha-arab": "ha",
    "hi-latn": "hi",
    "iu-latn": "iu",
    "kk-arab": "kk",
    "ks-deva": "ks",
    "ku-arab": "ku",
    "ky-arab": "ky",
    "ky-latn": "ky",
    "ml-arab": "ml",
    "mn-mong": "mn",
    "mni-mtei": "mni",
    "ms-arab": "ms",
    "pa-arab": "pa",
    "sat-deva": "sat",
    "sd-deva": "sd",
    "sd-khoj": "sd",
    "sd-sind": "sd",
    "shi-latn": "shi",
    "so-arab": "so",
    "sr-latn": "sr",
    "sw-arab": "sw",
    "tg-arab": "tg",
    "ug-cyrl": "ug",
    "uz-arab": "uz",
    "uz-cyrl": "uz",
    "vai-latn": "vai",
    "wo-arab": "wo",
    "yo-arab": "yo",
    "yue-hans": "yue",
    "zh-hant": "zh",
    "zh-hant-hk": "zh",
    "zh-hant-mo": "zh-hant-hk"
  }[sourceLocale];
}
/**
 * Replace localeDir, srcPathDirs and srcPathIgnorePatterns with catalogs
 *
 * Released in @lingui/conf 3.0
 * Remove anytime after 4.x
 */


function catalogMigration(config) {
  var localeDir = config.localeDir,
      srcPathDirs = config.srcPathDirs,
      srcPathIgnorePatterns = config.srcPathIgnorePatterns,
      newConfig = (0, _objectWithoutProperties2.default)(config, ["localeDir", "srcPathDirs", "srcPathIgnorePatterns"]);

  if (localeDir || srcPathDirs || srcPathIgnorePatterns) {
    // Replace missing values with default ones
    if (localeDir === undefined) localeDir = pathJoinPosix("<rootDir>", "locale", "{locale}", "messages");
    if (srcPathDirs === undefined) srcPathDirs = ["<rootDir>"];
    if (srcPathIgnorePatterns === undefined) srcPathIgnorePatterns = ["**/node_modules/**"];
    var newLocaleDir = localeDir.split(_path.default.sep).join("/");

    if (newLocaleDir.slice(-1) !== _path.default.sep) {
      newLocaleDir += "/";
    }

    if (!Array.isArray(newConfig.catalogs)) {
      newConfig.catalogs = [];
    }

    newConfig.catalogs.push({
      path: pathJoinPosix(newLocaleDir, "{locale}", "messages"),
      include: srcPathDirs,
      exclude: srcPathIgnorePatterns
    });
  }

  return newConfig;
}

var pipe = function pipe() {
  for (var _len = arguments.length, functions = new Array(_len), _key = 0; _key < _len; _key++) {
    functions[_key] = arguments[_key];
  }

  return function (args) {
    return functions.reduce(function (arg, fn) {
      return fn(arg);
    }, args);
  };
};
/** Typescript loader using just typescript API and eval(), instead of using ts-node/register which is slower */


function TypeScriptLoader(filePath) {
  var tsc = require("typescript");

  var fileContent = _fs.default.readFileSync(filePath, "utf-8");

  var _tsc$transpileModule = tsc.transpileModule(fileContent, {
    compilerOptions: {
      module: tsc.ModuleKind.CommonJS
    }
  }),
      outputText = _tsc$transpileModule.outputText;

  var configFileParsed = eval(outputText);
  return configFileParsed;
}