"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.upgrade = void 0;
const render_1 = require("@betterer/render");
const upgrade_1 = require("./upgrade/upgrade");
const options_1 = require("./options");
/**
 * Run the **Betterer** `upgrade` command to upgrade **Betterer** in an existing project.
 */
function upgrade(cwd) {
    const command = (0, options_1.upgradeCommand)();
    command.description('upgrade Betterer files in a project');
    command.action(async (config) => {
        (0, options_1.setEnv)(config);
        const RENDER_OPTIONS = {
            debug: process.env.NODE_ENV === 'test'
        };
        const configPaths = config.config ? config.config : ['./.betterer.ts'];
        const app = (0, render_1.render)(render_1.React.createElement(upgrade_1.Upgrade, { configPaths: configPaths, cwd: cwd, save: config.save }), RENDER_OPTIONS);
        await app.waitUntilExit();
    });
    return command;
}
exports.upgrade = upgrade;
//# sourceMappingURL=upgrade.js.map