/// <reference path="./bridge.d.ts" />

declare namespace Kusto.Charting {
    interface AnomalyDataHelper2 {
    }
    interface AnomalyDataHelper2Func extends Function {
        prototype: AnomalyDataHelper2;
        AnomalyDataFromServiceResult: Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResultFunc;
        AnomalyInputOutputRecord: Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecordFunc;
        new (): AnomalyDataHelper2;
        TimestampColumnName: string | null;
        ValueColumnName: string | null;
        SeriesColumnName: string | null;
        AnomalySerieSuffix: string | null;
        EnchanceDataWithAnomalyDataFromServiceAsync(kustoContext: Kusto.Charting.IKustoClientContext | null, data: System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null): System.Threading.Tasks.Task$1<Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResult> | null;
        DataItemsToDataTableLiteral(items: System.Collections.Generic.IEnumerable$1<Kusto.Charting.DataItem> | null): string | null;
        EnchanceDataWithAnomalyDataFromColumns(data: System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null, anomalyColumns: string[] | null, anomalySeriesMap: {v: System.Collections.Generic.Dictionary$2<string,string> | null}): System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null;
    }
    var AnomalyDataHelper2: AnomalyDataHelper2Func;
    module AnomalyDataHelper2 {
        interface AnomalyDataFromServiceResult {
            Data: System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null;
            HasErrors: boolean;
            Message: string | null;
        }
        interface AnomalyDataFromServiceResultFunc extends Function {
            prototype: AnomalyDataFromServiceResult;
            new (): AnomalyDataFromServiceResult;
        }

        interface AnomalyInputOutputRecord {
            Timestamp: System.DateTime;
            Value: number;
            Series: string | null;
        }
        interface AnomalyInputOutputRecordFunc extends Function {
            prototype: AnomalyInputOutputRecord;
            new (): AnomalyInputOutputRecord;
        }
    }

    enum ValidationStatus {
        Valid = 0,
        PolicyViolationError = 1,
        PolicyViolationWarning = 2
    }

    interface SeriesCreationException extends System.Exception {
    }
    interface SeriesCreationExceptionFunc extends Function {
        prototype: SeriesCreationException;
        new (error: string | null): SeriesCreationException;
    }
    var SeriesCreationException: SeriesCreationExceptionFunc;

    interface IKustoClientContext {
        Kusto$Charting$IKustoClientContext$ExecuteQueryAsync<TRow>(TRow: {prototype: TRow}, query: string | null): System.Threading.Tasks.Task$1<System.Collections.Generic.IEnumerable$1<TRow>> | null;
        ExecuteQueryAsync<TRow>(TRow: {prototype: TRow}, query: string | null): System.Threading.Tasks.Task$1<System.Collections.Generic.IEnumerable$1<TRow>> | null;
    }

    interface IChartingDataSource {
        /**
         * Amount of rows
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartingDataSource
         * @function Kusto$Charting$IChartingDataSource$RowsCount
         * @type number
         */
        Kusto$Charting$IChartingDataSource$RowsCount: number;
        RowsCount: number;
        /**
         * Provides access to Table schema
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Charting.IChartingDataSource
         * @memberof Kusto.Charting.IChartingDataSource
         * @return  {System.Collections.Generic.IEnumerable$1}        Collection of Tuples where Item1:ColumnName, Item2:ColumnType
         */
        Kusto$Charting$IChartingDataSource$GetSchema(): System.Collections.Generic.IEnumerable$1<System.Tuple$2<string,Kusto.Charting.ArgumentColumnType>> | null;
        GetSchema(): System.Collections.Generic.IEnumerable$1<System.Tuple$2<string,Kusto.Charting.ArgumentColumnType>> | null;
        /**
         * Provides access to data from specific cell
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Charting.IChartingDataSource
         * @memberof Kusto.Charting.IChartingDataSource
         * @param   {number}           row       Row index
         * @param   {number}           column    Column index
         * @return  {System.Object}              Cell content as an Object, 
         which should be able to be downcasted to one of supported by DataChartsHelper types: 
         string(or json array reprsented as string), numeric(int, double), datetime, timespan
         */
        Kusto$Charting$IChartingDataSource$GetValue(row: number, column: number): any | null;
        GetValue(row: number, column: number): any | null;
    }

    interface GeospatialCoordinates {
        Longitude: number;
        Latitude: number;
    }
    interface GeospatialCoordinatesFunc extends Function {
        prototype: GeospatialCoordinates;
        new (): GeospatialCoordinates;
    }
    var GeospatialCoordinates: GeospatialCoordinatesFunc;

    interface ExtendedDouble {
    }
    interface ExtendedDoubleFunc extends Function {
        prototype: ExtendedDouble;
        new (): ExtendedDouble;
        IsFinite(d: number): boolean;
    }
    var ExtendedDouble: ExtendedDoubleFunc;

    interface DataItem {
        SeriesName: string | null;
        ArgumentData: string | null;
        ValueData: number;
        ValueName: string | null;
        ArgumentDateTime: System.DateTime;
        ArgumentNumeric: number;
        GeoCoordinates: Kusto.Charting.GeospatialCoordinates | null;
        SecondaryAxisYName: string | null;
        PrefferredChartKind: Kusto.Charting.ChartKind;
        Properties: string | null;
        /**
         * Truncated value of the property - used for tooltip presentation.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Charting.DataItem
         * @function PropertiesTruncated
         * @type string
         */
        PropertiesTruncated: string | null;
        Clone(): Kusto.Charting.DataItem | null;
    }
    interface DataItemFunc extends Function {
        prototype: DataItem;
        new (): DataItem;
        ctor: {
            new (): DataItem
        };
        $ctor1: {
            new (other: Kusto.Charting.DataItem | null): DataItem
        };
    }
    var DataItem: DataItemFunc;

    /** @namespace Kusto.Charting */

    /**
     * Chart meta data
     Describe the columns that will be used for the chart
     *
     * @abstract
     * @public
     * @class Kusto.Charting.IChartMetaData
     */
    interface IChartMetaData {
        /**
         * The requested argument type
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$ArgumentColumnType
         * @type Kusto.Charting.ArgumentColumnType
         */
        Kusto$Charting$IChartMetaData$ArgumentColumnType: Kusto.Charting.ArgumentColumnType;
        ArgumentColumnType: Kusto.Charting.ArgumentColumnType;
        /**
         * The index of the chart argument data column
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex
         * @type number
         */
        Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex: number;
        ArgumentDataColumnIndex: number;
        Kusto$Charting$IChartMetaData$GeospatialColumnIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        GeospatialColumnIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        /**
         * The indexes of the chart series columns
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$SeriesIndexes
         * @type System.Collections.Generic.IEnumerable$1
         */
        Kusto$Charting$IChartMetaData$SeriesIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        SeriesIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        /**
         * The indexes of the chart data columns
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$DataIndexes
         * @type System.Collections.Generic.IEnumerable$1
         */
        Kusto$Charting$IChartMetaData$DataIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        DataIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        /**
         * Column indexes in the original data that are not used as argument, values, or series
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$UnusedIndexes
         * @type System.Collections.Generic.IEnumerable$1
         */
        Kusto$Charting$IChartMetaData$UnusedIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        UnusedIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        /**
         * Is the data provided as series
         *
         * @instance
         * @abstract
         * @public
         * @memberof Kusto.Charting.IChartMetaData
         * @function Kusto$Charting$IChartMetaData$IsDataFormedAsSeries
         * @type boolean
         */
        Kusto$Charting$IChartMetaData$IsDataFormedAsSeries: boolean;
        IsDataFormedAsSeries: boolean;
    }

    enum ArgumentColumnType {
        None = 0,
        Numeric = 2,
        DateTime = 4,
        TimeSpan = 8,
        String = 16,
        Object = 32,
        Geospatial = 64,
        DateTimeOrTimeSpan = 12,
        StringOrDateTimeOrTimeSpan = 28,
        NumericOrDateTimeOrTimeSpan = 14,
        StringOrObject = 48,
        AllExceptGeospatial = 62
    }

    enum ArgumentRestrictions {
        None = 0,
        MustHave = 1,
        NotIncludedInSeries = 2,
        GeospatialAsSeries = 4,
        PreferLast = 8,
        NumericAsSeries = 16
    }

    interface ChartLimitsPolicy {
        /**
         * The maximal amount of points allowed for visualization on the chart
         *
         * @instance
         * @public
         * @memberof Kusto.Charting.ChartLimitsPolicy
         * @function MaxPointsPerChartError
         * @type number
         */
        MaxPointsPerChartError: number;
        /**
         * Amount of points above which required user's approvement to visualize chart
         *
         * @instance
         * @public
         * @memberof Kusto.Charting.ChartLimitsPolicy
         * @function MaxPointsPerChartWarning
         * @type number
         */
        MaxPointsPerChartWarning: number;
        /**
         * The maximal amount of series allowed for visualization on the chart
         *
         * @instance
         * @public
         * @memberof Kusto.Charting.ChartLimitsPolicy
         * @function MaxSeriesPerChartError
         * @type number
         */
        MaxSeriesPerChartError: number;
        /**
         * Amount of series above which required user's approvement to visualize chart
         *
         * @instance
         * @public
         * @memberof Kusto.Charting.ChartLimitsPolicy
         * @function MaxSeriesPerChartWarning
         * @type number
         */
        MaxSeriesPerChartWarning: number;
        /**
         * The maximal interval of DateTime argument allowed for visualization on the chart
         *
         * @instance
         * @public
         * @memberof Kusto.Charting.ChartLimitsPolicy
         * @function MaxDatetimePeriodError
         * @type System.TimeSpan
         */
        MaxDatetimePeriodError: System.TimeSpan;
    }
    interface ChartLimitsPolicyFunc extends Function {
        prototype: ChartLimitsPolicy;
        new (maxPointsPerChartError: number, maxPointsPerChartWarning: number, maxSeriesPerChartError: number, maxSeriesPerChartWarning: number, maxDatetimePeriodError: System.TimeSpan): ChartLimitsPolicy;
    }
    var ChartLimitsPolicy: ChartLimitsPolicyFunc;

    interface DataChartsHelper {
    }
    interface DataChartsHelperFunc extends Function {
        prototype: DataChartsHelper;
        ChartMetaData: Kusto.Charting.DataChartsHelper.ChartMetaDataFunc;
        GeoJSONPoint: Kusto.Charting.DataChartsHelper.GeoJSONPointFunc;
        GeoJSON: DataChartsHelper.GeoJSONFunc;
        ColumnDesc: Kusto.Charting.DataChartsHelper.ColumnDescFunc;
        ArgumentData: Kusto.Charting.DataChartsHelper.ArgumentDataFunc;
        new (): DataChartsHelper;
        /**
         * Generates set of a DataItem objects from provided structure,
         based on required argument parameters(column type and restrictions).
         Takes in account x-columns, y-columns and series if provided.
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Kusto.Charting.IChartingDataSource}          table                   Data source, which has to implement IChartingDataSource.
         * @param   {Kusto.Charting.ArgumentColumnType}           argumentColumnType      Required column type
         * @param   {Kusto.Charting.ArgumentRestrictions}         argumentRestrictions    Argument restrictions
         * @param   {System.Collections.Generic.IEnumerable$1}    seriesColumns           Optional. Names of columns to be considered as series.
         * @param   {boolean}                                     accumulateResults       Optional. Defines the necessity of accumulation in each DataItem values from the previous ones. Default - false.
         * @param   {string}                                      xColumn                 Optional. Name of column to be considered as an argument.
         * @param   {System.Collections.Generic.IEnumerable$1}    yColumns                Optional. Names of columns to be considered as a function.
         * @return  {System.Collections.Generic.IEnumerable$1}                            Collection of DataItem objects.
         */
        GetData(table: Kusto.Charting.IChartingDataSource | null, argumentColumnType?: Kusto.Charting.ArgumentColumnType, argumentRestrictions?: Kusto.Charting.ArgumentRestrictions, seriesColumns?: System.Collections.Generic.IEnumerable$1<string> | null, accumulateResults?: boolean, xColumn?: string | null, yColumns?: System.Collections.Generic.IEnumerable$1<string> | null): System.Collections.Generic.IEnumerable$1<Kusto.Charting.DataItem> | null;
        /**
         * Generates set of a DataItem objects from provided structure,
         based on chart meta data
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Kusto.Charting.IChartingDataSource}          table                Data source, which has to implement IChartingDataSource.
         * @param   {Kusto.Charting.IChartMetaData}               metaData             chart meta data (argument, series and data columns) for data generation
         * @param   {boolean}                                     accumulateResults    Optional. Defines the necessity of accumulation in each DataItem values from the previous ones. Default - false.
         * @return  {System.Collections.Generic.IEnumerable$1}                         Collection of DataItem objects.
         */
        GetData$1(table: Kusto.Charting.IChartingDataSource | null, metaData: Kusto.Charting.IChartMetaData | null, accumulateResults?: boolean): System.Collections.Generic.IEnumerable$1<Kusto.Charting.DataItem> | null;
        /**
         * Figure out the chart meta data, which that will be used to generate the chart data 
         based on required argument parameters(column type and restrictions).
         Takes in account x-columns, y-columns and series if provided.
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Kusto.Charting.IChartingDataSource}          table                   Data source, which has to implement IChartingDataSource.
         * @param   {Kusto.Charting.ArgumentColumnType}           argumentColumnType      Required column type
         * @param   {Kusto.Charting.ArgumentRestrictions}         argumentRestrictions    Argument restrictions
         * @param   {System.Collections.Generic.IEnumerable$1}    seriesColumns           Optional. Names of columns to be considered as series.
         * @param   {string}                                      xColumn                 Optional. Name of column to be considered as an argument.
         * @param   {System.Collections.Generic.IEnumerable$1}    yColumns                Optional. Names of columns to be considered as a function.
         * @return  {Kusto.Charting.IChartMetaData}                                       return the actual argument, series and data columns or null if fails
         */
        GetMetaData(table: Kusto.Charting.IChartingDataSource | null, argumentColumnType?: Kusto.Charting.ArgumentColumnType, argumentRestrictions?: Kusto.Charting.ArgumentRestrictions, seriesColumns?: System.Collections.Generic.IEnumerable$1<string> | null, xColumn?: string | null, yColumns?: System.Collections.Generic.IEnumerable$1<string> | null): Kusto.Charting.IChartMetaData | null;
        /**
         * Detects if provided type is numeric.
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Type}    type                                    Type to be analyzed.
         * @param   {boolean}        considerDateTimeAndTimeSpanAsNumeric    Optional. Defines if DateTime and TimeSpan should be considered as numeric.
         Default - true.
         * @return  {boolean}                                                True, if provided type is numreic, false - if not.
         */
        IsNumericType(type: System.Type | null, considerDateTimeAndTimeSpanAsNumeric?: boolean): boolean;
        /**
         * Returns names of columns, from provided data source, which which may be considered as an argument.
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Kusto.Charting.IChartingDataSource}          table               Data source, which has to implement IChartingDataSource.
         * @param   {System.Collections.Generic.IEnumerable$1}    columnsToExclude    Optional. Columns to be excluded from detection.
         * @return  {System.Collections.Generic.IEnumerable$1}                        Collection of columns' names.
         */
        GetAllArgumentColumns(table: Kusto.Charting.IChartingDataSource | null, columnsToExclude?: System.Collections.Generic.IEnumerable$1<string> | null): System.Collections.Generic.IEnumerable$1<string> | null;
        /**
         * Detects the first column of type string.
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Kusto.Charting.IChartingDataSource}    table           Data source, which has to implement IChartingDataSource.
         * @param   {number}                                amountToSkip    Amount of columns type string to be skipped
         * @return  {string}                                                Name of first column of type string.
         */
        GetFirstStringColumnName(table: Kusto.Charting.IChartingDataSource | null, amountToSkip?: number): string | null;
        /**
         * Method fills gaps in arguments sequence in collection of DataItems,
         pasting new items with NaN values
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Collections.Generic.List$1}    data       Input collection of DataItems. For consistent result, data should be sorted.
         * @param   {Kusto.Charting.ArgumentColumnType}    argType    Type of argument
         * @return  {System.Collections.Generic.List$1}
         */
        FillGapsWithNaNs(data: System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null, argType: Kusto.Charting.ArgumentColumnType): System.Collections.Generic.List$1<Kusto.Charting.DataItem> | null;
        /**
         * Method resolves probable type of argument based on generated data items
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Collections.Generic.IEnumerable$1}    data    List of DataItems, which used as data source for visualization
         * @return  {Kusto.Charting.ArgumentColumnType}                   Type of data
         */
        ResolveArgumentType(data: System.Collections.Generic.IEnumerable$1<Kusto.Charting.DataItem> | null): Kusto.Charting.ArgumentColumnType;
        /**
         * The method checks whether the data is suitable for visualization based on provided limits
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Collections.Generic.IEnumerable$1}    data       Data co check
         * @param   {Kusto.Charting.ArgumentColumnType}           argType    Type of argument
         * @param   {Kusto.Charting.ChartLimitsPolicy}            limits     Data limitations
         * @param   {System.String}                               error      Description of found overlimits
         * @return  {Kusto.Charting.ValidationStatus}                        State of processed validation
         */
        ValidateData(data: System.Collections.Generic.IEnumerable$1<Kusto.Charting.DataItem> | null, argType: Kusto.Charting.ArgumentColumnType, limits: Kusto.Charting.ChartLimitsPolicy | null, error: {v: string | null}): Kusto.Charting.ValidationStatus;
        /**
         * Function resolves the type of data from JSON array represented as a string
         *
         * @static
         * @public
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {string}                               value    Input string. Expected to be JSON array
         * @return  {Kusto.Charting.ArgumentColumnType}             Type of data
         */
        ResolveJsonArrayType(value: string | null): Kusto.Charting.ArgumentColumnType;
        /**
         * Calculates intervals between values in collection
         *
         * @static
         * @private
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {Array.<number>}    collection
         * @return  {Array.<number>}                  Array of doubles
         */
        /**
         * from the table columns and reuirements, deduce the x, y, and series axis.
         *
         * @static
         * @private
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Collections.Generic.IEnumerable$1}         columns                 
         * @param   {Kusto.Charting.IChartingDataSource}               table                   
         * @param   {System.Collections.Generic.IEnumerable$1}         seriesColumns           
         * @param   {Kusto.Charting.ArgumentRestrictions}              argumentRestrictions    
         * @param   {Kusto.Charting.DataChartsHelper.ChartMetaData}    metaData
         * @return  {boolean}
         */
        /**
         * from the table columns and requirements, deduce the x, y, and series axis.
         *
         * @static
         * @private
         * @this Kusto.Charting.DataChartsHelper
         * @memberof Kusto.Charting.DataChartsHelper
         * @param   {System.Collections.Generic.IEnumerable$1}         columns                 
         * @param   {Kusto.Charting.IChartingDataSource}               table                   
         * @param   {Kusto.Charting.ArgumentRestrictions}              argumentRestrictions    
         * @param   {Kusto.Charting.DataChartsHelper.ChartMetaData}    metaData
         * @return  {boolean}
         */
    }
    var DataChartsHelper: DataChartsHelperFunc;
    module DataChartsHelper {
        interface ChartMetaData extends Kusto.Charting.IChartMetaData {
            ArgumentColumnType: Kusto.Charting.ArgumentColumnType;
            ArgumentDataColumnIndex: number;
            GeospatialColumnIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
            SeriesIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
            DataIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
            IsDataFormedAsSeries: boolean;
            SeriesIndexesList: System.Collections.Generic.List$1<number> | null;
            DataIndexesList: System.Collections.Generic.List$1<number> | null;
            GeospatiaColumnlIndexesList: System.Collections.Generic.List$1<number> | null;
            UnusedIndexes: System.Collections.Generic.IEnumerable$1<number> | null;
        }
        interface ChartMetaDataFunc extends Function {
            prototype: ChartMetaData;
            new (argumentColumnType: Kusto.Charting.ArgumentColumnType): ChartMetaData;
        }

        interface GeoJSONPoint {
            type: number;
            coordinates: number[] | null;
        }
        interface GeoJSONPointFunc extends Function {
            prototype: GeoJSONPoint;
            new (): GeoJSONPoint;
        }

        interface GeoJSON {
        }
        interface GeoJSONFunc extends Function {
            prototype: GeoJSON;
            Point: number;
        }

        interface ColumnDesc {
            Name: string | null;
            Type: Kusto.Charting.ArgumentColumnType;
            Index: number;
        }
        interface ColumnDescFunc extends Function {
            prototype: ColumnDesc;
            new (name: string | null, type: Kusto.Charting.ArgumentColumnType, index: number): ColumnDesc;
        }

        /**
         * The class will pre-calculate the argument value and convert it to different types.
         *
         * @private
         * @class Kusto.Charting.DataChartsHelper.ArgumentData
         */
        interface ArgumentData {
        }
        interface ArgumentDataFunc extends Function {
            prototype: ArgumentData;
        }
    }

    enum ChartKind {
        Unspecified = 0,
        Line = 1,
        Point = 2,
        Bar = 3
    }

}

declare namespace Kusto.Cloud.Platform.Text {
    interface StringLiteral {
    }
    interface StringLiteralFunc extends Function {
        prototype: StringLiteral;
        new (): StringLiteral;
        MultiLineStringQuote: string | null;
        AlternateMultiLineStringQuote: string | null;
        /**
         * Parses a CSL string literal. There are five kinds of string literals:
 
         Each kind of string literal may be preceeded by an 'h' to mark it as hidden - i.e. will <b>not</b> be saved in our traces.
         For example: h"This is a hidden string"/
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Text.StringLiteral
         * @memberof Kusto.Cloud.Platform.Text.StringLiteral
         * @param   {string}    literal
         * @return  {string}
         */
        ParseStringLiteral(literal: string | null): string | null;
        /**
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Text.StringLiteral
         * @memberof Kusto.Cloud.Platform.Text.StringLiteral
         * @param   {string}            literal     
         * @param   {System.Boolean}    isHidden
         * @return  {string}
         */
        ParseStringLiteral$1(literal: string | null, isHidden: {v: boolean}): string | null;
        TryParseStringLiteral(str: string | null, literal: {v: string | null}): boolean;
        TryParseStringLiteral$1(str: string | null, literal: {v: string | null}, isHidden: {v: boolean}): boolean;
        Equals(str1: string | null, str2: string | null): boolean;
        TrimSingleQuotes(name: string | null): string | null;
        TrimBrackets(input: string | null): string | null;
        InitArray<T>(T: {prototype: T}, arr: T[] | null, value: T): void;
        /**
         * Generate string that will be parsed as a string literal.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Text.StringLiteral
         * @memberof Kusto.Cloud.Platform.Text.StringLiteral
         * @param   {string}    value
         * @return  {string}
         */
        GetLiteral(value: string | null): string | null;
        /**
         * Generate string that will be parsed as a string literal.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Text.StringLiteral
         * @memberof Kusto.Cloud.Platform.Text.StringLiteral
         * @param   {string}     value     
         * @param   {boolean}    hidden
         * @return  {string}
         */
        GetLiteral$1(value: string | null, hidden: boolean): string | null;
        /**
         * Generate string that will be parsed as a string literal.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Text.StringLiteral
         * @memberof Kusto.Cloud.Platform.Text.StringLiteral
         * @param   {string}    value
         * @return  {string}
         */
        GetLiteralAsHiddenString(value: string | null): string | null;
    }
    var StringLiteral: StringLiteralFunc;

}

    /**
     * @memberof System
     * @callback System.Action
     * @return  {void}
     */

    /** @namespace System */

    /**
     * @memberof System
     * @callback System.Func
     * @param   {System.Object}    arg
     * @return  {string}
     */

declare namespace Kusto.Cloud.Platform.Utils {
    interface ExtendedStringBuilder {
    }
    interface ExtendedStringBuilderFunc extends Function {
        prototype: ExtendedStringBuilder;
        new (): ExtendedStringBuilder;
        InitializeStringBuildIfNeeded(value: string | null, sb: System.Text.StringBuilder | null, i: number): System.Text.StringBuilder | null;
    }
    var ExtendedStringBuilder: ExtendedStringBuilderFunc;

    /** @namespace Kusto.Cloud.Platform.Utils */

    /**
     * A per-thread cache of up to one {@link } object.
     This code is stolen from the .NET Framework source code. It is explicitly
     internal to Kusto.Cloud.Platform -- so not reuse the cache in other assemblies.
     *
     * @static
     * @abstract
     * @class Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache
     */
    interface UtilsStringBuilderCache {
    }
    interface UtilsStringBuilderCacheFunc extends Function {
        prototype: UtilsStringBuilderCache;
        new (): UtilsStringBuilderCache;
        Acquire(capacity?: number): System.Text.StringBuilder | null;
        Acquire$1(value: string | null): System.Text.StringBuilder | null;
        Release(sb: System.Text.StringBuilder | null): void;
        GetStringAndRelease(sb: System.Text.StringBuilder | null): string | null;
        GetStringAndClear(sb: System.Text.StringBuilder | null): string | null;
    }
    var UtilsStringBuilderCache: UtilsStringBuilderCacheFunc;

    interface TimeSpanConstants {
    }
    interface TimeSpanConstantsFunc extends Function {
        prototype: TimeSpanConstants;
        new (): TimeSpanConstants;
        _2sec: System.TimeSpan;
        _10sec: System.TimeSpan;
        _20sec: System.TimeSpan;
        _1min: System.TimeSpan;
        _2min: System.TimeSpan;
        _3min: System.TimeSpan;
        _4min: System.TimeSpan;
        _5min: System.TimeSpan;
        _10min: System.TimeSpan;
        _59min: System.TimeSpan;
        _60min: System.TimeSpan;
        _1hour: System.TimeSpan;
        _2hours: System.TimeSpan;
        _3hours: System.TimeSpan;
        _4hours: System.TimeSpan;
        _5hours: System.TimeSpan;
        _6hours: System.TimeSpan;
        _10hours: System.TimeSpan;
    }
    var TimeSpanConstants: TimeSpanConstantsFunc;

    /**
     * A helper for creating a per-thread ([ThreadStatic]) StringBuilder cache.
     This code is stolen from the .NET Framework source code. The code requires
     the caller to declare a [ThreadStatic] field member of type StringBuilder,
     and provide a reference to that field with each operation. See
     {@link } for an example.
     Note that it's not advisable to share such objects if their lifetime
     overlaps (which is why {@link } is made
     internal -- to prevent people from making mistakes).
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Cloud.Platform.Utils.StringBuilderCache
     */
    interface StringBuilderCache {
    }
    interface StringBuilderCacheFunc extends Function {
        prototype: StringBuilderCache;
        new (): StringBuilderCache;
        /**
         * Given a [ThreadStatic] field, returns a "clean" instance of {@link }.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @memberof Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @param   {System.Text.StringBuilder}    threadStaticStringBuilder    [ThreadStatic] static System.Text.StringBuilder s_myStringBuilderCache
         * @param   {number}                       capacity                     Capacity to ensure the returned object holds.
         * @param   {number}                       maxBuilderSize               The maximum size to allow the string builder to grow to.
         * @return  {System.Text.StringBuilder}
         */
        Acquire(threadStaticStringBuilder: {v: System.Text.StringBuilder | null}, capacity?: number, maxBuilderSize?: number): System.Text.StringBuilder | null;
        /**
         * Given a [ThreadStatic] field, returns an instance of {@link } with the given initial value.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @memberof Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @param   {System.Text.StringBuilder}    threadStaticStringBuilder    [ThreadStatic] static System.Text.StringBuilder s_myStringBuilderCache
         * @param   {string}                       value                        Initial value to assign the {@link } being returned.
         * @return  {System.Text.StringBuilder}
         */
        Acquire$1(threadStaticStringBuilder: {v: System.Text.StringBuilder | null}, value: string | null): System.Text.StringBuilder | null;
        /**
         * Given a [ThreadStatic] field and an existing {@link } that was acquired from it,
         release the acquired instance to make it available in the future to other functions.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @memberof Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @param   {System.Text.StringBuilder}    threadStaticStringBuilder    [ThreadStatic] static System.Text.StringBuilder s_myStringBuilderCache
         * @param   {System.Text.StringBuilder}    sb                           
         * @param   {number}                       maxBuilderSize
         * @return  {void}
         */
        Release(threadStaticStringBuilder: {v: System.Text.StringBuilder | null}, sb: System.Text.StringBuilder | null, maxBuilderSize?: number): void;
        /**
         * Given a [ThreadStatic] field and an existing {@link } that was acquired from it,
         release the acquired instance to make it available in the future to other functions.
         Returns the string held in the returned <b />.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @memberof Kusto.Cloud.Platform.Utils.StringBuilderCache
         * @param   {System.Text.StringBuilder}    threadStaticStringBuilder    [ThreadStatic] static System.Text.StringBuilder s_myStringBuilderCache
         * @param   {System.Text.StringBuilder}    sb                           
         * @param   {number}                       maxBuilderSize
         * @return  {string}
         */
        GetStringAndRelease(threadStaticStringBuilder: {v: System.Text.StringBuilder | null}, sb: System.Text.StringBuilder | null, maxBuilderSize?: number): string | null;
        GetStringAndClear(threadStaticStringBuilder: {v: System.Text.StringBuilder | null}, sb: System.Text.StringBuilder | null): string | null;
    }
    var StringBuilderCache: StringBuilderCacheFunc;

    interface MemoryConstants {
    }
    interface MemoryConstantsFunc extends Function {
        prototype: MemoryConstants;
        new (): MemoryConstants;
        _1KB: number;
        _2KB: number;
        _4KB: number;
        _8KB: number;
        _16KB: number;
        _32KB: number;
        _64KB: number;
        _128KB: number;
        _256KB: number;
        _512KB: number;
        _1MB: number;
        _2MB: number;
        _32MB: number;
        _64MB: number;
        _512MB: number;
        _1GB: number;
        _1TB: System.Int64;
        _1PB: System.Int64;
        LargeObjectHeap: number;
        LargeObjectHeapChars: number;
        /**
         * When using UTF8Encoding, StreamWriter multiplies the bufferSize supplied during construction by 3. Use this constant to avoid LOH
         *
         * @static
         * @public
         * @memberof Kusto.Cloud.Platform.Utils.MemoryConstants
         * @constant
         * @default 24576
         * @type number
         */
        LargeObjectHeapCharsStreamReaderWriter: number;
    }
    var MemoryConstants: MemoryConstantsFunc;

    /**
     * Extensions for {@link }
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Cloud.Platform.Utils.ExtendedString
     */
    interface ExtendedString {
    }
    interface ExtendedStringFunc extends Function {
        prototype: ExtendedString;
        new (): ExtendedString;
        /**
         * A delegate that can be used to get an object's value safely
         when it is unknown if the object will be null or not.
         *
         * @static
         * @public
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @type System.Func
         */
        SafeToString: {(arg: any): string} | null;
        /**
         * An empty (no elements) string array.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @type Array.<string>
         */
        EmptyArray: string[] | null;
        /**
         * A safe version (will not throw on null) of string.GetHashCode().
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    value
         * @return  {number}
         */
        SafeGetHashCode(value: string | null): number;
        /**
         * This fast calculation is relying on the fact that the different characters in the 
         Guid are already random (across a limited range of values though)".
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    value
         * @return  {number}
         */
        GuidSafeFastGetHashCode(value: string | null): number;
        /**
         * Returns the value of the string, unless it is a null or empty string,
         in which returns a specific text to print in a trace.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    value
         * @return  {string}
         */
        SafeToTraceString(value: string | null): string | null;
        /**
         * Like {@link }, but extra-safe with nulls.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                   format    
         * @param   {Array.<System.Object>}    args
         * @return  {string}
         */
        SafeFormat(format: string | null, args: any[] | null): string | null;
        /**
         * Replaces the format item in a specified string with the string representation
         of a corresponding object in a specified array with the current culture.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @throws {System.ArgumentNullException} format or args is null.
         * @throws {System.FormatException} format is invalid.-or- The index of a format item is less than zero, or greater
         than or equal to the length of the args array.
         * @param   {string}                   format    A composite format string.
         * @param   {Array.<System.Object>}    args      An object array that contains zero or more objects to format.
         * @return  {string}                             A copy of format in which the format items have been replaced by the string
         representation of the corresponding objects in args.
         */
        FormatWithCurrentCulture(format: string | null, args: any[] | null): string | null;
        /**
         * Replaces the format item in a specified string with the string representation
         of a corresponding object in a specified array with an invariant culture.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @throws {System.ArgumentNullException} format or args is null.
         * @throws {System.FormatException} format is invalid.-or- The index of a format item is less than zero, or greater
         than or equal to the length of the args array.
         * @param   {string}                   format    A composite format string.
         * @param   {Array.<System.Object>}    args      An object array that contains zero or more objects to format.
         * @return  {string}                             A copy of format in which the format items have been replaced by the string
         representation of the corresponding objects in args.
         */
        FormatWithInvariantCulture(format: string | null, args: any[] | null): string | null;
        /**
         * Replaces the format item in a specified string with the string representation
         of a corresponding object in a specified array. A specified parameter supplies
         culture-specific formatting information.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @throws {System.ArgumentNullException} format or args is null.
         * @throws {System.FormatException} format is invalid.-or- The index of a format item is less than zero, or greater
         than or equal to the length of the args array.
         * @param   {string}                    format            A composite format string.
         * @param   {System.IFormatProvider}    formatProvider    An object that supplies culture-specific formatting information.
         * @param   {Array.<System.Object>}     args              An object array that contains zero or more objects to format.
         * @return  {string}                                      A copy of format in which the format items have been replaced by the string
         representation of the corresponding objects in args.
         */
        FormatWith(format: string | null, formatProvider: System.IFormatProvider | null, args: any[] | null): string | null;
        /**
         * Returns true if the string is null, empty, whitespace, or
         indicates a null Guid (all zeros).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     value
         * @return  {boolean}
         */
        SafeIsNullGuid(value: string | null): boolean;
        /**
         * Returns true if the string is a valid, non-null GUID
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     value
         * @return  {boolean}
         */
        SafeIsValidGuid(value: string | null): boolean;
        /**
         * Gets back a string that describes the difference between two strings.
         Useful mainly for tests, in case one wants to easily highlight test failures
         due to expected/actual mismatch in the values of two strings.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    lhs    
         * @param   {string}    rhs
         * @return  {string}
         */
        GetDiff(lhs: string | null, rhs: string | null): string | null;
        /**
         * Like {@link }, but ensures that it doesn't throw
         on invalid strings or invalid boundary conditions.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    value         
         * @param   {number}    startIndex    
         * @param   {number}    count
         * @return  {string}
         */
        SafeSubstring(value: string | null, startIndex: number, count: number): string | null;
        /**
         * Returns true if the string is a valid and non-empty
         base-64 string.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     value              
         * @param   {boolean}    allowWhitespace
         * @return  {boolean}
         */
        SafeIsValidNonEmptyBase64(value: string | null, allowWhitespace?: boolean): boolean;
        /**
         * Returns true if the string is nothing but a '//' comment block,
         potentially with whitespace characters before each '//' and multiple
         lines. If the string is empty or null we return true as well.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     cmd
         * @return  {boolean}
         */
        SafeIsDoubleSlashCommentOrEmptyBlock(cmd: string | null): boolean;
        /**
         * Removes initial newlines, terminating newlines, and all mid-newlines that
         indicate empty lines.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        SafeFastTrimEmptyLines(text: string | null): string | null;
        /**
         * Removes all leading and trailing white-space characters from the given string
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        SafeFastTrim(text: string | null): string | null;
        /**
         * Trims a prefix from a string
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     text          The text to trim.
         * @param   {string}                     prefix        Prefix to remove.
         * @param   {System.StringComparison}    comparison    How to compare strings.
         * @return  {string}                                   The trimmed string.
         */
        TrimStart$1(text: string | null, prefix: string | null, comparison?: System.StringComparison): string | null;
        /**
         * Trims a character from the beginning of a string.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     text       The text to trim.
         * @param   {number}     c          The character to remove from the beginning of <b>c</b>
         if it exists.
         * @param   {boolean}    justOne    If true, remove just one instance of the character.
         * @return  {string}                The trimmed string.
         */
        TrimStart(text: string | null, c: number, justOne: boolean): string | null;
        /**
         * Trims a suffix from a string
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     text          The text to trim.
         * @param   {string}                     suffix        Suffix to remove
         * @param   {System.StringComparison}    comparison
         * @return  {string}
         */
        TrimEnd(text: string | null, suffix: string | null, comparison?: System.StringComparison): string | null;
        /**
         * Removes a single pair of balanced [ and ] characters
         that start and end the string, if they exist.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        TrimBalancedSquareBrackets(text: string | null): string | null;
        /**
         * Removes a single pair of balanced ( and ) characters
         that start and end the string, if they exist.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        TrimBalancedRoundBrackets(text: string | null): string | null;
        /**
         * Removes a single pair of balanced { and } characters
         that start and end the string, if they exist.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        TrimBalancedCurlyBrackets(text: string | null): string | null;
        /**
         * Removes a single pair of balanced [ and ] characters
         that start and end the string, if they exist.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     text          
         * @param   {string}                     openning      
         * @param   {string}                     closing       
         * @param   {System.StringComparison}    comparison
         * @return  {string}
         */
        TrimBalanced(text: string | null, openning: string | null, closing: string | null, comparison?: System.StringComparison): string | null;
        /**
         * Trims a string from single (') or double (") quotes surrounding it,
         as long as they are balanced.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        TrimBalancedSingleAndDoubleQuotes(text: string | null): string | null;
        /**
         * Given a string, breaks the string into lines
         and determines the length of the longest line.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {number}
         */
        DetermineMaxLineWidth(text: string | null): number;
        /**
         * Counts the number of occurrences of the character <b />
         within the string <b />. Does not fail on null  values.
         Count stops at <b /> (if negative, counting stops
         when the string is exhausted).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}          value       
         * @param   {number}          c           
         * @param   {System.Int64}    maxCount
         * @return  {System.Int64}
         */
        SafeCountCharacterUpTo(value: string | null, c: number, maxCount: System.Int64): System.Int64;
        /**
         * Counts the number of occurrences of any of these characters <b />
         within the string <b />. Does not fail on null  values.
         Count stops at <b /> (if negative, counting stops
         when the string is exhausted).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}            value       
         * @param   {Array.<number>}    chars       
         * @param   {System.Int64}      maxCount
         * @return  {System.Int64}
         */
        SafeCountAnyCharacterUpTo(value: string | null, chars: number[] | null, maxCount: System.Int64): System.Int64;
        
        FindFirstNonWhitespaceCharacter(value: string | null, index?: number): number;
        /**
         * Returns the index of the first character that is not equal between two strings.
         Returns -1 if they are identical.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    lhs    
         * @param   {string}    rhs
         * @return  {number}
         */
        FirstFirstUnequalCharacter(lhs: string | null, rhs: string | null): number;
        /**
         * Counts how many times a substring appears in the string, non-overlapping.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     text          The string we suspect may have one or more appearrences of the substring.
         * @param   {string}                     substring     The substring to find and count. Non-null and non-empty.
         * @param   {System.StringComparison}    comparison    How to compare strings.
         * @return  {number}                                   The number of times <b /> appears in <b />
         (non-overlapping: "aa" appears exactly twice in "aaaa", not three times).
         */
        CountNonOverlappingSubstrings(text: string | null, substring: string | null, comparison?: System.StringComparison): number;
        /**
         * Returns true if <b />'s first character
         is <b />, or false otherwise. Tolerant
         to null strings.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     what    
         * @param   {number}     c
         * @return  {boolean}
         */
        SafeStartsWith(what: string | null, c: number): boolean;
        /**
         * Returns true if <b /> starts with <b />, or false otherwise. Tolerant
         to null strings.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     what          
         * @param   {string}                     value         
         * @param   {System.StringComparison}    comparison
         * @return  {boolean}
         */
        SafeStartsWith$1(what: string | null, value: string | null, comparison?: System.StringComparison): boolean;
        EqualsOrdinalIgnoreCase(me: string | null, other: string | null): boolean;
        IsEmpty(me: string | null): boolean;
        IsNotEmpty(me: string | null): boolean;
        IsNullOrEmpty(me: string | null): boolean;
        IsNotNullOrEmpty(me: string | null): boolean;
        /**
         * Similar to {@link }, but (1) gets the number of characters
         in the "tail" to return rather than the count of characters to skip, and (2) is safe
         and does not throw.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    what      
         * @param   {number}    length
         * @return  {string}
         */
        SafeGetTail(what: string | null, length: number): string | null;
        /**
         * Returns the index of the string <b /> inside string <b />
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    what     
         * @param   {number}    value
         * @return  {number}
         */
        SafeIndexOf(what: string | null, value: number): number;
        /**
         * Returns the index of the string <b /> inside string <b />
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     what              
         * @param   {string}                     value             
         * @param   {number}                     startIndex        
         * @param   {System.StringComparison}    comparisonType
         * @return  {number}
         */
        SafeIndexOf$2(what: string | null, value: string | null, startIndex: number, comparisonType: System.StringComparison): number;
        /**
         * Returns the index of the string <b /> inside string <b />
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     what              
         * @param   {string}                     value             
         * @param   {number}                     startIndex        
         * @param   {number}                     count             
         * @param   {System.StringComparison}    comparisonType
         * @return  {number}
         */
        SafeIndexOf$1(what: string | null, value: string | null, startIndex: number, count: number, comparisonType: System.StringComparison): number;
        /**
         * Returns the beginning of the string <b /> up to
         but not including the first appearance of <b />.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}                     what          
         * @param   {string}                     delimiter     
         * @param   {System.StringComparison}    comparison
         * @return  {string}
         */
        SplitFirst$2(what: string | null, delimiter: string | null, comparison?: System.StringComparison): string | null;
        /**
         * Returns the beginning of the string <b /> up to
         but not including the first appearance of <b />.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    what         
         * @param   {number}    delimiter
         * @return  {string}
         */
        SplitFirst(what: string | null, delimiter: number): string | null;
        /**
         * Returns the beginning of the string <b /> up to
         but not including the first appearance of any of the chars in <b />.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}            what          
         * @param   {Array.<number>}    delimiters
         * @return  {string}
         */
        SplitFirst$1(what: string | null, delimiters: number[] | null): string | null;
        /**
         * Rotates right the string (right shift, where the last character becomes the first).
         (It might create an invalid string, for Some unicode characters that don't fit 16 bits and are represented by two UTF16 characters).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    s
         * @return  {string}
         */
        Rotate(s: string | null): string | null;
        /**
         * Changes the new line symbols '\n' and '\r' to Envorinment.NewLine
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}    text
         * @return  {string}
         */
        AdjustNewLineDelimiter(text: string | null): string | null;
        ReplaceInvisibleWhitespaces(value: string | null): string | null;
        /**
         * Checks if the string has non-Ascii quotes
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedString
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedString
         * @param   {string}     value
         * @return  {boolean}
         */
        HasNonAsciiQuotes(value: string | null): boolean;
        ReplaceNonAsciiQuotes(value: string | null): string | null;
        Replace(value: string | null, replacements: System.Collections.Generic.IDictionary$2<number,string> | null): string | null;
    }
    var ExtendedString: ExtendedStringFunc;

    interface CountConstants {
    }
    interface CountConstantsFunc extends Function {
        prototype: CountConstants;
        new (): CountConstants;
        _1K: number;
        _64K: number;
        _1M: number;
    }
    var CountConstants: CountConstantsFunc;

    /**
     * Enumerable extension methods
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Cloud.Platform.Utils.ExtendedEnumerable
     */
    interface ExtendedEnumerable {
    }
    interface ExtendedEnumerableFunc extends Function {
        prototype: ExtendedEnumerable;
        new (): ExtendedEnumerable;
        /**
         * Like Enumerable.LongCount, but stops counting at maxCount.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    TSource     
         * @param   {System.Collections.Generic.IEnumerable$1}    source      
         * @param   {System.Int64}                                maxCount
         * @return  {System.Int64}
         */
        LongCount<TSource>(TSource: {prototype: TSource}, source: System.Collections.Generic.IEnumerable$1<TSource> | null, maxCount: System.Int64): System.Int64;
        SafeFastDistinct<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Counts how many elements are in the collection, but does it safely
         (if the collection is null, returns 0) and efficiently (if the count
         is more than maxCount, stops at maxCount).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             
         * @param   {System.Collections.Generic.IEnumerable$1}    collection    
         * @param   {System.Int64}                                maxCount
         * @return  {System.Int64}
         */
        SafeFastCountUpTo<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, maxCount: System.Int64): System.Int64;
        /**
         * Safely checks if 2 sequences are the same, by ordering them and then using an IEqualityComparer (or a default EqualityComparer in case of null).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                          T                   
         * @param   {System.Collections.Generic.IEnumerable$1}          collection          
         * @param   {System.Collections.Generic.IEnumerable$1}          other               
         * @param   {System.Collections.Generic.IEqualityComparer$1}    equalityComparer
         * @return  {boolean}
         */
        SafeSequenceEquals<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, other: System.Collections.Generic.IEnumerable$1<T> | null, equalityComparer?: System.Collections.Generic.IEqualityComparer$1<T> | null): boolean;
        /**
         * Safely checks if 2 already sorted sequences are the same,
         returns true only if all elements and their corresponding element are equal with the given IEqualityComparer (or a default EqualityComparer in case of null).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                          T                    
         * @param   {System.Collections.Generic.IEnumerable$1}          sortedCollection1    The sorted first collection.
         * @param   {System.Collections.Generic.IEnumerable$1}          sortedCollection2    The sorted second collection2.
         * @param   {System.Collections.Generic.IEqualityComparer$1}    equalityComparer     The equality comparer.
         * @return  {boolean}
         */
        SortedSequenceEquals<T>(T: {prototype: T}, sortedCollection1: System.Collections.Generic.IEnumerable$1<T> | null, sortedCollection2: System.Collections.Generic.IEnumerable$1<T> | null, equalityComparer?: System.Collections.Generic.IEqualityComparer$1<T> | null): boolean;
        /**
         * Safely checks if 2 sequences are the same using a predicate. Does not order the sequences and compares their elements as is.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             
         * @param   {System.Collections.Generic.IEnumerable$1}    collection    
         * @param   {System.Collections.Generic.IEnumerable$1}    other         
         * @param   {System.Func}                                 predicate
         * @return  {boolean}
         */
        SequenceEqual<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, other: System.Collections.Generic.IEnumerable$1<T> | null, predicate: {(arg1: T, arg2: T): boolean} | null): boolean;
        /**
         * Safely compares two collections, ignoring duplications.
         Returns true if they are equal.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T        
         * @param   {System.Collections.Generic.IEnumerable$1}    that     
         * @param   {System.Collections.Generic.IEnumerable$1}    other
         * @return  {boolean}
         */
        SafeSetEquals<T>(T: {prototype: T}, that: System.Collections.Generic.IEnumerable$1<T> | null, other: System.Collections.Generic.IEnumerable$1<T> | null): boolean;
        /**
         * Creates a display string for collection
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T                      
         * @param   {System.Collections.Generic.IEnumerable$1}    collection             The collection.
         * @param   {string}                                      delimiter              The delimiter between each displayed element.
         * @param   {?number}                                     maxTake                The maximum number of elements displayed.
         * @param   {string}                                      nullString             The string representing null value.
         * @param   {number}                                      estimatedStringSize    Estimated final string size, for improved performance.
         * @param   {string}                                      elementPrefix          Prefix to element.
         * @param   {string}                                      elementPostfix         Postfix to element.
         * @return  {string}                                                             Formatted display string
         */
        ToDisplayString<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, delimiter?: string | null, maxTake?: number | null, nullString?: string | null, estimatedStringSize?: number, elementPrefix?: string | null, elementPostfix?: string | null): string | null;
        /**
         * Safely clones an existing collection in a shallow manner (it's the responsibility
         of the element itself to be a value type of immutable).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             
         * @param   {System.Collections.Generic.IEnumerable$1}    collection
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        SafeShallowClone<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Returns the 0-based index of the first item in the collection
         for which the predicate returns true, or -1.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    TCollection    
         * @param   {System.Collections.Generic.IEnumerable$1}    collection     
         * @param   {System.Func}                                 predicate
         * @return  {number}
         */
        IndexOf<TCollection>(TCollection: {prototype: TCollection}, collection: System.Collections.Generic.IEnumerable$1<TCollection> | null, predicate: {(arg: TCollection): boolean} | null): number;
        /**
         * Returns a collection that is the concatenation of two other collections.
         Any of the arguments may be null. Result might also be null.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T         
         * @param   {System.Collections.Generic.IEnumerable$1}    first     
         * @param   {System.Collections.Generic.IEnumerable$1}    second
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        SafeConcat<T>(T: {prototype: T}, first: System.Collections.Generic.IEnumerable$1<T> | null, second: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Returns a collection that is the union of two other collections (duplicates are excluded).
         Any of the arguments may be null. Result might also be null.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T         
         * @param   {System.Collections.Generic.IEnumerable$1}    first     
         * @param   {System.Collections.Generic.IEnumerable$1}    second
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        SafeUnion<T>(T: {prototype: T}, first: System.Collections.Generic.IEnumerable$1<T> | null, second: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Returns the collection unless it is null or holds no elements,
         in which case return null.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}       TCollection    
         * @param   {TCollection}    collection
         * @return  {TCollection}
         */
        SafeFastNullIfEmpty<TCollection>(TCollection: {prototype: TCollection}, collection: TCollection | null): TCollection | null;
        SafeEmptyIEnumerableIfNull<T>(T: {prototype: T}, collectionEnumerable: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Similar to IEnumerable{T}.Any, only faster and works on null arguments.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             
         * @param   {System.Collections.Generic.IEnumerable$1}    collection
         * @return  {boolean}
         */
        SafeFastAny$2<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null): boolean;
        SafeFastAny$4<T>(T: {prototype: T}, list: System.Collections.Generic.List$1<T> | null): boolean;
        SafeFastAny$1<T>(T: {prototype: T}, collection: System.Collections.Generic.ICollection$1<T> | null): boolean;
        /**
         * Similar to IEnumerable.Any, only faster and works on null arguments.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {System.Collections.IEnumerable}    collection
         * @return  {boolean}
         */
        SafeFastAny(collection: System.Collections.IEnumerable | null): boolean;
        SafeFastAny$3<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, predicate: {(arg: T): boolean} | null): boolean;
        /**
         * Similar to IEnumerable{T}.None, only faster and works on null arguments.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             
         * @param   {System.Collections.Generic.IEnumerable$1}    collection
         * @return  {boolean}
         */
        SafeFastNone$2<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null): boolean;
        SafeFastNone$1<T>(T: {prototype: T}, collection: System.Collections.Generic.ICollection$1<T> | null): boolean;
        /**
         * Similar to IEnumerable.None, only faster and works on null arguments.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {System.Collections.IEnumerable}    collection
         * @return  {boolean}
         */
        SafeFastNone(collection: System.Collections.IEnumerable | null): boolean;
        SafeFastNone$3<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, predicate: {(arg: T): boolean} | null): boolean;
        /**
         * Inverse of IEnumerable{T}.Any(predicate)
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T            Element type
         * @param   {System.Collections.Generic.IEnumerable$1}    source       The source IEnumerable.
         * @param   {System.Func}                                 predicate    The predicate.
         * @return  {boolean}                                                  true if none of the specified collection items match the given predicate
         */
        None$1<T>(T: {prototype: T}, source: System.Collections.Generic.IEnumerable$1<T> | null, predicate: {(arg: T): boolean} | null): boolean;
        /**
         * Overload. Inverse of IEnumerable{T}.Any()
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T         Element type
         * @param   {System.Collections.Generic.IEnumerable$1}    source    The source IEnumerable.
         * @return  {boolean}                                               true if the collection is empty
         */
        None<T>(T: {prototype: T}, source: System.Collections.Generic.IEnumerable$1<T> | null): boolean;
        /**
         * Similar to IEnumerable{T}.Contains, only faster and works on null arguments.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                          T             
         * @param   {System.Collections.Generic.IEnumerable$1}          collection    
         * @param   {T}                                                 item          
         * @param   {System.Collections.Generic.IEqualityComparer$1}    comparer
         * @return  {boolean}
         */
        SafeFastContains<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, item: T, comparer?: System.Collections.Generic.IEqualityComparer$1<T> | null): boolean;
        /**
         * Returns a collection where each key appears only once
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T              Element type
         * @param   {Function}                                    TKey           Key selector
         * @param   {System.Collections.Generic.IEnumerable$1}    source         IEnumerable collection
         * @param   {System.Func}                                 keySelector    Key selector function
         * @return  {System.Collections.Generic.IEnumerable$1}                   Returns collection of items that are aggregated by unique key selector
         */
        DistinctBy<T, TKey>(T: {prototype: T}, TKey: {prototype: TKey}, source: System.Collections.Generic.IEnumerable$1<T> | null, keySelector: {(arg: T): TKey} | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Returns an intersection of the given collections
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T              Element type
         * @param   {System.Collections.Generic.IEnumerable$1}    collections    The collection to intersect
         * @return  {System.Collections.Generic.IEnumerable$1}                   Returns collection of items with the given collections intersection
         */
        Intersect<T>(T: {prototype: T}, collections: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.IEnumerable$1<T>> | null): System.Collections.Generic.IEnumerable$1<T> | null;
        /**
         * Splits a collection to a Tuple of two lists.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedEnumerable
         * @param   {Function}                                    T             Element type of the collection.
         * @param   {Function}                                    TR            Element type of the results in the generated lists.
         * @param   {System.Collections.Generic.IEnumerable$1}    collection    The collection to split
         * @param   {System.Func}                                 isFirst       Function that runs on each item and determines where it should go.
         - null will be filtered out
         - true will go in the first array
         - false will go in the second array
         * @param   {System.Func}                                 transform     Function that can transform the returned items.
         - Default will be the first item of the tuple.
         * @return  {System.Tuple$2}                                            Returns Tuple of two lists
         */
        SplitBy<T, TR>(T: {prototype: T}, TR: {prototype: TR}, collection: System.Collections.Generic.IEnumerable$1<T> | null, isFirst: {(arg: T): boolean} | null, transform?: {(arg: T): TR} | null): System.Tuple$2<System.Collections.Generic.List$1<TR>,System.Collections.Generic.List$1<TR>> | null;
        IntersectWith<T>(T: {prototype: T}, collection: System.Collections.Generic.IEnumerable$1<T> | null, other: System.Collections.Generic.IEnumerable$1<T> | null): System.Collections.Generic.IEnumerable$1<T> | null;
    }
    var ExtendedEnumerable: ExtendedEnumerableFunc;

    /**
     * A wrapper class for {@link }.
     Provides time simulation capabilities.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Cloud.Platform.Utils.ExtendedDateTime
     */
    interface ExtendedDateTime {
    }
    interface ExtendedDateTimeFunc extends Function {
        prototype: ExtendedDateTime;
        RoundTo: ExtendedDateTime.RoundToFunc;
        new (): ExtendedDateTime;
        /**
         * The min value of a DateTime, in UTC.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @type System.DateTime
         */
        MinValueUtc: System.DateTime;
        /**
         * The max value of a DateTime, in UTC.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @type System.DateTime
         */
        MaxValueUtc: System.DateTime;
        /**
         * A list of datetime formats which we support but aren't supported by the default IFormatProvider
         which we use for DateTime.Parse.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @type System.Collections.Generic.Dictionary$2
         */
        SupportedNonStandardFormats: System.Collections.Generic.Dictionary$2<number,string[]> | null;
        /**
         * Jan 1 1970 ("epoch")
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @type System.DateTime
         */
        EpochStart: System.DateTime;
        MaxUnixTimeMilliseconds: System.Int64;
        MinUnixTimeMilliseconds: System.Int64;
        MaxUnixTimeMicroseconds: System.Int64;
        MinUnixTimeMicroseconds: System.Int64;
        /**
         * An event invoked when {@link } is invoked
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @function addOnStopSimulatingTime
         * @param   {System.Action}    value
         * @return  {void}
         */
        addOnStopSimulatingTime(value: {(): void} | null): void;
        /**
         * An event invoked when {@link } is invoked
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @function removeOnStopSimulatingTime
         * @param   {System.Action}    value
         * @return  {void}
         */
        removeOnStopSimulatingTime(value: {(): void} | null): void;
        /**
         * Is time currently being simulated?
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @function IsSimulatingTime
         * @type boolean
         */
        IsSimulatingTime: boolean;
        /**
         * Wraps {@link }
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @function UtcNow
         * @type System.DateTime
         */
        UtcNow: System.DateTime;
        /**
         * Stops time simulation.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @return  {void}
         */
        StopSimulatingTime(): void;
        ToUtcString(value: System.DateTime): string | null;
        ToUtcString$1(value: System.DateTime, culture: System.Globalization.CultureInfo | null): string | null;
        /**
         * Returns the greater of 2 dates
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    t1    The t1.
         * @param   {System.DateTime}    t2    The t2.
         * @return  {System.DateTime}
         */
        Max(t1: System.DateTime, t2: System.DateTime): System.DateTime;
        /**
         * Returns the greater of 2 dates
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {?System.DateTime}    t1    The t1.
         * @param   {?System.DateTime}    t2    The t2.
         * @return  {?System.DateTime}
         */
        Max$1(t1: System.DateTime | null, t2: System.DateTime | null): System.DateTime | null;
        /**
         * Returns the lesser of 2 dates
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    t1    The t1.
         * @param   {System.DateTime}    t2    The t2.
         * @return  {System.DateTime}
         */
        Min(t1: System.DateTime, t2: System.DateTime): System.DateTime;
        /**
         * Returns the lesser of 2 dates
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {?System.DateTime}    t1    The t1.
         * @param   {?System.DateTime}    t2    The t2.
         * @return  {?System.DateTime}
         */
        Min$1(t1: System.DateTime | null, t2: System.DateTime | null): System.DateTime | null;
        /**
         * Checks if there is an intersection between two date ranges.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    firstStart     Start datetime of the first range
         * @param   {System.DateTime}    firstEnd       End datetime of the first range
         * @param   {System.DateTime}    secondStart    Start datetime of the second range
         * @param   {System.DateTime}    secondEnd      End datetime of the second range
         * @return  {boolean}
         */
        RangesIntersect(firstStart: System.DateTime, firstEnd: System.DateTime, secondStart: System.DateTime, secondEnd: System.DateTime): boolean;
        /**
         * Returns the time in UNIX format (the diff time between the date and Jan 1 1970).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    date    The date.
         * @return  {System.TimeSpan}            The diff time since Jan 1 1970
         */
        ToUnixTimeSpan(date: System.DateTime): System.TimeSpan;
        /**
         * Returns a {@link } that has the same numeric value in ticks
         as the time span.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.TimeSpan}    timeSpan
         * @return  {System.DateTime}
         */
        FromTimeSpan(timeSpan: System.TimeSpan): System.DateTime;
        /**
         * Returns ISO 8601 Datetime string with timezone
         Example: 2020-10-28 13:48:10 +03:00
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    dateTime
         * @return  {string}
         */
        ToZonalTimeDisplayString(dateTime: System.DateTime): string | null;
        /**
         * Returns a {@link } that is the value in UTC of the date/time.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedDateTime
         * @param   {System.DateTime}    value
         * @return  {System.DateTime}
         */
        ToUtc(value: System.DateTime): System.DateTime;
        FastGetParts(value: System.DateTime, year: {v: number}, month: {v: number}, day: {v: number}, hour: {v: number}, minute: {v: number}, second: {v: number}, fraction: {v: System.Int64}): void;
        FromUnixTimeSeconds$1(seconds: System.Int64): System.DateTime;
        FromUnixTimeSeconds(seconds: number): System.DateTime;
        FromUnixTimeMilliseconds$1(milliseconds: System.Int64): System.DateTime;
        FromUnixTimeMilliseconds(milliseconds: number): System.DateTime;
        FromUnixTimeMicroseconds$1(microseconds: System.Int64): System.DateTime;
        FromUnixTimeMicroseconds(microseconds: number): System.DateTime;
        FromUnixTimeNanoseconds(nanoseconds: System.Int64): System.DateTime;
    }
    var ExtendedDateTime: ExtendedDateTimeFunc;
    module ExtendedDateTime {
        /**
         * Date Time Round To options
         *
         * @public
         * @class number
         */
        interface RoundTo {
        }
        interface RoundToFunc extends Function {
            prototype: RoundTo;
            /**
             * Round to nearest second
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 0
             * @type number
             */
            Second: number;
            /**
             * Round to nearest minute
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 1
             * @type number
             */
            Minute: number;
            /**
             * Round to nearest hour
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 2
             * @type number
             */
            Hour: number;
            /**
             * Round to nearest day
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 3
             * @type number
             */
            Day: number;
        }
    }

    /**
     * Represents a range between 2 dates
     *
     * @public
     * @class Kusto.Cloud.Platform.Utils.DateTimeRange
     * @implements  System.IEquatable$1
     */
    interface DateTimeRange extends System.IEquatable$1<Kusto.Cloud.Platform.Utils.DateTimeRange> {
        /**
         * The beginning date
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @function Begin
         * @type System.DateTime
         */
        Begin: System.DateTime;
        /**
         * The end date
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @function End
         * @type System.DateTime
         */
        End: System.DateTime;
        /**
         * The span between the dates
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @function Span
         * @type System.TimeSpan
         */
        Span: System.TimeSpan;
        /**
         * If the range is open.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @function IsOpenRange
         * @type boolean
         */
        IsOpenRange: boolean;
        IsInRangeInclusive(value: System.DateTime): boolean;
        IsInRangeExclusive(value: System.DateTime): boolean;
        /**
         * Implement IEquatable{ReportingHandsetStatRecord}
         *
         * @instance
         * @public
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {Kusto.Cloud.Platform.Utils.DateTimeRange}    other
         * @return  {boolean}
         */
        equalsT(other: Kusto.Cloud.Platform.Utils.DateTimeRange): boolean;
        /**
         * Override {@link }
         *
         * @instance
         * @public
         * @override
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {System.Object}    other
         * @return  {boolean}
         */
        equals(other: any | null): boolean;
        /**
         * Override {@link }
         *
         * @instance
         * @public
         * @override
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @return  {number}
         */
        getHashCode(): number;
        /**
         * Override {@link }
         *
         * @instance
         * @public
         * @override
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @return  {string}
         */
        toString(): string | null;
        $clone(to: Kusto.Cloud.Platform.Utils.DateTimeRange): Kusto.Cloud.Platform.Utils.DateTimeRange;
    }
    interface DateTimeRangeFunc extends Function {
        prototype: DateTimeRange;
        /**
         * Construction
         *
         * @instance
         * @public
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {System.DateTime}    begin    
         * @param   {System.DateTime}    end
         * @return  {void}
         */
        $ctor1: {
            new (begin: System.DateTime, end: System.DateTime): DateTimeRange
        };
        new (): DateTimeRange;
        ctor: {
            new (): DateTimeRange
        };
        /**
         * Get a range representing all of eternity
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @type Kusto.Cloud.Platform.Utils.DateTimeRange
         */
        All: Kusto.Cloud.Platform.Utils.DateTimeRange;
        /**
         * Return a range that "covers" two ranges, and potentially
         values that are not in any of the ranges (if the inputs
         do not overlap).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {Kusto.Cloud.Platform.Utils.DateTimeRange}    a    
         * @param   {Kusto.Cloud.Platform.Utils.DateTimeRange}    b
         * @return  {Kusto.Cloud.Platform.Utils.DateTimeRange}
         */
        Aggregate(a: Kusto.Cloud.Platform.Utils.DateTimeRange, b: Kusto.Cloud.Platform.Utils.DateTimeRange): Kusto.Cloud.Platform.Utils.DateTimeRange;
        /**
         * Merge any number of ranges and return the minimal set of
         ranges that covers them all precisely.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {System.Collections.Generic.IEnumerable$1}    ranges
         * @return  {System.Collections.Generic.HashSet$1}
         */
        Merge(ranges: System.Collections.Generic.IEnumerable$1<Kusto.Cloud.Platform.Utils.DateTimeRange> | null): System.Collections.Generic.HashSet$1<Kusto.Cloud.Platform.Utils.DateTimeRange> | null;
        /**
         * Returns every intersection of two ranges from each group.
         For example ([0, 10], [20, max]) and ([8, 30]) will produce ([8, 10], [20 - 30])
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.DateTimeRange
         * @memberof Kusto.Cloud.Platform.Utils.DateTimeRange
         * @param   {System.Collections.Generic.IEnumerable$1}    rangeGroupA    
         * @param   {System.Collections.Generic.IEnumerable$1}    rangeGroupB
         * @return  {System.Collections.Generic.HashSet$1}
         */
        Intersect(rangeGroupA: System.Collections.Generic.IEnumerable$1<Kusto.Cloud.Platform.Utils.DateTimeRange> | null, rangeGroupB: System.Collections.Generic.IEnumerable$1<Kusto.Cloud.Platform.Utils.DateTimeRange> | null): System.Collections.Generic.HashSet$1<Kusto.Cloud.Platform.Utils.DateTimeRange> | null;
    }
    var DateTimeRange: DateTimeRangeFunc;

    /**
     * Options to apply when chopping strings.
     *
     * @public
     * @class Kusto.Cloud.Platform.Utils.ChopOptions
     */
    enum ChopOptions {
        ChopFromBeginning = 1,
        ChopFromEnd = 2,
        ChopFromMiddle = 4,
        ThreeDotsCharacterNotSupported = 8
    }

    /**
     * CS freshman.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Cloud.Platform.Utils.BitTwiddling
     */
    interface BitTwiddling {
    }
    interface BitTwiddlingFunc extends Function {
        prototype: BitTwiddling;
        new (): BitTwiddling;
        /**
         * Count the number of bits set in the input (int).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.BitTwiddling
         * @memberof Kusto.Cloud.Platform.Utils.BitTwiddling
         * @param   {number}    n
         * @return  {number}
         */
        CountBits(n: number): number;
        /**
         * Count the number of bits set in the input (long).
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.BitTwiddling
         * @memberof Kusto.Cloud.Platform.Utils.BitTwiddling
         * @param   {System.Int64}    n
         * @return  {number}
         */
        CountBits$1(n: System.Int64): number;
    }
    var BitTwiddling: BitTwiddlingFunc;

    interface ExtendedRegex {
    }
    interface ExtendedRegexFunc extends Function {
        prototype: ExtendedRegex;
        new (): ExtendedRegex;
        TryUnescape(str: string | null, result: {v: string | null}): boolean;
        TryTransformWildCardPatternToRegex(wildcardPattern: string | null): System.Text.RegularExpressions.Regex | null;
        IsWildCardPattern(wildcardPattern: string | null): boolean;
        RegexEquals(regex: System.Text.RegularExpressions.Regex | null, other: any | null): boolean;
        /**
         * Compares Regex instances based on their Pattern, Options and MatchTimeout
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @param   {System.Text.RegularExpressions.Regex}    regex    
         * @param   {System.Text.RegularExpressions.Regex}    other
         * @return  {boolean}
         */
        RegexEquals$1(regex: System.Text.RegularExpressions.Regex | null, other: System.Text.RegularExpressions.Regex | null): boolean;
        /**
         * Compares Regex instances based on their Pattern and Options (disregards MatchTimeout)
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @param   {System.Text.RegularExpressions.Regex}    regex    
         * @param   {System.Text.RegularExpressions.Regex}    other
         * @return  {boolean}
         */
        RegexEquivalent(regex: System.Text.RegularExpressions.Regex | null, other: System.Text.RegularExpressions.Regex | null): boolean;
        /**
         * Replaces all strings in the input string that match the regular expression with the replacement string, and count number of replacements done.
         *
         * @static
         * @public
         * @this Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @memberof Kusto.Cloud.Platform.Utils.ExtendedRegex
         * @param   {System.Text.RegularExpressions.Regex}    regex            
         * @param   {string}                                  input            
         * @param   {string}                                  replacement      
         * @param   {System.Int32}                            replacesCount
         * @return  {string}
         */
        ReplaceAndCountReplacements(regex: System.Text.RegularExpressions.Regex | null, input: string | null, replacement: string | null, replacesCount: {v: number}): string | null;
    }
    var ExtendedRegex: ExtendedRegexFunc;

}

declare namespace Kusto.Data {
    /** @namespace Kusto.Data */

    /**
     * DM Settings Types
     *
     * @public
     * @class Kusto.Data.DmSettingsType
     */
    enum DmSettingsType {
        AdminSettings = 0,
        DataObtainerServiceSettings = 1,
        DataAggregatorSettings = 2,
        DataObtainerSettings = 3,
        CloudManagersSettings = 5,
        SchemaManagmentSettings = 6,
        CommonSettings = 7,
        DataImporterSettings = 8,
        StatusReporterSettings = 9,
        All = 10,
        VirtualDmsSettings = 11
    }

    /**
     * Extensions for enum DmSettingsType
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.ExtendedDmSettingsType
     */
    interface ExtendedDmSettingsType {
    }
    interface ExtendedDmSettingsTypeFunc extends Function {
        prototype: ExtendedDmSettingsType;
        new (): ExtendedDmSettingsType;
        FastToString(that: Kusto.Data.DmSettingsType): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.DmSettingsType, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.DmSettingsType, flag: Kusto.Data.DmSettingsType): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.DmSettingsType;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.DmSettingsType}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.DmSettingsType): number;
        FastGetDescription(that: Kusto.Data.DmSettingsType): string | null;
    }
    var ExtendedDmSettingsType: ExtendedDmSettingsTypeFunc;

    /**
     * Ingestion Queue Types
     *
     * @public
     * @class Kusto.Data.IngestionQueueType
     */
    enum IngestionQueueType {
        All = 0,
        InputQueue = 1,
        InternalQueue = 2,
        ReadyForAggregationQueue = 3,
        SecuredReadyForAggregationQueue = 4,
        AggregatedReadyForImportQueue = 5,
        FailedIngestionsQueue = 6,
        SuccessfulIngestionsQueue = 7,
        AbandonedIngestionsQueue = 9,
        SecuredAbandonedIngestionsQueue = 10,
        InternalFailedIngestionsQueue = 11,
        AbandonedInputQueues = 12
    }

    /**
     * Extensions for enum IngestionQueueType
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.ExtendedIngestionQueueType
     */
    interface ExtendedIngestionQueueType {
    }
    interface ExtendedIngestionQueueTypeFunc extends Function {
        prototype: ExtendedIngestionQueueType;
        new (): ExtendedIngestionQueueType;
        FastToString(that: Kusto.Data.IngestionQueueType): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.IngestionQueueType, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.IngestionQueueType, flag: Kusto.Data.IngestionQueueType): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.IngestionQueueType;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.IngestionQueueType}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.IngestionQueueType): number;
        FastGetDescription(that: Kusto.Data.IngestionQueueType): string | null;
    }
    var ExtendedIngestionQueueType: ExtendedIngestionQueueTypeFunc;

}

declare namespace Kusto.Data.Common {
    /** @namespace Kusto.Data.Common */

    /**
     * Extensions for enum StorageEngineKind
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedStorageEngineKind
     */
    interface ExtendedStorageEngineKind {
    }
    interface ExtendedStorageEngineKindFunc extends Function {
        prototype: ExtendedStorageEngineKind;
        new (): ExtendedStorageEngineKind;
        FastToString(that: Kusto.Data.Common.StorageEngineKind): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.StorageEngineKind, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.StorageEngineKind, flag: Kusto.Data.Common.StorageEngineKind): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.StorageEngineKind;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.StorageEngineKind}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.StorageEngineKind): number;
        FastGetDescription(that: Kusto.Data.Common.StorageEngineKind): string | null;
    }
    var ExtendedStorageEngineKind: ExtendedStorageEngineKindFunc;

    /**
     * Transformation methods (NOTE: This type is mirrored by the type CsvFromJsonStream_TransformationMethod (defined in UtilsEnums.tt). Make sure that the two are always mirrors of each other.)
     *
     * @public
     * @class Kusto.Data.Common.TransformationMethod
     */
    enum TransformationMethod {
        None = 0,
        PropertyBagArrayToDictionary = 1,
        SourceLocation = 2,
        SourceLineNumber = 3,
        UnknownMethod1 = 4,
        UnknownMethod = 5,
        DateTimeFromUnixSeconds = 6,
        DateTimeFromUnixMilliseconds = 7,
        DateTimeFromUnixMicroseconds = 8,
        DateTimeFromUnixNanoseconds = 9
    }

    /**
     * The kind of storage engine used for ingestion flows
     *
     * @public
     * @class Kusto.Data.Common.StorageEngineKind
     */
    enum StorageEngineKind {
        StorageV2 = 0,
        StorageV3 = 1
    }

    /**
     * The ingestion error code returned by a Kusto service. Note that this list is documented in Kusto external docs, so when changing the ingestion error codes, the documentation should also be updated.
     *
     * @public
     * @class Kusto.Data.Common.IngestionErrorCode
     * @augments number
     */
    enum IngestionErrorCode {
        Unknown = 0,
        OutOfMemory = 2161770503,
        Stream_WrongNumberOfFields = 2161770504,
        Stream_InputStreamTooLarge = 2161770505,
        Stream_NoDataToIngest = 2161770506,
        Stream_ClosingQuoteMissing = 2161770507,
        Stream_DynamicPropertyBagTooLarge = 2161770510,
        Download_SourceNotFound = 2161770511,
        Download_AccessConditionNotSatisfied = 2161770512,
        Download_Forbidden = 2161770513,
        Download_AccountNotFound = 2161770514,
        Download_BadRequest = 2161770515,
        Download_NotTransient = 2161770516,
        Download_UnknownError = 2161770517,
        UpdatePolicy_QuerySchemaDoesNotMatchTableSchema = 2161770518,
        UpdatePolicy_FailedDescendantTransaction = 2161770519,
        UpdatePolicy_IngestionError = 2161770520,
        UpdatePolicy_UnknownError = 2161770521,
        BadRequest_MissingMappingFailure = 2161770522,
        BadRequest_InvalidBlob = 2161770523,
        BadRequest_EmptyBlob = 2161770524,
        BadRequest_NoRecordsOrWrongFormat = 2161770525,
        BadRequest_EmptyArchive = 2161770526,
        BadRequest_InvalidArchive = 2161770527,
        BadRequest_InvalidBlobUri = 2161770528,
        BadRequest_EmptyBlobUri = 2161770529,
        BadRequest_DatabaseNotExist = 2161770530,
        BadRequest_TableNotExist = 2161770531,
        BadRequest_InvalidKustoIdentityToken = 2161770532,
        BadRequest_FileTooLarge = 2161770533,
        BadRequest_TableAccessDenied = 2161770534,
        General_RetryAttemptsExceeded = 2161770535,
        General_BadRequest = 2161770536,
        General_InternalServerError = 2161770537,
        UpdatePolicy_Cyclic_Update_Not_Allowed = 2161770538,
        BadRequest_InvalidMapping = 2161770539,
        BadRequest_InvalidMappingReference = 2161770540,
        BadRequest_MappingReferenceWasNotFound = 2161770541,
        BadRequest_FormatNotSupported = 2161770542,
        BadRequest_DuplicateMapping = 2161770543,
        BadRequest_CorruptedMessage = 2161770544,
        BadRequest_InconsistentMapping = 2161770545,
        BadRequest_SyntaxError = 2161770546,
        BadRequest_InvalidOrEmptyTableName = 2161770547,
        BadRequest_EmptyDatabaseName = 2161770548,
        BadRequest_EmptyTenantIdentifier = 2161770549,
        BadRequest_EmptyMappingReference = 2161770550,
        BadRequest_EntityNotFound = 2161770551,
        BadRequest_EntityNameIsNotValid = 2161770552,
        General_AbandonedIngestion = 2161770553,
        General_ThrottledIngestion = 2161770554,
        General_TransientSchemaMismatch = 2161770555,
        BadRequest_DatabaseAccessDenied = 2161770556,
        BadRequest_UnexpectedCharacterInInputStream = 2161770557,
        Forbidden = 2161770558,
        BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy = 2161770559,
        BadRequest_CreationTimeEarlierThanSoftDeletePeriod = 2161770560,
        BadRequest_NotSupported = 2161770561,
        Skipped_IngestByTagAlreadyExists = 2161770562,
        Timeout = 2148734213,
        BadRequest_MalformedIngestionProperty = 2148734214,
        BadRequest_IngestionPropertyNotSupportedInThisContext = 2148734215,
        BadRequest_InvalidAuthentication = 2148734216,
        BlobAlreadyReceived_BlobAlreadyFoundInBatch = 2148734217,
        BadRequest_InvalidManagedIdentity = 2148734218,
        BadRequest_DataCapacityLimitReached = 2148734219,
        UpdatePolicy_BadRequest = 2148734220,
        BadRequest_NonMultiDatabaseDataConnection = 2148734221
    }

    /**
     * The IngestionErrorCode Category.
     *
     * @public
     * @class Kusto.Data.Common.IngestionErrorCategory
     */
    enum IngestionErrorCategory {
        Unknown = 0,
        InternalServiceError = 1,
        BadFormat = 2,
        BadRequest = 3,
        UpdatePolicyFailure = 4,
        EntityNotFound = 5,
        UserAccessNotAuthorized = 6,
        DataAccessNotAuthorized = 7,
        FileTooLarge = 8,
        ThrottledOnEngine = 9,
        DownloadFailed = 10,
        RetryAttemptsExceeded = 11,
        BlobAlreadyReceived = 12
    }

    /**
     * The kind of lookback period to use when choosing which extents to merge/rebuild
     *
     * @public
     * @class Kusto.Data.Common.ExtentsMergeLookbackPeriodKind
     */
    enum ExtentsMergeLookbackPeriodKind {
        Default = 0,
        HotCache = 1,
        All = 2,
        Custom = 3
    }

    /**
     * Extensions for enum TransformationMethod
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedTransformationMethod
     */
    interface ExtendedTransformationMethod {
    }
    interface ExtendedTransformationMethodFunc extends Function {
        prototype: ExtendedTransformationMethod;
        new (): ExtendedTransformationMethod;
        FastToString(that: Kusto.Data.Common.TransformationMethod): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.TransformationMethod, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.TransformationMethod, flag: Kusto.Data.Common.TransformationMethod): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.TransformationMethod;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.TransformationMethod}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.TransformationMethod): number;
        FastGetDescription(that: Kusto.Data.Common.TransformationMethod): string | null;
    }
    var ExtendedTransformationMethod: ExtendedTransformationMethodFunc;

    /**
     * Extensions for enum IngestionErrorCode
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedIngestionErrorCode
     */
    interface ExtendedIngestionErrorCode {
    }
    interface ExtendedIngestionErrorCodeFunc extends Function {
        prototype: ExtendedIngestionErrorCode;
        new (): ExtendedIngestionErrorCode;
        FastToString(that: Kusto.Data.Common.IngestionErrorCode): string | null;
        FastIsDefined(value: string | null): boolean;
        FastIsDefined$1(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.IngestionErrorCode, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.IngestionErrorCode, flag: Kusto.Data.Common.IngestionErrorCode): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.IngestionErrorCode;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.IngestionErrorCode}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.IngestionErrorCode): number;
        FastGetDescription(that: Kusto.Data.Common.IngestionErrorCode): string | null;
    }
    var ExtendedIngestionErrorCode: ExtendedIngestionErrorCodeFunc;

    /**
     * Extensions for enum DataRecoverability
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedDataRecoverability
     */
    interface ExtendedDataRecoverability {
    }
    interface ExtendedDataRecoverabilityFunc extends Function {
        prototype: ExtendedDataRecoverability;
        new (): ExtendedDataRecoverability;
        FastToString(that: Kusto.Data.Common.DataRecoverability): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.DataRecoverability, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.DataRecoverability, flag: Kusto.Data.Common.DataRecoverability): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.DataRecoverability;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.DataRecoverability}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.DataRecoverability): number;
        FastGetDescription(that: Kusto.Data.Common.DataRecoverability): string | null;
    }
    var ExtendedDataRecoverability: ExtendedDataRecoverabilityFunc;

    /**
     * Extensions for enum ExtentsMergeLookbackPeriodKind
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind
     */
    interface ExtendedExtentsMergeLookbackPeriodKind {
    }
    interface ExtendedExtentsMergeLookbackPeriodKindFunc extends Function {
        prototype: ExtendedExtentsMergeLookbackPeriodKind;
        new (): ExtendedExtentsMergeLookbackPeriodKind;
        FastToString(that: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind, flag: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.ExtentsMergeLookbackPeriodKind;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind): number;
        FastGetDescription(that: Kusto.Data.Common.ExtentsMergeLookbackPeriodKind): string | null;
    }
    var ExtendedExtentsMergeLookbackPeriodKind: ExtendedExtentsMergeLookbackPeriodKindFunc;

    /**
     * Extensions for enum EntityType
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedEntityType
     */
    interface ExtendedEntityType {
    }
    interface ExtendedEntityTypeFunc extends Function {
        prototype: ExtendedEntityType;
        new (): ExtendedEntityType;
        FastToString(that: Kusto.Data.Common.EntityType): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.EntityType, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.EntityType, flag: Kusto.Data.Common.EntityType): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.EntityType;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.EntityType}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.EntityType): number;
        FastGetDescription(that: Kusto.Data.Common.EntityType): string | null;
    }
    var ExtendedEntityType: ExtendedEntityTypeFunc;

    /**
     * Extensions for enum DataSourceCompressionType
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedDataSourceCompressionType
     */
    interface ExtendedDataSourceCompressionType {
    }
    interface ExtendedDataSourceCompressionTypeFunc extends Function {
        prototype: ExtendedDataSourceCompressionType;
        new (): ExtendedDataSourceCompressionType;
        FastToString(that: Kusto.Data.Common.DataSourceCompressionType): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.DataSourceCompressionType, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.DataSourceCompressionType, flag: Kusto.Data.Common.DataSourceCompressionType): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.DataSourceCompressionType;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.DataSourceCompressionType}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.DataSourceCompressionType): number;
        FastGetDescription(that: Kusto.Data.Common.DataSourceCompressionType): string | null;
    }
    var ExtendedDataSourceCompressionType: ExtendedDataSourceCompressionTypeFunc;

    interface CslQueryParser {
    }
    interface CslQueryParserFunc extends Function {
        prototype: CslQueryParser;
        new (): CslQueryParser;
        PrettifyQuery(query: string | null, appendText: string | null): string | null;
    }
    var CslQueryParser: CslQueryParserFunc;

    /**
     * Extensions for enum DataConnectionError
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedDataConnectionError
     */
    interface ExtendedDataConnectionError {
    }
    interface ExtendedDataConnectionErrorFunc extends Function {
        prototype: ExtendedDataConnectionError;
        new (): ExtendedDataConnectionError;
        FastToString(that: Kusto.Data.Common.DataConnectionError): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.DataConnectionError, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.DataConnectionError, flag: Kusto.Data.Common.DataConnectionError): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.DataConnectionError;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.DataConnectionError}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.DataConnectionError): number;
        FastGetDescription(that: Kusto.Data.Common.DataConnectionError): string | null;
    }
    var ExtendedDataConnectionError: ExtendedDataConnectionErrorFunc;

    /**
     * Extensions for enum DatabaseShowFlavor
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedDatabaseShowFlavor
     */
    interface ExtendedDatabaseShowFlavor {
    }
    interface ExtendedDatabaseShowFlavorFunc extends Function {
        prototype: ExtendedDatabaseShowFlavor;
        new (): ExtendedDatabaseShowFlavor;
        FastToString(that: Kusto.Data.Common.DatabaseShowFlavor): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.DatabaseShowFlavor, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.DatabaseShowFlavor, flag: Kusto.Data.Common.DatabaseShowFlavor): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.DatabaseShowFlavor;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.DatabaseShowFlavor}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.DatabaseShowFlavor): number;
        FastGetDescription(that: Kusto.Data.Common.DatabaseShowFlavor): string | null;
    }
    var ExtendedDatabaseShowFlavor: ExtendedDatabaseShowFlavorFunc;

    /**
     * Kusto Entity Types.
     *
     * @public
     * @class Kusto.Data.Common.EntityType
     */
    enum EntityType {
        Unknown = 0,
        Cluster = 1,
        Database = 2,
        Table = 3,
        Column = 4,
        Function = 5,
        ExternalTable = 6,
        MaterializedView = 7
    }

    /**
     * Data compression types supported for Kusto ingestion.
     *
     * @public
     * @class Kusto.Data.Common.DataSourceCompressionType
     */
    enum DataSourceCompressionType {
        None = 0,
        GZip = 1,
        Zip = 2
    }

    /**
     * Recoverability of data after soft deletion
     *
     * @public
     * @class Kusto.Data.Common.DataRecoverability
     */
    enum DataRecoverability {
        Unknown = 0,
        Enabled = 1,
        Disabled = 2
    }

    /**
     * Errors from Data Connections
     *
     * @public
     * @class Kusto.Data.Common.DataConnectionError
     */
    enum DataConnectionError {
        ManagedIdentityUnauthorized = 0,
        ManagedIdentityNotFound = 1,
        UsingDeprecatedConnectionString = 2
    }

    /**
     * Flavor of DatabaseShow command
     *
     * @public
     * @class Kusto.Data.Common.DatabaseShowFlavor
     */
    enum DatabaseShowFlavor {
        Identity = 0,
        Verbose = 1,
        Policies = 2,
        DataStats = 3,
        Default = 4
    }

    /**
     * Extensions for enum IngestionErrorCategory
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.ExtendedIngestionErrorCategory
     */
    interface ExtendedIngestionErrorCategory {
    }
    interface ExtendedIngestionErrorCategoryFunc extends Function {
        prototype: ExtendedIngestionErrorCategory;
        new (): ExtendedIngestionErrorCategory;
        FastToString(that: Kusto.Data.Common.IngestionErrorCategory): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Common.IngestionErrorCategory, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Common.IngestionErrorCategory, flag: Kusto.Data.Common.IngestionErrorCategory): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Common.IngestionErrorCategory;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Common.IngestionErrorCategory}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Common.IngestionErrorCategory): number;
        FastGetDescription(that: Kusto.Data.Common.IngestionErrorCategory): string | null;
    }
    var ExtendedIngestionErrorCategory: ExtendedIngestionErrorCategoryFunc;

    /**
     * Support for generating CSL (Kusto) queries and control commands
     using code-generation.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Common.CslSyntaxGenerator
     */
    interface CslSyntaxGenerator {
    }
    interface CslSyntaxGeneratorFunc extends Function {
        prototype: CslSyntaxGenerator;
        new (): CslSyntaxGenerator;
        NormalizeDatabaseName$1(databaseName: string | null, forceNormalization: boolean): string | null;
        NormalizeDatabaseName(databaseName: string | null): string | null;
        NormalizeVirutalClusterName(virtualClusterName: string | null, forceNormalization?: boolean): string | null;
        NormalizeFunctionName(functionName: string | null, forceNormalizeFunctionName?: boolean): string | null;
        NormalizeTableName(tableName: string | null, forceNormalizeTableName?: boolean): string | null;
        NormalizeColumnName(columnName: string | null, forceNormalizeColumnName?: boolean): string | null;
        NormalizeRowStoreName(rowStoreName: string | null): string | null;
        NormalizeWorkloadGroupName(workloadGroupName: string | null): string | null;
        IsIdentifier(token: string | null): boolean;
        IsKeyword(token: string | null): boolean;
    }
    var CslSyntaxGenerator: CslSyntaxGeneratorFunc;

}

declare namespace Kusto.Data.Ingestion {
    /** @namespace Kusto.Data.Ingestion */

    /**
     * The ingestion mapping kind
     *
     * @public
     * @class Kusto.Data.Ingestion.IngestionMappingKind
     */
    enum IngestionMappingKind {
        Unknown = 0,
        Csv = 1,
        Json = 2,
        Avro = 4,
        Parquet = 5,
        SStream = 6,
        Orc = 7,
        ApacheAvro = 8,
        W3CLogFile = 9
    }

    /**
     * Extensions for enum IngestionMappingKind
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Ingestion.ExtendedIngestionMappingKind
     */
    interface ExtendedIngestionMappingKind {
    }
    interface ExtendedIngestionMappingKindFunc extends Function {
        prototype: ExtendedIngestionMappingKind;
        new (): ExtendedIngestionMappingKind;
        FastToString(that: Kusto.Data.Ingestion.IngestionMappingKind): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Ingestion.IngestionMappingKind, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Ingestion.IngestionMappingKind, flag: Kusto.Data.Ingestion.IngestionMappingKind): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Ingestion.IngestionMappingKind;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Ingestion.IngestionMappingKind}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Ingestion.IngestionMappingKind): number;
        FastGetDescription(that: Kusto.Data.Ingestion.IngestionMappingKind): string | null;
    }
    var ExtendedIngestionMappingKind: ExtendedIngestionMappingKindFunc;

}

declare namespace Kusto.Data.IntelliSense {
    interface IntelliSenseCommandTip {
        Name: string | null;
        Signature: string | null;
        Summary: string | null;
        Usage: string | null;
        NameSuffix: string | null;
        Parameters: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter> | null;
        GetSignatureWithBoldParameter(i: number): string | null;
        Clone(): Kusto.Data.IntelliSense.IntelliSenseCommandTip | null;
    }
    interface IntelliSenseCommandTipFunc extends Function {
        prototype: IntelliSenseCommandTip;
        new (): IntelliSenseCommandTip;
    }
    var IntelliSenseCommandTip: IntelliSenseCommandTipFunc;

    interface IntelliSenseCommandTipParameter {
        Name: string | null;
        Description: string | null;
        DataType: string | null;
        Optional: boolean;
        IsArgsArray: boolean;
        Singature: string | null;
        PlainSignature: string | null;
        Clone(): Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter | null;
    }
    interface IntelliSenseCommandTipParameterFunc extends Function {
        prototype: IntelliSenseCommandTipParameter;
        new (): IntelliSenseCommandTipParameter;
    }
    var IntelliSenseCommandTipParameter: IntelliSenseCommandTipParameterFunc;

    interface KustoCommandContext extends System.IEquatable$1<Kusto.Data.IntelliSense.KustoCommandContext> {
        Context: string | null;
        Operation: Kusto.Data.IntelliSense.ContextOperation;
        equalsT(other: Kusto.Data.IntelliSense.KustoCommandContext | null): boolean;
        getHashCode(): number;
        Flatten(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoCommandContext> | null;
        IsEmpty(): boolean;
    }
    interface KustoCommandContextFunc extends Function {
        prototype: KustoCommandContext;
        new (context: string | null, operation: Kusto.Data.IntelliSense.ContextOperation): KustoCommandContext;
        Empty: Kusto.Data.IntelliSense.KustoCommandContext | null;
    }
    var KustoCommandContext: KustoCommandContextFunc;

    interface KustoIntelliSenseAccountEntity {
        Name: string | null;
    }
    interface KustoIntelliSenseAccountEntityFunc extends Function {
        prototype: KustoIntelliSenseAccountEntity;
        new (): KustoIntelliSenseAccountEntity;
    }
    var KustoIntelliSenseAccountEntity: KustoIntelliSenseAccountEntityFunc;

    interface IKustoIntelliSenseSchemaResolver {
        Kusto$Data$IntelliSense$IKustoIntelliSenseSchemaResolver$ResolveDatabaseSchema(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null): Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null;
        ResolveDatabaseSchema(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null): Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null;
        Kusto$Data$IntelliSense$IKustoIntelliSenseSchemaResolver$ResolveDatabaseSchema$1(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null, tableName: string | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity> | null;
        ResolveDatabaseSchema$1(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null, tableName: string | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity> | null;
        Kusto$Data$IntelliSense$IKustoIntelliSenseSchemaResolver$ResolveDatabaseNames(clusterUriOrAlias: string | null): System.Collections.Generic.IEnumerable$1<string> | null;
        ResolveDatabaseNames(clusterUriOrAlias: string | null): System.Collections.Generic.IEnumerable$1<string> | null;
    }

    interface KustoIntelliSenseClusterEntity {
        ConnectionString: string | null;
        Alias: string | null;
        Databases: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity> | null;
        Plugins: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity> | null;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity | null;
    }
    interface KustoIntelliSenseClusterEntityFunc extends Function {
        prototype: KustoIntelliSenseClusterEntity;
        new (): KustoIntelliSenseClusterEntity;
    }
    var KustoIntelliSenseClusterEntity: KustoIntelliSenseClusterEntityFunc;

    interface KustoIntelliSenseColumnEntity {
        Name: string | null;
        TypeCode: Kusto.Data.IntelliSense.EntityDataType;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity | null;
    }
    interface KustoIntelliSenseColumnEntityFunc extends Function {
        prototype: KustoIntelliSenseColumnEntity;
        new (): KustoIntelliSenseColumnEntity;
    }
    var KustoIntelliSenseColumnEntity: KustoIntelliSenseColumnEntityFunc;

    interface KustoIntelliSenseDatabaseEntity {
        Name: string | null;
        Alias: string | null;
        Tables: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity> | null;
        Functions: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity> | null;
        IsInitialized: boolean;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null;
    }
    interface KustoIntelliSenseDatabaseEntityFunc extends Function {
        prototype: KustoIntelliSenseDatabaseEntity;
        new (): KustoIntelliSenseDatabaseEntity;
    }
    var KustoIntelliSenseDatabaseEntity: KustoIntelliSenseDatabaseEntityFunc;

    interface KustoIntelliSenseFunctionEntity {
        Name: string | null;
        CallName: string | null;
        Expression: string | null;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity | null;
    }
    interface KustoIntelliSenseFunctionEntityFunc extends Function {
        prototype: KustoIntelliSenseFunctionEntity;
        new (): KustoIntelliSenseFunctionEntity;
    }
    var KustoIntelliSenseFunctionEntity: KustoIntelliSenseFunctionEntityFunc;

    interface KustoIntelliSensePluginEntity {
        Name: string | null;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity | null;
    }
    interface KustoIntelliSensePluginEntityFunc extends Function {
        prototype: KustoIntelliSensePluginEntity;
        new (): KustoIntelliSensePluginEntity;
    }
    var KustoIntelliSensePluginEntity: KustoIntelliSensePluginEntityFunc;

    interface ClusterManagerIntelliSenseRulesProvider extends Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase {
        ResetState(): void;
        AnalyzeCommand$1(statement: string | null, cachedReference: Kusto.Data.IntelliSense.CslCommand | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        AnalyzeCommand(command: Kusto.Data.IntelliSense.AnalyzedCommand | null, appendingPart: string | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        Clone(): Kusto.Data.IntelliSense.ClusterManagerIntelliSenseRulesProvider | null;
    }
    interface ClusterManagerIntelliSenseRulesProviderFunc extends Function {
        prototype: ClusterManagerIntelliSenseRulesProvider;
        $ctor1: {
            new (accounts: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseAccountEntity> | null, services: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseServiceEntity> | null, connectionContext: string | null): ClusterManagerIntelliSenseRulesProvider
        };
        ctor: {
            new (other: Kusto.Data.IntelliSense.ClusterManagerIntelliSenseRulesProvider | null): ClusterManagerIntelliSenseRulesProvider
        };
    }
    var ClusterManagerIntelliSenseRulesProvider: ClusterManagerIntelliSenseRulesProviderFunc;

    interface KustoIntelliSenseServiceEntity {
        Name: string | null;
    }
    interface KustoIntelliSenseServiceEntityFunc extends Function {
        prototype: KustoIntelliSenseServiceEntity;
        new (): KustoIntelliSenseServiceEntity;
    }
    var KustoIntelliSenseServiceEntity: KustoIntelliSenseServiceEntityFunc;

    interface KustoIntelliSenseTableEntity {
        Name: string | null;
        IsInvisible: boolean;
        Columns: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity> | null;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity | null;
    }
    interface KustoIntelliSenseTableEntityFunc extends Function {
        prototype: KustoIntelliSenseTableEntity;
        new (): KustoIntelliSenseTableEntity;
    }
    var KustoIntelliSenseTableEntity: KustoIntelliSenseTableEntityFunc;

    enum OptionKind {
        None = 0,
        Operator = 1,
        Command = 2,
        Service = 3,
        Policy = 4,
        Database = 5,
        Table = 6,
        DataType = 7,
        Literal = 8,
        Parameter = 9,
        IngestionMapping = 10,
        ExpressionFunction = 11,
        Option = 12,
        OptionKind = 13,
        OptionRender = 14,
        Column = 15,
        ColumnString = 16,
        ColumnNumeric = 17,
        ColumnDateTime = 18,
        ColumnTimespan = 19,
        FunctionLocal = 20,
        FunctionServerSide = 21,
        FunctionAggregation = 22,
        FunctionFilter = 23,
        FunctionScalar = 24,
        ClientDirective = 25,
        MaterializedView = 26
    }

    enum ParseMode {
        CommandTokensOnly = 0,
        TokenizeAllText = 1
    }

    enum RuleKind {
        None = 0,
        YieldColumnNamesForFilter = 1,
        YieldColumnNamesForProject = 2,
        YieldColumnNamesForProjectAway = 3,
        YieldColumnNamesForProjectRename = 4,
        YieldColumnNamesForJoin = 5,
        YieldKindFlavorsForJoin = 6,
        YieldKindFlavorsForReduceBy = 7,
        YieldColumnNamesForOrdering = 8,
        YieldColumnNamesForTwoParamFunctions = 9,
        YieldColumnNamesForThreeParamFunctions = 10,
        YieldColumnNamesForManyParamFunctions = 11,
        YieldColumnNamesAndFunctionsForExtend = 12,
        YieldColumnNamesForMakeSeries = 13,
        YieldTableNames = 14,
        YieldTableNamesForFindIn = 15,
        YieldRenderOptions = 16,
        YieldRenderKindKeywordOption = 17,
        YieldRenderKindOptions = 18,
        YieldOperatorsAfterPipe = 19,
        YieldStringComparisonOptions = 20,
        YieldNumericComparisonOptions = 21,
        YieldDateTimeOperatorsOptions = 22,
        YieldSummarizeOperatorOptions = 23,
        YieldAscendingDescendingOptions = 24,
        YieldNumericScalarOptions = 25,
        YieldByKeywordOptions = 26,
        YieldWithKeywordOptions = 27,
        YieldStarOption = 28,
        YieldParseTypesKeywordOptions = 29,
        YieldColumnNamesForParse = 30,
        YieldColumnNamesForDiffPatternsPluginSplitParameter = 31,
        YieldParseKeywordKindsOptions = 32,
        YieldRangeFromOptions = 33,
        YieldRangeFromToOptions = 34,
        YieldRangeFromToStepOptions = 35,
        YieldQueryParameters = 36,
        YieldEvaluateOperatorOptions = 37,
        YieldPostJoinOptions = 38,
        YieldPostFindInOptions = 39,
        YieldPostFindOptions = 40,
        YieldTopNestedOfKeywordOption = 41,
        YieldTopNestedOthersOption = 42,
        YieldTopNestedKeywordOption = 43,
        YieldTopHittersKeywordOption = 44,
        YieldTimespanOptions = 45,
        YieldDatabaseNamesOptions = 46,
        YieldClusterNamesOptions = 47,
        YieldDatabaseFunctionOption = 48,
        YieldNullsFirstNullsLastOptions = 49,
        YieldTableNamesForRemoteQueryOptions = 50,
        YieldColumnNamesForRender = 51,
        YieldColumnNamesForFilterInFind = 52,
        YieldColumnNamesForProjectInFind = 53,
        YieldEndOrContinueFindInOptions = 54,
        YieldPostFindInListOptions = 55,
        YieldFindProjectSmartOptions = 56,
        YieldMakeSeriesOperatorOptions = 57,
        YieldMakeSeriesOperatorForDefaultOrOn = 58,
        YieldMakeSeriesOperatorForOn = 59,
        YieldMakeSeriesOperatorForRange = 60,
        YieldMakeSeriesOperatorForBy = 61,
        YieldPostSearchOptions = 62,
        YieldPostSearchKindOptions = 63,
        YieldSearchKindOptions = 64,
        YieldInsideSearchOptions = 65,
        YieldClientDirectivesOptions = 66,
        YieldClientDirective_ConnectOptions = 67,
        Last = 68
    }

    interface ContextualRegexIntelliSenseRule extends Kusto.Data.IntelliSense.IntelliSenseRule {
        MatchingRegex: System.Text.RegularExpressions.Regex | null;
        AdditionalOptions: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOptionCollection> | null;
        ContextualOptions: System.Collections.Generic.Dictionary$2<Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1<string>> | null;
        OverrideOptions: System.Collections.Generic.Dictionary$2<Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1<string>> | null;
        OptionsKind: Kusto.Data.IntelliSense.OptionKind;
        RequiresFullCommand: boolean;
        IsContextual: boolean;
        IsMatch(context: Kusto.Data.IntelliSense.KustoCommandContext | null, input: string | null): boolean;
        GetOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<string> | null;
        GetCompletionOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOption> | null;
    }
    interface ContextualRegexIntelliSenseRuleFunc extends Function {
        prototype: ContextualRegexIntelliSenseRule;
        new (): ContextualRegexIntelliSenseRule;
    }
    var ContextualRegexIntelliSenseRule: ContextualRegexIntelliSenseRuleFunc;

    interface ContextualTokensWithRegexIntelliSenseRule extends Kusto.Data.IntelliSense.IntelliSenseRule {
        MatchingRegex: System.Text.RegularExpressions.Regex | null;
        MatchingTokens: System.Collections.Generic.HashSet$1<string> | null;
        GroupNameToUseAfterMatch: string | null;
        Options: Kusto.Data.IntelliSense.CompletionOptionCollection | null;
        RequiresFullCommand: boolean;
        IsContextual: boolean;
        IsMatch(context: Kusto.Data.IntelliSense.KustoCommandContext | null, input: string | null): boolean;
        GetOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<string> | null;
        GetCompletionOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOption> | null;
    }
    interface ContextualTokensWithRegexIntelliSenseRuleFunc extends Function {
        prototype: ContextualTokensWithRegexIntelliSenseRule;
        new (): ContextualTokensWithRegexIntelliSenseRule;
        GetHashStringForContextAndToken(context: string | null, token: string | null): string | null;
    }
    var ContextualTokensWithRegexIntelliSenseRule: ContextualTokensWithRegexIntelliSenseRuleFunc;

    interface CslQueryIntelliSenseRulesProvider extends Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase {
        AllowQueryParameters: boolean;
        ResetState(): void;
        Clone(): Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider | null;
        ResolveKnownEntitiesFromContext(commandContext: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.List$1<string> | null;
        SetQueryParametersRule(queryParameters: System.Collections.Generic.IEnumerable$1<string> | null): void;
        ResolveEntitiesFromCommand(input: string | null, entitiesList: System.Collections.Generic.List$1<string> | null, knownEntities: System.Collections.Generic.IEnumerable$1<string> | null): number;
        AnalyzeCommand$1(statement: string | null, cachedReference: Kusto.Data.IntelliSense.CslCommand | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        AnalyzeCommand(analyzedCommand: Kusto.Data.IntelliSense.AnalyzedCommand | null, appendingPart: string | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
    }
    interface CslQueryIntelliSenseRulesProviderFunc extends Function {
        prototype: CslQueryIntelliSenseRulesProvider;
        ResolveResult: CslQueryIntelliSenseRulesProvider.ResolveResultFunc;
        $ctor1: {
            new (cluster: Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity | null, databaseSchema: Kusto.Data.IntelliSense.KustoIntelliSenseQuerySchema | null, queryParameters: System.Collections.Generic.IEnumerable$1<string> | null, availableClusters: System.Collections.Generic.IEnumerable$1<string> | null, schemaResolver: Kusto.Data.IntelliSense.IKustoIntelliSenseSchemaResolver | null, allowQueryParameters: boolean, allowClientDirectives: boolean): CslQueryIntelliSenseRulesProvider
        };
        ctor: {
            new (other: Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider | null): CslQueryIntelliSenseRulesProvider
        };
        /**
         * After all summarize entities were finalized, go over the list and finalize it
         *
         * @static
         * @private
         * @this Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider
         * @memberof Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider
         * @param   {System.Collections.Generic.List$1}    argMinMaxEntities    
         * @param   {System.Collections.Generic.List$1}    entitiesList
         * @return  {void}
         */
    }
    var CslQueryIntelliSenseRulesProvider: CslQueryIntelliSenseRulesProviderFunc;
    module CslQueryIntelliSenseRulesProvider {
        interface ResolveResult {
        }
        interface ResolveResultFunc extends Function {
            prototype: ResolveResult;
            None: number;
            AppendEntities: number;
            ReplaceEntities: number;
        }
    }

    interface DataManagerIntelliSenseRulesProvider extends Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase {
        AnalyzeCommand$1(statement: string | null, cachedReference: Kusto.Data.IntelliSense.CslCommand | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        AnalyzeCommand(command: Kusto.Data.IntelliSense.AnalyzedCommand | null, appendingPart: string | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        ResetState(): void;
    }
    interface DataManagerIntelliSenseRulesProviderFunc extends Function {
        prototype: DataManagerIntelliSenseRulesProvider;
        new (connectionContext: string | null): DataManagerIntelliSenseRulesProvider;
    }
    var DataManagerIntelliSenseRulesProvider: DataManagerIntelliSenseRulesProviderFunc;

    interface RegexIntelliSenseRule extends Kusto.Data.IntelliSense.IntelliSenseRule {
        MatchingRegex: System.Text.RegularExpressions.Regex | null;
        Options: Kusto.Data.IntelliSense.CompletionOptionCollection | null;
        AdditionalOptions: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOptionCollection> | null;
        RequiresFullCommand: boolean;
        IsContextual: boolean;
        IsMatch(context: Kusto.Data.IntelliSense.KustoCommandContext | null, input: string | null): boolean;
        GetOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<string> | null;
        GetCompletionOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOption> | null;
    }
    interface RegexIntelliSenseRuleFunc extends Function {
        prototype: RegexIntelliSenseRule;
        new (): RegexIntelliSenseRule;
    }
    var RegexIntelliSenseRule: RegexIntelliSenseRuleFunc;

    interface ExpressionEntityParser {
    }
    interface ExpressionEntityParserFunc extends Function {
        prototype: ExpressionEntityParser;
        new (): ExpressionEntityParser;
        /**
         * Parses string list 
         count(), any(SubscriptionId), LogicalServerName, AppName, database_id, bin(TIMESTAMP, time(10m)) 
         into list of Entity objects
         *
         * @static
         * @public
         * @this Kusto.Data.IntelliSense.ExpressionEntityParser
         * @memberof Kusto.Data.IntelliSense.ExpressionEntityParser
         * @param   {string}                               input
         * @return  {System.Collections.Generic.List$1}
         */
        ParseEntities(input: string | null): System.Collections.Generic.List$1<Kusto.Data.IntelliSense.ExpressionEntity> | null;
        /**
         * Parses string list 
         count(), any(SubscriptionId), LogicalServerName, AppName, database_id, bin(TIMESTAMP, time(10m)), (a,b,c)=foo()
         into list of Entity objects. Allows to generate implicit names for functions with multicolumn output
         *
         * @static
         * @public
         * @this Kusto.Data.IntelliSense.ExpressionEntityParser
         * @memberof Kusto.Data.IntelliSense.ExpressionEntityParser
         * @param   {string}                               input                       Input
         * @param   {System.Func}                          generateImplicitEntities    Action which generates multicolumn results for columns that were not specified explicitly:
         bool generateImplicitEntities(functionName, arguments, explicitColumnCount, listOfResultsToAddTo)
         returns true if implicit entities were added
         * @return  {System.Collections.Generic.List$1}
         */
        ParseEntities$1(input: string | null, generateImplicitEntities: {(arg1: string, arg2: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.ExpressionEntity>, arg3: number, arg4: System.Collections.Generic.List$1<Kusto.Data.IntelliSense.ExpressionEntity>): boolean} | null): System.Collections.Generic.List$1<Kusto.Data.IntelliSense.ExpressionEntity> | null;
        UnescapeEntityName(token: string | null): string | null;
    }
    var ExpressionEntityParser: ExpressionEntityParserFunc;

    interface KustoIntelliSenseQuerySchema {
        Cluster: Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity | null;
        Database: Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null;
        Clone(): Kusto.Data.IntelliSense.KustoIntelliSenseQuerySchema | null;
    }
    interface KustoIntelliSenseQuerySchemaFunc extends Function {
        prototype: KustoIntelliSenseQuerySchema;
        new (cluster: Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity | null, database: Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null): KustoIntelliSenseQuerySchema;
    }
    var KustoIntelliSenseQuerySchema: KustoIntelliSenseQuerySchemaFunc;

    interface ExpressionEntity {
        Operator: string | null;
        Name: string | null;
        Arguments: System.Collections.Generic.IEnumerable$1<string> | null;
        IsGenerated: boolean;
        FirstArgument(): string | null;
    }
    interface ExpressionEntityFunc extends Function {
        prototype: ExpressionEntity;
        new (): ExpressionEntity;
    }
    var ExpressionEntity: ExpressionEntityFunc;

    enum AdminEngineRuleKind {
        None,
        Start,
        YieldShowCommandOptions = 0,
        YieldTableNamesForAdminOptions = 1,
        YieldFunctionNamesForAdminOptions = 2,
        YieldDatabaseNames = 3,
        YieldShowBasicAuthOptions = 4,
        YieldShowDatabasePrincipalsPoliciesAndSchemaOptions = 5,
        YieldShowDatabasesOptions = 6,
        YieldShowClusterPrincipalsOptions = 7,
        YieldSetDatabaseAdminsUsersViewersPrettyNameOptions = 8,
        YieldSetClusterAdminsUsersViewersDatabaseCreatorsOptions = 9,
        YieldSetTableAdminsOptions = 10,
        YieldAddDatabaseAdminsUsersViewersOptions = 11,
        YieldDropDatabaseOptions = 12,
        YieldAddClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions = 13,
        YieldDropClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions = 14,
        YieldAddClusterBlockedPrincipalsOptions = 15,
        YieldAddTableAdminsOptions = 16,
        YieldDropTableEntitiesOptions = 17,
        YieldDeleteTableEntitiesOptions = 18,
        YieldCreateTableEntitiesOptions = 19,
        YieldAlterTableEntitiesOptions = 20,
        YieldDropTableColumnsSyntaxOptions = 21,
        YieldSetDatabaseUsersNoneOptions = 22,
        YieldSetDatabaseAdminsNoneOptions = 23,
        YieldSetDatabaseViewersNoneOptions = 24,
        YieldSetClusterUsersNoneOptions = 25,
        YieldSetClusterAdminsNoneOptions = 26,
        YieldSetClusterViewersNoneOptions = 27,
        YieldSetClusterDatabaseCreatorsNoneOptions = 28,
        YieldSetTableAdminsNoneOptions = 29,
        YieldShowTableEntitiesOptions = 30,
        YieldAlterExtentTagsOptions = 31,
        YieldAttachExtentsOptions = 32,
        YieldAttachExtentsIntoTableOptions = 33,
        YieldDropExtentTagsOptions = 34,
        YieldMoveExtentsOptions = 35,
        YieldMoveSpecifiedExtentsOptions = 36,
        YieldMoveExtentsToTableOptions = 37,
        YieldReplaceCommandOptions = 38,
        YieldReplaceExtentsOptions = 39,
        YieldRunCommandOptions = 40,
        YieldShowExtentsOptions = 41,
        YieldShowExtentsByEntityOptions = 42,
        YieldShowExtentsByEntityWithTagsFiltersOptions = 43,
        YieldSetCommandOptions = 44,
        YieldSetOrAppendCommandOptions = 45,
        YieldAddCommandOptions = 46,
        YieldAttachCommandOptions = 47,
        YieldDropCommandOptions = 48,
        YieldMoveCommandOptions = 49,
        YieldPoliciesOptions = 50,
        YieldClusterPoliciesOptions = 51,
        YieldDatabasePoliciesOptions = 52,
        YieldTablePoliciesOptions = 53,
        YieldColumnPoliciesOptions = 54,
        YieldAlterCommandOptions = 55,
        YieldAlterMergeCommandOptions = 56,
        YieldDeleteCommandOptions = 57,
        YieldCreateCommandOptions = 58,
        YieldMultiplePoliciesOptions = 59,
        YieldDatabaseCreatePersistencyOptions = 60,
        YieldCreateIfNotExistsOptions = 61,
        YieldAdminCommandsOptions = 62,
        YieldExportCommandOptions = 63,
        YieldExportCommandWithModifiersAndOptions = 64,
        YieldExportCommandNoModifiersAndOptions = 65,
        YieldAlterDatabaseCommandOptions = 66,
        YieldDeleteMultiplePoliciesOptions = 67,
        YieldIngestionDuplicationOptions = 68,
        YieldPurgeOptions = 69,
        YieldPurgeCleanupOptions = 70,
        YieldPurgeWhatIfOptions = 71,
        YieldPurgeWithPropertiesOptions = 72,
        YieldPurgeTableOptions = 73,
        YieldShowPrincipalCommandOptions = 74,
        YieldAlterFunctionEntitiesOptions = 75,
        YieldAlterMergePolicyRetentionOptions = 76,
        YieldAlterMergePolicyRetentionSoftDeleteDefinedOptions = 77,
        YieldAlterTimeSpanPolicyOptions = 78,
        YieldCreateOrAlterOptions = 79,
        YieldShowFabricOptions = 80,
        YieldRowStoreCreatePersistencyOptions = 81,
        YieldSetDatabaseIngestorsNoneOptions = 82,
        YieldSetTableIngestorsNoneOptions = 83,
        YieldSuspendNodeControlCommandOptions = 84
    }

    enum EntityDataType {
        Empty = 0,
        Object = 1,
        DBNull = 2,
        Boolean = 3,
        Char = 4,
        SByte = 5,
        Byte = 6,
        Int16 = 7,
        UInt16 = 8,
        Int32 = 9,
        UInt32 = 10,
        Int64 = 11,
        UInt64 = 12,
        Single = 13,
        Double = 14,
        Decimal = 15,
        DateTime = 16,
        String = 18,
        Dynamic = 19,
        TimeSpan = 20
    }

    interface AnalyzedCommand {
        Command: string | null;
        Context: Kusto.Data.IntelliSense.KustoCommandContext | null;
    }
    interface AnalyzedCommandFunc extends Function {
        prototype: AnalyzedCommand;
        new (): AnalyzedCommand;
    }
    var AnalyzedCommand: AnalyzedCommandFunc;

    enum ApiKind {
        Query = 0,
        AdminSyncCommand = 1,
        AdminAsyncCommand = 2
    }

    interface ApplyPolicy {
        Text: string | null;
        OffsetPosition: number;
        OffsetToken: string | null;
    }
    interface ApplyPolicyFunc extends Function {
        prototype: ApplyPolicy;
        new (): ApplyPolicy;
        NullApplyPolicy: Kusto.Data.IntelliSense.ApplyPolicy | null;
        AppendSpacePolicy: Kusto.Data.IntelliSense.ApplyPolicy | null;
    }
    var ApplyPolicy: ApplyPolicyFunc;

    interface IntelliSenseRulesProviderBase {
        DefaultRule: Kusto.Data.IntelliSense.IntelliSenseRule | null;
        CommandToolTips: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.IntelliSenseCommandTip> | null;
        ContextConnection: string | null;
        /**
         * Attempts to match any rule for input string
         *
         * @instance
         * @public
         * @this Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase
         * @memberof Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase
         * @param   {string}                                      command    
         * @param   {Kusto.Data.IntelliSense.IntelliSenseRule}    rule
         * @return  {boolean}
         */
        TryMatchAnyRule(command: string | null, rule: {v: Kusto.Data.IntelliSense.IntelliSenseRule | null}): boolean;
        TryMatchSpecificRule(command: string | null, commandContext: Kusto.Data.IntelliSense.KustoCommandContext | null, ruleKind: number, rule: {v: Kusto.Data.IntelliSense.IntelliSenseRule | null}): boolean;
        SetQueryParametersRule(queryParameters: System.Collections.Generic.IEnumerable$1<string> | null): void;
        ResetState(): void;
        AnalyzeCommand$1(statement: string | null, cachedReference: Kusto.Data.IntelliSense.CslCommand | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
        AnalyzeCommand(command: Kusto.Data.IntelliSense.AnalyzedCommand | null, appendingPart: string | null): Kusto.Data.IntelliSense.AnalyzedCommand | null;
    }
    interface IntelliSenseRulesProviderBaseFunc extends Function {
        prototype: IntelliSenseRulesProviderBase;
        PrivateTracer: Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracerFunc;
        new (): IntelliSenseRulesProviderBase;
    }
    var IntelliSenseRulesProviderBase: IntelliSenseRulesProviderBaseFunc;
    module IntelliSenseRulesProviderBase {
        interface PrivateTracer {
            TraceVerbose(format: string | null, list: any[] | null): void;
        }
        interface PrivateTracerFunc extends Function {
            prototype: PrivateTracer;
            new (): PrivateTracer;
            Tracer: Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer | null;
        }
    }

    enum CMRuleKind {
        None,
        Start,
        YieldServiceCancelMaintenance = 0,
        YieldServiceMoveToMaintenance = 1,
        YieldShowRegionsByHosters = 2,
        YieldAdminCommandsOptions = 3,
        YieldPipeOptions = 4,
        YieldOperatorsAfterPipe = 5,
        YieldShowCommandOptions = 6,
        YieldShowFabricCommandOptions = 7,
        YieldShowAccountCommandOptions = 8,
        YieldShowAccountsKeywordOptions = 9,
        YieldMoveAccountCommandOptions = 10,
        YieldMoveAccountSubscriptionCommandOptions = 11,
        YieldMoveCommandOptions = 12,
        YieldAlterCommandOptions = 13,
        YieldAddCommandOptions = 14,
        YieldDropCommandOptions = 15,
        YieldRemoveCommandOptions = 16,
        YieldCreateCommandOptions = 17,
        YieldCreateExternalCommandOptions = 18,
        YieldDeleteCommandOptions = 19,
        YieldDetachCommandOptions = 20,
        YieldCheckCommandOptions = 21,
        YieldSetCommandOptions = 22,
        YieldRegisterCommandOptions = 23,
        YieldPutCommandOptions = 24,
        YieldListCommandOptions = 25,
        YieldListKustoPoolsServicesCommandPropertiesSuffix = 26,
        YieldSyncCommandOptions = 27,
        YieldServiceKeywordOptions = 28,
        YieldServiceOrClusterKeywordOptions = 29,
        YieldStorageAccountsKeywordOptions = 30,
        YieldIngestLogsIntoKeywordsOptions = 31,
        YieldInServiceKeywordOptions = 32,
        YieldShowClusterKeywordOptions = 33,
        YieldOperationsKeywordOptions = 34,
        YieldOrchestrationKeywordOptions = 35,
        YieldOrchestrationTaskHubKeywordOptions = 36,
        YieldPcCodeKeywordOptions = 37,
        YieldsAlterServiceConfigurationKeywordOptions = 38,
        YieldFromAccountKeywordOptions = 39,
        YieldShowAuditLogCommandOptions = 40,
        YieldShowAuditLogFromCommandOptions = 41,
        YieldShowCmServiceCommandOptions = 42,
        YieldShowClusterClientOptions = 43,
        YieldShowClusterClientSubscriptionCommandOptions = 44,
        YieldShowClusterClusterNamePrincipalCommandOptions = 45,
        YieldShowServicesCompletionKeywordsOptions = 46,
        YieldConfigurationPropertySetKeywordOptions = 47,
        YieldConfigurationPropertyDropKeywordOptions = 48,
        YieldToStringKeywordOptions = 49,
        YieldToKeywordOptions = 50,
        YieldConfigurationPropertyWithConsentKeywordOptions = 51,
        YieldAccountAlterOperationsKeywordOptions = 52,
        YieldAccountAddOperationsKeywordOptions = 53,
        YieldAccountRemoveOperationsKeywordOptions = 54,
        YieldAccountSetOperationsKeywordOptions = 55,
        YieldAccountRenameOperationsKeywordOptions = 56,
        YieldServiceAlterOperationsKeywordOptions = 57,
        YieldMetadataKeywordOptions = 58,
        YieldSummaryKeywordOptions = 59,
        YieldSummaryOrMetadataKeywordOptions = 60,
        YieldDatabaseOrAccountMetadataKeywordOptions = 61,
        YieldAccountNames = 62,
        YieldDmServiceAddKeywordOptions = 63,
        YieldDmServiceDropKeywordOptions = 64,
        YieldDmServiceAlterKeywordOptions = 65,
        YieldDmServiceAlterSettingsOptions = 66,
        YieldDmServiceShowKeywordOptions = 67,
        YieldServicesNames = 68,
        YieldServicesNamesCombinedWithOptions = 69,
        YieldTargetServiceOptions = 70,
        YieldWithPropertiesSuffix = 71,
        YieldWithEventHubPropertiesSuffix = 72,
        YieldInstallCommandOptions = 73,
        YieldReinstallCommandOptions = 74,
        YieldUninstallServiceCommandOptions = 75,
        YieldUninstallCommandOptions = 76,
        YieldUpdateCommandOptions = 77,
        YieldMigrateServiceCommandOptions = 78,
        YieldMigrateClusterCommandOptions = 79,
        YieldFromServiceKeywordOptions = 80,
        YieldDatabaseMoveFromServiceCommandOptions = 81,
        YieldSetClusterPrincipalsCommandOptions = 82,
        YieldAddClusterPrincipalsCommandOptions = 83,
        YieldDropClusterPrincipalsCommandOptions = 84,
        YieldAddClusterJitPrincipalsCommandOptions = 85,
        YieldDropClusterJitPrincipalsCommandOptions = 86,
        YieldSetClusterPrincipalsNoneOptions = 87,
        YieldDropAccountPrincipalsCommandOptions = 88,
        YieldDatabaseCreateCommandOptions = 89,
        YieldServiceCreateCommandOptions = 90,
        YieldShowPrincipalRolesCommandOptions = 91,
        YieldAddKeywordOptions = 92,
        YieldAlterServiceConfigurationPropertiesOptions = 93,
        YieldAlterServiceConfigurationCommandOptions = 94,
        YieldMoveServiceConfigurationCommandOptions = 95,
        YieldAddServiceServiceNameOptions = 96,
        YieldLoadBalancerKeywordOptions = 97,
        YieldOperationKeywordOptions = 98,
        YieldShowSubscriptionCommandOptions = 99,
        YieldShowServiceSecurityRulesCommandOptions = 100,
        YieldKeysCommandOptions = 101,
        YieldKeyTypesCommandOptions = 102,
        YieldAlterServiceStorageAccountsCommandOptions = 103,
        YieldCmNotifyCommandOptions = 104,
        YieldExecuteCommandOptions = 105,
        YieldExecuteJobCommandOptions = 106,
        YieldGenerateCommandOptions = 107,
        YieldPublishCommandOptions = 108,
        YieldSkuAvailabilityPrefix = 109,
        YieldSkuAvailabilityCommandValues = 110,
        YieldSkuAvailabilityPropertiesSuffix = 111,
        YieldServiceRegenerateSuffix = 112,
        YieldVersionKeywordOptions = 113,
        YieldExportCommandOptions = 114,
        YieldExportPackageForOptions = 115,
        YieldExportPackageForServiceTypeOptions = 116,
        YieldSharedIdentity = 117,
        YieldSetRegionVisibility = 118,
        YieldRegisterFeature = 119,
        YieldBillingServiceCreateResources = 120,
        YieldPublishServiceCommandOptions = 121,
        YieldUnPublishCommandOptions = 122,
        YieldUnPublishServiceCommandOptions = 123,
        YieldRotateCommandOptions = 124,
        YieldRotateServiceCommandOptions = 125,
        YieldCreateFollowerDatabaseInServiceCommandOptions = 126,
        YieldColumnNamesAfterPipeCommandOptions = 127,
        YieldPutClientSubscriptionsNotification = 128,
        YieldDatabaseKeywordOptions = 129,
        YieldSyncKustoPoolRbacCommandOptions = 130
    }

    interface CompletionOption {
        Kind: Kusto.Data.IntelliSense.OptionKind;
        Value: string | null;
    }
    interface CompletionOptionFunc extends Function {
        prototype: CompletionOption;
        new (kind: Kusto.Data.IntelliSense.OptionKind, value: string | null): CompletionOption;
    }
    var CompletionOption: CompletionOptionFunc;

    interface EntityDataTypeConverter {
    }
    interface EntityDataTypeConverterFunc extends Function {
        prototype: EntityDataTypeConverter;
        new (): EntityDataTypeConverter;
        FromType(typeName: string | null): Kusto.Data.IntelliSense.EntityDataType;
    }
    var EntityDataTypeConverter: EntityDataTypeConverterFunc;

    enum ContextOperation {
        None = 0,
        Union = 1,
        Intersect = 2
    }

    interface IntelliSenseRule {
        Kind: number;
        RequiredKeywords: System.Collections.Generic.HashSet$1<string> | null;
        GetAfterApplyInfo(selectedOption: string | null): Kusto.Data.IntelliSense.ApplyPolicy | null;
        GetBeforeApplyInfo(selectedOption: string | null): Kusto.Data.IntelliSense.ApplyPolicy | null;
        IsMatch(context: Kusto.Data.IntelliSense.KustoCommandContext | null, input: string | null): boolean;
        GetOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<string> | null;
        GetCompletionOptions(context: Kusto.Data.IntelliSense.KustoCommandContext | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOption> | null;
    }
    interface IntelliSenseRuleFunc extends Function {
        prototype: IntelliSenseRule;
        new (): IntelliSenseRule;
    }
    var IntelliSenseRule: IntelliSenseRuleFunc;

    interface CslCommand {
        CslExpressionStartPosition: number;
        CslExpressionLength: number;
        Tokens: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandToken> | null;
        CommandParts: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandToken> | null;
        CommentParts: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandToken> | null;
        BracketParts: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandToken> | null;
        AllParts: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandToken> | null;
        Text: string | null;
        RelativeStart: number;
        Length: number;
        RelativeEnd: number;
        AbsoluteStart: number;
        AbsoluteEnd: number;
        AbsolutePositionBias: number;
        IsRunnable: boolean;
        ParseMode: Kusto.Data.IntelliSense.ParseMode;
        FormatAsString(separator: string | null, traits: number): string | null;
        /**
         * Optimization: instead of re-parsing tokens, copy them from the already parsed command that has the same text
         *
         * @instance
         * @this Kusto.Data.IntelliSense.CslCommand
         * @memberof Kusto.Data.IntelliSense.CslCommand
         * @param   {Kusto.Data.IntelliSense.CslCommand}    other
         * @return  {void}
         */
        /**
         * Re-parse the command string
         *
         * @instance
         * @this Kusto.Data.IntelliSense.CslCommand
         * @memberof Kusto.Data.IntelliSense.CslCommand
         * @param   {Kusto.Data.IntelliSense.CslIntelliSenseRulesProvider}    rulesProvider        
         * @param   {Kusto.Data.IntelliSense.ParseMode}                       parseMode            
         * @param   {Kusto.Data.IntelliSense.CslCommand}                      previousCandidate
         * @return  {void}
         */
        /**
         * Adds tokens that consist of tables, columns and calculated columns entities
         *
         * @instance
         * @private
         * @this Kusto.Data.IntelliSense.CslCommand
         * @memberof Kusto.Data.IntelliSense.CslCommand
         * @param   {Kusto.Data.IntelliSense.CslIntelliSenseRulesProvider}    rulesProvider       
         * @param   {System.Collections.Generic.List$1}                       tokens              
         * @param   {System.Collections.Generic.List$1}                       recognizedTokens    
         * @param   {Kusto.Data.IntelliSense.CslCommandIndexer}               indexer             
         * @param   {System.Collections.Generic.IList$1}                      commandParts        
         * @param   {Kusto.Data.IntelliSense.CslCommand}                      refernceCommand
         * @return  {void}
         */
        /**
         * When requested - this function takes care that between all previous tokens that were
         recognized - we will add a 'Unrecognized' tokens (e.g. so those can have specific color in UI)
         *
         * @instance
         * @private
         * @this Kusto.Data.IntelliSense.CslCommand
         * @memberof Kusto.Data.IntelliSense.CslCommand
         * @param   {Kusto.Data.IntelliSense.CslCommandIndexer}    indexer             
         * @param   {System.Collections.Generic.List$1}            tokens              
         * @param   {System.Collections.Generic.List$1}            recognizedTokens
         * @return  {void}
         */
    }
    interface CslCommandFunc extends Function {
        prototype: CslCommand;
        AddEntitiesTokensState: Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensStateFunc;
        FormatTraits: CslCommand.FormatTraitsFunc;
        PrivateTracer: Kusto.Data.IntelliSense.CslCommand.PrivateTracerFunc;
        MakeTrivialCommandFromText(text: string | null): Kusto.Data.IntelliSense.CslCommand | null;
        UnionCommands(commands: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommand> | null): Kusto.Data.IntelliSense.CslCommand | null;
    }
    var CslCommand: CslCommandFunc;
    module CslCommand {
        interface AddEntitiesTokensState {
            MapOfKnownEntities: System.Collections.Generic.Dictionary$2<Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1<string>> | null;
            MapOfPreviousCalculatedEntities: System.Collections.Generic.Dictionary$2<Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1<string>> | null;
            MapOfOriginallyKnownEntities: System.Collections.Generic.Dictionary$2<Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1<string>> | null;
            Clone(): Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState | null;
        }
        interface AddEntitiesTokensStateFunc extends Function {
            prototype: AddEntitiesTokensState;
            new (): AddEntitiesTokensState;
        }

        interface FormatTraits {
        }
        interface FormatTraitsFunc extends Function {
            prototype: FormatTraits;
            None: number;
            IncludeComments: number;
            TabulateOnJoins: number;
            TabulateOnFunctionBoundaries: number;
        }

        interface PrivateTracer {
            TraceVerbose(format: string | null, list: any[] | null): void;
        }
        interface PrivateTracerFunc extends Function {
            prototype: PrivateTracer;
            new (): PrivateTracer;
            Tracer: Kusto.Data.IntelliSense.CslCommand.PrivateTracer | null;
        }
    }

    interface CompletionOptionCollection {
        Kind: Kusto.Data.IntelliSense.OptionKind;
        Values: System.Collections.Generic.IEnumerable$1<string> | null;
        Priority: number;
        GetCompletionOptions(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CompletionOption> | null;
    }
    interface CompletionOptionCollectionFunc extends Function {
        prototype: CompletionOptionCollection;
        new (kind: Kusto.Data.IntelliSense.OptionKind, values: System.Collections.Generic.IEnumerable$1<string> | null, priority: number): CompletionOptionCollection;
    }
    var CompletionOptionCollection: CompletionOptionCollectionFunc;

    interface CslCommandIndexer {
        AntiTokenizers: System.Collections.Generic.HashSet$1<number> | null;
        TokenTerminators: System.Collections.Generic.HashSet$1<number> | null;
        TokenStarters: number[] | null;
        IndexText(text: string | null): void;
        GetCommandPartsPositions(): System.Collections.Generic.IList$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetCommentsPositions(): System.Collections.Generic.IList$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetClientDirectivesPositions(): System.Collections.Generic.IList$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetStringLiteralsPositions(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetQueryParametersPositions(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetBracketsPositions(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetAllTokensSortedByPosition(): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
        GetAllTokenPositions(tokens: System.Collections.Generic.IEnumerable$1<string> | null, tokenSuffix?: number): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition> | null;
    }
    interface CslCommandIndexerFunc extends Function {
        prototype: CslCommandIndexer;
        TokenPosition: Kusto.Data.IntelliSense.CslCommandIndexer.TokenPositionFunc;
        State: CslCommandIndexer.StateFunc;
        new (indexQueryParameters: boolean): CslCommandIndexer;
    }
    var CslCommandIndexer: CslCommandIndexerFunc;
    module CslCommandIndexer {
        interface TokenPosition {
            Text: string | null;
            Start: number;
            End: number;
            TokenTerminator: number;
            Length: number;
        }
        interface TokenPositionFunc extends Function {
            prototype: TokenPosition;
            new (): TokenPosition;
        }

        interface State {
        }
        interface StateFunc extends Function {
            prototype: State;
            LookingForTokenStart: number;
            LookingForTokenEnd: number;
            InsideComment: number;
            InsideStringLiteral: number;
        }
    }

    enum DMRuleKind {
        None,
        Start,
        YieldAdminCommandsOptions = 0,
        YieldShowCommandOptions = 1,
        YieldShowClustersKeywordOptions = 2,
        YieldShowClustersSettingsKeywordOptions = 3,
        YieldShowClustersSettingsVersionKeywordOptions = 4,
        YieldShowClustersSettingsWithEncryptedSecretsKeywordOptions = 5,
        YieldShowPrincipalRolesCommandOptions = 6,
        YieldAlterCommandOptions = 7,
        YieldAlterMergeCommandOptions = 8,
        YieldAlterClustersSettingsKeywordOptions = 9,
        YieldCreateCommandOptions = 10,
        YieldDropCommandOptions = 11,
        YieldAddCommandOptions = 12,
        YieldAddOrAlterCommandOptions = 13,
        YieldAddDataObtainerKeyworkOptions = 14,
        YieldAddDataObtainerInitializeKeyworkOptions = 15,
        YieldAddDataObtainerInitializeWithKeyworkOptions = 16,
        YieldGetCommandOptions = 17,
        YieldGetIngestionQueuesCommandOptions = 18,
        YieldGetIngestionQueuesTypeCommandOptions = 19,
        YieldFlushCommandOptions = 20,
        YieldInitializeCommandOptions = 21,
        YieldInitializeClusterConfigCommandOptions = 22,
        YieldInitializeClusterConfigEncryptionCommandOptions = 23,
        YieldResetCommandOptions = 24,
        YieldSetCommandOptions = 25,
        YieldAlterClustersSettingsFromKeywordOptions = 26,
        YieldAlterObtainerQueuesOptions = 27,
        YieldAddOrAlterEventHubIngestionSourceSettingsOptions = 28,
        YieldPurgeShowCommandOptions = 29,
        YieldPurgeShowCommandFromKeywordOptions = 30,
        YieldPurgeShowCommandToKeywordOptions = 31,
        YieldPurgeTableCommandOptions = 32,
        YieldPurgeMaterializedViewTableCommandOptions = 33,
        YieldPurgeTableInDatabaseCommandOptions = 34,
        YieldPurgeTableRecordsInDatabaseCommandOptions = 35,
        YieldPurgeRetryCommandOptions = 36,
        YieldPurgeRetryCommandFromKeywordOptions = 37,
        YieldPurgeRetryCommandToKeywordOptions = 38,
        YieldPurgeCancelCommandOptions = 39,
        YieldPurgeCancelAllCommandsOptions = 40,
        YieldClearCommandOptions = 41,
        YieldClearIngestionQueuesCommandOptions = 42,
        RefreshPolicyCacheCommandOptions = 43
    }

    /** @namespace Kusto.Data.IntelliSense */

    /**
     * Holds the documentation of a single csl token.
     *
     * @public
     * @class Kusto.Data.IntelliSense.CslTopicDocumentation
     */
    interface CslTopicDocumentation {
        TokenKind: number;
        Name: string | null;
        ShortDescription: string | null;
        LongDescription: string | null;
        Examples: string | null;
        Url: string | null;
        MarkdownSource: string | null;
        GetMarkDownText(): string | null;
        equals(obj: any | null): boolean;
        getHashCode(): number;
    }
    interface CslTopicDocumentationFunc extends Function {
        prototype: CslTopicDocumentation;
        new (tokenKind: number, name: string | null, shortDescription: string | null, longDescription: string | null, examples: string | null, url: string | null, markdownSource: string | null): CslTopicDocumentation;
    }
    var CslTopicDocumentation: CslTopicDocumentationFunc;

    interface CslDocumentation {
        Topics: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslTopicDocumentation> | null;
        AddTopic(topic: Kusto.Data.IntelliSense.CslTopicDocumentation | null): void;
        GetTopic(option: Kusto.Data.IntelliSense.CompletionOption | null): Kusto.Data.IntelliSense.CslTopicDocumentation | null;
        GetTopic$1(tokenKind: number, name: string | null): Kusto.Data.IntelliSense.CslTopicDocumentation | null;
        GetTopicByMarkdownSource(markdownSource: string | null): Kusto.Data.IntelliSense.CslTopicDocumentation | null;
        GetTopicByName(name: string | null): Kusto.Data.IntelliSense.CslTopicDocumentation | null;
        equals(obj: any | null): boolean;
        getHashCode(): number;
        Initialize(): void;
    }
    interface CslDocumentationFunc extends Function {
        prototype: CslDocumentation;
        new (): CslDocumentation;
        Instance: Kusto.Data.IntelliSense.CslDocumentation | null;
    }
    var CslDocumentation: CslDocumentationFunc;

    interface CslCommandToken extends System.ICloneable {
        AbsolutePositionBias: number;
        Value: string | null;
        TokenKind: number;
        AbsoluteStart: number;
        AbsoluteEnd: number;
        RelativeStart: number;
        Length: number;
        RelativeEnd: number;
        CompareTo(other: Kusto.Data.IntelliSense.CslCommandToken | null): number;
        clone(): any | null;
        equals(obj: any | null): boolean;
        getHashCode(): number;
    }
    interface CslCommandTokenFunc extends Function {
        prototype: CslCommandToken;
        Kind: CslCommandToken.KindFunc;
        new (value: string | null, absolutePositionBias: number, tokenKind: number): CslCommandToken;
    }
    var CslCommandToken: CslCommandTokenFunc;
    module CslCommandToken {
        interface Kind {
        }
        interface KindFunc extends Function {
            prototype: Kind;
            TableToken: number;
            TableColumnToken: number;
            OperatorToken: number;
            SubOperatorToken: number;
            CalculatedColumnToken: number;
            StringLiteralToken: number;
            FunctionNameToken: number;
            UnknownToken: number;
            CommentToken: number;
            PlainTextToken: number;
            DataTypeToken: number;
            ControlCommandToken: number;
            CommandPartToken: number;
            QueryParametersToken: number;
            CslCommandToken: number;
            LetVariablesToken: number;
            PluginToken: number;
            BracketRangeToken: number;
            ClientDirectiveToken: number;
            IsRecognizedEntity: number;
            IsMismatchedTokenValue: number;
        }
    }

    interface CslIntelliSenseRulesProvider extends Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider {
        Clone$1(): Kusto.Data.IntelliSense.CslIntelliSenseRulesProvider | null;
    }
    interface CslIntelliSenseRulesProviderFunc extends Function {
        prototype: CslIntelliSenseRulesProvider;
        $ctor1: {
            new (cluster: Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity | null, schema: Kusto.Data.IntelliSense.KustoIntelliSenseQuerySchema | null, queryParameters: System.Collections.Generic.IEnumerable$1<string> | null, availableClusters: System.Collections.Generic.IEnumerable$1<string> | null, schemaResolver: Kusto.Data.IntelliSense.IKustoIntelliSenseSchemaResolver | null, allowQueryParameters: boolean, allowClientDirectives: boolean): CslIntelliSenseRulesProvider
        };
        ctor: {
            new (other: Kusto.Data.IntelliSense.CslIntelliSenseRulesProvider | null): CslIntelliSenseRulesProvider
        };
    }
    var CslIntelliSenseRulesProvider: CslIntelliSenseRulesProviderFunc;

    interface CslCommandParser {
        Results: System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommand> | null;
        Reset(): void;
        Parse(rulesProvider: Kusto.Data.IntelliSense.CslIntelliSenseRulesProvider | null, text: string | null, parseMode: Kusto.Data.IntelliSense.ParseMode): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.CslCommand> | null;
        Clone(): Kusto.Data.IntelliSense.CslCommandParser | null;
    }
    interface CslCommandParserFunc extends Function {
        prototype: CslCommandParser;
        CslCommandTokenizer: Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizerFunc;
        new (): CslCommandParser;
        ControlCommandsTokens: string[] | null;
        CslCommandsTokens: string[] | null;
        ChartRenderTypesTokens: string[] | null;
        ChartRenderKindTokens: string[] | null;
        SubOperatorsTokens: string[] | null;
        JoinKindTokens: string[] | null;
        ReduceByKindTokens: string[] | null;
        DataTypesTokens: string[] | null;
        ScalarFunctionsDateTimeTokens: string[] | null;
        ScalarFunctionsNoDateTimeTokens: string[] | null;
        SingleParameterFunctionsDateTimeTokens: string[] | null;
        ZeroParameterFunctionsNoDateTimeTokens: string[] | null;
        SingleParameterFunctionsNoDateTimeTokens: string[] | null;
        IntrinsicFunctionTokens: string[] | null;
        TwoParameterFunctionsTokens: string[] | null;
        ThreeParameterFunctionsTokens: string[] | null;
        ManyParametersFunctionsTokens: string[] | null;
        PromotedOperatorCommandTokens: string[] | null;
        ClientDirectiveTokens: string[] | null;
        OperatorCommandTokens: string[] | null;
        DataOperatorTokens: string[] | null;
        SummarizeAggregationSingleParameterTokens: string[] | null;
        SummarizeAggregationTwoParametersTokens: string[] | null;
        SummarizeAggregationThreeParametersTokens: string[] | null;
        SummarizeAggregationManyParametersTokens: string[] | null;
        MakeSeriesAggregationTokens: string[] | null;
        PluginTokens: string[] | null;
        DatetimeFunctionsTokens: string[] | null;
        ScalarFunctionsTokens: string[] | null;
        SingleParameterFunctionsTokens: string[] | null;
        SummarizeAggregationTokens: string[] | null;
        SummarizeAggregationAliasesTokens: string[] | null;
        SortedSummarizeAggregators: string[] | null;
        SortedMakeSeriesAggregationTokens: string[] | null;
        SortedDatetimeFunctions: string[] | null;
        SortedExtendFunctions: string[] | null;
        FunctionsTokens: string[] | null;
        SortedEvaluateFunctions: string[] | null;
        IsAdminCommand$1(query: string | null, queryWithoutLeadingComments: {v: string | null}): boolean;
        IsAdminCommand(command: string | null): boolean;
        ResolveRequestApiKind(requestContent: string | null): Kusto.Data.IntelliSense.ApiKind;
        IsClientDirective(command: string | null, directiveWithoutLeadingComments: {v: string | null}): boolean;
    }
    var CslCommandParser: CslCommandParserFunc;
    module CslCommandParser {
        interface CslCommandTokenizer {
        }
        interface CslCommandTokenizerFunc extends Function {
            prototype: CslCommandTokenizer;
            new (): CslCommandTokenizer;
            GetCommands(text: string | null): System.Collections.Generic.List$1<Kusto.Data.IntelliSense.CslCommand> | null;
        }
    }

}

declare namespace Kusto.Data.Net.Common {
    /** @namespace Kusto.Data.Net.Common */

    /**
     * The format of the data stream returned by a Kusto service.
     *
     * @public
     * @class Kusto.Data.Net.Common.KustoDataStreamFormat
     */
    enum KustoDataStreamFormat {
        KustoJsonDataStream = 0,
        KustoDataStream = 1
    }

    /**
     * Extensions for enum RemoteServiceType
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Net.Common.ExtendedRemoteServiceType
     */
    interface ExtendedRemoteServiceType {
    }
    interface ExtendedRemoteServiceTypeFunc extends Function {
        prototype: ExtendedRemoteServiceType;
        new (): ExtendedRemoteServiceType;
        FastToString(that: Kusto.Data.Net.Common.RemoteServiceType): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Net.Common.RemoteServiceType, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Net.Common.RemoteServiceType, flag: Kusto.Data.Net.Common.RemoteServiceType): boolean;
        FastHasAllFlags(that: Kusto.Data.Net.Common.RemoteServiceType, flags: Kusto.Data.Net.Common.RemoteServiceType): boolean;
        FastHasAnyFlags(that: Kusto.Data.Net.Common.RemoteServiceType, flags: Kusto.Data.Net.Common.RemoteServiceType): boolean;
        FastCountIntersectionsWith(that: Kusto.Data.Net.Common.RemoteServiceType, flags: Kusto.Data.Net.Common.RemoteServiceType): number;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Net.Common.RemoteServiceType;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Net.Common.RemoteServiceType}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Net.Common.RemoteServiceType): number;
        FastGetDescription(that: Kusto.Data.Net.Common.RemoteServiceType): string | null;
        FastGetFlags(that: Kusto.Data.Net.Common.RemoteServiceType): System.Collections.Generic.IEnumerable$1<Kusto.Data.Net.Common.RemoteServiceType> | null;
    }
    var ExtendedRemoteServiceType: ExtendedRemoteServiceTypeFunc;

    /**
     * Extensions for enum KustoDataStreamFormat
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Data.Net.Common.ExtendedKustoDataStreamFormat
     */
    interface ExtendedKustoDataStreamFormat {
    }
    interface ExtendedKustoDataStreamFormatFunc extends Function {
        prototype: ExtendedKustoDataStreamFormat;
        new (): ExtendedKustoDataStreamFormat;
        FastToString(that: Kusto.Data.Net.Common.KustoDataStreamFormat): string | null;
        FastIsDefined$1(value: string | null): boolean;
        FastIsDefined(value: number): boolean;
        FastHasFlag$1(that: Kusto.Data.Net.Common.KustoDataStreamFormat, flag: number): boolean;
        FastHasFlag(that: Kusto.Data.Net.Common.KustoDataStreamFormat, flag: Kusto.Data.Net.Common.KustoDataStreamFormat): boolean;
        FastParse(value: string | null, ignoreCase?: boolean, ignoreInts?: boolean): Kusto.Data.Net.Common.KustoDataStreamFormat;
        FastTryParse(value: string | null, ret: {v: Kusto.Data.Net.Common.KustoDataStreamFormat}, ignoreCase?: boolean, ignoreInts?: boolean): boolean;
        FastGetHashCode(that: Kusto.Data.Net.Common.KustoDataStreamFormat): number;
        FastGetDescription(that: Kusto.Data.Net.Common.KustoDataStreamFormat): string | null;
    }
    var ExtendedKustoDataStreamFormat: ExtendedKustoDataStreamFormatFunc;

    /**
     * A bitmask that represents one or more externally-visible Kusto network services
     *
     * @public
     * @class Kusto.Data.Net.Common.RemoteServiceType
     */
    enum RemoteServiceType {
        Admin = 1,
        Query = 2,
        UIRedirect = 4,
        DataManagement = 8,
        ClusterManagement = 16,
        Bridge = 32,
        Ping = 64,
        CustomType = 1024,
        StreamIngest = 2048,
        PassiveLogin = 4096,
        ArmResourceProvider = 8192,
        AuthMetadata = 16384,
        Flighting = 32768,
        HealthSuite = 65536,
        Gaia = 131072,
        Proxy = 262144,
        SaasResourceProvider = 524288,
        Dashboard = 1048576,
        AllControlCommands = 57
    }

}

declare namespace Kusto.JavaScript.Client {
    interface App {
    }
    interface AppFunc extends Function {
        prototype: App;
        new (): App;
        Test(): void;
    }
    var App: AppFunc;

}

declare namespace Kusto.UT {
    interface AssertStub {
        AreEqual(expected: any | null, actual: any | null): void;
        AreEqual$1(expected: any | null, actual: any | null, errorMessage: string | null): void;
        Fail(message: string | null): void;
        IsTrue(condition: boolean, message: string | null): void;
    }
    interface AssertStubFunc extends Function {
        prototype: AssertStub;
        new (): AssertStub;
    }
    var AssertStub: AssertStubFunc;

    interface IntelliSenseRulesTests {
        IntelliSenseCommandEntitiesTest(): void;
        IntelliSenseCommandEntities_EscapedNamesTest(): void;
        IntelliSenseCommandEntities_FindTest(): void;
        IntelliSenseCommandEntities_SearchTest(): void;
        IntelliSenseCommandEntitiesForTablesTest(): void;
        IntelliSenseCommandEntitiesForClusters(): void;
        IntelliSenseCommandEntitiesForGetSchemaOperator(): void;
        IntelliSenseCommandEntitiesUsingFunctionsTest(): void;
        IntelliSenseEntityParserTest(): void;
        IntelliSenseFilterTest(): void;
        IntelliSenseRangeTest(): void;
        IntelliSenseDatabaseTest(): void;
        IntelliSenseClusterTest(): void;
        IntelliSenseSummarizeTest(): void;
        IntelliSenseMakeSeriesTest(): void;
        IntelliSenseDistinctTest(): void;
        IntelliSenseTopNestedTest(): void;
        IntelliSenseTopHittersTest(): void;
        IntelliSenseProjectTest(): void;
        IntelliSenseProjectAwayTest(): void;
        IntelliSenseProjectRenameTest(): void;
        IntelliSenseLimitTest(): void;
        IntelliSenseSampleTest(): void;
        IntelliSenseSampleDistinctTest(): void;
        IntelliSenseShowCommandTest(): void;
        IntelliSenseClientDirectivesTest(): void;
        IntelliSenseAppendCommandTest(): void;
        IntelliSenseReplaceCommandTest(): void;
        IntelliSenseExtendTest(): void;
        IntelliSenseParseOperator(): void;
        IntelliSenseShowTableCommandTest(): void;
        IntelliSenseAlterTableCommandTest(): void;
        IntelliSenseDeleteTableCommandTest(): void;
        IntelliSenseDropTableCommandTest(): void;
        IntelliSenseAlterFunctionCommandTest(): void;
        IntelliSenseShowDatabaseCommandTest(): void;
        IntelliSenseShowDatabasesCommandTest(): void;
        IntelliSenseShowClusterCommandTest(): void;
        IntelliSenseShowBasicAuthUsersCommandTest(): void;
        IntelliSenseIngestionDuplicateCommandTest(): void;
        IntelliSenseColumnCommandTest(): void;
        IntelliSenseDatabasePoliciesCommandTest(): void;
        IntelliSenseTablePoliciesCommandTest(): void;
        IntelliSenseClusterPoliciesCommandTest(): void;
        IntelliSenseSetDatabaseUsersAdminsViewersPrettyNameCommandTest(): void;
        IntelliSenseSetClusterUsersAdminsViewersCommandTest(): void;
        IntelliSenseSetTableAdminsCommandTest(): void;
        IntelliSenseAddDatabaseUsersAdminsViewersCommandTest(): void;
        IntelliSenseAddClusterUsersAdminsViewersCommandTest(): void;
        IntelliSenseAddTableAdminsCommandTest(): void;
        IntelliSenseDropDatabaseUsersAdminsViewersCommandTest(): void;
        IntelliSenseDropTableAdminsColumnsCommandTest(): void;
        IntelliSenseDropExtentTagsCommandTest(): void;
        IntelliSenseAlterExtentTagsCommandTest(): void;
        IntelliSenseExtentsAttachCommandTest(): void;
        IntelliSenseExtentsMoveCommandTest(): void;
        IntelliSenseExtentsReplaceCommandTest(): void;
        IntelliSenseCreateDatabaseAdminCommandTest(): void;
        IntelliSenseAlterDatabaseMetadataAdminCommandTest(): void;
        IntelliSenseCreateAddAlterDropAdminsCommandTest(): void;
        IntelliSenseDropClusterUsersAdminsViewersCommandTest(): void;
        IntelliSenseQueryParametersTest(): void;
        IntelliSenseJoinTest(): void;
        IntelliSenseRenderTest(): void;
        IntelliSenseTopTest(): void;
        IntelliSenseReduceTest(): void;
        IntelliSenseToScalarTest(): void;
        IntelliSenseTimeKeywordsTest(): void;
        IntelliSenseEvaluateTest(): void;
        IntelliSenseExportCommandTest(): void;
        IntelliSensePurgeCommandTest(): void;
        IntelliSensePurgeCleanupCommandTest(): void;
        IntelliSenseCreateRowstoreAdminCommandTest(): void;
        IntelliSenseSearchTest(): void;
        IntelliSenseFindTest(): void;
        IntelliSenseGetCommandContextTest(): void;
    }
    interface IntelliSenseRulesTestsFunc extends Function {
        prototype: IntelliSenseRulesTests;
        IntelliSenseTestPattern: Kusto.UT.IntelliSenseRulesTests.IntelliSenseTestPatternFunc;
        RemoteSchemaResolverMock: Kusto.UT.IntelliSenseRulesTests.RemoteSchemaResolverMockFunc;
        new (): IntelliSenseRulesTests;
        ValidateEntities(command: string | null, expectedFields: string[] | null, entititesList: System.Collections.Generic.List$1<string> | null): void;
        InitializeTestClass(): void;
        /**
         * Creates an-IntelliSense view of the database schema
         Database: "Database1"
             Tables: "Table1", "Table.2", "Table3"
                 Table1 columns: Field[0..9] (string), NumField[0..9]:int, DateTimeField[0..4]:datetime, TimeSpanField[0..4]:timespan
                 Table2 columns: Field[0..9] (string), NumField[0..9]:int, DateTimeField[0..4]:datetime, TimeSpanField[0..4]:timespan
                 Table3 columns: Field[0..1] (string)
            Functions: func, func[1..6]
         *
         * @static
         * @this Kusto.UT.IntelliSenseRulesTests
         * @memberof Kusto.UT.IntelliSenseRulesTests
         * @param   {System.Collections.Generic.List$1}                         queryParameters      
         * @param   {System.Collections.Generic.List$1}                         availableClusters
         * @return  {Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity}
         */
    }
    var IntelliSenseRulesTests: IntelliSenseRulesTestsFunc;
    module IntelliSenseRulesTests {
        interface IntelliSenseTestPattern {
            Input: string | null;
            ExpectedMatch: boolean;
            ExpectedRuleKind: number;
        }
        interface IntelliSenseTestPatternFunc extends Function {
            prototype: IntelliSenseTestPattern;
            ctor: {
                new (input: string | null): IntelliSenseTestPattern
            };
            $ctor2: {
                new (input: string | null, matchingRule: Kusto.Data.IntelliSense.RuleKind): IntelliSenseTestPattern
            };
            $ctor1: {
                new (input: string | null, matchingRule: Kusto.Data.IntelliSense.AdminEngineRuleKind): IntelliSenseTestPattern
            };
        }

        interface RemoteSchemaResolverMock extends Kusto.Data.IntelliSense.IKustoIntelliSenseSchemaResolver {
            ResolveDatabaseNames(clusterUriOrAlias: string | null): System.Collections.Generic.IEnumerable$1<string> | null;
            ResolveDatabaseSchema(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null): Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity | null;
            ResolveDatabaseSchema$1(clusterUriOrAlias: string | null, databaseNameOrAlias: string | null, tableName: string | null): System.Collections.Generic.IEnumerable$1<Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity> | null;
        }
        interface RemoteSchemaResolverMockFunc extends Function {
            prototype: RemoteSchemaResolverMock;
            new (): RemoteSchemaResolverMock;
        }
    }

    interface IntelliSenseCslCommandParserTests {
        TestClsCommandsPerttifier(): void;
        TestCslCommandParserEntities(): void;
        TestCslCommandParserReuse(): void;
        TestCslCommandParserBrackets(): void;
        TestCslCommandParserApiKind(): void;
    }
    interface IntelliSenseCslCommandParserTestsFunc extends Function {
        prototype: IntelliSenseCslCommandParserTests;
        new (): IntelliSenseCslCommandParserTests;
        InitializeTestClass(): void;
    }
    var IntelliSenseCslCommandParserTests: IntelliSenseCslCommandParserTestsFunc;
}
