//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"context"
	"errors"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// KeyVaultClient contains the methods for the KeyVaultClient group.
// Don't use this type directly, use NewKeyVaultClient() instead.
type KeyVaultClient struct {
	Pl runtime.Pipeline
}

// NewKeyVaultClient creates a new instance of KeyVaultClient with the specified values.
// pl - the pipeline used for sending requests and handling responses.
func NewKeyVaultClient(pl runtime.Pipeline) *KeyVaultClient {
	client := &KeyVaultClient{
		Pl: pl,
	}
	return client
}

// BackupKey - The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
// NOT return key material in a form that can be used outside the Azure Key Vault system,
// the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this
// operation is to allow a client to GENERATE a key in one Azure Key Vault
// instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to
// export, in protected form, any key type from Azure Key Vault. Individual
// versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that
// a BACKUP from one geographical area cannot be restored to another
// geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This
// operation requires the key/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// options - KeyVaultClientBackupKeyOptions contains the optional parameters for the KeyVaultClient.BackupKey method.
func (client *KeyVaultClient) BackupKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientBackupKeyOptions) (KeyVaultClientBackupKeyResponse, error) {
	req, err := client.backupKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientBackupKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientBackupKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientBackupKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupKeyHandleResponse(resp)
}

// backupKeyCreateRequest creates the BackupKey request.
func (client *KeyVaultClient) backupKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientBackupKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/backup"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// backupKeyHandleResponse handles the BackupKey response.
func (client *KeyVaultClient) backupKeyHandleResponse(resp *http.Response) (KeyVaultClientBackupKeyResponse, error) {
	result := KeyVaultClientBackupKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupKeyResult); err != nil {
		return KeyVaultClientBackupKeyResponse{}, err
	}
	return result, nil
}

// CreateKey - The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists,
// Azure Key Vault creates a new version of the key. It requires the keys/create
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name for the new key. The system will generate the version name for the new key.
// parameters - The parameters to create a key.
// options - KeyVaultClientCreateKeyOptions contains the optional parameters for the KeyVaultClient.CreateKey method.
func (client *KeyVaultClient) CreateKey(ctx context.Context, vaultBaseURL string, keyName string, parameters KeyCreateParameters, options *KeyVaultClientCreateKeyOptions) (KeyVaultClientCreateKeyResponse, error) {
	req, err := client.createKeyCreateRequest(ctx, vaultBaseURL, keyName, parameters, options)
	if err != nil {
		return KeyVaultClientCreateKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientCreateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientCreateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.createKeyHandleResponse(resp)
}

// createKeyCreateRequest creates the CreateKey request.
func (client *KeyVaultClient) createKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, parameters KeyCreateParameters, options *KeyVaultClientCreateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/create"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createKeyHandleResponse handles the CreateKey response.
func (client *KeyVaultClient) createKeyHandleResponse(resp *http.Response) (KeyVaultClientCreateKeyResponse, error) {
	result := KeyVaultClientCreateKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientCreateKeyResponse{}, err
	}
	return result, nil
}

// Decrypt - The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
// algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of
// data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT
// operation applies to asymmetric and symmetric keys stored in Azure Key Vault
// since it uses the private portion of the key. This operation requires the keys/decrypt permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for the decryption operation.
// options - KeyVaultClientDecryptOptions contains the optional parameters for the KeyVaultClient.Decrypt method.
func (client *KeyVaultClient) Decrypt(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientDecryptOptions) (KeyVaultClientDecryptResponse, error) {
	req, err := client.decryptCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientDecryptResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientDecryptResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientDecryptResponse{}, runtime.NewResponseError(resp)
	}
	return client.decryptHandleResponse(resp)
}

// decryptCreateRequest creates the Decrypt request.
func (client *KeyVaultClient) decryptCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientDecryptOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/decrypt"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// decryptHandleResponse handles the Decrypt response.
func (client *KeyVaultClient) decryptHandleResponse(resp *http.Response) (KeyVaultClientDecryptResponse, error) {
	result := KeyVaultClientDecryptResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return KeyVaultClientDecryptResponse{}, err
	}
	return result, nil
}

// DeleteKey - The delete key operation cannot be used to remove individual versions of a key. This operation removes the
// cryptographic material associated with the key, which means the key is not usable for
// Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key to delete.
// options - KeyVaultClientDeleteKeyOptions contains the optional parameters for the KeyVaultClient.DeleteKey method.
func (client *KeyVaultClient) DeleteKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientDeleteKeyOptions) (KeyVaultClientDeleteKeyResponse, error) {
	req, err := client.deleteKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientDeleteKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientDeleteKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientDeleteKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteKeyHandleResponse(resp)
}

// deleteKeyCreateRequest creates the DeleteKey request.
func (client *KeyVaultClient) deleteKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientDeleteKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// deleteKeyHandleResponse handles the DeleteKey response.
func (client *KeyVaultClient) deleteKeyHandleResponse(resp *http.Response) (KeyVaultClientDeleteKeyResponse, error) {
	result := KeyVaultClientDeleteKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyBundle); err != nil {
		return KeyVaultClientDeleteKeyResponse{}, err
	}
	return result, nil
}

// Encrypt - The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
// Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size
// of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly
// necessary for symmetric keys stored in Azure Key Vault since protection with an
// asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience
// for callers that have a key-reference but do not have access to the
// public key material. This operation requires the keys/encrypt permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for the encryption operation.
// options - KeyVaultClientEncryptOptions contains the optional parameters for the KeyVaultClient.Encrypt method.
func (client *KeyVaultClient) Encrypt(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientEncryptOptions) (KeyVaultClientEncryptResponse, error) {
	req, err := client.encryptCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientEncryptResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientEncryptResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientEncryptResponse{}, runtime.NewResponseError(resp)
	}
	return client.encryptHandleResponse(resp)
}

// encryptCreateRequest creates the Encrypt request.
func (client *KeyVaultClient) encryptCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientEncryptOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/encrypt"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// encryptHandleResponse handles the Encrypt response.
func (client *KeyVaultClient) encryptHandleResponse(resp *http.Response) (KeyVaultClientEncryptResponse, error) {
	result := KeyVaultClientEncryptResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return KeyVaultClientEncryptResponse{}, err
	}
	return result, nil
}

// GetDeletedKey - The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
// invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This
// operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// options - KeyVaultClientGetDeletedKeyOptions contains the optional parameters for the KeyVaultClient.GetDeletedKey method.
func (client *KeyVaultClient) GetDeletedKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientGetDeletedKeyOptions) (KeyVaultClientGetDeletedKeyResponse, error) {
	req, err := client.getDeletedKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientGetDeletedKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeletedKeyHandleResponse(resp)
}

// getDeletedKeyCreateRequest creates the GetDeletedKey request.
func (client *KeyVaultClient) getDeletedKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientGetDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedkeys/{key-name}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getDeletedKeyHandleResponse handles the GetDeletedKey response.
func (client *KeyVaultClient) getDeletedKeyHandleResponse(resp *http.Response) (KeyVaultClientGetDeletedKeyResponse, error) {
	result := KeyVaultClientGetDeletedKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyBundle); err != nil {
		return KeyVaultClientGetDeletedKeyResponse{}, err
	}
	return result, nil
}

// GetDeletedKeys - Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part
// of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys
// operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return
// an error if invoked on a non soft-delete enabled vault. This operation
// requires the keys/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// options - KeyVaultClientGetDeletedKeysOptions contains the optional parameters for the KeyVaultClient.GetDeletedKeys method.
func (client *KeyVaultClient) GetDeletedKeys(vaultBaseURL string, options *KeyVaultClientGetDeletedKeysOptions) *KeyVaultClientGetDeletedKeysPager {
	return &KeyVaultClientGetDeletedKeysPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.getDeletedKeysCreateRequest(ctx, vaultBaseURL, options)
		},
		advancer: func(ctx context.Context, resp KeyVaultClientGetDeletedKeysResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.DeletedKeyListResult.NextLink)
		},
	}
}

// getDeletedKeysCreateRequest creates the GetDeletedKeys request.
func (client *KeyVaultClient) getDeletedKeysCreateRequest(ctx context.Context, vaultBaseURL string, options *KeyVaultClientGetDeletedKeysOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedkeys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getDeletedKeysHandleResponse handles the GetDeletedKeys response.
func (client *KeyVaultClient) getDeletedKeysHandleResponse(resp *http.Response) (KeyVaultClientGetDeletedKeysResponse, error) {
	result := KeyVaultClientGetDeletedKeysResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyListResult); err != nil {
		return KeyVaultClientGetDeletedKeysResponse{}, err
	}
	return result, nil
}

// GetKey - The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
// is released in the response. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key to get.
// keyVersion - Adding the version parameter retrieves a specific version of a key. This URI fragment is optional. If not
// specified, the latest version of the key is returned.
// options - KeyVaultClientGetKeyOptions contains the optional parameters for the KeyVaultClient.GetKey method.
func (client *KeyVaultClient) GetKey(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, options *KeyVaultClientGetKeyOptions) (KeyVaultClientGetKeyResponse, error) {
	req, err := client.getKeyCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, options)
	if err != nil {
		return KeyVaultClientGetKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeyHandleResponse(resp)
}

// getKeyCreateRequest creates the GetKey request.
func (client *KeyVaultClient) getKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, options *KeyVaultClientGetKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	// if keyVersion == "" {
	// 	return nil, errors.New("parameter keyVersion cannot be empty")
	// }
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getKeyHandleResponse handles the GetKey response.
func (client *KeyVaultClient) getKeyHandleResponse(resp *http.Response) (KeyVaultClientGetKeyResponse, error) {
	result := KeyVaultClientGetKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientGetKeyResponse{}, err
	}
	return result, nil
}

// GetKeyRotationPolicy - The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key
// vault. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key in a given key vault.
// options - KeyVaultClientGetKeyRotationPolicyOptions contains the optional parameters for the KeyVaultClient.GetKeyRotationPolicy
// method.
func (client *KeyVaultClient) GetKeyRotationPolicy(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientGetKeyRotationPolicyOptions) (KeyVaultClientGetKeyRotationPolicyResponse, error) {
	req, err := client.getKeyRotationPolicyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientGetKeyRotationPolicyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetKeyRotationPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeyRotationPolicyHandleResponse(resp)
}

// getKeyRotationPolicyCreateRequest creates the GetKeyRotationPolicy request.
func (client *KeyVaultClient) getKeyRotationPolicyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientGetKeyRotationPolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/rotationpolicy"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getKeyRotationPolicyHandleResponse handles the GetKeyRotationPolicy response.
func (client *KeyVaultClient) getKeyRotationPolicyHandleResponse(resp *http.Response) (KeyVaultClientGetKeyRotationPolicyResponse, error) {
	result := KeyVaultClientGetKeyRotationPolicyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.RotationPolicy); err != nil {
		return KeyVaultClientGetKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// GetKeyVersions - The full key identifier, attributes, and tags are provided in the response. This operation requires the
// keys/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// options - KeyVaultClientGetKeyVersionsOptions contains the optional parameters for the KeyVaultClient.GetKeyVersions method.
func (client *KeyVaultClient) GetKeyVersions(vaultBaseURL string, keyName string, options *KeyVaultClientGetKeyVersionsOptions) *KeyVaultClientGetKeyVersionsPager {
	return &KeyVaultClientGetKeyVersionsPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.getKeyVersionsCreateRequest(ctx, vaultBaseURL, keyName, options)
		},
		advancer: func(ctx context.Context, resp KeyVaultClientGetKeyVersionsResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.KeyListResult.NextLink)
		},
	}
}

// getKeyVersionsCreateRequest creates the GetKeyVersions request.
func (client *KeyVaultClient) getKeyVersionsCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientGetKeyVersionsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/versions"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getKeyVersionsHandleResponse handles the GetKeyVersions response.
func (client *KeyVaultClient) getKeyVersionsHandleResponse(resp *http.Response) (KeyVaultClientGetKeyVersionsResponse, error) {
	result := KeyVaultClientGetKeyVersionsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return KeyVaultClientGetKeyVersionsResponse{}, err
	}
	return result, nil
}

// GetKeys - Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored
// key. The LIST operation is applicable to all key types, however only the base key
// identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response.
// This operation requires the keys/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// options - KeyVaultClientGetKeysOptions contains the optional parameters for the KeyVaultClient.GetKeys method.
func (client *KeyVaultClient) GetKeys(vaultBaseURL string, options *KeyVaultClientGetKeysOptions) *KeyVaultClientGetKeysPager {
	return &KeyVaultClientGetKeysPager{
		Client: client,
		Requester: func(ctx context.Context) (*policy.Request, error) {
			return client.GetKeysCreateRequest(ctx, vaultBaseURL, options)
		},
		Advancer: func(ctx context.Context, resp KeyVaultClientGetKeysResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.KeyListResult.NextLink)
		},
	}
}

// GetKeysCreateRequest creates the GetKeys request.
func (client *KeyVaultClient) GetKeysCreateRequest(ctx context.Context, vaultBaseURL string, options *KeyVaultClientGetKeysOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// GetKeysHandleResponse handles the GetKeys response.
func (client *KeyVaultClient) GetKeysHandleResponse(resp *http.Response) (KeyVaultClientGetKeysResponse, error) {
	result := KeyVaultClientGetKeysResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return KeyVaultClientGetKeysResponse{}, err
	}
	return result, nil
}

// GetRandomBytes - Get the requested number of bytes containing random values from a managed HSM.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// parameters - The request object to get random bytes.
// options - KeyVaultClientGetRandomBytesOptions contains the optional parameters for the KeyVaultClient.GetRandomBytes method.
func (client *KeyVaultClient) GetRandomBytes(ctx context.Context, vaultBaseURL string, parameters GetRandomBytesRequest, options *KeyVaultClientGetRandomBytesOptions) (KeyVaultClientGetRandomBytesResponse, error) {
	req, err := client.getRandomBytesCreateRequest(ctx, vaultBaseURL, parameters, options)
	if err != nil {
		return KeyVaultClientGetRandomBytesResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetRandomBytesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetRandomBytesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRandomBytesHandleResponse(resp)
}

// getRandomBytesCreateRequest creates the GetRandomBytes request.
func (client *KeyVaultClient) getRandomBytesCreateRequest(ctx context.Context, vaultBaseURL string, parameters GetRandomBytesRequest, options *KeyVaultClientGetRandomBytesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/rng"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// getRandomBytesHandleResponse handles the GetRandomBytes response.
func (client *KeyVaultClient) getRandomBytesHandleResponse(resp *http.Response) (KeyVaultClientGetRandomBytesResponse, error) {
	result := KeyVaultClientGetRandomBytesResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.RandomBytes); err != nil {
		return KeyVaultClientGetRandomBytesResponse{}, err
	}
	return result, nil
}

// ImportKey - The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
// exists, Azure Key Vault creates a new version of the key. This operation requires the
// keys/import permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - Name for the imported key.
// parameters - The parameters to import a key.
// options - KeyVaultClientImportKeyOptions contains the optional parameters for the KeyVaultClient.ImportKey method.
func (client *KeyVaultClient) ImportKey(ctx context.Context, vaultBaseURL string, keyName string, parameters KeyImportParameters, options *KeyVaultClientImportKeyOptions) (KeyVaultClientImportKeyResponse, error) {
	req, err := client.importKeyCreateRequest(ctx, vaultBaseURL, keyName, parameters, options)
	if err != nil {
		return KeyVaultClientImportKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientImportKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientImportKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.importKeyHandleResponse(resp)
}

// importKeyCreateRequest creates the ImportKey request.
func (client *KeyVaultClient) importKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, parameters KeyImportParameters, options *KeyVaultClientImportKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// importKeyHandleResponse handles the ImportKey response.
func (client *KeyVaultClient) importKeyHandleResponse(resp *http.Response) (KeyVaultClientImportKeyResponse, error) {
	result := KeyVaultClientImportKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientImportKeyResponse{}, err
	}
	return result, nil
}

// PurgeDeletedKey - The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can
// be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault.
// This operation requires the keys/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key
// options - KeyVaultClientPurgeDeletedKeyOptions contains the optional parameters for the KeyVaultClient.PurgeDeletedKey
// method.
func (client *KeyVaultClient) PurgeDeletedKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientPurgeDeletedKeyOptions) (KeyVaultClientPurgeDeletedKeyResponse, error) {
	req, err := client.purgeDeletedKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientPurgeDeletedKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientPurgeDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return KeyVaultClientPurgeDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return KeyVaultClientPurgeDeletedKeyResponse{RawResponse: resp}, nil
}

// purgeDeletedKeyCreateRequest creates the PurgeDeletedKey request.
func (client *KeyVaultClient) purgeDeletedKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientPurgeDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedkeys/{key-name}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// RecoverDeletedKey - The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It
// recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted
// key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation
// requires the keys/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the deleted key.
// options - KeyVaultClientRecoverDeletedKeyOptions contains the optional parameters for the KeyVaultClient.RecoverDeletedKey
// method.
func (client *KeyVaultClient) RecoverDeletedKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientRecoverDeletedKeyOptions) (KeyVaultClientRecoverDeletedKeyResponse, error) {
	req, err := client.recoverDeletedKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientRecoverDeletedKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientRecoverDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientRecoverDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.recoverDeletedKeyHandleResponse(resp)
}

// recoverDeletedKeyCreateRequest creates the RecoverDeletedKey request.
func (client *KeyVaultClient) recoverDeletedKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientRecoverDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedkeys/{key-name}/recover"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// recoverDeletedKeyHandleResponse handles the RecoverDeletedKey response.
func (client *KeyVaultClient) recoverDeletedKeyHandleResponse(resp *http.Response) (KeyVaultClientRecoverDeletedKeyResponse, error) {
	result := KeyVaultClientRecoverDeletedKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientRecoverDeletedKeyResponse{}, err
	}
	return result, nil
}

// Release - The release key operation is applicable to all key types. The target key must be marked exportable. This operation
// requires the keys/release permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key to get.
// keyVersion - Adding the version parameter retrieves a specific version of a key.
// parameters - The parameters for the key release operation.
// options - KeyVaultClientReleaseOptions contains the optional parameters for the KeyVaultClient.Release method.
func (client *KeyVaultClient) Release(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyReleaseParameters, options *KeyVaultClientReleaseOptions) (KeyVaultClientReleaseResponse, error) {
	req, err := client.releaseCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientReleaseResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientReleaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientReleaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.releaseHandleResponse(resp)
}

// releaseCreateRequest creates the Release request.
func (client *KeyVaultClient) releaseCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyReleaseParameters, options *KeyVaultClientReleaseOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/release"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	// if keyVersion == "" {
	// 	return nil, errors.New("parameter keyVersion cannot be empty")
	// }
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// releaseHandleResponse handles the Release response.
func (client *KeyVaultClient) releaseHandleResponse(resp *http.Response) (KeyVaultClientReleaseResponse, error) {
	result := KeyVaultClientReleaseResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyReleaseResult); err != nil {
		return KeyVaultClientReleaseResponse{}, err
	}
	return result, nil
}

// RestoreKey - Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes
// and access control policies. The RESTORE operation may be used to import a previously backed
// up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as
// it had when it was backed up. If the key name is not available in the target Key
// Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier
// will change if the key is restored to a different vault. Restore will restore all
// versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault
// must be owned by the same Microsoft Azure Subscription as the source Key Vault
// The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// parameters - The parameters to restore the key.
// options - KeyVaultClientRestoreKeyOptions contains the optional parameters for the KeyVaultClient.RestoreKey method.
func (client *KeyVaultClient) RestoreKey(ctx context.Context, vaultBaseURL string, parameters KeyRestoreParameters, options *KeyVaultClientRestoreKeyOptions) (KeyVaultClientRestoreKeyResponse, error) {
	req, err := client.restoreKeyCreateRequest(ctx, vaultBaseURL, parameters, options)
	if err != nil {
		return KeyVaultClientRestoreKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientRestoreKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientRestoreKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.restoreKeyHandleResponse(resp)
}

// restoreKeyCreateRequest creates the RestoreKey request.
func (client *KeyVaultClient) restoreKeyCreateRequest(ctx context.Context, vaultBaseURL string, parameters KeyRestoreParameters, options *KeyVaultClientRestoreKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// restoreKeyHandleResponse handles the RestoreKey response.
func (client *KeyVaultClient) restoreKeyHandleResponse(resp *http.Response) (KeyVaultClientRestoreKeyResponse, error) {
	result := KeyVaultClientRestoreKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientRestoreKeyResponse{}, err
	}
	return result, nil
}

// RotateKey - The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of key to be rotated. The system will generate a new version in the specified key.
// options - KeyVaultClientRotateKeyOptions contains the optional parameters for the KeyVaultClient.RotateKey method.
func (client *KeyVaultClient) RotateKey(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientRotateKeyOptions) (KeyVaultClientRotateKeyResponse, error) {
	req, err := client.rotateKeyCreateRequest(ctx, vaultBaseURL, keyName, options)
	if err != nil {
		return KeyVaultClientRotateKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientRotateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientRotateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.rotateKeyHandleResponse(resp)
}

// rotateKeyCreateRequest creates the RotateKey request.
func (client *KeyVaultClient) rotateKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, options *KeyVaultClientRotateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/rotate"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// rotateKeyHandleResponse handles the RotateKey response.
func (client *KeyVaultClient) rotateKeyHandleResponse(resp *http.Response) (KeyVaultClientRotateKeyResponse, error) {
	result := KeyVaultClientRotateKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientRotateKeyResponse{}, err
	}
	return result, nil
}

// Sign - The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation
// uses the private portion of the key. This operation requires the keys/sign permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for the signing operation.
// options - KeyVaultClientSignOptions contains the optional parameters for the KeyVaultClient.Sign method.
func (client *KeyVaultClient) Sign(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeySignParameters, options *KeyVaultClientSignOptions) (KeyVaultClientSignResponse, error) {
	req, err := client.signCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientSignResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientSignResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientSignResponse{}, runtime.NewResponseError(resp)
	}
	return client.signHandleResponse(resp)
}

// signCreateRequest creates the Sign request.
func (client *KeyVaultClient) signCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeySignParameters, options *KeyVaultClientSignOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/sign"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// signHandleResponse handles the Sign response.
func (client *KeyVaultClient) signHandleResponse(resp *http.Response) (KeyVaultClientSignResponse, error) {
	result := KeyVaultClientSignResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return KeyVaultClientSignResponse{}, err
	}
	return result, nil
}

// UnwrapKey - The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation
// is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and
// symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for the key operation.
// options - KeyVaultClientUnwrapKeyOptions contains the optional parameters for the KeyVaultClient.UnwrapKey method.
func (client *KeyVaultClient) UnwrapKey(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientUnwrapKeyOptions) (KeyVaultClientUnwrapKeyResponse, error) {
	req, err := client.unwrapKeyCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientUnwrapKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientUnwrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientUnwrapKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.unwrapKeyHandleResponse(resp)
}

// unwrapKeyCreateRequest creates the UnwrapKey request.
func (client *KeyVaultClient) unwrapKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientUnwrapKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/unwrapkey"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// unwrapKeyHandleResponse handles the UnwrapKey response.
func (client *KeyVaultClient) unwrapKeyHandleResponse(resp *http.Response) (KeyVaultClientUnwrapKeyResponse, error) {
	result := KeyVaultClientUnwrapKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return KeyVaultClientUnwrapKeyResponse{}, err
	}
	return result, nil
}

// UpdateKey - In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material
// of a key itself cannot be changed. This operation requires the keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of key to update.
// keyVersion - The version of the key to update.
// parameters - The parameters of the key to update.
// options - KeyVaultClientUpdateKeyOptions contains the optional parameters for the KeyVaultClient.UpdateKey method.
func (client *KeyVaultClient) UpdateKey(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyUpdateParameters, options *KeyVaultClientUpdateKeyOptions) (KeyVaultClientUpdateKeyResponse, error) {
	req, err := client.updateKeyCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientUpdateKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientUpdateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientUpdateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateKeyHandleResponse(resp)
}

// updateKeyCreateRequest creates the UpdateKey request.
func (client *KeyVaultClient) updateKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyUpdateParameters, options *KeyVaultClientUpdateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	// if keyVersion == "" {
	// 	return nil, errors.New("parameter keyVersion cannot be empty")
	// }
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateKeyHandleResponse handles the UpdateKey response.
func (client *KeyVaultClient) updateKeyHandleResponse(resp *http.Response) (KeyVaultClientUpdateKeyResponse, error) {
	result := KeyVaultClientUpdateKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return KeyVaultClientUpdateKeyResponse{}, err
	}
	return result, nil
}

// UpdateKeyRotationPolicy - Set specified members in the key policy. Leave others as undefined. This operation requires the
// keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key in the given vault.
// keyRotationPolicy - The policy for the key.
// options - KeyVaultClientUpdateKeyRotationPolicyOptions contains the optional parameters for the KeyVaultClient.UpdateKeyRotationPolicy
// method.
func (client *KeyVaultClient) UpdateKeyRotationPolicy(ctx context.Context, vaultBaseURL string, keyName string, keyRotationPolicy RotationPolicy, options *KeyVaultClientUpdateKeyRotationPolicyOptions) (KeyVaultClientUpdateKeyRotationPolicyResponse, error) {
	req, err := client.updateKeyRotationPolicyCreateRequest(ctx, vaultBaseURL, keyName, keyRotationPolicy, options)
	if err != nil {
		return KeyVaultClientUpdateKeyRotationPolicyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientUpdateKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientUpdateKeyRotationPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateKeyRotationPolicyHandleResponse(resp)
}

// updateKeyRotationPolicyCreateRequest creates the UpdateKeyRotationPolicy request.
func (client *KeyVaultClient) updateKeyRotationPolicyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyRotationPolicy RotationPolicy, options *KeyVaultClientUpdateKeyRotationPolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/rotationpolicy"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, keyRotationPolicy)
}

// updateKeyRotationPolicyHandleResponse handles the UpdateKeyRotationPolicy response.
func (client *KeyVaultClient) updateKeyRotationPolicyHandleResponse(resp *http.Response) (KeyVaultClientUpdateKeyRotationPolicyResponse, error) {
	result := KeyVaultClientUpdateKeyRotationPolicyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.RotationPolicy); err != nil {
		return KeyVaultClientUpdateKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// Verify - The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary
// for asymmetric keys stored in Azure Key Vault since signature verification can be
// performed using the public portion of the key but this operation is supported as a convenience for callers that only have
// a key-reference and not the public portion of the key. This operation requires
// the keys/verify permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for verify operations.
// options - KeyVaultClientVerifyOptions contains the optional parameters for the KeyVaultClient.Verify method.
func (client *KeyVaultClient) Verify(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyVerifyParameters, options *KeyVaultClientVerifyOptions) (KeyVaultClientVerifyResponse, error) {
	req, err := client.verifyCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientVerifyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientVerifyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientVerifyResponse{}, runtime.NewResponseError(resp)
	}
	return client.verifyHandleResponse(resp)
}

// verifyCreateRequest creates the Verify request.
func (client *KeyVaultClient) verifyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyVerifyParameters, options *KeyVaultClientVerifyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/verify"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// verifyHandleResponse handles the Verify response.
func (client *KeyVaultClient) verifyHandleResponse(resp *http.Response) (KeyVaultClientVerifyResponse, error) {
	result := KeyVaultClientVerifyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyVerifyResult); err != nil {
		return KeyVaultClientVerifyResponse{}, err
	}
	return result, nil
}

// WrapKey - The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
// stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric
// keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the
// key. This operation is supported for asymmetric keys as a convenience for
// callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// keyName - The name of the key.
// keyVersion - The version of the key.
// parameters - The parameters for wrap operation.
// options - KeyVaultClientWrapKeyOptions contains the optional parameters for the KeyVaultClient.WrapKey method.
func (client *KeyVaultClient) WrapKey(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientWrapKeyOptions) (KeyVaultClientWrapKeyResponse, error) {
	req, err := client.wrapKeyCreateRequest(ctx, vaultBaseURL, keyName, keyVersion, parameters, options)
	if err != nil {
		return KeyVaultClientWrapKeyResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientWrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientWrapKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.wrapKeyHandleResponse(resp)
}

// wrapKeyCreateRequest creates the WrapKey request.
func (client *KeyVaultClient) wrapKeyCreateRequest(ctx context.Context, vaultBaseURL string, keyName string, keyVersion string, parameters KeyOperationsParameters, options *KeyVaultClientWrapKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/keys/{key-name}/{key-version}/wrapkey"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(keyName))
	if keyVersion == "" {
		return nil, errors.New("parameter keyVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(keyVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// wrapKeyHandleResponse handles the WrapKey response.
func (client *KeyVaultClient) wrapKeyHandleResponse(resp *http.Response) (KeyVaultClientWrapKeyResponse, error) {
	result := KeyVaultClientWrapKeyResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return KeyVaultClientWrapKeyResponse{}, err
	}
	return result, nil
}
