var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
/// <reference path="../../node_modules/@kusto/language-service/Kusto.JavaScript.Client.d.ts" />
/// <reference path="../../node_modules/@kusto/language-service-next/Kusto.Language.Bridge.d.ts" />
/// <reference path="../typings/refs.d.ts" />
import * as s from './schema';
// polyfill string endsWith
if (!String.prototype.endsWith) {
    String.prototype.endsWith = function (search, this_len) {
        if (this_len === undefined || this_len > this.length) {
            this_len = this.length;
        }
        return this.substring(this_len - search.length, this_len) === search;
    };
}
// If we're running in a web worker - which doesn't share global context with the main thread -
// we need to manually load dependencies that are not explicit- meaning our non-module dependencies
// generated by Bridge.Net
if (typeof document == 'undefined') {
    // monaco will run the worker from vs/base/worker so the relative path needs to be from there (hence going up 2 dirs)
    importScripts('../../language/kusto/bridge.min.js');
    importScripts('../../language/kusto/kusto.javascript.client.min.js');
    importScripts('../../language/kusto/Kusto.Language.Bridge.min.js');
}
import * as ls from '../_deps/vscode-languageserver-types/main';
import * as XRegExp from '../_deps/xregexp/xregexp-all';
var k = Kusto.Data.IntelliSense;
var parsing = Kusto.Language.Parsing;
var k2 = Kusto.Language.Editor;
var sym = Kusto.Language.Symbols;
var GlobalState = Kusto.Language.GlobalState;
import { getCslTypeNameFromClrType, getEntityDataTypeFromCslType } from './schema';
var List = System.Collections.Generic.List$1;
function assertNever(x) {
    throw new Error('Unexpected object: ' + x);
}
var ParseProperties = /** @class */ (function () {
    function ParseProperties(version, uri, rulesProvider, parseMode) {
        this.version = version;
        this.uri = uri;
        this.rulesProvider = rulesProvider;
        this.parseMode = parseMode;
    }
    ParseProperties.prototype.isParseNeeded = function (document, rulesProvider, parseMode) {
        if (document.uri === this.uri &&
            (!rulesProvider || rulesProvider === this.rulesProvider) &&
            document.version <= this.version &&
            parseMode &&
            parseMode <= this.parseMode) {
            return false;
        }
        return true;
    };
    return ParseProperties;
}());
export var TokenKind;
(function (TokenKind) {
    TokenKind[TokenKind["TableToken"] = 2] = "TableToken";
    TokenKind[TokenKind["TableColumnToken"] = 4] = "TableColumnToken";
    TokenKind[TokenKind["OperatorToken"] = 8] = "OperatorToken";
    TokenKind[TokenKind["SubOperatorToken"] = 16] = "SubOperatorToken";
    TokenKind[TokenKind["CalculatedColumnToken"] = 32] = "CalculatedColumnToken";
    TokenKind[TokenKind["StringLiteralToken"] = 64] = "StringLiteralToken";
    TokenKind[TokenKind["FunctionNameToken"] = 128] = "FunctionNameToken";
    TokenKind[TokenKind["UnknownToken"] = 256] = "UnknownToken";
    TokenKind[TokenKind["CommentToken"] = 512] = "CommentToken";
    TokenKind[TokenKind["PlainTextToken"] = 1024] = "PlainTextToken";
    TokenKind[TokenKind["DataTypeToken"] = 2048] = "DataTypeToken";
    TokenKind[TokenKind["ControlCommandToken"] = 4096] = "ControlCommandToken";
    TokenKind[TokenKind["CommandPartToken"] = 8192] = "CommandPartToken";
    TokenKind[TokenKind["QueryParametersToken"] = 16384] = "QueryParametersToken";
    TokenKind[TokenKind["CslCommandToken"] = 32768] = "CslCommandToken";
    TokenKind[TokenKind["LetVariablesToken"] = 65536] = "LetVariablesToken";
    TokenKind[TokenKind["PluginToken"] = 131072] = "PluginToken";
    TokenKind[TokenKind["BracketRangeToken"] = 262144] = "BracketRangeToken";
    TokenKind[TokenKind["ClientDirectiveToken"] = 524288] = "ClientDirectiveToken";
})(TokenKind || (TokenKind = {}));
/**
 * convert the bridge.net object to a plain javascript object that only contains data.
 * @param k2Classifications @kusto/language-service-next bridge.net object
 */
function toClassifiedRange(k2Classifications) {
    return k2Classifications.map(function (classification) { return ({
        start: classification.Start,
        end: classification.End,
        length: classification.Length,
        kind: classification.Kind,
    }); });
}
/**
 * Kusto Language service translates the kusto object model (transpiled from C# by Bridge.Net)
 * to the vscode language server types, which are used by vscode language extensions.
 * This should make things easier in the future to provide a vscode extension based on this translation layer.
 *
 * Further translations, if needed, to support specific editors (Atom, sublime, Etc)
 * should be done on top of this API, since it is (at least meant to be) a standard that is supported by multiple editors.
 *
 * Note1:  Currently monaco isn't using this object model so further translation will be necessary on calling modules.
 *
 * Note2: This file is responsible for interacting with the kusto object model and exposing Microsoft language service types.
 * An exception to that rule is tokenization (and syntax highlighting which depends on it) -
 * since it's not currently part of the Microsoft language service protocol. Thus tokenize() _does_ 'leak' kusto types to the callers.
 */
var KustoLanguageService = /** @class */ (function () {
    function KustoLanguageService(schema, languageSettings) {
        var _a, _b, _c, _d;
        var _this = this;
        this._toOptionKind = (_a = {},
            _a[k2.CompletionKind.AggregateFunction] = k.OptionKind.FunctionAggregation,
            _a[k2.CompletionKind.BuiltInFunction] = k.OptionKind.FunctionServerSide,
            _a[k2.CompletionKind.Cluster] = k.OptionKind.Database,
            _a[k2.CompletionKind.Column] = k.OptionKind.Column,
            _a[k2.CompletionKind.CommandPrefix] = k.OptionKind.None,
            _a[k2.CompletionKind.Database] = k.OptionKind.Database,
            _a[k2.CompletionKind.DatabaseFunction] = k.OptionKind.FunctionServerSide,
            _a[k2.CompletionKind.Example] = k.OptionKind.None,
            _a[k2.CompletionKind.Identifier] = k.OptionKind.None,
            _a[k2.CompletionKind.Keyword] = k.OptionKind.None,
            _a[k2.CompletionKind.LocalFunction] = k.OptionKind.FunctionLocal,
            _a[k2.CompletionKind.MaterialiedView] = k.OptionKind.MaterializedView,
            _a[k2.CompletionKind.Parameter] = k.OptionKind.Parameter,
            _a[k2.CompletionKind.Punctuation] = k.OptionKind.None,
            _a[k2.CompletionKind.QueryPrefix] = k.OptionKind.Operator,
            _a[k2.CompletionKind.RenderChart] = k.OptionKind.Operator,
            _a[k2.CompletionKind.ScalarInfix] = k.OptionKind.None,
            _a[k2.CompletionKind.ScalarPrefix] = k.OptionKind.None,
            _a[k2.CompletionKind.ScalarType] = k.OptionKind.DataType,
            _a[k2.CompletionKind.Syntax] = k.OptionKind.None,
            _a[k2.CompletionKind.Table] = k.OptionKind.Table,
            _a[k2.CompletionKind.TabularPrefix] = k.OptionKind.None,
            _a[k2.CompletionKind.TabularSuffix] = k.OptionKind.None,
            _a[k2.CompletionKind.Unknown] = k.OptionKind.None,
            _a[k2.CompletionKind.Variable] = k.OptionKind.Parameter,
            _a[k2.CompletionKind.Option] = k.OptionKind.Option,
            _a);
        this.disabledCompletionItemsV2 = {
            // render charts
            ladderchart: k2.CompletionKind.RenderChart,
            pivotchart: k2.CompletionKind.RenderChart,
            timeline: k2.CompletionKind.RenderChart,
            timepivot: k2.CompletionKind.RenderChart,
            '3Dchart': k2.CompletionKind.RenderChart,
            list: k2.CompletionKind.RenderChart,
        };
        this.isIntellisenseV2 = function () {
            return _this._languageSettings.useIntellisenseV2 && _this._schema && _this._schema.clusterType === 'Engine';
        };
        this.disabledCompletionItemsV1 = {
            capacity: k.OptionKind.Policy,
            callout: k.OptionKind.Policy,
            encoding: k.OptionKind.Policy,
            batching: k.OptionKind.Policy,
            querythrottling: k.OptionKind.Policy,
            merge: k.OptionKind.Policy,
            querylimit: k.OptionKind.Policy,
            rowstore: k.OptionKind.Policy,
            streamingingestion: k.OptionKind.Policy,
            restricted_view_access: k.OptionKind.Policy,
            sharding: k.OptionKind.Policy,
            'restricted-viewers': k.OptionKind.Policy,
            attach: k.OptionKind.Command,
            purge: k.OptionKind.Command,
        };
        this._kustoKindtolsKind = (_b = {},
            _b[k.OptionKind.None] = ls.CompletionItemKind.Interface,
            _b[k.OptionKind.Operator] = ls.CompletionItemKind.Method,
            _b[k.OptionKind.Command] = ls.CompletionItemKind.Method,
            _b[k.OptionKind.Service] = ls.CompletionItemKind.Class,
            _b[k.OptionKind.Policy] = ls.CompletionItemKind.Reference,
            _b[k.OptionKind.Database] = ls.CompletionItemKind.Class,
            _b[k.OptionKind.Table] = ls.CompletionItemKind.Class,
            _b[k.OptionKind.DataType] = ls.CompletionItemKind.Class,
            _b[k.OptionKind.Literal] = ls.CompletionItemKind.Property,
            _b[k.OptionKind.Parameter] = ls.CompletionItemKind.Variable,
            _b[k.OptionKind.IngestionMapping] = ls.CompletionItemKind.Variable,
            _b[k.OptionKind.ExpressionFunction] = ls.CompletionItemKind.Variable,
            _b[k.OptionKind.Option] = ls.CompletionItemKind.Interface,
            _b[k.OptionKind.OptionKind] = ls.CompletionItemKind.Interface,
            _b[k.OptionKind.OptionRender] = ls.CompletionItemKind.Interface,
            _b[k.OptionKind.Column] = ls.CompletionItemKind.Function,
            _b[k.OptionKind.ColumnString] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.ColumnNumeric] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.ColumnDateTime] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.ColumnTimespan] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.FunctionServerSide] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.FunctionAggregation] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.FunctionFilter] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.FunctionScalar] = ls.CompletionItemKind.Field,
            _b[k.OptionKind.ClientDirective] = ls.CompletionItemKind.Enum,
            _b);
        this._kustoKindToLsKindV2 = (_c = {},
            _c[k2.CompletionKind.AggregateFunction] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.BuiltInFunction] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.Cluster] = ls.CompletionItemKind.Class,
            _c[k2.CompletionKind.Column] = ls.CompletionItemKind.Function,
            _c[k2.CompletionKind.CommandPrefix] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.Database] = ls.CompletionItemKind.Class,
            _c[k2.CompletionKind.DatabaseFunction] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.Example] = ls.CompletionItemKind.Text,
            _c[k2.CompletionKind.Identifier] = ls.CompletionItemKind.Method,
            _c[k2.CompletionKind.Keyword] = ls.CompletionItemKind.Method,
            _c[k2.CompletionKind.LocalFunction] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.MaterialiedView] = ls.CompletionItemKind.Class,
            _c[k2.CompletionKind.Parameter] = ls.CompletionItemKind.Variable,
            _c[k2.CompletionKind.Punctuation] = ls.CompletionItemKind.Interface,
            _c[k2.CompletionKind.QueryPrefix] = ls.CompletionItemKind.Function,
            _c[k2.CompletionKind.RenderChart] = ls.CompletionItemKind.Method,
            _c[k2.CompletionKind.ScalarInfix] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.ScalarPrefix] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.ScalarType] = ls.CompletionItemKind.TypeParameter,
            _c[k2.CompletionKind.Syntax] = ls.CompletionItemKind.Method,
            _c[k2.CompletionKind.Table] = ls.CompletionItemKind.Class,
            _c[k2.CompletionKind.TabularPrefix] = ls.CompletionItemKind.Field,
            // datatable, externaldata
            _c[k2.CompletionKind.TabularSuffix] = ls.CompletionItemKind.Field,
            _c[k2.CompletionKind.Unknown] = ls.CompletionItemKind.Interface,
            _c[k2.CompletionKind.Variable] = ls.CompletionItemKind.Variable,
            _c[k2.CompletionKind.Option] = ls.CompletionItemKind.Text,
            _c);
        this._tokenKindToClassificationKind = (_d = {},
            _d[TokenKind.TableToken] = k2.ClassificationKind.Table,
            _d[TokenKind.TableColumnToken] = k2.ClassificationKind.Column,
            _d[TokenKind.OperatorToken] = k2.ClassificationKind.QueryOperator,
            _d[TokenKind.SubOperatorToken] = k2.ClassificationKind.Function,
            _d[TokenKind.CalculatedColumnToken] = k2.ClassificationKind.Column,
            _d[TokenKind.StringLiteralToken] = k2.ClassificationKind.Literal,
            _d[TokenKind.FunctionNameToken] = k2.ClassificationKind.Function,
            _d[TokenKind.UnknownToken] = k2.ClassificationKind.PlainText,
            _d[TokenKind.CommentToken] = k2.ClassificationKind.Comment,
            _d[TokenKind.PlainTextToken] = k2.ClassificationKind.PlainText,
            _d[TokenKind.DataTypeToken] = k2.ClassificationKind.Type,
            _d[TokenKind.ControlCommandToken] = k2.ClassificationKind.PlainText,
            _d[TokenKind.CommandPartToken] = k2.ClassificationKind.PlainText,
            _d[TokenKind.QueryParametersToken] = k2.ClassificationKind.QueryParameter,
            _d[TokenKind.CslCommandToken] = k2.ClassificationKind.Keyword,
            _d[TokenKind.LetVariablesToken] = k2.ClassificationKind.Identifier,
            _d[TokenKind.PluginToken] = k2.ClassificationKind.Function,
            _d[TokenKind.BracketRangeToken] = k2.ClassificationKind.Keyword,
            _d[TokenKind.ClientDirectiveToken] = k2.ClassificationKind.Keyword,
            _d);
        this._schemaCache = {};
        this._kustoJsSchema = KustoLanguageService.convertToKustoJsSchema(schema);
        this.__kustoJsSchemaV2 = this.convertToKustoJsSchemaV2(schema);
        this._schema = schema;
        this._clustersSetInGlobalState = new Set();
        this._nonEmptyDatabaseSetInGlobalState = new Set(); // used to remove clusters that are already in the global state
        this.configure(languageSettings);
        this._newlineAppendPipePolicy = new Kusto.Data.IntelliSense.ApplyPolicy();
        this._newlineAppendPipePolicy.Text = '\n| ';
    }
    KustoLanguageService.prototype.createDatabaseUniqueName = function (clusterName, databaseName) {
        return clusterName + "_" + databaseName;
    };
    Object.defineProperty(KustoLanguageService.prototype, "_kustoJsSchemaV2", {
        /**
         * A getter for __kustoJsSchemaV2
         */
        get: function () {
            return this.__kustoJsSchemaV2;
        },
        /**
         * A setter for _kustoJsSchemaV2. After a schema (global state) is set, create 2 sets of cluster and database names.
         */
        set: function (globalState) {
            this.__kustoJsSchemaV2 = globalState;
            this._clustersSetInGlobalState.clear();
            this._nonEmptyDatabaseSetInGlobalState.clear();
            // create 2 Sets with cluster names and database names based on the updated Global State.
            for (var i = 0; i < globalState.Clusters.Count; i++) {
                var clusterSymbol = this._kustoJsSchemaV2.Clusters.getItem(i);
                this._clustersSetInGlobalState.add(clusterSymbol.Name);
                for (var i2 = 0; i2 < clusterSymbol.Databases.Count; i2++) {
                    var databaseSymbol = clusterSymbol.Databases.getItem(i2);
                    if (databaseSymbol.Tables.Count > 0) {
                        // only include database with tables
                        this._nonEmptyDatabaseSetInGlobalState.add(this.createDatabaseUniqueName(clusterSymbol.Name, databaseSymbol.Name));
                    }
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    KustoLanguageService.prototype.configure = function (languageSettings) {
        this._languageSettings = languageSettings;
        // Since we're still reverting to V1 intellisense for control commands, we need to update the rules provider
        // (which is a notion of V1 intellisense).
        this.createRulesProvider(this._kustoJsSchema, this._schema.clusterType);
    };
    KustoLanguageService.prototype.doComplete = function (document, position) {
        return this.isIntellisenseV2() ? this.doCompleteV2(document, position) : this.doCompleteV1(document, position);
    };
    /**
     * important: Only use during development to test Global State.
     * Prints clusters, databases and tables that are currently in the GlobalState.
     */
    KustoLanguageService.prototype.debugGlobalState = function (globals) {
        // iterate over clusters
        console.log("globals.Clusters.Count: " + globals.Clusters.Count);
        for (var i = 0; i < globals.Clusters.Count; i++) {
            var cluster = globals.Clusters.getItem(i);
            console.log("cluster: " + cluster.Name);
            // iterate over databases
            console.log("cluster.Databases.Count: " + cluster.Databases.Count);
            for (var i2 = 0; i2 < cluster.Databases.Count; i2++) {
                var database = cluster.Databases.getItem(i2);
                console.log("cluster.database: [" + cluster.Name + "].[" + database.Name + "]");
                // iterate over tables
                console.log("cluster.Databases.Tables.Count: " + database.Tables.Count);
                for (var i3 = 0; i3 < database.Tables.Count; i3++) {
                    var table = database.Tables.getItem(i3);
                    console.log("cluster.database.table: [" + cluster.Name + "].[" + database.Name + "].[" + table.Name + "]");
                }
            }
        }
    };
    KustoLanguageService.prototype.doCompleteV2 = function (document, position) {
        var _this = this;
        if (!document) {
            return Promise.resolve(ls.CompletionList.create([]));
        }
        var script = this.parseDocumentV2(document);
        // print cluster/database/tables from CodeScript.Globals
        // this.debugGlobalState(script.Globals);
        // get current command
        var cursorOffset = document.offsetAt(position);
        var currentCommand = script.GetBlockAtPosition(cursorOffset);
        // get completion items
        var completionItems = currentCommand.Service.GetCompletionItems(cursorOffset);
        var disabledItems = this.disabledCompletionItemsV2;
        if (this._languageSettings.disabledCompletionItems) {
            this._languageSettings.disabledCompletionItems.map(function (item) {
                // logic will treat unknown as a '*' wildcard, meaning that if the key is in the object
                // the completion item will be suppressed.
                disabledItems[item] = k2.CompletionKind.Unknown;
            });
        }
        var items = this.toArray(completionItems.Items)
            .filter(function (item) {
            return !(item &&
                item.MatchText &&
                disabledItems[item.MatchText] !== undefined &&
                (disabledItems[item.MatchText] === k2.CompletionKind.Unknown ||
                    disabledItems[item.MatchText] === item.Kind));
        })
            .map(function (kItem, i) {
            var v1CompletionOption = new k.CompletionOption(_this._toOptionKind[kItem.Kind] || k.OptionKind.None, kItem.DisplayText);
            var helpTopic = _this.getTopic(v1CompletionOption);
            // If we have AfterText it means that the cursor should no be placed at end of suggested text.
            // In that case we switch to snippet format and represent the point where the cursor should be as
            // as '\$0'
            var _a = kItem.AfterText && kItem.AfterText.length > 0
                ? {
                    // Need to escape dollar sign since it is used as a placeholder in snippet.
                    // Usually dollar sign is not a valid character in a function name, but grafana uses macros that start with dollars.
                    textToInsert: kItem.EditText.replace('$', '\\$') + "$0" + kItem.AfterText,
                    format: ls.InsertTextFormat.Snippet,
                }
                : {
                    textToInsert: kItem.EditText,
                    format: ls.InsertTextFormat.PlainText,
                }, textToInsert = _a.textToInsert, format = _a.format;
            var lsItem = ls.CompletionItem.create(kItem.DisplayText);
            var startPosition = document.positionAt(completionItems.EditStart);
            var endPosition = document.positionAt(completionItems.EditStart + completionItems.EditLength);
            lsItem.textEdit = ls.TextEdit.replace(ls.Range.create(startPosition, endPosition), textToInsert);
            lsItem.sortText = _this.getSortText(i + 1);
            // lsItem.filterText = lsItem.sortText;
            lsItem.kind = _this.kustoKindToLsKindV2(kItem.Kind);
            lsItem.insertTextFormat = format;
            lsItem.detail = helpTopic ? helpTopic.ShortDescription : undefined;
            lsItem.documentation = helpTopic
                ? { value: helpTopic.LongDescription, kind: ls.MarkupKind.Markdown }
                : undefined;
            return lsItem;
        });
        return Promise.resolve(ls.CompletionList.create(items));
    };
    /**
     * when trying to get a topic we need the function name (abs, toLower, ETC).
     * The problem is that the 'Value' string also contains the  arguments (e.g abs(number)), which means that we are
     * not able to correlate the option with its documentation.
     * This piece of code tries to strip this hwne getting topic.
     * @param completionOption the Completion option
     */
    KustoLanguageService.prototype.getTopic = function (completionOption) {
        if (completionOption.Kind == k.OptionKind.FunctionScalar ||
            completionOption.Kind == k.OptionKind.FunctionAggregation) {
            // from a value like 'abs(number)' remove the '(number)' so that only 'abs' will remain
            var indexOfParen = completionOption.Value.indexOf('(');
            if (indexOfParen >= 0) {
                completionOption = new k.CompletionOption(completionOption.Kind, completionOption.Value.substring(0, indexOfParen));
            }
        }
        return k.CslDocumentation.Instance.GetTopic(completionOption);
    };
    KustoLanguageService.prototype.doCompleteV1 = function (document, position) {
        var _this = this;
        // TODO: fix typing in CslCommandParser to allow rulesProvider to be query only.
        var caretAbsolutePosition = document.offsetAt(position);
        // find out what's the current command to only parse this one.
        this.parseDocumentV1(document, k.ParseMode.CommandTokensOnly);
        var currentCommand = this.getCurrentCommand(document, caretAbsolutePosition);
        var commandTextUntilCursor = '';
        if (currentCommand) {
            var commandStartOffset = currentCommand.AbsoluteStart;
            this.parseTextV1(currentCommand.Text, k.ParseMode.TokenizeAllText);
            var caretRelativePosition = caretAbsolutePosition - currentCommand.AbsoluteStart;
            commandTextUntilCursor = currentCommand.Text.substring(currentCommand.CslExpressionStartPosition, caretRelativePosition);
        }
        var commandTextWithoutLastWord = this.getCommandWithoutLastWord(commandTextUntilCursor);
        var context = this._rulesProvider.AnalyzeCommand$1(commandTextUntilCursor, currentCommand).Context;
        var result = { v: null };
        this._rulesProvider.TryMatchAnyRule(commandTextWithoutLastWord, result);
        var rule = result.v;
        if (rule) {
            var completionOptions = this.toArray(rule.GetCompletionOptions(context));
            // TODO once AppendPipePolicy becomes a public static member of ApplyPolicy in our c# code, and bridge.Net transplies this,
            //  remove the 'as any' part..
            // Also = DefaultApplyPolicy is internal in c# code, so not exposed in d.ts, so we cast it to any.
            if (this._languageSettings.newlineAfterPipe &&
                rule.DefaultAfterApplyPolicy === Kusto.Data.IntelliSense.ApplyPolicy.AppendPipePolicy) {
                rule.DefaultAfterApplyPolicy = this._newlineAppendPipePolicy;
            }
            var options = completionOptions
                .filter(function (option) {
                return !(option && option.Value && _this.disabledCompletionItemsV1[option.Value] === option.Kind);
            })
                .map(function (option, ordinal) {
                var _a = _this.getTextToInsert(rule, option), insertText = _a.insertText, insertTextFormat = _a.insertTextFormat;
                var helpTopic = k.CslDocumentation.Instance.GetTopic(option);
                var item = ls.CompletionItem.create(option.Value);
                item.kind = _this.kustoKindToLsKind(option.Kind);
                item.insertText = insertText;
                item.insertTextFormat = insertTextFormat;
                item.sortText = _this.getSortText(ordinal + 1);
                item.detail = helpTopic ? helpTopic.ShortDescription : undefined;
                item.documentation = helpTopic
                    ? { value: helpTopic.LongDescription, kind: ls.MarkupKind.Markdown }
                    : undefined;
                return item;
            });
            return Promise.resolve(ls.CompletionList.create(options));
        }
        return Promise.resolve(ls.CompletionList.create([]));
    };
    KustoLanguageService.prototype.doRangeFormat = function (document, range) {
        if (!document) {
            return Promise.resolve([]);
        }
        var rangeStartOffset = document.offsetAt(range.start);
        var rangeEndOffset = document.offsetAt(range.end);
        var commands = this.getFormattedCommandsInDocumentV2(document, rangeStartOffset, rangeEndOffset);
        if (!commands.originalRange || commands.formattedCommands.length === 0) {
            return Promise.resolve([]);
        }
        return Promise.resolve([ls.TextEdit.replace(commands.originalRange, commands.formattedCommands.join(''))]);
    };
    KustoLanguageService.prototype.doDocumentFormat = function (document) {
        if (!document) {
            return Promise.resolve([]);
        }
        var startPos = document.positionAt(0);
        var endPos = document.positionAt(document.getText().length);
        var fullDocRange = ls.Range.create(startPos, endPos);
        var formattedDoc = this.getFormattedCommandsInDocumentV2(document).formattedCommands.join('');
        return Promise.resolve([ls.TextEdit.replace(fullDocRange, formattedDoc)]);
    };
    // Method is not triggered, instead doRangeFormat is invoked with the range of the caret's line.
    KustoLanguageService.prototype.doCurrentCommandFormat = function (document, caretPosition) {
        var offset = document.offsetAt(caretPosition);
        var range = this.createRange(document, offset - 1, offset + 1);
        return this.doRangeFormat(document, range);
    };
    KustoLanguageService.prototype.doFolding = function (document) {
        if (!document) {
            return Promise.resolve([]);
        }
        return this.getCommandsInDocument(document).then(function (commands) {
            return commands.map(function (command) {
                // don't count the last empty line as part of the folded range (consider linux, mac, pc newlines)
                if (command.text.endsWith('\r\n')) {
                    command.absoluteEnd -= 2;
                }
                else if (command.text.endsWith('\r') || command.text.endsWith('\n')) {
                    --command.absoluteEnd;
                }
                var startPosition = document.positionAt(command.absoluteStart);
                var endPosition = document.positionAt(command.absoluteEnd);
                return {
                    startLine: startPosition.line,
                    startCharacter: startPosition.character,
                    endLine: endPosition.line,
                    endCharacter: endPosition.character,
                };
            });
        });
    };
    KustoLanguageService.prototype.getClusterReferences = function (document, cursorOffset) {
        var _a;
        var script = this.parseDocumentV2(document);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        var clusterReferences = (_a = currentBlock === null || currentBlock === void 0 ? void 0 : currentBlock.Service) === null || _a === void 0 ? void 0 : _a.GetClusterReferences();
        if (!clusterReferences) {
            return Promise.resolve([]);
        }
        var newClustersReferences = [];
        var newClustersReferencesSet = new Set(); // used to remove duplicates
        // Keep only unique clusters that aren't already exist in the Global State
        for (var i = 0; i < clusterReferences.Count; i++) {
            var clusterReference = clusterReferences.getItem(i);
            var clusterHostName = Kusto.Language.KustoFacts.GetHostName(clusterReference.Cluster);
            // ignore duplicates
            if (newClustersReferencesSet.has(clusterHostName)) {
                continue;
            }
            newClustersReferencesSet.add(clusterHostName);
            // ignore references that are already in the GlobalState.
            if (!this._clustersSetInGlobalState.has(clusterHostName)) {
                newClustersReferences.push({ clusterName: clusterHostName });
            }
        }
        return Promise.resolve(newClustersReferences);
    };
    KustoLanguageService.prototype.getDatabaseReferences = function (document, cursorOffset) {
        var _a;
        var script = this.parseDocumentV2(document);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        var databasesReferences = (_a = currentBlock === null || currentBlock === void 0 ? void 0 : currentBlock.Service) === null || _a === void 0 ? void 0 : _a.GetDatabaseReferences();
        if (!databasesReferences) {
            return Promise.resolve([]);
        }
        var newDatabasesReferences = [];
        var newDatabasesReferencesSet = new Set();
        for (var i1 = 0; i1 < databasesReferences.Count; i1++) {
            var databaseReference = databasesReferences.getItem(i1);
            var clusterHostName = Kusto.Language.KustoFacts.GetHostName(databaseReference.Cluster);
            // ignore duplicates
            var databaseReferenceUniqueId = this.createDatabaseUniqueName(clusterHostName, databaseReference.Database);
            if (newDatabasesReferencesSet.has(databaseReferenceUniqueId)) {
                continue;
            }
            newDatabasesReferencesSet.add(databaseReferenceUniqueId);
            // ignore references that are already in the GlobalState.
            var foundInGlobalState = this._nonEmptyDatabaseSetInGlobalState.has(databaseReferenceUniqueId);
            if (!foundInGlobalState) {
                newDatabasesReferences.push({
                    databaseName: databaseReference.Database,
                    clusterName: databaseReference.Cluster,
                });
            }
        }
        return Promise.resolve(newDatabasesReferences);
    };
    KustoLanguageService.prototype.doValidation = function (document, changeIntervals, includeWarnings, includeSuggestions) {
        var _this = this;
        // didn't implement validation for v1.
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var script = this.parseDocumentV2(document);
        var blocks = this.toArray(script.Blocks);
        if (changeIntervals.length > 0) {
            blocks = this.getAffectedBlocks(blocks, changeIntervals);
        }
        var diagnostics = blocks
            .map(function (block) {
            // GetDiagnostics returns the errors in the block
            var diagnostics = _this.toArray(block.Service.GetDiagnostics());
            var enableWarnings = includeWarnings !== null && includeWarnings !== void 0 ? includeWarnings : _this._languageSettings.enableQueryWarnings;
            var enableSuggestions = includeSuggestions !== null && includeSuggestions !== void 0 ? includeSuggestions : _this._languageSettings.enableQuerySuggestions;
            if (enableWarnings || enableSuggestions) {
                // Concat Warnings and suggestions to the diagnostics
                var warningAndSuggestionDiagnostics = block.Service.GetAnalyzerDiagnostics(null, true);
                var filterredDiagnostics = _this.toArray(warningAndSuggestionDiagnostics).filter(function (d) {
                    var _a;
                    var allowSeverity = (enableWarnings && d.Severity === 'Warning') ||
                        (enableSuggestions && d.Severity === 'Suggestion');
                    var allowCode = !((_a = _this._languageSettings.disabledDiagnoticCodes) === null || _a === void 0 ? void 0 : _a.includes(d.Code));
                    return allowSeverity && allowCode;
                });
                diagnostics = diagnostics.concat(filterredDiagnostics);
            }
            return diagnostics;
        })
            .reduce(function (prev, curr) { return prev.concat(curr); }, []);
        var lsDiagnostics = this.toLsDiagnostics(diagnostics, document);
        return Promise.resolve(lsDiagnostics);
    };
    KustoLanguageService.prototype.toLsDiagnostics = function (diagnostics, document) {
        return diagnostics
            .filter(function (diag) { return diag.HasLocation; })
            .map(function (diag) {
            var start = document.positionAt(diag.Start);
            var end = document.positionAt(diag.Start + diag.Length);
            var range = ls.Range.create(start, end);
            var severity;
            switch (diag.Severity) {
                case 'Suggestion':
                    severity = ls.DiagnosticSeverity.Information;
                    break;
                case 'Warning':
                    severity = ls.DiagnosticSeverity.Warning;
                    break;
                default:
                    severity = ls.DiagnosticSeverity.Error;
            }
            return ls.Diagnostic.create(range, diag.Message, severity, diag.Code);
        });
    };
    /**
     * Colorize one or more kusto blocks (a.k.a commands), or just the entire document.
     * Supports multi-cursor editing (colorizes blocks on multiple changes).
     * @param document The document to colorize
     * @param changeIntervals an array containing 0 or more changed intervals. if the array is empty - just colorize the entire row.
     * if the array contains a single change - just color the kusto blocks that wraps this change. If multiple changes are provided,
     * colorize all blocks that intersect these changes.
     * The code will try to only parse once if this is the same command.
     */
    KustoLanguageService.prototype.doColorization = function (document, changeIntervals) {
        var _this = this;
        if (!document || !this._languageSettings.useSemanticColorization) {
            return Promise.resolve([]);
        }
        // V1 intellisense
        if (!this.isIntellisenseV2()) {
            // Handle specific ranges changes (and not the whole doc)
            if (changeIntervals.length > 0) {
                this.parseDocumentV1(document, k.ParseMode.CommandTokensOnly);
                var affectedCommands = this.toArray(this._parser.Results).filter(function (command) {
                    // a command is affected if it intersects at least on of changed ranges.
                    return command // command can be null. we're filtering all nulls in the array.
                        ? changeIntervals.some(function (_a) {
                            var changeStart = _a.start, changeEnd = _a.end;
                            // both intervals intersect if either the start or the end of interval A is inside interval B.
                            // If we deleted something at the end of a command, the interval will not intersect the current command.
                            // so we also want consider affected commands commands the end where the interval begins.
                            // hence the + 1.
                            return (command.AbsoluteStart >= changeStart && command.AbsoluteStart <= changeEnd) ||
                                (changeStart >= command.AbsoluteStart && changeStart <= command.AbsoluteEnd + 1);
                        })
                        : false;
                });
                // We're not on any command so don't return any classifications.
                // this can happen if we're at the and of the file and deleting empty rows (for example).
                if (!affectedCommands || affectedCommands.length === 0) {
                    return Promise.resolve([
                        {
                            classifications: [],
                            absoluteStart: changeIntervals[0].start,
                            absoluteEnd: changeIntervals[0].end,
                        },
                    ]);
                }
                var results = affectedCommands.map(function (command) {
                    _this.parseTextV1(command.Text, k.ParseMode.TokenizeAllText);
                    var k2Classifications = _this.getClassificationsFromParseResult(command.AbsoluteStart);
                    var classifications = toClassifiedRange(k2Classifications);
                    return {
                        classifications: classifications,
                        absoluteStart: command.AbsoluteStart,
                        absoluteEnd: command.AbsoluteEnd,
                    };
                });
                return Promise.resolve(results);
            }
            // Entire document requested
            this.parseDocumentV1(document, k.ParseMode.TokenizeAllText);
            var classifications_1 = this.getClassificationsFromParseResult();
            return Promise.resolve([
                {
                    classifications: toClassifiedRange(classifications_1),
                    absoluteStart: 0,
                    absoluteEnd: document.getText().length,
                },
            ]);
        }
        // V2 intellisense
        var script = this.parseDocumentV2(document);
        if (changeIntervals.length > 0) {
            var blocks_1 = this.toArray(script.Blocks);
            var affectedBlocks = this.getAffectedBlocks(blocks_1, changeIntervals);
            var result = affectedBlocks.map(function (block) { return ({
                classifications: toClassifiedRange(_this.toArray(block.Service.GetClassifications(block.Start, block.End).Classifications)),
                absoluteStart: block.Start,
                absoluteEnd: block.End,
            }); });
            return Promise.resolve(result);
        }
        // Entire document requested
        var blocks = this.toArray(script.Blocks);
        var classifications = blocks
            .map(function (block) {
            return _this.toArray(block.Service.GetClassifications(block.Start, block.Length).Classifications);
        })
            .reduce(function (prev, curr) { return prev.concat(curr); }, []);
        return Promise.resolve([
            {
                classifications: toClassifiedRange(classifications),
                absoluteStart: 0,
                absoluteEnd: document.getText().length,
            },
        ]);
    };
    KustoLanguageService.prototype.getAffectedBlocks = function (blocks, changeIntervals) {
        return blocks.filter(function (block) {
            // a command is affected if it intersects at least on of changed ranges.
            return block // command can be null. we're filtering all nulls in the array.
                ? changeIntervals.some(function (_a) {
                    var changeStart = _a.start, changeEnd = _a.end;
                    // both intervals intersect if either the start or the end of interval A is inside interval B.
                    return (block.Start >= changeStart && block.Start <= changeEnd) ||
                        (changeStart >= block.Start && changeStart <= block.End + 1);
                })
                : false;
        });
    };
    KustoLanguageService.prototype.addClusterToSchema = function (document, clusterName, databaseNames) {
        var clusterNameOnly = Kusto.Language.KustoFacts.GetHostName(clusterName);
        var cluster = this._kustoJsSchemaV2.GetCluster$1(clusterNameOnly);
        if (cluster) {
            // add databases that are not already in the cluster.
            databaseNames
                .filter(function (databaseName) { return !cluster.GetDatabase(databaseName); })
                .map(function (databaseName) {
                var symbol = new sym.DatabaseSymbol.$ctor1(databaseName, undefined, false);
                cluster = cluster.AddDatabase(symbol);
            });
        }
        if (!cluster) {
            var databaseSymbols = databaseNames.map(function (databaseName) {
                var symbol = new sym.DatabaseSymbol.$ctor1(databaseName, undefined, false);
                return symbol;
            });
            var databaseSymbolsList = KustoLanguageService.toBridgeList(databaseSymbols);
            cluster = new sym.ClusterSymbol.$ctor1(clusterNameOnly, databaseSymbolsList, false);
        }
        this._kustoJsSchemaV2 = this._kustoJsSchemaV2.AddOrReplaceCluster(cluster);
        this._script = k2.CodeScript.From$1(document.getText(), this._kustoJsSchemaV2);
        return Promise.resolve();
    };
    KustoLanguageService.prototype.addDatabaseToSchema = function (document, clusterName, databaseSchema) {
        var clusterHostName = Kusto.Language.KustoFacts.GetHostName(clusterName);
        var cluster = this._kustoJsSchemaV2.GetCluster$1(clusterHostName);
        if (!cluster) {
            cluster = new sym.ClusterSymbol.$ctor1(clusterHostName, null, false);
        }
        var databaseSymbol = KustoLanguageService.convertToDatabaseSymbol(databaseSchema);
        cluster = cluster.AddOrUpdateDatabase(databaseSymbol);
        this._kustoJsSchemaV2 = this._kustoJsSchemaV2.AddOrReplaceCluster(cluster);
        this._script = k2.CodeScript.From$1(document.getText(), this._kustoJsSchemaV2);
        return Promise.resolve();
    };
    KustoLanguageService.prototype.setSchema = function (schema) {
        var _this = this;
        this._schema = schema;
        if (this._languageSettings.useIntellisenseV2) {
            var kustoJsSchemaV2 = schema && schema.clusterType === 'Engine' ? this.convertToKustoJsSchemaV2(schema) : null;
            this._kustoJsSchemaV2 = kustoJsSchemaV2;
            this._script = undefined;
            this._parsePropertiesV2 = undefined;
        }
        // since V2 doesn't support control commands, we're initializing V1 intellisense for both cases and we'll going to use V1 intellisense for contorl commands.
        return new Promise(function (resolve, reject) {
            var kustoJsSchema = schema ? KustoLanguageService.convertToKustoJsSchema(schema) : undefined;
            _this._kustoJsSchema = kustoJsSchema;
            _this.createRulesProvider(kustoJsSchema, schema.clusterType);
            resolve(undefined);
        });
    };
    KustoLanguageService.prototype.setParameters = function (parameters) {
        if (!this._languageSettings.useIntellisenseV2 || this._schema.clusterType !== 'Engine') {
            throw new Error('setParameters requires intellisense V2 and Engine cluster');
        }
        this._schema.globalParameters = parameters;
        var symbols = parameters.map(function (param) { return KustoLanguageService.createParameterSymbol(param); });
        this._kustoJsSchemaV2 = this._kustoJsSchemaV2.WithParameters(KustoLanguageService.toBridgeList(symbols));
        return Promise.resolve(undefined);
    };
    /**
     * A combination of normalizeSchema and setSchema
     * @param schema schema json as received from .show schema as json
     * @param clusterConnectionString cluster connection string
     * @param databaseInContextName name of database in context
     */
    KustoLanguageService.prototype.setSchemaFromShowSchema = function (schema, clusterConnectionString, databaseInContextName, globalParameters) {
        var _this = this;
        return this.normalizeSchema(schema, clusterConnectionString, databaseInContextName).then(function (normalized) {
            return _this.setSchema(__assign(__assign({}, normalized), { globalParameters: globalParameters }));
        });
    };
    /**
     * Converts the result of .show schema as json to a normalized schema used by kusto language service.
     * @param schema result of show schema
     * @param clusterConnectionString cluster connection string`
     * @param databaseInContextName database in context name
     */
    KustoLanguageService.prototype.normalizeSchema = function (schema, clusterConnectionString, databaseInContextName) {
        var databases = Object.keys(schema.Databases)
            .map(function (key) { return schema.Databases[key]; })
            .map(function (_a) {
            var Name = _a.Name, Tables = _a.Tables, ExternalTables = _a.ExternalTables, MaterializedViews = _a.MaterializedViews, Functions = _a.Functions, MinorVersion = _a.MinorVersion, MajorVersion = _a.MajorVersion;
            return ({
                name: Name,
                minorVersion: MinorVersion,
                majorVersion: MajorVersion,
                tables: [].concat.apply([], [
                    [Tables, 'Table'],
                    [MaterializedViews, 'MaterializedView'],
                    [ExternalTables, 'ExternalTable'],
                ]
                    .filter(function (_a) {
                    var tableContainer = _a[0];
                    return tableContainer;
                })
                    .map(function (_a) {
                    var tableContainer = _a[0], tableEntity = _a[1];
                    return Object.values(tableContainer).map(function (_a) {
                        var Name = _a.Name, OrderedColumns = _a.OrderedColumns, DocString = _a.DocString;
                        return ({
                            name: Name,
                            docstring: DocString,
                            entityType: tableEntity,
                            columns: OrderedColumns.map(function (_a) {
                                var Name = _a.Name, Type = _a.Type, DocString = _a.DocString, CslType = _a.CslType;
                                return ({
                                    name: Name,
                                    type: CslType,
                                    docstring: DocString,
                                });
                            }),
                        });
                    });
                })),
                functions: Object.keys(Functions)
                    .map(function (key) { return Functions[key]; })
                    .map(function (_a) {
                    var Name = _a.Name, Body = _a.Body, DocString = _a.DocString, InputParameters = _a.InputParameters;
                    return ({
                        name: Name,
                        body: Body,
                        docstring: DocString,
                        inputParameters: InputParameters.map(function (inputParam) { return ({
                            name: inputParam.Name,
                            type: inputParam.Type,
                            cslType: inputParam.CslType,
                            cslDefaultValue: inputParam.CslDefaultValue,
                            columns: inputParam.Columns
                                ? inputParam.Columns.map(function (col) { return ({
                                    name: col.Name,
                                    type: col.Type,
                                    cslType: col.CslType,
                                }); })
                                : inputParam.Columns,
                        }); }),
                    });
                }),
            });
        });
        var result = {
            clusterType: 'Engine',
            cluster: {
                connectionString: clusterConnectionString,
                databases: databases,
            },
            database: databases.filter(function (db) { return db.name === databaseInContextName; })[0],
        };
        return Promise.resolve(result);
    };
    KustoLanguageService.prototype.getSchema = function () {
        return Promise.resolve(this._schema);
    };
    KustoLanguageService.prototype.getCommandInContext = function (document, cursorOffset) {
        return this.isIntellisenseV2()
            ? this.getCommandInContextV2(document, cursorOffset)
            : this.getCommandInContextV1(document, cursorOffset);
    };
    KustoLanguageService.prototype.getCommandAndLocationInContext = function (document, cursorOffset) {
        // We are going to remove v1 intellisense. no use to keep parity.
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve(null);
        }
        var script = this.parseDocumentV2(document);
        var block = this.getCurrentCommandV2(script, cursorOffset);
        if (!block) {
            return Promise.resolve(null);
        }
        var start = document.positionAt(block.Start);
        var end = document.positionAt(block.End);
        var location = ls.Location.create(document.uri, ls.Range.create(start, end));
        var text = block.Text;
        return Promise.resolve({
            text: text,
            location: location,
        });
    };
    KustoLanguageService.prototype.getCommandInContextV1 = function (document, cursorOffset) {
        this.parseDocumentV1(document, k.ParseMode.CommandTokensOnly);
        var command = this.getCurrentCommand(document, cursorOffset);
        if (!command) {
            return Promise.resolve(null);
        }
        return Promise.resolve(command.Text);
    };
    KustoLanguageService.prototype.getCommandInContextV2 = function (document, cursorOffset) {
        if (!document) {
            return Promise.resolve(null);
        }
        var script = this.parseDocumentV2(document);
        var block = this.getCurrentCommandV2(script, cursorOffset);
        if (!block) {
            return Promise.resolve(null);
        }
        // TODO: do we need to do tricks like V1 is doing in this.getCurrentCommand?
        return Promise.resolve(block.Text);
    };
    /**
     * Return an array of commands in document. each command contains the range and text.
     */
    KustoLanguageService.prototype.getCommandsInDocument = function (document) {
        if (!document) {
            return Promise.resolve([]);
        }
        return this.isIntellisenseV2()
            ? this.getCommandsInDocumentV2(document)
            : this.getCommandsInDocumentV1(document);
    };
    KustoLanguageService.prototype.getCommandsInDocumentV1 = function (document) {
        this.parseDocumentV1(document, k.ParseMode.CommandTokensOnly);
        var commands = this.toArray(this._parser.Results);
        return Promise.resolve(commands.map(function (_a) {
            var AbsoluteStart = _a.AbsoluteStart, AbsoluteEnd = _a.AbsoluteEnd, Text = _a.Text;
            return ({
                absoluteStart: AbsoluteStart,
                absoluteEnd: AbsoluteEnd,
                text: Text,
            });
        }));
    };
    KustoLanguageService.prototype.toPlacementStyle = function (formatterPlacementStyle) {
        if (!formatterPlacementStyle) {
            return undefined;
        }
        switch (formatterPlacementStyle) {
            case 'None':
                return k2.PlacementStyle.None;
            case 'NewLine':
                return k2.PlacementStyle.NewLine;
            case 'Smart':
                return k2.PlacementStyle.Smart;
            default:
                throw new Error('Unknown PlacementStyle');
        }
    };
    KustoLanguageService.prototype.getFormattedCommandsInDocumentV2 = function (document, rangeStart, rangeEnd) {
        var _this = this;
        var script = this.parseDocumentV2(document);
        var commands = this.toArray(script.Blocks).filter(function (command) {
            if (!command.Text || command.Text.trim() == '')
                return false;
            if (rangeStart == null || rangeEnd == null)
                return true;
            // calculate command end position without \r\n.
            var commandEnd = command.End;
            var commandText = command.Text;
            for (var i = commandText.length - 1; i >= 0; i--) {
                if (commandText[i] != '\r' && commandText[i] != '\n') {
                    break;
                }
                else {
                    commandEnd--;
                }
            }
            if (command.Start > rangeStart && command.Start < rangeEnd)
                return true;
            if (commandEnd > rangeStart && commandEnd < rangeEnd)
                return true;
            if (command.Start <= rangeStart && commandEnd >= rangeEnd)
                return true;
        });
        if (commands.length === 0) {
            return { formattedCommands: [] };
        }
        var formattedCommands = commands.map(function (command) {
            var _a, _b;
            var formatterOptions = _this._languageSettings.formatter;
            var formatter = Kusto.Language.Editor.FormattingOptions.Default.WithIndentationSize((_a = formatterOptions === null || formatterOptions === void 0 ? void 0 : formatterOptions.indentationSize) !== null && _a !== void 0 ? _a : 4)
                .WithInsertMissingTokens(false)
                .WithPipeOperatorStyle((_b = _this.toPlacementStyle(formatterOptions === null || formatterOptions === void 0 ? void 0 : formatterOptions.pipeOperatorStyle)) !== null && _b !== void 0 ? _b : k2.PlacementStyle.Smart)
                .WithSemicolonStyle(Kusto.Language.Editor.PlacementStyle.None)
                .WithBrackettingStyle(k2.BrackettingStyle.Diagonal);
            if (rangeStart == null || rangeEnd == null || (rangeStart === command.Start && rangeEnd === command.End)) {
                var result = command.Service.GetFormattedText(formatter);
                return result.Text;
            }
            return command.Service.GetFormattedText(formatter).Text;
        });
        var originalRange = this.createRange(document, commands[0].Start, commands[commands.length - 1].End);
        return { formattedCommands: formattedCommands, originalRange: originalRange };
    };
    KustoLanguageService.prototype.getCommandsInDocumentV2 = function (document) {
        var script = this.parseDocumentV2(document);
        var commands = this.toArray(script.Blocks).filter(function (command) { return command.Text.trim() != ''; });
        return Promise.resolve(commands.map(function (_a) {
            var Start = _a.Start, End = _a.End, Text = _a.Text;
            return ({ absoluteStart: Start, absoluteEnd: End, text: Text });
        }));
    };
    KustoLanguageService.prototype.getClientDirective = function (text) {
        var outParam = { v: null };
        var isClientDirective = k.CslCommandParser.IsClientDirective(text, outParam);
        return Promise.resolve({
            isClientDirective: isClientDirective,
            directiveWithoutLeadingComments: outParam.v,
        });
    };
    KustoLanguageService.prototype.getAdminCommand = function (text) {
        var outParam = { v: null };
        var isAdminCommand = k.CslCommandParser.IsAdminCommand$1(text, outParam);
        return Promise.resolve({
            isAdminCommand: isAdminCommand,
            adminCommandWithoutLeadingComments: outParam.v,
        });
    };
    KustoLanguageService.prototype.findDefinition = function (document, position) {
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var script = this.parseDocumentV2(document);
        var cursorOffset = document.offsetAt(position);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBlock) {
            return Promise.resolve([]);
        }
        var relatedInfo = currentBlock.Service.GetRelatedElements(document.offsetAt(position));
        var relatedElements = this.toArray(relatedInfo.Elements);
        var definition = relatedElements[0];
        if (!definition) {
            return Promise.resolve([]);
        }
        var start = document.positionAt(definition.Start);
        var end = document.positionAt(definition.End);
        var range = ls.Range.create(start, end);
        var location = ls.Location.create(document.uri, range);
        return Promise.resolve([location]);
    };
    KustoLanguageService.prototype.findReferences = function (document, position) {
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var script = this.parseDocumentV2(document);
        var cursorOffset = document.offsetAt(position);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBlock) {
            return Promise.resolve([]);
        }
        var relatedInfo = currentBlock.Service.GetRelatedElements(document.offsetAt(position));
        var relatedElements = this.toArray(relatedInfo.Elements);
        if (!relatedElements || relatedElements.length == 0) {
            return Promise.resolve([]);
        }
        var references = relatedElements.map(function (relatedElement) {
            var start = document.positionAt(relatedElement.Start);
            var end = document.positionAt(relatedElement.End);
            var range = ls.Range.create(start, end);
            var location = ls.Location.create(document.uri, range);
            return location;
        });
        return Promise.resolve(references);
    };
    KustoLanguageService.prototype.getQueryParams = function (document, cursorOffset) {
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var script = this.parseDocumentV2(document);
        var parsedAndAnalyzed = this.parseAndAnalyze(document, cursorOffset);
        var queryParamStatements = this.toArray(parsedAndAnalyzed.Syntax.GetDescendants(Kusto.Language.Syntax.QueryParametersStatement));
        if (!queryParamStatements || queryParamStatements.length == 0) {
            return Promise.resolve([]);
        }
        var queryParams = [];
        queryParamStatements.forEach(function (paramStatement) {
            paramStatement.WalkElements(function (el) {
                return el.ReferencedSymbol && el.ReferencedSymbol.Type
                    ? queryParams.push({ name: el.ReferencedSymbol.Name, type: el.ReferencedSymbol.Type.Name })
                    : undefined;
            });
        });
        return Promise.resolve(queryParams);
    };
    KustoLanguageService.prototype.getRenderInfo = function (document, cursorOffset) {
        var _this = this;
        var parsedAndAnalyzed = this.parseAndAnalyze(document, cursorOffset);
        if (!parsedAndAnalyzed) {
            return Promise.resolve(undefined);
        }
        var renderStatements = this.toArray(parsedAndAnalyzed.Syntax.GetDescendants(Kusto.Language.Syntax.RenderOperator));
        if (!renderStatements || renderStatements.length === 0) {
            return Promise.resolve(undefined);
        }
        // assuming a single render statement
        var renderStatement = renderStatements[0];
        // Start and end relative to block start.
        var startOffset = renderStatement.TextStart;
        var endOffset = renderStatement.End;
        var visualization = renderStatement.ChartType.ValueText;
        var withClause = renderStatement.WithClause;
        if (!withClause) {
            var info = {
                options: {
                    visualization: visualization,
                },
                location: { startOffset: startOffset, endOffset: endOffset },
            };
            return Promise.resolve(info);
        }
        var properties = this.toArray(withClause.Properties);
        var props = properties.reduce(function (prev, property) {
            var name = property.Element$1.Name.SimpleName;
            switch (name) {
                case 'xcolumn':
                    var value = property.Element$1.Expression.ReferencedSymbol.Name;
                    prev[name] = value;
                    break;
                case 'ycolumns':
                case 'anomalycolumns':
                    var nameNodes = _this.toArray(property.Element$1.Expression.Names);
                    var values = nameNodes.map(function (nameNode) { return nameNode.Element$1.SimpleName; });
                    prev[name] = values;
                    break;
                case 'ymin':
                case 'ymax':
                    var numericVal = parseFloat(property.Element$1.Expression.ConstantValue);
                    prev[name] = numericVal;
                    break;
                case 'title':
                case 'xtitle':
                case 'ytitle':
                case 'visualization':
                case 'series':
                    var strVal = property.Element$1.Expression.ConstantValue;
                    prev[name] = strVal;
                    break;
                case 'xaxis':
                case 'yaxis':
                    var scale = property.Element$1.Expression.ConstantValue;
                    prev[name] = scale;
                    break;
                case 'legend':
                    var legend = property.Element$1.Expression.ConstantValue;
                    prev[name] = legend;
                    break;
                case 'ysplit':
                    var split = property.Element$1.Expression.ConstantValue;
                    prev[name] = split;
                    break;
                case 'accumulate':
                    var accumulate = property.Element$1.Expression.ConstantValue;
                    prev[name] = accumulate;
                    break;
                case 'kind':
                    var val = property.Element$1.Expression.ConstantValue;
                    prev[name] = val;
                    break;
                default:
                    assertNever(name);
            }
            return prev;
        }, {});
        var renderOptions = __assign({ visualization: visualization }, props);
        var renderInfo = {
            options: renderOptions,
            location: { startOffset: startOffset, endOffset: endOffset },
        };
        return Promise.resolve(renderInfo);
    };
    KustoLanguageService.prototype.getReferencedGlobalParams = function (document, cursorOffset) {
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var script = this.parseDocumentV2(document);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBlock) {
            return Promise.resolve([]);
        }
        var text = currentBlock.Text;
        var parsedAndAnalyzed = Kusto.Language.KustoCode.ParseAndAnalyze(text, this._kustoJsSchemaV2);
        // We take the ambient parameters
        var ambientParameters = this.toArray(this._kustoJsSchemaV2.Parameters);
        // We take all referenced symbols in the query
        var referencedSymbols = this.toArray(parsedAndAnalyzed.Syntax.GetDescendants(Kusto.Language.Syntax.Expression))
            .filter(function (expression) { return expression.ReferencedSymbol !== null; })
            .map(function (x) { return x.ReferencedSymbol; });
        // The Intersection between them is the ambient parameters that are used in the query.
        // Note: Ideally we would use Set here (or at least array.Include), but were' compiling down to es2015.
        var intersection = referencedSymbols.filter(function (referencedSymbol) {
            return ambientParameters.filter(function (ambientParameter) { return ambientParameter === referencedSymbol; }).length > 0;
        });
        var result = intersection.map(function (param) { return ({ name: param.Name, type: param.Type.Name }); });
        return Promise.resolve(result);
    };
    KustoLanguageService.prototype.getGlobalParams = function (document) {
        if (!this.isIntellisenseV2()) {
            return Promise.resolve([]);
        }
        var params = this.toArray(this._kustoJsSchemaV2.Parameters);
        var result = params.map(function (param) { return ({ name: param.Name, type: param.Type.Name }); });
        return Promise.resolve(result);
    };
    KustoLanguageService.prototype.doRename = function (document, position, newName) {
        var _a;
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve(undefined);
        }
        var script = this.parseDocumentV2(document);
        var cursorOffset = document.offsetAt(position);
        var currentBLock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBLock) {
            return Promise.resolve(undefined);
        }
        var relatedInfo = currentBLock.Service.GetRelatedElements(document.offsetAt(position));
        var relatedElements = this.toArray(relatedInfo.Elements);
        var declarations = relatedElements.filter(function (e) { return e.Kind == k2.RelatedElementKind.Declaration; });
        // A declaration must be one of the elements
        if (!declarations || declarations.length == 0) {
            return Promise.resolve(undefined);
        }
        var edits = relatedElements.map(function (edit) {
            var start = document.positionAt(edit.Start);
            var end = document.positionAt(edit.End);
            var range = ls.Range.create(start, end);
            return ls.TextEdit.replace(range, newName);
        });
        // create a workspace edit
        var workspaceEdit = { changes: (_a = {}, _a[document.uri] = edits, _a) };
        return Promise.resolve(workspaceEdit);
    };
    KustoLanguageService.prototype.doHover = function (document, position) {
        if (!document || !this.isIntellisenseV2()) {
            return Promise.resolve(undefined);
        }
        var script = this.parseDocumentV2(document);
        var cursorOffset = document.offsetAt(position);
        var currentBLock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBLock) {
            return Promise.resolve(undefined);
        }
        var isSupported = currentBLock.Service.IsFeatureSupported(k2.CodeServiceFeatures.QuickInfo, cursorOffset);
        if (!isSupported) {
            return Promise.resolve(undefined);
        }
        var quickInfo = currentBLock.Service.GetQuickInfo(cursorOffset);
        if (!quickInfo || !quickInfo.Items) {
            return Promise.resolve(undefined);
        }
        var items = this.toArray(quickInfo.Items);
        if (!items) {
            return Promise.resolve(undefined);
        }
        // Errors, Warnings and Suggestions are already shown in getDiagnostics. we don't want them in doHover.
        items = items.filter(function (item) {
            return item.Kind !== k2.QuickInfoKind.Error &&
                item.Kind !== k2.QuickInfoKind.Suggestion &&
                item.Kind !== k2.QuickInfoKind.Warning;
        });
        var itemsText = items.map(function (item) { return item.Text.replace('\n\n', '\n* * *\n'); });
        // separate items by horizontal line.
        var text = itemsText.join('\n* * *\n');
        // Instead of just an empty line between the first line (the signature) and the second line (the description)
        // add an horizontal line (* * * in markdown) between them.
        return Promise.resolve({ contents: text });
    };
    Object.defineProperty(KustoLanguageService, "dummySchema", {
        //#region dummy schema for manual testing
        get: function () {
            var database = {
                majorVersion: 0,
                minorVersion: 0,
                name: 'Kuskus',
                tables: [
                    {
                        name: 'KustoLogs',
                        columns: [
                            {
                                name: 'Source',
                                type: 'string',
                            },
                            {
                                name: 'Timestamp',
                                type: 'datetime',
                            },
                            {
                                name: 'Directory',
                                type: 'string',
                            },
                        ],
                        docstring: 'A dummy description to test that docstring shows as expected when hovering over a table',
                    },
                ],
                functions: [
                    {
                        name: 'HowBig',
                        inputParameters: [
                            {
                                name: 'T',
                                columns: [
                                    {
                                        name: 'Timestamp',
                                        type: 'System.DateTime',
                                        cslType: 'datetime',
                                    },
                                ],
                            },
                        ],
                        docstring: 'A dummy description to test that docstring shows as expected when hovering over a function',
                        body: "{\r\n    union \r\n    (T | count | project V='Volume', Metric = strcat(Count/1e9, ' Billion records')),\r\n    (T | summarize FirstRecord=min(Timestamp)| project V='Volume', Metric = strcat(toint((now()-FirstRecord)/1d), ' Days of data (from: ', format_datetime(FirstRecord, 'yyyy-MM-dd'),')')),\r\n    (T | where Timestamp > ago(1h) | count | project V='Velocity', Metric = strcat(Count/1e6, ' Million records / hour')),\r\n    (T | summarize Latency=now()-max(Timestamp) | project V='Velocity', Metric = strcat(Latency / 1sec, ' seconds latency')),\r\n    (T | take 1 | project V='Variety', Metric=tostring(pack_all()))\r\n    | order by V \r\n}",
                    },
                    {
                        name: 'FindCIDPast24h',
                        inputParameters: [
                            {
                                name: 'clientActivityId',
                                type: 'System.String',
                                cslType: 'string',
                            },
                        ],
                        body: '{ KustoLogs | where Timestamp > now(-1d) | where ClientActivityId == clientActivityId}   ',
                    },
                ],
            };
            var languageServiceSchema = {
                clusterType: 'Engine',
                cluster: {
                    connectionString: 'https://kuskus.kusto.windows.net;fed=true',
                    databases: [database],
                },
                database: database,
            };
            return languageServiceSchema;
        },
        enumerable: false,
        configurable: true
    });
    //#endregion
    KustoLanguageService.convertToEntityDataType = function (kustoType) { };
    /**
     * We do not want to expose Bridge.Net generated schema, so we expose a cleaner javascript schema.
     * Here it gets converted to the bridge.Net schema
     * @param schema Language Service schema
     */
    KustoLanguageService.convertToKustoJsSchema = function (schema) {
        switch (schema.clusterType) {
            case 'Engine':
                var currentDatabaseName_1 = schema.database ? schema.database.name : undefined;
                var kCluster = new k.KustoIntelliSenseClusterEntity();
                var kDatabaseInContext_1 = undefined;
                kCluster.ConnectionString = schema.cluster.connectionString;
                var databases_1 = [];
                schema.cluster.databases.forEach(function (database) {
                    var kDatabase = new k.KustoIntelliSenseDatabaseEntity();
                    kDatabase.Name = database.name;
                    var tables = [];
                    database.tables.forEach(function (table) {
                        var kTable = new k.KustoIntelliSenseTableEntity();
                        kTable.Name = table.name;
                        var cols = [];
                        table.columns.forEach(function (column) {
                            var kColumn = new k.KustoIntelliSenseColumnEntity();
                            kColumn.Name = column.name;
                            kColumn.TypeCode = k.EntityDataType[getEntityDataTypeFromCslType(column.type)];
                            cols.push(kColumn);
                        });
                        kTable.Columns = new Bridge.ArrayEnumerable(cols);
                        tables.push(kTable);
                    });
                    var functions = [];
                    database.functions.forEach(function (fn) {
                        var kFunction = new k.KustoIntelliSenseFunctionEntity();
                        (kFunction.Name = fn.name),
                            (kFunction.CallName = s.getCallName(fn)),
                            (kFunction.Expression = s.getExpression(fn)),
                            functions.push(kFunction);
                    });
                    kDatabase.Tables = new Bridge.ArrayEnumerable(tables);
                    kDatabase.Functions = new Bridge.ArrayEnumerable(functions);
                    databases_1.push(kDatabase);
                    if (database.name == currentDatabaseName_1) {
                        kDatabaseInContext_1 = kDatabase;
                    }
                });
                kCluster.Databases = new Bridge.ArrayEnumerable(databases_1);
                var kSchema = new k.KustoIntelliSenseQuerySchema(kCluster, kDatabaseInContext_1);
                return kSchema;
            case 'ClusterManager':
                var accounts = schema.accounts.map(function (account) {
                    var kAccount = new k.KustoIntelliSenseAccountEntity();
                    kAccount.Name = account;
                    return kAccount;
                });
                var services = schema.services.map(function (service) {
                    var kService = new k.KustoIntelliSenseServiceEntity();
                    kService.Name = service;
                    return kService;
                });
                var connectionString = schema.connectionString;
                var result = {
                    accounts: accounts,
                    services: services,
                    connectionString: connectionString,
                };
                return result;
            case 'DataManagement':
                return undefined;
            default:
                return assertNever(schema);
        }
    };
    /**
     * Returns something like '(x: string, y: datetime)'
     * @param params scalar parameters
     */
    KustoLanguageService.scalarParametersToSignature = function (params) {
        var signatureWithoutParens = params.map(function (param) { return param.name + ": " + param.cslType; }).join(', ');
        return "(" + signatureWithoutParens + ")";
    };
    /**
     * Returns something like '(x: string, T: (y: int))'
     * @param params input parameters (tabular or scalar)
     */
    KustoLanguageService.inputParameterToSignature = function (params) {
        var _this = this;
        var signatureWithoutParens = params
            .map(function (param) {
            if (param.columns) {
                var tableSignature = _this.scalarParametersToSignature(param.columns);
                return param.name + ": " + tableSignature;
            }
            else {
                return param.name + ": " + param.cslType;
            }
        })
            .join(', ');
        return "(" + signatureWithoutParens + ")";
    };
    /**
     * converts a function definition to a let statement.
     * @param fn function
     */
    KustoLanguageService.toLetStatement = function (fn) {
        var signature = this.inputParameterToSignature(fn.inputParameters);
        return "let " + fn.name + " = " + signature + " " + fn.body;
    };
    KustoLanguageService.createColumnSymbol = function (col) {
        return new sym.ColumnSymbol(col.name, sym.ScalarTypes.GetSymbol(getCslTypeNameFromClrType(col.type)), col.docstring);
    };
    KustoLanguageService.createParameterSymbol = function (param) {
        var paramSymbol = Kusto.Language.Symbols.ScalarTypes.GetSymbol(getCslTypeNameFromClrType(param.type));
        return new sym.ParameterSymbol(param.name, paramSymbol, null);
    };
    KustoLanguageService.createParameter = function (param) {
        if (!param.columns) {
            var paramSymbol = Kusto.Language.Symbols.ScalarTypes.GetSymbol(getCslTypeNameFromClrType(param.type));
            var expression = param.cslDefaultValue && typeof param.cslDefaultValue === 'string'
                ? parsing.QueryParser.ParseLiteral$1(param.cslDefaultValue)
                : undefined;
            return new sym.Parameter.$ctor3(param.name, paramSymbol, null, null, null, false, null, 1, 1, expression, null);
        }
        if (param.columns.length == 0) {
            return new sym.Parameter.ctor(param.name, sym.ParameterTypeKind.Tabular, sym.ArgumentKind.Expression, null, null, false, null, 1, 1, null, null);
        }
        var argumentType = new sym.TableSymbol.ctor(param.columns.map(function (col) { return KustoLanguageService.createColumnSymbol(col); }));
        return new sym.Parameter.$ctor2(param.name, argumentType);
    };
    KustoLanguageService.convertToDatabaseSymbol = function (db) {
        var createFunctionSymbol = function (fn) {
            var parameters = fn.inputParameters.map(function (param) {
                return KustoLanguageService.createParameter(param);
            });
            // TODO: handle outputColumns (right now it doesn't seem to be implemented for any function).
            return new sym.FunctionSymbol.$ctor16(fn.name, fn.body, KustoLanguageService.toBridgeList(parameters), fn.docstring);
        };
        var createTableSymbol = function (tbl) {
            var _a;
            var columnSymbols = tbl.columns.map(function (col) { return KustoLanguageService.createColumnSymbol(col); });
            var symbol = new sym.TableSymbol.$ctor4(tbl.name, columnSymbols);
            symbol.Description = tbl.docstring;
            switch (tbl.entityType) {
                case 'MaterializedViewTable':
                    var mvQuery = (_a = tbl.mvQuery) !== null && _a !== void 0 ? _a : null;
                    symbol = new sym.MaterializedViewSymbol.$ctor2(tbl.name, symbol.Columns, mvQuery, tbl.docstring);
                    symbol = symbol.WithIsMaterializedView(true);
                    break;
                case 'ExternalTable':
                    symbol = symbol.WithIsExternal(true);
                    break;
                default:
            }
            return symbol;
        };
        var createDatabaseSymbol = function (db) {
            var tableSymbols = db.tables ? db.tables.map(function (tbl) { return createTableSymbol(tbl); }) : [];
            var functionSymbols = db.functions ? db.functions.map(function (fun) { return createFunctionSymbol(fun); }) : [];
            return new sym.DatabaseSymbol.ctor(db.name, tableSymbols.concat(functionSymbols));
        };
        var databaseSymbol = createDatabaseSymbol(db);
        return databaseSymbol;
    };
    KustoLanguageService.prototype.convertToKustoJsSchemaV2 = function (schema) {
        var cached = this._schemaCache[schema.cluster.connectionString];
        // create a cache entry for the cluster if non yet exists.
        if (!cached) {
            this._schemaCache[schema.cluster.connectionString] = {};
            cached = this._schemaCache[schema.cluster.connectionString];
        }
        // Remove deleted databases from cache
        var schemaDbLookup = schema.cluster.databases.reduce(function (prev, curr) { return (prev[curr.name] = curr); }, {});
        Object.keys(cached).map(function (dbName) {
            if (!schemaDbLookup[dbName]) {
                delete cached.dbName;
            }
        });
        var globalState = GlobalState.Default;
        var currentDatabaseName = schema.database ? schema.database.name : undefined;
        var databaseInContext = undefined;
        // Update out-of-data databases to cache
        var databases = schema.cluster.databases.map(function (db) {
            var shouldIncludeFunctions = db.name === currentDatabaseName;
            var cachedDb = cached[db.name];
            // This is an older version than we have, or we need to parse functions.
            if (!cachedDb ||
                cachedDb.database.majorVersion < db.majorVersion ||
                (shouldIncludeFunctions && !cachedDb.includesFunctions)) {
                // only add functions for the database in context (it's very time consuming)
                var databaseSymbol_1 = KustoLanguageService.convertToDatabaseSymbol(db);
                cached[db.name] = { database: db, symbol: databaseSymbol_1, includesFunctions: shouldIncludeFunctions };
            }
            var databaseSymbol = cached[db.name].symbol;
            if (db.name === currentDatabaseName) {
                databaseInContext = databaseSymbol;
            }
            return databaseSymbol;
        });
        // Replace new URL due to polyfill issue in IE
        // const hostname = new URL(schema.cluster.connectionString.split(';')[0]).hostname;
        var hostname = schema.cluster.connectionString.match(/(.*\/\/)?([^\/;]*)/)[2];
        var clusterName = hostname.split('.')[0];
        var clusterSymbol = new sym.ClusterSymbol.ctor(clusterName, databases);
        globalState = globalState.WithCluster(clusterSymbol);
        if (databaseInContext) {
            globalState = globalState.WithDatabase(databaseInContext);
        }
        // Inject global parameters to global scope.
        if (schema.globalParameters) {
            var parameters = schema.globalParameters.map(function (param) {
                return KustoLanguageService.createParameterSymbol(param);
            });
            globalState = globalState.WithParameters(KustoLanguageService.toBridgeList(parameters));
        }
        return globalState;
    };
    KustoLanguageService.prototype.getClassificationsFromParseResult = function (offset) {
        var _this = this;
        if (offset === void 0) { offset = 0; }
        var classifications = this.toArray(this._parser.Results)
            .map(function (command) { return _this.toArray(command.Tokens); })
            .reduce(function (prev, curr) { return prev.concat(curr); }, [])
            .map(function (cslCommandToken) {
            var range = new k2.ClassifiedRange(_this.tokenKindToClassificationKind(cslCommandToken.TokenKind), cslCommandToken.AbsoluteStart + offset, cslCommandToken.Length);
            return range;
        });
        return classifications;
    };
    /**
     * trim trailing newlines from range
     */
    KustoLanguageService.trimTrailingNewlineFromRange = function (textInRange, rangeStartOffset, document, range) {
        var currentIndex = textInRange.length - 1;
        while (textInRange[currentIndex] === '\r' || textInRange[currentIndex] === '\n') {
            --currentIndex;
        }
        var newEndOffset = rangeStartOffset + currentIndex + 1;
        var newEndPosition = document.positionAt(newEndOffset);
        var newRange = ls.Range.create(range.start, newEndPosition);
        return newRange;
    };
    /**
     * Maps numbers to strings, such that if a>b numerically, f(a)>f(b) lexicographically.
     * 1 -> "a", 26 -> "z", 27 -> "za", 28 -> "zb", 52 -> "zz", 53 ->"zza"
     * @param order - The number to be converted to a sorting-string. order should start at 1.
     * @returns A string repenting the order.
     */
    KustoLanguageService.prototype.getSortText = function (order) {
        if (order <= 0) {
            throw new RangeError("order should be a number >= 1. instead got " + order);
        }
        var sortText = '';
        var numCharacters = 26; // "z" - "a" + 1;
        var div = Math.floor(order / numCharacters);
        for (var i = 0; i < div; ++i) {
            sortText += 'z';
        }
        var reminder = order % numCharacters;
        if (reminder > 0) {
            sortText += String.fromCharCode(96 + reminder);
        }
        return sortText;
    };
    /**
     * ParseTextV1 parses the given text with the given parse mode.
     * Additionally - it will make sure not to provide rules provider for non-engine clusters
     * since the only rules provider parse can handle is the engine's. It will try to look for function
     * definitions to colorize and will throw since they're not there.
     * @param text
     * @param parseMode
     */
    KustoLanguageService.prototype.parseTextV1 = function (text, parseMode) {
        this._parser.Parse(this._schema.clusterType === 'Engine' ? this._rulesProvider : null, text, parseMode);
    };
    KustoLanguageService.prototype.parseDocumentV1 = function (document, parseMode) {
        // already parsed a later version, or better parse mode for this uri
        if (this._parsePropertiesV1 &&
            !this._parsePropertiesV1.isParseNeeded(document, this._rulesProvider, parseMode)) {
            return;
        }
        this.parseTextV1(document.getText(), parseMode);
        this._parsePropertiesV1 = new ParseProperties(document.version, document.uri, this._rulesProvider, parseMode);
    };
    KustoLanguageService.prototype.parseDocumentV2 = function (document) {
        if (this._parsePropertiesV2 && !this._parsePropertiesV2.isParseNeeded(document, this._rulesProvider)) {
            return this._script;
        }
        if (!this._script) {
            this._script = k2.CodeScript.From$1(document.getText(), this._kustoJsSchemaV2);
        }
        else {
            this._script = this._script.WithText(document.getText());
        }
        this._parsePropertiesV2 = new ParseProperties(document.version, document.uri);
        return this._script;
    };
    /**
     * Return the CslCommand that wraps the caret location, or undefined if caret is outside any command
     * @param document the document to extract the current command from
     * @param caretAbsolutePosition absolute caret position
     */
    KustoLanguageService.prototype.getCurrentCommand = function (document, caretAbsolutePosition) {
        var commands = this.toArray(this._parser.Results);
        var command = commands.filter(function (command) { return command.AbsoluteStart <= caretAbsolutePosition && command.AbsoluteEnd >= caretAbsolutePosition; })[0];
        // There is an edge case when cursor appears at the end of the command
        // which is not yet considered to be part of the parsed command (therefore: +1 for the AbsoluteEdit property)
        if (!command) {
            command = commands.filter(function (command) {
                return command.AbsoluteStart <= caretAbsolutePosition && command.AbsoluteEnd + 1 >= caretAbsolutePosition;
            })[0];
            // If we have 2 newlines in the end of the text the cursor is _probably_ at the end of the text
            // which this means that we're not actually standing on any command. Thus return null.
            if (!command || command.Text.endsWith('\r\n\r\n')) {
                return null;
            }
        }
        return command;
    };
    KustoLanguageService.prototype.getCurrentCommandV2 = function (script, offset) {
        var block = script.GetBlockAtPosition(offset);
        return block;
    };
    KustoLanguageService.prototype.getTextToInsert = function (rule, option) {
        var beforeApplyInfo = rule.GetBeforeApplyInfo(option.Value);
        var afterApplyInfo = rule.GetAfterApplyInfo(option.Value);
        // this is the basic text to be inserted,
        // but we still need to figure out where the cursor will end up after completion is applied.
        var insertText = beforeApplyInfo.Text || '' + option.Value + afterApplyInfo.Text || '';
        var insertTextFormat = ls.InsertTextFormat.PlainText;
        var snippetFinalTabStop = '$0';
        if (afterApplyInfo.OffsetToken && afterApplyInfo.OffsetPosition) {
            var tokenOffset = insertText.indexOf(afterApplyInfo.OffsetToken);
            if (tokenOffset >= 0) {
                insertText = this.insertToString(insertText, snippetFinalTabStop, tokenOffset - insertText.length + afterApplyInfo.OffsetPosition);
                insertTextFormat = ls.InsertTextFormat.Snippet;
            }
        }
        else if (afterApplyInfo.OffsetPosition) {
            // We only handle negative offsets
            insertText = this.insertToString(insertText, snippetFinalTabStop, afterApplyInfo.OffsetPosition);
            insertTextFormat = ls.InsertTextFormat.Snippet;
        }
        return { insertText: insertText, insertTextFormat: insertTextFormat };
    };
    /**
     * create a new string with stringToInsert inserted at offsetFromEnd in originalString.
     * @param originalString string to insert to
     * @param stringToInsert string to insert
     * @param offsetFromEnd a negative number that will represent offset to the left. 0 means simple concat
     */
    KustoLanguageService.prototype.insertToString = function (originalString, stringToInsert, offsetFromEnd) {
        var index = originalString.length + offsetFromEnd;
        if (offsetFromEnd >= 0 || index < 0) {
            return originalString; // Cannot insert before or after the string
        }
        var before = originalString.substring(0, index);
        var after = originalString.substring(index);
        return before + stringToInsert + after;
    };
    KustoLanguageService.prototype.getCommandWithoutLastWord = function (text) {
        var lastWordRegex = XRegExp('[\\w_]*$', 's');
        return text.replace(lastWordRegex, '');
    };
    KustoLanguageService.prototype.createRulesProvider = function (schema, clusterType) {
        var queryParameters = new (List(String))();
        var availableClusters = new (List(String))();
        this._parser = new k.CslCommandParser();
        if (clusterType == 'Engine') {
            var engineSchema = schema;
            this._rulesProvider =
                this._languageSettings && this._languageSettings.includeControlCommands
                    ? new k.CslIntelliSenseRulesProvider.$ctor1(engineSchema.Cluster, engineSchema, queryParameters, availableClusters, null, true, true)
                    : new k.CslQueryIntelliSenseRulesProvider.$ctor1(engineSchema.Cluster, engineSchema, queryParameters, availableClusters, null, null, null);
            return;
        }
        if (clusterType === 'DataManagement') {
            this._rulesProvider = new k.DataManagerIntelliSenseRulesProvider(null);
            return;
        }
        // This is a cluster manger
        var _a = schema, accounts = _a.accounts, services = _a.services, connectionString = _a.connectionString;
        new k.KustoIntelliSenseAccountEntity();
        new k.KustoIntelliSenseServiceEntity();
        this._rulesProvider = new k.ClusterManagerIntelliSenseRulesProvider.$ctor1(new Bridge.ArrayEnumerable(accounts), new Bridge.ArrayEnumerable(services), connectionString);
    };
    KustoLanguageService.prototype.kustoKindToLsKind = function (kustoKind) {
        var res = this._kustoKindtolsKind[kustoKind];
        return res ? res : ls.CompletionItemKind.Variable;
    };
    KustoLanguageService.prototype.kustoKindToLsKindV2 = function (kustoKind) {
        var res = this._kustoKindToLsKindV2[kustoKind];
        return res ? res : ls.CompletionItemKind.Variable;
    };
    KustoLanguageService.prototype.createRange = function (document, start, end) {
        return ls.Range.create(document.positionAt(start), document.positionAt(end));
    };
    KustoLanguageService.prototype.toArray = function (bridgeList) {
        return Bridge.toArray(bridgeList);
    };
    KustoLanguageService.toBridgeList = function (array) {
        // copied from bridge.js from the implementation of Enumerable.prototype.toList
        return new (System.Collections.Generic.List$1(System.Object).$ctor1)(array);
    };
    KustoLanguageService.prototype.tokenKindToClassificationKind = function (token) {
        var conversion = this._tokenKindToClassificationKind[token];
        return conversion || k2.ClassificationKind.PlainText;
    };
    KustoLanguageService.prototype.parseAndAnalyze = function (document, cursorOffset) {
        if (!document || !this.isIntellisenseV2()) {
            return undefined;
        }
        var script = this.parseDocumentV2(document);
        var currentBlock = this.getCurrentCommandV2(script, cursorOffset);
        if (!currentBlock) {
            return undefined;
        }
        var text = currentBlock.Text;
        var parsedAndAnalyzed = Kusto.Language.KustoCode.ParseAndAnalyze(text, this._kustoJsSchemaV2);
        return parsedAndAnalyzed;
    };
    return KustoLanguageService;
}());
var languageService = new KustoLanguageService(KustoLanguageService.dummySchema, {
    includeControlCommands: true,
    useIntellisenseV2: true,
    useSemanticColorization: true,
});
/**
 * Obtain an instance of the kusto language service.
 */
export function getKustoLanguageService() {
    return languageService;
}
