'use strict';

const _importLazy = require('import-lazy');

const importLazy = _importLazy(require);

/** @type {typeof import('stylelint').rules} */
const rules = {
	'alpha-value-notation': importLazy('./alpha-value-notation'),
	'at-rule-allowed-list': importLazy('./at-rule-allowed-list'),
	'at-rule-disallowed-list': importLazy('./at-rule-disallowed-list'),
	'at-rule-empty-line-before': importLazy('./at-rule-empty-line-before'),
	'at-rule-name-case': importLazy('./at-rule-name-case'),
	'at-rule-name-newline-after': importLazy('./at-rule-name-newline-after'),
	'at-rule-semicolon-space-before': importLazy('./at-rule-semicolon-space-before'),
	'at-rule-name-space-after': importLazy('./at-rule-name-space-after'),
	'at-rule-no-unknown': importLazy('./at-rule-no-unknown'),
	'at-rule-no-vendor-prefix': importLazy('./at-rule-no-vendor-prefix'),
	'at-rule-property-required-list': importLazy('./at-rule-property-required-list'),
	'at-rule-semicolon-newline-after': importLazy('./at-rule-semicolon-newline-after'),
	'block-closing-brace-empty-line-before': importLazy('./block-closing-brace-empty-line-before'),
	'block-closing-brace-newline-after': importLazy('./block-closing-brace-newline-after'),
	'block-closing-brace-newline-before': importLazy('./block-closing-brace-newline-before'),
	'block-closing-brace-space-after': importLazy('./block-closing-brace-space-after'),
	'block-closing-brace-space-before': importLazy('./block-closing-brace-space-before'),
	'block-no-empty': importLazy('./block-no-empty'),
	'block-opening-brace-newline-after': importLazy('./block-opening-brace-newline-after'),
	'block-opening-brace-newline-before': importLazy('./block-opening-brace-newline-before'),
	'block-opening-brace-space-after': importLazy('./block-opening-brace-space-after'),
	'block-opening-brace-space-before': importLazy('./block-opening-brace-space-before'),
	'color-function-notation': importLazy('./color-function-notation'),
	'color-hex-alpha': importLazy('./color-hex-alpha'),
	'color-hex-case': importLazy('./color-hex-case'),
	'color-hex-length': importLazy('./color-hex-length'),
	'color-named': importLazy('./color-named'),
	'color-no-hex': importLazy('./color-no-hex'),
	'color-no-invalid-hex': importLazy('./color-no-invalid-hex'),
	'comment-empty-line-before': importLazy('./comment-empty-line-before'),
	'comment-no-empty': importLazy('./comment-no-empty'),
	'comment-pattern': importLazy('./comment-pattern'),
	'comment-whitespace-inside': importLazy('./comment-whitespace-inside'),
	'comment-word-disallowed-list': importLazy('./comment-word-disallowed-list'),
	'custom-media-pattern': importLazy('./custom-media-pattern'),
	'custom-property-empty-line-before': importLazy('./custom-property-empty-line-before'),
	'custom-property-no-missing-var-function': importLazy(
		'./custom-property-no-missing-var-function',
	),
	'custom-property-pattern': importLazy('./custom-property-pattern'),
	'declaration-bang-space-after': importLazy('./declaration-bang-space-after'),
	'declaration-bang-space-before': importLazy('./declaration-bang-space-before'),
	'declaration-block-no-duplicate-custom-properties': importLazy(
		'./declaration-block-no-duplicate-custom-properties',
	),
	'declaration-block-no-duplicate-properties': importLazy(
		'./declaration-block-no-duplicate-properties',
	),
	'declaration-block-no-redundant-longhand-properties': importLazy(
		'./declaration-block-no-redundant-longhand-properties',
	),
	'declaration-block-no-shorthand-property-overrides': importLazy(
		'./declaration-block-no-shorthand-property-overrides',
	),
	'declaration-block-semicolon-newline-after': importLazy(
		'./declaration-block-semicolon-newline-after',
	),
	'declaration-block-semicolon-newline-before': importLazy(
		'./declaration-block-semicolon-newline-before',
	),
	'declaration-block-semicolon-space-after': importLazy(
		'./declaration-block-semicolon-space-after',
	),
	'declaration-block-semicolon-space-before': importLazy(
		'./declaration-block-semicolon-space-before',
	),
	'declaration-block-single-line-max-declarations': importLazy(
		'./declaration-block-single-line-max-declarations',
	),
	'declaration-block-trailing-semicolon': importLazy('./declaration-block-trailing-semicolon'),
	'declaration-colon-newline-after': importLazy('./declaration-colon-newline-after'),
	'declaration-colon-space-after': importLazy('./declaration-colon-space-after'),
	'declaration-colon-space-before': importLazy('./declaration-colon-space-before'),
	'declaration-empty-line-before': importLazy('./declaration-empty-line-before'),
	'declaration-no-important': importLazy('./declaration-no-important'),
	'declaration-property-max-values': importLazy('./declaration-property-max-values'),
	'declaration-property-unit-allowed-list': importLazy('./declaration-property-unit-allowed-list'),
	'declaration-property-unit-disallowed-list': importLazy(
		'./declaration-property-unit-disallowed-list',
	),
	'declaration-property-value-allowed-list': importLazy(
		'./declaration-property-value-allowed-list',
	),
	'declaration-property-value-disallowed-list': importLazy(
		'./declaration-property-value-disallowed-list',
	),
	'font-family-no-missing-generic-family-keyword': importLazy(
		'./font-family-no-missing-generic-family-keyword',
	),
	'font-family-name-quotes': importLazy('./font-family-name-quotes'),
	'font-family-no-duplicate-names': importLazy('./font-family-no-duplicate-names'),
	'font-weight-notation': importLazy('./font-weight-notation'),
	'function-allowed-list': importLazy('./function-allowed-list'),
	'function-calc-no-unspaced-operator': importLazy('./function-calc-no-unspaced-operator'),
	'function-comma-newline-after': importLazy('./function-comma-newline-after'),
	'function-comma-newline-before': importLazy('./function-comma-newline-before'),
	'function-comma-space-after': importLazy('./function-comma-space-after'),
	'function-comma-space-before': importLazy('./function-comma-space-before'),
	'function-disallowed-list': importLazy('./function-disallowed-list'),
	'function-linear-gradient-no-nonstandard-direction': importLazy(
		'./function-linear-gradient-no-nonstandard-direction',
	),
	'function-max-empty-lines': importLazy('./function-max-empty-lines'),
	'function-name-case': importLazy('./function-name-case'),
	'function-no-unknown': importLazy('./function-no-unknown'),
	'function-parentheses-newline-inside': importLazy('./function-parentheses-newline-inside'),
	'function-parentheses-space-inside': importLazy('./function-parentheses-space-inside'),
	'function-url-no-scheme-relative': importLazy('./function-url-no-scheme-relative'),
	'function-url-quotes': importLazy('./function-url-quotes'),
	'function-url-scheme-allowed-list': importLazy('./function-url-scheme-allowed-list'),
	'function-url-scheme-disallowed-list': importLazy('./function-url-scheme-disallowed-list'),
	'function-whitespace-after': importLazy('./function-whitespace-after'),
	'hue-degree-notation': importLazy('./hue-degree-notation'),
	'import-notation': importLazy('./import-notation'),
	'keyframe-block-no-duplicate-selectors': importLazy('./keyframe-block-no-duplicate-selectors'),
	'keyframe-declaration-no-important': importLazy('./keyframe-declaration-no-important'),
	'keyframes-name-pattern': importLazy('./keyframes-name-pattern'),
	'length-zero-no-unit': importLazy('./length-zero-no-unit'),
	linebreaks: importLazy('./linebreaks'),
	'max-empty-lines': importLazy('./max-empty-lines'),
	'max-line-length': importLazy('./max-line-length'),
	'max-nesting-depth': importLazy('./max-nesting-depth'),
	'media-feature-colon-space-after': importLazy('./media-feature-colon-space-after'),
	'media-feature-colon-space-before': importLazy('./media-feature-colon-space-before'),
	'media-feature-name-allowed-list': importLazy('./media-feature-name-allowed-list'),
	'media-feature-name-case': importLazy('./media-feature-name-case'),
	'media-feature-name-disallowed-list': importLazy('./media-feature-name-disallowed-list'),
	'media-feature-name-no-unknown': importLazy('./media-feature-name-no-unknown'),
	'media-feature-name-no-vendor-prefix': importLazy('./media-feature-name-no-vendor-prefix'),
	'media-feature-name-value-allowed-list': importLazy('./media-feature-name-value-allowed-list'),
	'media-feature-parentheses-space-inside': importLazy('./media-feature-parentheses-space-inside'),
	'media-feature-range-operator-space-after': importLazy(
		'./media-feature-range-operator-space-after',
	),
	'media-feature-range-operator-space-before': importLazy(
		'./media-feature-range-operator-space-before',
	),
	'media-query-list-comma-newline-after': importLazy('./media-query-list-comma-newline-after'),
	'media-query-list-comma-newline-before': importLazy('./media-query-list-comma-newline-before'),
	'media-query-list-comma-space-after': importLazy('./media-query-list-comma-space-after'),
	'media-query-list-comma-space-before': importLazy('./media-query-list-comma-space-before'),
	'named-grid-areas-no-invalid': importLazy('./named-grid-areas-no-invalid'),
	'no-descending-specificity': importLazy('./no-descending-specificity'),
	'no-duplicate-at-import-rules': importLazy('./no-duplicate-at-import-rules'),
	'no-duplicate-selectors': importLazy('./no-duplicate-selectors'),
	'no-empty-source': importLazy('./no-empty-source'),
	'no-empty-first-line': importLazy('./no-empty-first-line'),
	'no-eol-whitespace': importLazy('./no-eol-whitespace'),
	'no-extra-semicolons': importLazy('./no-extra-semicolons'),
	'no-invalid-double-slash-comments': importLazy('./no-invalid-double-slash-comments'),
	'no-invalid-position-at-import-rule': importLazy('./no-invalid-position-at-import-rule'),
	'no-irregular-whitespace': importLazy('./no-irregular-whitespace'),
	'no-missing-end-of-source-newline': importLazy('./no-missing-end-of-source-newline'),
	'no-unknown-animations': importLazy('./no-unknown-animations'),
	'number-leading-zero': importLazy('./number-leading-zero'),
	'number-max-precision': importLazy('./number-max-precision'),
	'number-no-trailing-zeros': importLazy('./number-no-trailing-zeros'),
	'property-allowed-list': importLazy('./property-allowed-list'),
	'property-case': importLazy('./property-case'),
	'property-disallowed-list': importLazy('./property-disallowed-list'),
	'property-no-unknown': importLazy('./property-no-unknown'),
	'property-no-vendor-prefix': importLazy('./property-no-vendor-prefix'),
	'rule-empty-line-before': importLazy('./rule-empty-line-before'),
	'rule-selector-property-disallowed-list': importLazy('./rule-selector-property-disallowed-list'),
	'selector-attribute-brackets-space-inside': importLazy(
		'./selector-attribute-brackets-space-inside',
	),
	'selector-attribute-name-disallowed-list': importLazy(
		'./selector-attribute-name-disallowed-list',
	),
	'selector-attribute-operator-allowed-list': importLazy(
		'./selector-attribute-operator-allowed-list',
	),
	'selector-attribute-operator-disallowed-list': importLazy(
		'./selector-attribute-operator-disallowed-list',
	),
	'selector-attribute-operator-space-after': importLazy(
		'./selector-attribute-operator-space-after',
	),
	'selector-attribute-operator-space-before': importLazy(
		'./selector-attribute-operator-space-before',
	),
	'selector-attribute-quotes': importLazy('./selector-attribute-quotes'),
	'selector-class-pattern': importLazy('./selector-class-pattern'),
	'selector-combinator-allowed-list': importLazy('./selector-combinator-allowed-list'),
	'selector-combinator-disallowed-list': importLazy('./selector-combinator-disallowed-list'),
	'selector-combinator-space-after': importLazy('./selector-combinator-space-after'),
	'selector-combinator-space-before': importLazy('./selector-combinator-space-before'),
	'selector-descendant-combinator-no-non-space': importLazy(
		'./selector-descendant-combinator-no-non-space',
	),
	'selector-disallowed-list': importLazy('./selector-disallowed-list'),
	'selector-id-pattern': importLazy('./selector-id-pattern'),
	'selector-list-comma-newline-after': importLazy('./selector-list-comma-newline-after'),
	'selector-list-comma-newline-before': importLazy('./selector-list-comma-newline-before'),
	'selector-list-comma-space-after': importLazy('./selector-list-comma-space-after'),
	'selector-list-comma-space-before': importLazy('./selector-list-comma-space-before'),
	'selector-max-attribute': importLazy('./selector-max-attribute'),
	'selector-max-class': importLazy('./selector-max-class'),
	'selector-max-combinators': importLazy('./selector-max-combinators'),
	'selector-max-compound-selectors': importLazy('./selector-max-compound-selectors'),
	'selector-max-empty-lines': importLazy('./selector-max-empty-lines'),
	'selector-max-id': importLazy('./selector-max-id'),
	'selector-max-pseudo-class': importLazy('./selector-max-pseudo-class'),
	'selector-max-specificity': importLazy('./selector-max-specificity'),
	'selector-max-type': importLazy('./selector-max-type'),
	'selector-max-universal': importLazy('./selector-max-universal'),
	'selector-nested-pattern': importLazy('./selector-nested-pattern'),
	'selector-no-qualifying-type': importLazy('./selector-no-qualifying-type'),
	'selector-no-vendor-prefix': importLazy('./selector-no-vendor-prefix'),
	'selector-not-notation': importLazy('./selector-not-notation'),
	'selector-pseudo-class-allowed-list': importLazy('./selector-pseudo-class-allowed-list'),
	'selector-pseudo-class-case': importLazy('./selector-pseudo-class-case'),
	'selector-pseudo-class-disallowed-list': importLazy('./selector-pseudo-class-disallowed-list'),
	'selector-pseudo-class-no-unknown': importLazy('./selector-pseudo-class-no-unknown'),
	'selector-pseudo-class-parentheses-space-inside': importLazy(
		'./selector-pseudo-class-parentheses-space-inside',
	),
	'selector-pseudo-element-allowed-list': importLazy('./selector-pseudo-element-allowed-list'),
	'selector-pseudo-element-case': importLazy('./selector-pseudo-element-case'),
	'selector-pseudo-element-colon-notation': importLazy('./selector-pseudo-element-colon-notation'),
	'selector-pseudo-element-disallowed-list': importLazy(
		'./selector-pseudo-element-disallowed-list',
	),
	'selector-pseudo-element-no-unknown': importLazy('./selector-pseudo-element-no-unknown'),
	'selector-type-case': importLazy('./selector-type-case'),
	'selector-type-no-unknown': importLazy('./selector-type-no-unknown'),
	'shorthand-property-no-redundant-values': importLazy('./shorthand-property-no-redundant-values'),
	'string-no-newline': importLazy('./string-no-newline'),
	'string-quotes': importLazy('./string-quotes'),
	'time-min-milliseconds': importLazy('./time-min-milliseconds'),
	'unicode-bom': importLazy('./unicode-bom'),
	'unit-allowed-list': importLazy('./unit-allowed-list'),
	'unit-case': importLazy('./unit-case'),
	'unit-disallowed-list': importLazy('./unit-disallowed-list'),
	'unit-no-unknown': importLazy('./unit-no-unknown'),
	'value-keyword-case': importLazy('./value-keyword-case'),
	'value-list-comma-newline-after': importLazy('./value-list-comma-newline-after'),
	'value-list-comma-newline-before': importLazy('./value-list-comma-newline-before'),
	'value-list-comma-space-after': importLazy('./value-list-comma-space-after'),
	'value-list-comma-space-before': importLazy('./value-list-comma-space-before'),
	'value-list-max-empty-lines': importLazy('./value-list-max-empty-lines'),
	'value-no-vendor-prefix': importLazy('./value-no-vendor-prefix'),
	indentation: importLazy('./indentation'),
};

module.exports = rules;
