"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setHandlers = void 0;
const tslib_1 = require("tslib");
const assert_1 = tslib_1.__importDefault(require("assert"));
const worker_threads_1 = require("worker_threads");
const comlink_1 = require("./vendor/comlink");
const node_adapter_1 = tslib_1.__importDefault(require("./vendor/node-adapter"));
const constants_1 = require("./constants");
function setHandlers() {
    const proxyHandler = comlink_1.transferHandlers.get('proxy');
    const throwHandler = comlink_1.transferHandlers.get('throw');
    assert_1.default(proxyHandler && throwHandler);
    comlink_1.transferHandlers.set('cloneable', {
        canHandle: (val) => {
            return !proxyHandler.canHandle(val) && isCloneable(val);
        },
        serialize: (val) => {
            return [val[constants_1.TO_CLONEABLE](), []];
        },
        deserialize: (obj) => obj,
    });
    const cloneableHandle = comlink_1.transferHandlers.get('cloneable');
    assert_1.default(cloneableHandle);
    comlink_1.transferHandlers.set('proxy', {
        canHandle(val) {
            return (!throwHandler.canHandle(val) &&
                !cloneableHandle.canHandle(val) &&
                (proxyHandler.canHandle(val) ||
                    isFunction(val) ||
                    isPromise(val) ||
                    hasFunctions(val)));
        },
        serialize(val) {
            const { port1, port2 } = new worker_threads_1.MessageChannel();
            comlink_1.expose(val, node_adapter_1.default(port1));
            return [port2, [port2]];
        },
        deserialize(port) {
            port.start();
            return comlink_1.wrap(node_adapter_1.default(port));
        },
    });
}
exports.setHandlers = setHandlers;
function isCloneable(val) {
    var _a;
    if (val === null) {
        return false;
    }
    const toClonable = (_a = val) === null || _a === void 0 ? void 0 : _a[constants_1.TO_CLONEABLE];
    return !!toClonable && isFunction(toClonable);
}
function isFunction(func) {
    return typeof func === 'function';
}
function isPromise(val) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, @typescript-eslint/no-explicit-any
    return val != null && Object.is(val.constructor, Promise);
}
function hasFunctions(val) {
    return (isObject(val) &&
        Object.getOwnPropertyNames(val).some((name) => {
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, @typescript-eslint/no-explicit-any
            const property = val[name];
            return isFunction(property) || hasFunctions(property);
        }));
}
function isObject(val) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, @typescript-eslint/no-explicit-any
    return val != null && Object.is(val.constructor, Object);
}
//# sourceMappingURL=handlers.js.map