/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.nio.ByteBuffer;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.SymmetricKeyDeriver;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class SymKeyDeriving {
    private static final byte[] iv8 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] iv16 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] derivationData1 = new byte[]{17, 17, 19, 20, 21, 22, 23, 24};
    private static final byte[] derivationData2 = new byte[]{9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] derivationData16 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage SymKeyDeriving /path/to/nssdb /path/to/password.txt");
            System.exit(1);
        }
        Object macKeyDev = null;
        CryptoManager cm = CryptoManager.getInstance();
        cm.setPasswordCallback((PasswordCallback)new FilePasswordCallback(args[1]));
        CryptoToken token = cm.getInternalCryptoToken();
        CryptoToken keyToken = cm.getInternalKeyStorageToken();
        System.out.println("interal token name: " + keyToken.getName());
        KeyGenerator keyKg = keyToken.getKeyGenerator(KeyGenAlgorithm.DES3);
        SymmetricKey baseKey = keyKg.generate();
        KeyGenerator keyKgDes = keyToken.getKeyGenerator(KeyGenAlgorithm.DES);
        SymmetricKey baseKeyDes = keyKgDes.generate();
        System.out.println("strength: " + baseKeyDes.getStrength());
        KeyGenerator keyKgAES = keyToken.getKeyGenerator(KeyGenAlgorithm.AES);
        keyKgAES.initialize(128);
        SymmetricKey baseKeyAES = keyKgAES.generate();
        System.out.println("baseKey bytes: ");
        byte[] baseBytes = baseKey.getEncoded();
        SymKeyDeriving.displayByteArray(baseBytes, true);
        System.out.println("\n Mechanism CKM_EXTRACT_KEY_FROM_KEY test 16 bytes. \n");
        SymmetricKeyDeriver deriver = token.getSymmetricKeyDeriver();
        System.out.println("deriver: " + deriver);
        System.out.println("CKM_EXTRACT_KEY_FROM_KEY : 869");
        long bitPosition = 0L;
        byte[] param = SymKeyDeriving.longToBytes(bitPosition);
        deriver.initDerive(baseKey, 869L, param, null, 260L, 268L, 16L);
        SymmetricKey extracted16 = deriver.derive();
        System.out.println("Derived key: " + extracted16);
        if (extracted16 == null) {
            System.out.println("Failed to derive 16 byte key with mechanism: CKM_EXTRACT_KEY_FROM_KEY \n");
        }
        System.out.println("derivedKey 16 bytes: ");
        byte[] derivedBytes = extracted16.getEncoded();
        SymKeyDeriving.displayByteArray(derivedBytes, true);
        System.out.println("\n Mechanism CKM_EXTRACT_KEY_FROM_KEY test 8 bytes. \n");
        SymmetricKeyDeriver extract8 = token.getSymmetricKeyDeriver();
        extract8.initDerive(extracted16, 869L, param, null, 260L, 268L, 8L);
        SymmetricKey extracted8 = extract8.derive();
        System.out.println("Derived key: " + extracted8);
        if (extracted8 == null) {
            System.out.println("Failed to derive key extracted 8 bytes with mechanism: CKM_EXTRACT_KEY_FROM_KEY \n");
        }
        byte[] extracted8Bytes = extracted8.getEncoded();
        System.out.println("derived extracted 8 bytes of key: ");
        SymKeyDeriving.displayByteArray(extracted8Bytes, true);
        System.out.println("\n Mechanism CKM_CONCATENATE_BASE_AND_KEY test 16 + 8 = 24 byte key. \n");
        SymmetricKeyDeriver concat = keyToken.getSymmetricKeyDeriver();
        concat.initDerive(extracted16, extracted8, 864L, null, null, 306L, 268L, 0L);
        SymmetricKey concated24 = concat.derive();
        if (concated24 == null) {
            System.out.println("Failed to derive key concated 8 bytes to 16 bytes key: CKM_CONCATENATE_BASE_AND_KEY \n");
        }
        byte[] concated24Bytes = concated24.getEncoded();
        System.out.println("derived concated 16 + 8 = 24 byte key: ");
        SymKeyDeriving.displayByteArray(concated24Bytes, true);
        System.out.println("\n Mechanism CKM_DES3_ECB_ENCRYPT_DATA test. \n");
        SymmetricKeyDeriver encryptDes3 = token.getSymmetricKeyDeriver();
        encryptDes3.initDerive(baseKey, 4354L, derivationData16, null, 306L, 268L, 16L);
        SymmetricKey encrypted16 = encryptDes3.derive();
        if (encrypted16 == null) {
            System.out.println("Failed to derive 16 bytes from encrypted derivation data.");
        }
        byte[] encrypted16Bytes = encrypted16.getEncoded();
        System.out.println("derived encrypted 16 bytes: " + encrypted16Bytes.length);
        SymKeyDeriving.displayByteArray(encrypted16Bytes, true);
        Cipher cipher2 = keyToken.getCipherContext(EncryptionAlgorithm.DES3_ECB);
        cipher2.initEncrypt(baseKey);
        byte[] ciphertext = cipher2.doFinal(derivationData16);
        SymKeyDeriving.displayByteArray(ciphertext, true);
        if (ciphertext.length != encrypted16Bytes.length) {
            System.out.println("FAILED: encrypted data length not equal to derived key length.");
        } else {
            int i = 0;
            while (i < ciphertext.length) {
                int n = i;
                ciphertext[n] = (byte)(ciphertext[n] & 0xFE);
                int n2 = i++;
                encrypted16Bytes[n2] = (byte)(encrypted16Bytes[n2] & 0xFE);
            }
            if (Arrays.equals(ciphertext, encrypted16Bytes)) {
                System.out.println("PASSED: derived key the same as encrypted data.");
            } else {
                System.out.println("FAILED: derived key not the same as encrypted data.");
            }
        }
        System.out.println("\n Mechanism CKM_DES3_CBC_ENCRYPT_DATA test. \n");
        SymmetricKeyDeriver encryptDes3CBC = token.getSymmetricKeyDeriver();
        encryptDes3CBC.initDerive(baseKey, 4355L, derivationData16, iv8, 307L, 268L, 16L);
        SymmetricKey encryptedDes3CBC = encryptDes3CBC.derive();
        if (encryptedDes3CBC == null) {
            System.out.println("Failed to derive 16 bytes from encrypted derivation data.");
        }
        byte[] encryptedDes3CBCBytes = encryptedDes3CBC.getEncoded();
        System.out.println("derived encrypted 16 bytes: " + encryptedDes3CBCBytes.length);
        SymKeyDeriving.displayByteArray(encryptedDes3CBCBytes, true);
        cipher2 = keyToken.getCipherContext(EncryptionAlgorithm.DES3_CBC);
        cipher2.initEncrypt(baseKey, (AlgorithmParameterSpec)new IVParameterSpec(iv8));
        ciphertext = cipher2.doFinal(derivationData16);
        SymKeyDeriving.displayByteArray(ciphertext, true);
        if (ciphertext.length != encryptedDes3CBCBytes.length) {
            System.out.println("FAILED: encrypted data length not equal to derived key length.");
        } else {
            int i = 0;
            while (i < ciphertext.length) {
                int n = i;
                ciphertext[n] = (byte)(ciphertext[n] & 0xFE);
                int n3 = i++;
                encryptedDes3CBCBytes[n3] = (byte)(encryptedDes3CBCBytes[n3] & 0xFE);
            }
            if (Arrays.equals(ciphertext, encryptedDes3CBCBytes)) {
                System.out.println("PASSED: derived key the same as encrypted data.");
            } else {
                System.out.println("FAILED: derived key not the same as encrypted data.");
            }
        }
        System.out.println("\n Mechanism CKM_AES_ECB_ENCRYPT_DATA test. \n");
        SymmetricKeyDeriver encryptAESECB = token.getSymmetricKeyDeriver();
        encryptAESECB.initDerive(baseKeyAES, 4356L, derivationData16, null, 4225L, 268L, 16L);
        SymmetricKey encryptedAESECB = encryptAESECB.derive();
        if (encryptedAESECB == null) {
            System.out.println("Failed to derive 16 bytes from encrypted derivation data.");
        }
        byte[] encryptedAESECBBytes = encryptedAESECB.getEncoded();
        System.out.println("derived encrypted 16 bytes: " + encryptedAESECBBytes.length);
        SymKeyDeriving.displayByteArray(encryptedAESECBBytes, true);
        cipher2 = keyToken.getCipherContext(EncryptionAlgorithm.AES_128_ECB);
        cipher2.initEncrypt(baseKeyAES);
        ciphertext = cipher2.doFinal(derivationData16);
        SymKeyDeriving.displayByteArray(ciphertext, true);
        if (ciphertext.length != encryptedAESECBBytes.length) {
            System.out.println("FAILED: encrypted data length not equal to derived key length.");
        } else {
            int i = 0;
            while (i < ciphertext.length) {
                int n = i;
                ciphertext[n] = (byte)(ciphertext[n] & 0xFE);
                int n4 = i++;
                encryptedAESECBBytes[n4] = (byte)(encryptedAESECBBytes[n4] & 0xFE);
            }
            if (Arrays.equals(ciphertext, encryptedAESECBBytes)) {
                System.out.println("PASSED: derived key the same as encrypted data.");
            } else {
                System.out.println("FAILED: derived key not the same as encrypted data.");
            }
        }
        System.out.println("\n Mechanism CKM_AES_CBC_ENCRYPT_DATA test. \n");
        SymmetricKeyDeriver encryptAESCBC = token.getSymmetricKeyDeriver();
        encryptAESCBC.initDerive(baseKeyAES, 4357L, derivationData16, iv16, 4226L, 268L, 16L);
        SymmetricKey encryptedAESCBC = encryptAESCBC.derive();
        if (encryptedAESCBC == null) {
            System.out.println("Failed to derive 16 bytes from encrypted derivation data.");
        }
        byte[] encryptedAESCBCBytes = encryptedAESCBC.getEncoded();
        System.out.println("derived encrypted 16 bytes: " + encryptedAESCBCBytes.length);
        SymKeyDeriving.displayByteArray(encryptedAESCBCBytes, true);
        cipher2 = keyToken.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
        cipher2.initEncrypt(baseKeyAES, (AlgorithmParameterSpec)new IVParameterSpec(iv16));
        ciphertext = cipher2.doFinal(derivationData16);
        SymKeyDeriving.displayByteArray(ciphertext, true);
        if (ciphertext.length != encryptedAESCBCBytes.length) {
            System.out.println("FAILED: encrypted data length not equal to derived key length.");
        } else {
            int i = 0;
            while (i < ciphertext.length) {
                int n = i;
                ciphertext[n] = (byte)(ciphertext[n] & 0xFE);
                int n5 = i++;
                encryptedAESCBCBytes[n5] = (byte)(encryptedAESCBCBytes[n5] & 0xFE);
            }
            if (Arrays.equals(ciphertext, encryptedAESCBCBytes)) {
                System.out.println("PASSED: derived key the same as encrypted data.");
            } else {
                System.out.println("FAILED: derived key not the same as encrypted data.");
            }
        }
        Enumeration ect = cm.getAllTokens();
        CryptoToken ct = null;
        while (ect.hasMoreElements()) {
            ct = (CryptoToken)ect.nextElement();
            System.out.println("CryptoToken.name= " + ct.getName());
        }
        SymmetricKey[] keys = keyToken.getCryptoStore().getSymmetricKeys();
        SymmetricKey macKey = SymKeyDeriving.getSymKeyByName(keys, "defKeySet-macKey");
        System.out.println("macKey: " + macKey);
    }

    public static void displayByteArray(byte[] ba, boolean has_check_sum) {
        int mask = 255;
        if (has_check_sum) {
            mask = 254;
        }
        for (int i = 0; i < ba.length; ++i) {
            System.out.print(Integer.toHexString(ba[i] & mask) + " ");
            if (i % 26 != 25) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static byte[] concatByteArrays(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static SymmetricKey getSymKeyByName(SymmetricKey[] keys, String name) {
        if (keys == null || name == null) {
            return null;
        }
        for (SymmetricKey cur : keys) {
            if (cur == null || !name.equals(cur.getNickName())) continue;
            System.out.println("Found key: " + name + "\n");
            return cur;
        }
        return null;
    }
}

