/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.nss.Buffer;
import org.mozilla.jss.nss.BufferProxy;
import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRErrors;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSL;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SecurityStatusResult;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.SSLVersionRange;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class TestBufferPRFD {
    public static void TestCreateClose() {
        byte[] info = new byte[]{1, 2, 3, 4};
        BufferProxy left_read = Buffer.Create((long)10L);
        BufferProxy right_read = Buffer.Create((long)10L);
        assert (left_read != null);
        assert (right_read != null);
        PRFDProxy left = PR.NewBufferPRFD((BufferProxy)left_read, (BufferProxy)right_read, (byte[])info);
        PRFDProxy right = PR.NewBufferPRFD((BufferProxy)right_read, (BufferProxy)left_read, (byte[])info);
        assert (left != null);
        assert (right != null);
        assert (PR.Write((PRFDProxy)left, (byte[])info) == 4);
        assert (PR.Send((PRFDProxy)left, (byte[])info, (int)0, (long)0L) == 4);
        assert (PR.Send((PRFDProxy)left, (byte[])info, (int)0, (long)0L) == 2);
        byte[] result = PR.Recv((PRFDProxy)right, (int)10, (int)0, (long)0L);
        assert (result.length == 10);
        for (int i = 0; i < 10; ++i) {
            assert (result[i] == info[i % info.length]);
        }
        assert (PR.Close((PRFDProxy)left) == PR.SUCCESS);
        assert (PR.Close((PRFDProxy)right) == PR.SUCCESS);
        Buffer.Free((BufferProxy)left_read);
        Buffer.Free((BufferProxy)right_read);
    }

    public static SSLFDProxy Setup_NSS_Client(PRFDProxy fd, String host) throws Exception {
        SSLFDProxy result = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (result != null);
        assert (SSL.ResetHandshake((SSLFDProxy)result, (boolean)false) == SSL.SECSuccess);
        assert (SSL.SetURL((SSLFDProxy)result, (String)host) == SSL.SECSuccess);
        TestBufferPRFD.TestSSLVersionGetSet(result);
        return result;
    }

    public static SSLFDProxy Setup_NSS_Server(PRFDProxy fd, String host, PK11Cert cert, PK11PrivKey key) throws Exception {
        SSLFDProxy result = SSL.ImportFD(null, (PRFDProxy)fd);
        assert (result != null);
        assert (SSL.ConfigServerCert((SSLFDProxy)result, (PK11Cert)cert, (PK11PrivKey)key) == SSL.SECSuccess);
        assert (SSL.ConfigServerSessionIDCache((int)1, (long)100L, (long)100L, null) == SSL.SECSuccess);
        assert (SSL.ResetHandshake((SSLFDProxy)result, (boolean)true) == SSL.SECSuccess);
        assert (SSL.SetURL((SSLFDProxy)result, (String)host) == SSL.SECSuccess);
        TestBufferPRFD.TestSSLVersionGetSet(result);
        return result;
    }

    public static boolean IsHandshakeFinished(SSLFDProxy c_nspr, SSLFDProxy s_nspr) {
        SecurityStatusResult c_result = SSL.SecurityStatus((SSLFDProxy)c_nspr);
        SecurityStatusResult s_result = SSL.SecurityStatus((SSLFDProxy)s_nspr);
        assert (c_result != null && s_result != null);
        return c_result.on == 1 && s_result.on == 1;
    }

    public static void TestSSLVersionGetSet(SSLFDProxy s_nspr) throws Exception {
        SSLVersionRange initial = SSL.VersionRangeGet((SSLFDProxy)s_nspr);
        System.out.println("Initial: (" + initial.getMinVersion() + ":" + initial.getMinEnum() + ", " + initial.getMaxVersion() + ":" + initial.getMaxEnum() + ")");
        SSLVersionRange vrange = new SSLVersionRange(SSLVersion.TLS_1_1, SSLVersion.TLS_1_3);
        assert (SSL.VersionRangeSet((SSLFDProxy)s_nspr, (SSLVersionRange)vrange) == SSL.SECSuccess);
        SSLVersionRange actual = SSL.VersionRangeGet((SSLFDProxy)s_nspr);
        System.out.println("Actual: (" + actual.getMinVersion() + ":" + actual.getMinEnum() + ", " + actual.getMaxVersion() + ":" + actual.getMaxEnum() + ")");
        assert (actual.getMinEnum() <= SSLVersion.TLS_1_2.value());
        assert (SSLVersion.TLS_1_2.value() <= actual.getMaxEnum());
    }

    public static void InitializeCM(String database, String password) throws Exception {
        CryptoManager manager = CryptoManager.getInstance();
        manager.setPasswordCallback((PasswordCallback)new Password(password.toCharArray()));
    }

    public static void TestSSLHandshake(String server_nickname, String client_nickname) throws Exception {
        String host = "localhost";
        byte[] peer_info = host.getBytes();
        CryptoManager manager = CryptoManager.getInstance();
        PK11Cert server_cert = (PK11Cert)manager.findCertByNickname(server_nickname);
        PK11PrivKey server_key = (PK11PrivKey)manager.findPrivKeyByCert((X509Certificate)server_cert);
        assert (server_cert != null);
        assert (server_key != null);
        PK11Cert client_cert = null;
        if (client_nickname != null) {
            client_cert = (PK11Cert)manager.findCertByNickname(client_nickname);
            assert (client_cert != null);
        }
        BufferProxy read_buf = Buffer.Create((long)1024L);
        BufferProxy write_buf = Buffer.Create((long)1024L);
        assert (read_buf != null);
        assert (write_buf != null);
        PRFDProxy c_buffer = PR.NewBufferPRFD((BufferProxy)read_buf, (BufferProxy)write_buf, (byte[])peer_info);
        PRFDProxy s_buffer = PR.NewBufferPRFD((BufferProxy)write_buf, (BufferProxy)read_buf, (byte[])peer_info);
        assert (c_buffer != null);
        assert (s_buffer != null);
        SSLFDProxy c_nspr = TestBufferPRFD.Setup_NSS_Client(c_buffer, host);
        SSLFDProxy s_nspr = TestBufferPRFD.Setup_NSS_Server(s_buffer, host, server_cert, server_key);
        assert (c_nspr != null);
        assert (s_nspr != null);
        if (client_cert != null) {
            c_nspr.SetClientCert((X509Certificate)client_cert);
            assert (SSL.AttachClientCertCallback((SSLFDProxy)c_nspr) == SSL.SECSuccess);
            assert (SSL.OptionSet((SSLFDProxy)s_nspr, (int)SSL.REQUEST_CERTIFICATE, (int)1) == SSL.SECSuccess);
        }
        assert (SSL.EnableAlertLogging((SSLFDProxy)c_nspr) == SSL.SECSuccess);
        assert (SSL.EnableAlertLogging((SSLFDProxy)s_nspr) == SSL.SECSuccess);
        assert (!TestBufferPRFD.IsHandshakeFinished(c_nspr, s_nspr));
        int count = 0;
        while (!TestBufferPRFD.IsHandshakeFinished(c_nspr, s_nspr)) {
            int error;
            if (SSL.ForceHandshake((SSLFDProxy)c_nspr) != SSL.SECSuccess && (error = PR.GetError()) != PRErrors.WOULD_BLOCK_ERROR) {
                System.out.println("Unexpected error: " + new String(PR.ErrorToName((int)error)) + " (" + error + ")");
                System.exit(1);
            }
            if (SSL.ForceHandshake((SSLFDProxy)s_nspr) != SSL.SECSuccess && (error = PR.GetError()) != PRErrors.WOULD_BLOCK_ERROR) {
                System.out.println("Unexpected error: " + new String(PR.ErrorToName((int)error)) + " (" + error + ")");
                System.exit(1);
            }
            if (++count < 40) continue;
            System.err.println("Error: unable to make progress after " + count + " steps!");
            System.exit(1);
        }
        System.out.println("Handshake completed successfully!\n");
        assert (TestBufferPRFD.IsHandshakeFinished(c_nspr, s_nspr));
        assert (SSL.PeerCertificate((SSLFDProxy)c_nspr) != null);
        assert (SSL.PeerCertificateChain((SSLFDProxy)c_nspr) != null);
        if (client_nickname == null) {
            assert (SSL.PeerCertificate((SSLFDProxy)s_nspr) == null);
            assert (SSL.PeerCertificateChain((SSLFDProxy)s_nspr) == null);
        } else {
            assert (SSL.PeerCertificate((SSLFDProxy)s_nspr) != null);
            assert (SSL.PeerCertificateChain((SSLFDProxy)s_nspr) != null);
        }
        byte[] client_message = "Cooking MCs".getBytes();
        assert (PR.Write((PRFDProxy)c_nspr, (byte[])client_message) == client_message.length);
        byte[] server_received = PR.Read((PRFDProxy)s_nspr, (int)client_message.length);
        assert (server_received != null);
        if (server_received.length != client_message.length) {
            System.out.println("Expected a client message of length " + client_message.length + " but got one of " + server_received.length);
            System.exit(1);
        }
        for (int i = 0; i < client_message.length && i < server_received.length; ++i) {
            if (client_message[i] == server_received[i]) continue;
            System.out.println("Received byte " + server_received[i] + " on server but expected " + client_message[i]);
            System.exit(1);
        }
        byte[] server_message = "like a pound of bacon".getBytes();
        assert (PR.Write((PRFDProxy)s_nspr, (byte[])server_message) == server_message.length);
        byte[] client_received = PR.Read((PRFDProxy)c_nspr, (int)server_message.length);
        assert (client_received != null);
        if (client_received.length != server_message.length) {
            System.out.println("Expected a server message of length " + server_message.length + " but got one of " + client_received.length);
            System.exit(1);
        }
        for (int i = 0; i < server_message.length && i < client_received.length; ++i) {
            if (server_message[i] == client_received[i]) continue;
            System.out.println("Received byte " + client_received[i] + " on client but expected " + server_message[i]);
            System.exit(1);
        }
        assert (PR.Shutdown((PRFDProxy)c_nspr, (int)PR.SHUTDOWN_BOTH) == PR.SUCCESS);
        assert (PR.Shutdown((PRFDProxy)s_nspr, (int)PR.SHUTDOWN_BOTH) == PR.SUCCESS);
        for (SSLAlertEvent alert : c_nspr.inboundAlerts) {
            System.err.println("client inbound: " + alert);
        }
        for (SSLAlertEvent alert : c_nspr.outboundAlerts) {
            System.err.println("client outbound: " + alert);
        }
        for (SSLAlertEvent alert : s_nspr.inboundAlerts) {
            System.err.println("server inbound: " + alert);
        }
        for (SSLAlertEvent alert : s_nspr.outboundAlerts) {
            System.err.println("server outbound: " + alert);
        }
        assert (PR.Close((SSLFDProxy)c_nspr) == PR.SUCCESS);
        assert (PR.Close((SSLFDProxy)s_nspr) == PR.SUCCESS);
        Buffer.Free((BufferProxy)read_buf);
        Buffer.Free((BufferProxy)write_buf);
    }

    public static void main(String[] args) throws Exception {
        System.loadLibrary("jss");
        System.out.println("Calling TestCreateClose()...");
        TestBufferPRFD.TestCreateClose();
        System.out.println("Initializing CryptoManager...");
        TestBufferPRFD.InitializeCM(args[0], args[1]);
        System.out.println("Calling TestSSLHandshake(Server_RSA, null)...");
        TestBufferPRFD.TestSSLHandshake("Server_RSA", null);
        System.out.println("Calling TestSSLHandshake(Server_RSA, Client_RSA)...");
        TestBufferPRFD.TestSSLHandshake("Server_RSA", "Client_RSA");
        System.out.println("Calling TestSSLHandshake(Server_ECDSA, null)...");
        TestBufferPRFD.TestSSLHandshake("Server_ECDSA", null);
        System.out.println("Calling TestSSLHandshake(Server_ECDSA, Client_ECDSA)...");
        TestBufferPRFD.TestSSLHandshake("Server_ECDSA", "Client_ECDSA");
    }
}

