/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.util.Password;

public class PBEKeyGenParams
implements AlgorithmParameterSpec,
KeySpec {
    private Password pass;
    private byte[] salt;
    private int iterations;
    private EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.DES3_CBC;
    private HMACAlgorithm hashAlgorithm = null;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int DEFAULT_ITERATIONS = 1;

    public PBEKeyGenParams(Password pass, byte[] salt, int iterations) {
        if (pass == null || salt == null) {
            throw new NullPointerException();
        }
        this.pass = (Password)pass.clone();
        this.salt = salt;
        this.iterations = iterations;
    }

    public PBEKeyGenParams(char[] pass, byte[] salt, int iterations) {
        this(pass, salt, iterations, null, null);
    }

    public PBEKeyGenParams(char[] pass, byte[] salt, int iterations, EncryptionAlgorithm encAlg) {
        this(pass, salt, iterations, encAlg, null);
    }

    public PBEKeyGenParams(char[] pass, byte[] salt, int iterations, EncryptionAlgorithm encAlg, HMACAlgorithm hashAlg) {
        if (pass == null || salt == null) {
            throw new NullPointerException();
        }
        this.pass = new Password((char[])pass.clone());
        this.salt = salt;
        this.iterations = iterations;
        if (encAlg != null) {
            this.encryptionAlgorithm = encAlg;
        }
        this.hashAlgorithm = hashAlg;
    }

    public Password getPassword() {
        return this.pass;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public HMACAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void clear() {
        this.pass.clear();
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.pass.clear();
    }
}

