/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class PBKDF2Params
implements ASN1Value {
    private byte[] salt;
    private AlgorithmIdentifier otherSource;
    private int iterations;
    private int keyLength;
    private AlgorithmIdentifier prf;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public AlgorithmIdentifier getOtherSource() {
        return this.otherSource;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }

    public PBKDF2Params(byte[] salt, AlgorithmIdentifier otherSource, int iterations, int keyLength, AlgorithmIdentifier prf) {
        this.salt = salt;
        this.otherSource = otherSource;
        this.iterations = iterations;
        this.keyLength = keyLength;
        this.prf = prf;
        this.sequence = new SEQUENCE();
        if (salt != null) {
            this.sequence.addElement(new OCTET_STRING(salt));
        } else {
            this.sequence.addElement(otherSource);
        }
        this.sequence.addElement(new INTEGER(iterations));
        if (keyLength > 0) {
            this.sequence.addElement(new INTEGER(keyLength));
        }
        this.sequence.addElement(prf);
    }

    public PBKDF2Params(OCTET_STRING salt, AlgorithmIdentifier otherSource, INTEGER iterations, INTEGER keyLength, AlgorithmIdentifier prf) {
        this(salt == null ? null : salt.toByteArray(), otherSource, iterations.intValue(), keyLength != null ? keyLength.intValue() : 0, prf);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            CHOICE.Template salt = CHOICE.getTemplate();
            salt.addElement(OCTET_STRING.getTemplate());
            salt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(salt);
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            OCTET_STRING specified = null;
            AlgorithmIdentifier otherSource = null;
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            CHOICE salt = (CHOICE)seq.elementAt(0);
            ASN1Value aSN1Value = salt.getValue();
            if (aSN1Value instanceof OCTET_STRING) {
                OCTET_STRING saltValue;
                specified = saltValue = (OCTET_STRING)aSN1Value;
            }
            if ((aSN1Value = salt.getValue()) instanceof AlgorithmIdentifier) {
                AlgorithmIdentifier saltSource;
                otherSource = saltSource = (AlgorithmIdentifier)aSN1Value;
            }
            return new PBKDF2Params(specified, otherSource, (INTEGER)seq.elementAt(1), (INTEGER)seq.elementAt(2), (AlgorithmIdentifier)seq.elementAt(3));
        }
    }
}

