/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class Encoding
implements ASN1Value {
    private SEQUENCE seq = new SEQUENCE();
    private byte[] iv;
    private OBJECT_IDENTIFIER encOID;
    private byte[] ctext;
    private byte[] keyID;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public Encoding(byte[] keyID, byte[] iv, OBJECT_IDENTIFIER encOID, byte[] ctext) {
        this.keyID = keyID;
        this.iv = iv;
        this.encOID = encOID;
        this.ctext = ctext;
        AlgorithmIdentifier algID = new AlgorithmIdentifier(encOID, new OCTET_STRING(iv));
        this.seq.addElement(new OCTET_STRING(keyID));
        this.seq.addElement(algID);
        this.seq.addElement(new OCTET_STRING(ctext));
    }

    public byte[] getKeyID() {
        return this.keyID;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public OBJECT_IDENTIFIER getEncryptionOID() {
        return this.encOID;
    }

    public byte[] getCiphertext() {
        return this.ctext;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    extends SEQUENCE.Template {
        private SEQUENCE.Template template = new SEQUENCE.Template();

        public Template() {
            this.template.addElement(OCTET_STRING.getTemplate());
            this.template.addElement(AlgorithmIdentifier.getTemplate());
            this.template.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.template.decode(implicitTag, istream);
            OCTET_STRING keyID = (OCTET_STRING)seq.elementAt(0);
            AlgorithmIdentifier algID = (AlgorithmIdentifier)seq.elementAt(1);
            OCTET_STRING ivOS = (OCTET_STRING)((ANY)algID.getParameters()).decodeWith(OCTET_STRING.getTemplate());
            OCTET_STRING ctextOS = (OCTET_STRING)seq.elementAt(2);
            return new Encoding(keyID.toByteArray(), ivOS.toByteArray(), algID.getOID(), ctextOS.toByteArray());
        }
    }
}

