/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class OCSPNoCheckExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -4692759557964594790L;
    public static final String OID = "1.3.6.1.5.5.7.48.1.5";
    public static final String NAME = "OCSPNoCheckExtension";
    private byte[] mCached = null;

    public OCSPNoCheckExtension() throws IOException {
        this(Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCSPNoCheckExtension(Boolean crit) throws IOException {
        try {
            this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.critical = crit;
        try (DerOutputStream tmpD = new DerOutputStream();){
            tmpD.putNull();
        }
        this.extensionValue = tmpD.toByteArray();
    }

    public OCSPNoCheckExtension(Boolean crit, Object byteVal) {
        try {
            this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.critical = crit;
        this.extensionValue = (byte[])((byte[])byteVal).clone();
    }

    @Override
    public void setCritical(boolean newValue) {
        if (this.critical != newValue) {
            this.critical = newValue;
            this.mCached = null;
        }
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (this.mCached == null) {
            super.encode(out);
            this.mCached = out.toByteArray();
        }
    }

    @Override
    public String toString() {
        Object presentation = "oid=1.3.6.1.5.5.7.48.1.5 ";
        if (this.critical) {
            presentation = (String)presentation + "critical=true";
        }
        if (this.extensionValue != null) {
            StringBuffer extByteValue = new StringBuffer(" val=");
            for (int i = 0; i < this.extensionValue.length; ++i) {
                extByteValue.append(this.extensionValue[i] + " ");
            }
            presentation = (String)presentation + extByteValue.toString();
        }
        return presentation;
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        if (this.mCached == null) {
            DerOutputStream temp = new DerOutputStream();
            this.encode(temp);
        }
        out.write(this.mCached);
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
    }

    static {
        try {
            OIDMap.addAttribute(OCSPNoCheckExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

