/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Locale;
import java.util.ResourceBundle;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.PrettyPrintResources;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubKeyPrettyPrint {
    public static final Logger logger = LoggerFactory.getLogger(PubKeyPrettyPrint.class);
    private X509Key mX509Key = null;
    private PrettyPrintFormat pp = null;

    public PubKeyPrettyPrint(PublicKey key) {
        if (key instanceof X509Key) {
            this.mX509Key = (X509Key)key;
        }
        this.pp = new PrettyPrintFormat(":");
    }

    public String toString(Locale clientLocale, int indentSize, int lineLen) {
        if (this.mX509Key != null) {
            return this.X509toString(clientLocale, indentSize, lineLen);
        }
        return null;
    }

    public String X509toString(Locale clientLocale, int indentSize, int lineLen) {
        ResourceBundle resource = ResourceBundle.getBundle(PrettyPrintResources.class.getName());
        StringBuffer sb = new StringBuffer();
        try {
            String alg = this.mX509Key.getAlgorithm();
            sb.append(this.pp.indent(indentSize) + resource.getString("tokenAlgorithm") + alg + " - " + this.mX509Key.getAlgorithmId().getOID().toString() + "\n");
            if (alg.equals("RSA")) {
                RSAPublicKey rsakey = new RSAPublicKey(this.mX509Key.getEncoded());
                sb.append(this.pp.indent(indentSize) + resource.getString("tokenPublicKey") + "\n");
                sb.append(this.pp.indent(indentSize + 4) + resource.getString("tokenPublicKeyExponent") + rsakey.getPublicExponent().toInt() + "\n");
                sb.append(this.pp.indent(indentSize + 4) + resource.getString("tokenPublicKeyModulus") + "(" + rsakey.getKeySize() + " bits) :\n");
                sb.append(this.pp.toHexString(rsakey.getModulus().toByteArray(), indentSize + 8, lineLen));
            } else {
                sb.append(this.pp.indent(indentSize) + resource.getString("tokenPublicKey") + "\n");
                sb.append(this.pp.toHexString(this.mX509Key.getKey(), indentSize + 4, lineLen));
            }
        }
        catch (InvalidKeyException e) {
            logger.debug("Impossible convert public certificate to string", (Throwable)e);
        }
        return sb.toString();
    }
}

