/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.PropertyResourceBundle;

class LDAPResourceBundle
implements Serializable {
    static final long serialVersionUID = -5903986665461157980L;
    private static final boolean m_debug = false;
    private static final String m_suffix = ".props";
    private static final String m_locale_separator = "_";

    LDAPResourceBundle() {
    }

    static PropertyResourceBundle getBundle(String baseName) throws IOException {
        return LDAPResourceBundle.getBundle(baseName, Locale.getDefault());
    }

    static PropertyResourceBundle getBundle(String baseName, Locale l) throws IOException {
        Object localeStr = m_locale_separator + l.toString();
        InputStream fin = null;
        while (true) {
            if ((fin = LDAPResourceBundle.getStream(baseName, (String)localeStr)) != null) {
                PropertyResourceBundle p = new PropertyResourceBundle(fin);
                return p;
            }
            int index = ((String)localeStr).lastIndexOf(m_locale_separator);
            if (index == -1) {
                LDAPResourceBundle.printDebug("File " + baseName + (String)localeStr + ".props not found");
                return null;
            }
            localeStr = ((String)localeStr).substring(0, index);
        }
    }

    private static InputStream getStream(String baseName, String locale) {
        String fStr = baseName + locale + m_suffix;
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fStr);
    }

    private static void printDebug(String str) {
    }
}

