// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use std::fmt;
use std::ptr;
use SocketConnectable;

glib_wrapper! {
    pub struct NetworkAddress(Object<gio_sys::GNetworkAddress, gio_sys::GNetworkAddressClass, NetworkAddressClass>) @implements SocketConnectable;

    match fn {
        get_type => || gio_sys::g_network_address_get_type(),
    }
}

impl NetworkAddress {
    pub fn new(hostname: &str, port: u16) -> NetworkAddress {
        unsafe {
            from_glib_full(gio_sys::g_network_address_new(
                hostname.to_glib_none().0,
                port,
            ))
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    pub fn new_loopback(port: u16) -> NetworkAddress {
        unsafe { from_glib_full(gio_sys::g_network_address_new_loopback(port)) }
    }

    pub fn parse(host_and_port: &str, default_port: u16) -> Result<NetworkAddress, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_network_address_parse(
                host_and_port.to_glib_none().0,
                default_port,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn parse_uri(uri: &str, default_port: u16) -> Result<NetworkAddress, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_network_address_parse_uri(
                uri.to_glib_none().0,
                default_port,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

unsafe impl Send for NetworkAddress {}
unsafe impl Sync for NetworkAddress {}

pub const NONE_NETWORK_ADDRESS: Option<&NetworkAddress> = None;

pub trait NetworkAddressExt: 'static {
    fn get_hostname(&self) -> Option<GString>;

    fn get_port(&self) -> u16;

    fn get_scheme(&self) -> Option<GString>;
}

impl<O: IsA<NetworkAddress>> NetworkAddressExt for O {
    fn get_hostname(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_address_get_hostname(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_port(&self) -> u16 {
        unsafe { gio_sys::g_network_address_get_port(self.as_ref().to_glib_none().0) }
    }

    fn get_scheme(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_address_get_scheme(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for NetworkAddress {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "NetworkAddress")
    }
}
