# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver1 -instruction-tables < %s | FileCheck %s

vaddpd            %xmm0, %xmm1, %xmm2
vaddpd            (%rax), %xmm1, %xmm2

vaddpd            %ymm0, %ymm1, %ymm2
vaddpd            (%rax), %ymm1, %ymm2

vaddps            %xmm0, %xmm1, %xmm2
vaddps            (%rax), %xmm1, %xmm2

vaddps            %ymm0, %ymm1, %ymm2
vaddps            (%rax), %ymm1, %ymm2

vaddsd            %xmm0, %xmm1, %xmm2
vaddsd            (%rax), %xmm1, %xmm2

vaddss            %xmm0, %xmm1, %xmm2
vaddss            (%rax), %xmm1, %xmm2

vaddsubpd         %xmm0, %xmm1, %xmm2
vaddsubpd         (%rax), %xmm1, %xmm2

vaddsubpd         %ymm0, %ymm1, %ymm2
vaddsubpd         (%rax), %ymm1, %ymm2

vaddsubps         %xmm0, %xmm1, %xmm2
vaddsubps         (%rax), %xmm1, %xmm2

vaddsubps         %ymm0, %ymm1, %ymm2
vaddsubps         (%rax), %ymm1, %ymm2

vaesdec           %xmm0, %xmm1, %xmm2
vaesdec           (%rax), %xmm1, %xmm2

vaesdeclast       %xmm0, %xmm1, %xmm2
vaesdeclast       (%rax), %xmm1, %xmm2

vaesenc           %xmm0, %xmm1, %xmm2
vaesenc           (%rax), %xmm1, %xmm2

vaesenclast       %xmm0, %xmm1, %xmm2
vaesenclast       (%rax), %xmm1, %xmm2

vaesimc           %xmm0, %xmm2
vaesimc           (%rax), %xmm2

vaeskeygenassist  $22, %xmm0, %xmm2
vaeskeygenassist  $22, (%rax), %xmm2

vandnpd           %xmm0, %xmm1, %xmm2
vandnpd           (%rax), %xmm1, %xmm2

vandnpd           %ymm0, %ymm1, %ymm2
vandnpd           (%rax), %ymm1, %ymm2

vandnps           %xmm0, %xmm1, %xmm2
vandnps           (%rax), %xmm1, %xmm2

vandnps           %ymm0, %ymm1, %ymm2
vandnps           (%rax), %ymm1, %ymm2

vandpd            %xmm0, %xmm1, %xmm2
vandpd            (%rax), %xmm1, %xmm2

vandpd            %ymm0, %ymm1, %ymm2
vandpd            (%rax), %ymm1, %ymm2

vandps            %xmm0, %xmm1, %xmm2
vandps            (%rax), %xmm1, %xmm2

vandps            %ymm0, %ymm1, %ymm2
vandps            (%rax), %ymm1, %ymm2

vblendpd          $11, %xmm0, %xmm1, %xmm2
vblendpd          $11, (%rax), %xmm1, %xmm2

vblendpd          $11, %ymm0, %ymm1, %ymm2
vblendpd          $11, (%rax), %ymm1, %ymm2

vblendps          $11, %xmm0, %xmm1, %xmm2
vblendps          $11, (%rax), %xmm1, %xmm2

vblendps          $11, %ymm0, %ymm1, %ymm2
vblendps          $11, (%rax), %ymm1, %ymm2

vblendvpd         %xmm3, %xmm0, %xmm1, %xmm2
vblendvpd         %xmm3, (%rax), %xmm1, %xmm2

vblendvpd         %ymm3, %ymm0, %ymm1, %ymm2
vblendvpd         %ymm3, (%rax), %ymm1, %ymm2

vblendvps         %xmm3, %xmm0, %xmm1, %xmm2
vblendvps         %xmm3, (%rax), %xmm1, %xmm2

vblendvps         %ymm3, %ymm0, %ymm1, %ymm2
vblendvps         %ymm3, (%rax), %ymm1, %ymm2

vbroadcastf128    (%rax), %ymm2

vbroadcastsd      (%rax), %ymm2

vbroadcastss      (%rax), %xmm2
vbroadcastss      (%rax), %ymm2

vcmppd            $0, %xmm0, %xmm1, %xmm2
vcmppd            $0, (%rax), %xmm1, %xmm2

vcmppd            $0, %ymm0, %ymm1, %ymm2
vcmppd            $0, (%rax), %ymm1, %ymm2

vcmpps            $0, %xmm0, %xmm1, %xmm2
vcmpps            $0, (%rax), %xmm1, %xmm2

vcmpps            $0, %ymm0, %ymm1, %ymm2
vcmpps            $0, (%rax), %ymm1, %ymm2

vcmpsd            $0, %xmm0, %xmm1, %xmm2
vcmpsd            $0, (%rax), %xmm1, %xmm2

vcmpss            $0, %xmm0, %xmm1, %xmm2
vcmpss            $0, (%rax), %xmm1, %xmm2

vcomisd           %xmm0, %xmm1
vcomisd           (%rax), %xmm1

vcomiss           %xmm0, %xmm1
vcomiss           (%rax), %xmm1

vcvtdq2pd         %xmm0, %xmm2
vcvtdq2pd         (%rax), %xmm2

vcvtdq2pd         %xmm0, %ymm2
vcvtdq2pd         (%rax), %ymm2

vcvtdq2ps         %xmm0, %xmm2
vcvtdq2ps         (%rax), %xmm2

vcvtdq2ps         %ymm0, %ymm2
vcvtdq2ps         (%rax), %ymm2

vcvtpd2dqx        %xmm0, %xmm2
vcvtpd2dqx        (%rax), %xmm2

vcvtpd2dqy        %ymm0, %xmm2
vcvtpd2dqy        (%rax), %xmm2

vcvtpd2psx        %xmm0, %xmm2
vcvtpd2psx        (%rax), %xmm2

vcvtpd2psy        %ymm0, %xmm2
vcvtpd2psy        (%rax), %xmm2

vcvtps2dq         %xmm0, %xmm2
vcvtps2dq         (%rax), %xmm2

vcvtps2dq         %ymm0, %ymm2
vcvtps2dq         (%rax), %ymm2

vcvtps2pd         %xmm0, %xmm2
vcvtps2pd         (%rax), %xmm2

vcvtps2pd         %xmm0, %ymm2
vcvtps2pd         (%rax), %ymm2

vcvtsd2si         %xmm0, %ecx
vcvtsd2si         %xmm0, %rcx
vcvtsd2si         (%rax), %ecx
vcvtsd2si         (%rax), %rcx

vcvtsd2ss         %xmm0, %xmm1, %xmm2
vcvtsd2ss         (%rax), %xmm1, %xmm2

vcvtsi2sdl        %ecx, %xmm0, %xmm2
vcvtsi2sdq        %rcx, %xmm0, %xmm2
vcvtsi2sdl        (%rax), %xmm0, %xmm2
vcvtsi2sdq        (%rax), %xmm0, %xmm2

vcvtsi2ssl        %ecx, %xmm0, %xmm2
vcvtsi2ssq        %rcx, %xmm0, %xmm2
vcvtsi2ssl        (%rax), %xmm0, %xmm2
vcvtsi2ssq        (%rax), %xmm0, %xmm2

vcvtss2sd         %xmm0, %xmm1, %xmm2
vcvtss2sd         (%rax), %xmm1, %xmm2

vcvtss2si         %xmm0, %ecx
vcvtss2si         %xmm0, %rcx
vcvtss2si         (%rax), %ecx
vcvtss2si         (%rax), %rcx

vcvttpd2dqx       %xmm0, %xmm2
vcvttpd2dqx       (%rax), %xmm2

vcvttpd2dqy       %ymm0, %xmm2
vcvttpd2dqy       (%rax), %xmm2

vcvttps2dq        %xmm0, %xmm2
vcvttps2dq        (%rax), %xmm2

vcvttps2dq        %ymm0, %ymm2
vcvttps2dq        (%rax), %ymm2

vcvttsd2si        %xmm0, %ecx
vcvttsd2si        %xmm0, %rcx
vcvttsd2si        (%rax), %ecx
vcvttsd2si        (%rax), %rcx

vcvttss2si        %xmm0, %ecx
vcvttss2si        %xmm0, %rcx
vcvttss2si        (%rax), %ecx
vcvttss2si        (%rax), %rcx

vdivpd            %xmm0, %xmm1, %xmm2
vdivpd            (%rax), %xmm1, %xmm2

vdivpd            %ymm0, %ymm1, %ymm2
vdivpd            (%rax), %ymm1, %ymm2

vdivps            %xmm0, %xmm1, %xmm2
vdivps            (%rax), %xmm1, %xmm2

vdivps            %ymm0, %ymm1, %ymm2
vdivps            (%rax), %ymm1, %ymm2

vdivsd            %xmm0, %xmm1, %xmm2
vdivsd            (%rax), %xmm1, %xmm2

vdivss            %xmm0, %xmm1, %xmm2
vdivss            (%rax), %xmm1, %xmm2

vdppd             $22, %xmm0, %xmm1, %xmm2
vdppd             $22, (%rax), %xmm1, %xmm2

vdpps             $22, %xmm0, %xmm1, %xmm2
vdpps             $22, (%rax), %xmm1, %xmm2

vdpps             $22, %ymm0, %ymm1, %ymm2
vdpps             $22, (%rax), %ymm1, %ymm2

vextractf128      $1, %ymm0, %xmm2
vextractf128      $1, %ymm0, (%rax)

vextractps        $1, %xmm0, %rcx
vextractps        $1, %xmm0, (%rax)

vhaddpd           %xmm0, %xmm1, %xmm2
vhaddpd           (%rax), %xmm1, %xmm2

vhaddpd           %ymm0, %ymm1, %ymm2
vhaddpd           (%rax), %ymm1, %ymm2

vhaddps           %xmm0, %xmm1, %xmm2
vhaddps           (%rax), %xmm1, %xmm2

vhaddps           %ymm0, %ymm1, %ymm2
vhaddps           (%rax), %ymm1, %ymm2

vhsubpd           %xmm0, %xmm1, %xmm2
vhsubpd           (%rax), %xmm1, %xmm2

vhsubpd           %ymm0, %ymm1, %ymm2
vhsubpd           (%rax), %ymm1, %ymm2

vhsubps           %xmm0, %xmm1, %xmm2
vhsubps           (%rax), %xmm1, %xmm2

vhsubps           %ymm0, %ymm1, %ymm2
vhsubps           (%rax), %ymm1, %ymm2

vinsertf128       $1, %xmm0, %ymm1, %ymm2
vinsertf128       $1, (%rax), %ymm1, %ymm2

vinsertps         $1, %xmm0, %xmm1, %xmm2
vinsertps         $1, (%rax), %xmm1, %xmm2

vlddqu            (%rax), %xmm2
vlddqu            (%rax), %ymm2

vldmxcsr          (%rax)

vmaskmovdqu       %xmm0, %xmm1

vmaskmovpd        (%rax), %xmm0, %xmm2
vmaskmovpd        (%rax), %ymm0, %ymm2

vmaskmovpd        %xmm0, %xmm1, (%rax)
vmaskmovpd        %ymm0, %ymm1, (%rax)

vmaskmovps        (%rax), %xmm0, %xmm2
vmaskmovps        (%rax), %ymm0, %ymm2

vmaskmovps        %xmm0, %xmm1, (%rax)
vmaskmovps        %ymm0, %ymm1, (%rax)

vmaxpd            %xmm0, %xmm1, %xmm2
vmaxpd            (%rax), %xmm1, %xmm2

vmaxpd            %ymm0, %ymm1, %ymm2
vmaxpd            (%rax), %ymm1, %ymm2

vmaxps            %xmm0, %xmm1, %xmm2
vmaxps            (%rax), %xmm1, %xmm2

vmaxps            %ymm0, %ymm1, %ymm2
vmaxps            (%rax), %ymm1, %ymm2

vmaxsd            %xmm0, %xmm1, %xmm2
vmaxsd            (%rax), %xmm1, %xmm2

vmaxss            %xmm0, %xmm1, %xmm2
vmaxss            (%rax), %xmm1, %xmm2

vminpd            %xmm0, %xmm1, %xmm2
vminpd            (%rax), %xmm1, %xmm2

vminpd            %ymm0, %ymm1, %ymm2
vminpd            (%rax), %ymm1, %ymm2

vminps            %xmm0, %xmm1, %xmm2
vminps            (%rax), %xmm1, %xmm2

vminps            %ymm0, %ymm1, %ymm2
vminps            (%rax), %ymm1, %ymm2

vminsd            %xmm0, %xmm1, %xmm2
vminsd            (%rax), %xmm1, %xmm2

vminss            %xmm0, %xmm1, %xmm2
vminss            (%rax), %xmm1, %xmm2

vmovapd           %xmm0, %xmm2
vmovapd           %xmm0, (%rax)
vmovapd           (%rax), %xmm2

vmovapd           %ymm0, %ymm2
vmovapd           %ymm0, (%rax)
vmovapd           (%rax), %ymm2

vmovaps           %xmm0, %xmm2
vmovaps           %xmm0, (%rax)
vmovaps           (%rax), %xmm2

vmovaps           %ymm0, %ymm2
vmovaps           %ymm0, (%rax)
vmovaps           (%rax), %ymm2

vmovd             %eax, %xmm2
vmovd             (%rax), %xmm2

vmovd             %xmm0, %ecx
vmovd             %xmm0, (%rax)

vmovddup          %xmm0, %xmm2
vmovddup          (%rax), %xmm2

vmovddup          %ymm0, %ymm2
vmovddup          (%rax), %ymm2

vmovdqa           %xmm0, %xmm2
vmovdqa           %xmm0, (%rax)
vmovdqa           (%rax), %xmm2

vmovdqa           %ymm0, %ymm2
vmovdqa           %ymm0, (%rax)
vmovdqa           (%rax), %ymm2

vmovdqu           %xmm0, %xmm2
vmovdqu           %xmm0, (%rax)
vmovdqu           (%rax), %xmm2

vmovdqu           %ymm0, %ymm2
vmovdqu           %ymm0, (%rax)
vmovdqu           (%rax), %ymm2

vmovhlps          %xmm0, %xmm1, %xmm2
vmovlhps          %xmm0, %xmm1, %xmm2

vmovhpd           %xmm0, (%rax)
vmovhpd           (%rax), %xmm1, %xmm2

vmovhps           %xmm0, (%rax)
vmovhps           (%rax), %xmm1, %xmm2

vmovlpd           %xmm0, (%rax)
vmovlpd           (%rax), %xmm1, %xmm2

vmovlps           %xmm0, (%rax)
vmovlps           (%rax), %xmm1, %xmm2

vmovmskpd         %xmm0, %rcx
vmovmskpd         %ymm0, %rcx

vmovmskps         %xmm0, %rcx
vmovmskps         %ymm0, %rcx

vmovntdq          %xmm0, (%rax)
vmovntdq          %ymm0, (%rax)

vmovntdqa         (%rax), %xmm2
vmovntdqa         (%rax), %ymm2

vmovntpd          %xmm0, (%rax)
vmovntpd          %ymm0, (%rax)

vmovntps          %xmm0, (%rax)
vmovntps          %ymm0, (%rax)

vmovq             %xmm0, %xmm2

vmovq             %rax, %xmm2
vmovq             (%rax), %xmm2

vmovq             %xmm0, %rcx
vmovq             %xmm0, (%rax)

vmovsd            %xmm0, %xmm1, %xmm2
vmovsd            %xmm0, (%rax)
vmovsd            (%rax), %xmm2

vmovshdup         %xmm0, %xmm2
vmovshdup         (%rax), %xmm2

vmovshdup         %ymm0, %ymm2
vmovshdup         (%rax), %ymm2

vmovsldup         %xmm0, %xmm2
vmovsldup         (%rax), %xmm2

vmovsldup         %ymm0, %ymm2
vmovsldup         (%rax), %ymm2

vmovss            %xmm0, %xmm1, %xmm2
vmovss            %xmm0, (%rax)
vmovss            (%rax), %xmm2

vmovupd           %xmm0, %xmm2
vmovupd           %xmm0, (%rax)
vmovupd           (%rax), %xmm2

vmovupd           %ymm0, %ymm2
vmovupd           %ymm0, (%rax)
vmovupd           (%rax), %ymm2

vmovups           %xmm0, %xmm2
vmovups           %xmm0, (%rax)
vmovups           (%rax), %xmm2

vmovups           %ymm0, %ymm2
vmovups           %ymm0, (%rax)
vmovups           (%rax), %ymm2

vmpsadbw          $1, %xmm0, %xmm1, %xmm2
vmpsadbw          $1, (%rax), %xmm1, %xmm2

vmulpd            %xmm0, %xmm1, %xmm2
vmulpd            (%rax), %xmm1, %xmm2

vmulpd            %ymm0, %ymm1, %ymm2
vmulpd            (%rax), %ymm1, %ymm2

vmulps            %xmm0, %xmm1, %xmm2
vmulps            (%rax), %xmm1, %xmm2

vmulps            %ymm0, %ymm1, %ymm2
vmulps            (%rax), %ymm1, %ymm2

vmulsd            %xmm0, %xmm1, %xmm2
vmulsd            (%rax), %xmm1, %xmm2

vmulss            %xmm0, %xmm1, %xmm2
vmulss            (%rax), %xmm1, %xmm2

vorpd             %xmm0, %xmm1, %xmm2
vorpd             (%rax), %xmm1, %xmm2

vorpd             %ymm0, %ymm1, %ymm2
vorpd             (%rax), %ymm1, %ymm2

vorps             %xmm0, %xmm1, %xmm2
vorps             (%rax), %xmm1, %xmm2

vorps             %ymm0, %ymm1, %ymm2
vorps             (%rax), %ymm1, %ymm2

vpabsb            %xmm0, %xmm2
vpabsb            (%rax), %xmm2

vpabsd            %xmm0, %xmm2
vpabsd            (%rax), %xmm2

vpabsw            %xmm0, %xmm2
vpabsw            (%rax), %xmm2

vpackssdw         %xmm0, %xmm1, %xmm2
vpackssdw         (%rax), %xmm1, %xmm2

vpacksswb         %xmm0, %xmm1, %xmm2
vpacksswb         (%rax), %xmm1, %xmm2

vpackusdw         %xmm0, %xmm1, %xmm2
vpackusdw         (%rax), %xmm1, %xmm2

vpackuswb         %xmm0, %xmm1, %xmm2
vpackuswb         (%rax), %xmm1, %xmm2

vpaddb            %xmm0, %xmm1, %xmm2
vpaddb            (%rax), %xmm1, %xmm2

vpaddd            %xmm0, %xmm1, %xmm2
vpaddd            (%rax), %xmm1, %xmm2

vpaddq            %xmm0, %xmm1, %xmm2
vpaddq            (%rax), %xmm1, %xmm2

vpaddsb           %xmm0, %xmm1, %xmm2
vpaddsb           (%rax), %xmm1, %xmm2

vpaddsw           %xmm0, %xmm1, %xmm2
vpaddsw           (%rax), %xmm1, %xmm2

vpaddusb          %xmm0, %xmm1, %xmm2
vpaddusb          (%rax), %xmm1, %xmm2

vpaddusw          %xmm0, %xmm1, %xmm2
vpaddusw          (%rax), %xmm1, %xmm2

vpaddw            %xmm0, %xmm1, %xmm2
vpaddw            (%rax), %xmm1, %xmm2

vpalignr          $1, %xmm0, %xmm1, %xmm2
vpalignr          $1, (%rax), %xmm1, %xmm2

vpand             %xmm0, %xmm1, %xmm2
vpand             (%rax), %xmm1, %xmm2

vpandn            %xmm0, %xmm1, %xmm2
vpandn            (%rax), %xmm1, %xmm2

vpavgb            %xmm0, %xmm1, %xmm2
vpavgb            (%rax), %xmm1, %xmm2

vpavgw            %xmm0, %xmm1, %xmm2
vpavgw            (%rax), %xmm1, %xmm2

vpblendvb         %xmm3, %xmm0, %xmm1, %xmm2
vpblendvb         %xmm3, (%rax), %xmm1, %xmm2

vpblendw          $11, %xmm0, %xmm1, %xmm2
vpblendw          $11, (%rax), %xmm1, %xmm2

vpclmulqdq        $11, %xmm0, %xmm1, %xmm2
vpclmulqdq        $11, (%rax), %xmm1, %xmm2

vpcmpeqb          %xmm0, %xmm1, %xmm2
vpcmpeqb          (%rax), %xmm1, %xmm2

vpcmpeqd          %xmm0, %xmm1, %xmm2
vpcmpeqd          (%rax), %xmm1, %xmm2

vpcmpeqq          %xmm0, %xmm1, %xmm2
vpcmpeqq          (%rax), %xmm1, %xmm2

vpcmpeqw          %xmm0, %xmm1, %xmm2
vpcmpeqw          (%rax), %xmm1, %xmm2

vpcmpestri        $1, %xmm0, %xmm2
vpcmpestri        $1, (%rax), %xmm2

vpcmpestrm        $1, %xmm0, %xmm2
vpcmpestrm        $1, (%rax), %xmm2

vpcmpgtb          %xmm0, %xmm1, %xmm2
vpcmpgtb          (%rax), %xmm1, %xmm2

vpcmpgtd          %xmm0, %xmm1, %xmm2
vpcmpgtd          (%rax), %xmm1, %xmm2

vpcmpgtq          %xmm0, %xmm1, %xmm2
vpcmpgtq          (%rax), %xmm1, %xmm2

vpcmpgtw          %xmm0, %xmm1, %xmm2
vpcmpgtw          (%rax), %xmm1, %xmm2

vpcmpistri        $1, %xmm0, %xmm2
vpcmpistri        $1, (%rax), %xmm2

vpcmpistrm        $1, %xmm0, %xmm2
vpcmpistrm        $1, (%rax), %xmm2

vperm2f128        $1, %ymm0, %ymm1, %ymm2
vperm2f128        $1, (%rax), %ymm1, %ymm2

vpermilpd         $1, %xmm0, %xmm2
vpermilpd         $1, (%rax), %xmm2
vpermilpd         %xmm0, %xmm1, %xmm2
vpermilpd         (%rax), %xmm1, %xmm2

vpermilpd         $1, %ymm0, %ymm2
vpermilpd         $1, (%rax), %ymm2
vpermilpd         %ymm0, %ymm1, %ymm2
vpermilpd         (%rax), %ymm1, %ymm2

vpermilps         $1, %xmm0, %xmm2
vpermilps         $1, (%rax), %xmm2
vpermilps         %xmm0, %xmm1, %xmm2
vpermilps         (%rax), %xmm1, %xmm2

vpermilps         $1, %ymm0, %ymm2
vpermilps         $1, (%rax), %ymm2
vpermilps         %ymm0, %ymm1, %ymm2
vpermilps         (%rax), %ymm1, %ymm2

vpextrb           $1, %xmm0, %ecx
vpextrb           $1, %xmm0, (%rax)

vpextrd           $1, %xmm0, %ecx
vpextrd           $1, %xmm0, (%rax)

vpextrq           $1, %xmm0, %rcx
vpextrq           $1, %xmm0, (%rax)

vpextrw           $1, %xmm0, %ecx
vpextrw           $1, %xmm0, (%rax)

vphaddd           %xmm0, %xmm1, %xmm2
vphaddd           (%rax), %xmm1, %xmm2

vphaddsw          %xmm0, %xmm1, %xmm2
vphaddsw          (%rax), %xmm1, %xmm2

vphaddw           %xmm0, %xmm1, %xmm2
vphaddw           (%rax), %xmm1, %xmm2

vphminposuw       %xmm0, %xmm2
vphminposuw       (%rax), %xmm2

vphsubd           %xmm0, %xmm1, %xmm2
vphsubd           (%rax), %xmm1, %xmm2

vphsubsw          %xmm0, %xmm1, %xmm2
vphsubsw          (%rax), %xmm1, %xmm2

vphsubw           %xmm0, %xmm1, %xmm2
vphsubw           (%rax), %xmm1, %xmm2

vpinsrb           $1, %eax, %xmm1, %xmm2
vpinsrb           $1, (%rax), %xmm1, %xmm2

vpinsrd           $1, %eax, %xmm1, %xmm2
vpinsrd           $1, (%rax), %xmm1, %xmm2

vpinsrq           $1, %rax, %xmm1, %xmm2
vpinsrq           $1, (%rax), %xmm1, %xmm2

vpinsrw           $1, %eax, %xmm1, %xmm2
vpinsrw           $1, (%rax), %xmm1, %xmm2

vpmaddubsw        %xmm0, %xmm1, %xmm2
vpmaddubsw        (%rax), %xmm1, %xmm2

vpmaddwd          %xmm0, %xmm1, %xmm2
vpmaddwd          (%rax), %xmm1, %xmm2

vpmaxsb           %xmm0, %xmm1, %xmm2
vpmaxsb           (%rax), %xmm1, %xmm2

vpmaxsd           %xmm0, %xmm1, %xmm2
vpmaxsd           (%rax), %xmm1, %xmm2

vpmaxsw           %xmm0, %xmm1, %xmm2
vpmaxsw           (%rax), %xmm1, %xmm2

vpmaxub           %xmm0, %xmm1, %xmm2
vpmaxub           (%rax), %xmm1, %xmm2

vpmaxud           %xmm0, %xmm1, %xmm2
vpmaxud           (%rax), %xmm1, %xmm2

vpmaxuw           %xmm0, %xmm1, %xmm2
vpmaxuw           (%rax), %xmm1, %xmm2

vpminsb           %xmm0, %xmm1, %xmm2
vpminsb           (%rax), %xmm1, %xmm2

vpminsd           %xmm0, %xmm1, %xmm2
vpminsd           (%rax), %xmm1, %xmm2

vpminsw           %xmm0, %xmm1, %xmm2
vpminsw           (%rax), %xmm1, %xmm2

vpminub           %xmm0, %xmm1, %xmm2
vpminub           (%rax), %xmm1, %xmm2

vpminud           %xmm0, %xmm1, %xmm2
vpminud           (%rax), %xmm1, %xmm2

vpminuw           %xmm0, %xmm1, %xmm2
vpminuw           (%rax), %xmm1, %xmm2

vpmovmskb         %xmm0, %rcx

vpmovsxbd         %xmm0, %xmm2
vpmovsxbd         (%rax), %xmm2

vpmovsxbq         %xmm0, %xmm2
vpmovsxbq         (%rax), %xmm2

vpmovsxbw         %xmm0, %xmm2
vpmovsxbw         (%rax), %xmm2

vpmovsxdq         %xmm0, %xmm2
vpmovsxdq         (%rax), %xmm2

vpmovsxwd         %xmm0, %xmm2
vpmovsxwd         (%rax), %xmm2

vpmovsxwq         %xmm0, %xmm2
vpmovsxwq         (%rax), %xmm2

vpmovzxbd         %xmm0, %xmm2
vpmovzxbd         (%rax), %xmm2

vpmovzxbq         %xmm0, %xmm2
vpmovzxbq         (%rax), %xmm2

vpmovzxbw         %xmm0, %xmm2
vpmovzxbw         (%rax), %xmm2

vpmovzxdq         %xmm0, %xmm2
vpmovzxdq         (%rax), %xmm2

vpmovzxwd         %xmm0, %xmm2
vpmovzxwd         (%rax), %xmm2

vpmovzxwq         %xmm0, %xmm2
vpmovzxwq         (%rax), %xmm2

vpmuldq           %xmm0, %xmm1, %xmm2
vpmuldq           (%rax), %xmm1, %xmm2

vpmulhrsw         %xmm0, %xmm1, %xmm2
vpmulhrsw         (%rax), %xmm1, %xmm2

vpmulhuw          %xmm0, %xmm1, %xmm2
vpmulhuw          (%rax), %xmm1, %xmm2

vpmulhw           %xmm0, %xmm1, %xmm2
vpmulhw           (%rax), %xmm1, %xmm2

vpmulld           %xmm0, %xmm1, %xmm2
vpmulld           (%rax), %xmm1, %xmm2

vpmullw           %xmm0, %xmm1, %xmm2
vpmullw           (%rax), %xmm1, %xmm2

vpmuludq          %xmm0, %xmm1, %xmm2
vpmuludq          (%rax), %xmm1, %xmm2

vpor              %xmm0, %xmm1, %xmm2
vpor              (%rax), %xmm1, %xmm2

vpsadbw           %xmm0, %xmm1, %xmm2
vpsadbw           (%rax), %xmm1, %xmm2

vpshufb           %xmm0, %xmm1, %xmm2
vpshufb           (%rax), %xmm1, %xmm2

vpshufd           $1, %xmm0, %xmm2
vpshufd           $1, (%rax), %xmm2

vpshufhw          $1, %xmm0, %xmm2
vpshufhw          $1, (%rax), %xmm2

vpshuflw          $1, %xmm0, %xmm2
vpshuflw          $1, (%rax), %xmm2

vpsignb           %xmm0, %xmm1, %xmm2
vpsignb           (%rax), %xmm1, %xmm2

vpsignd           %xmm0, %xmm1, %xmm2
vpsignd           (%rax), %xmm1, %xmm2

vpsignw           %xmm0, %xmm1, %xmm2
vpsignw           (%rax), %xmm1, %xmm2

vpslld            $1, %xmm0, %xmm2
vpslld            %xmm0, %xmm1, %xmm2
vpslld            (%rax), %xmm1, %xmm2

vpslldq           $1, %xmm1, %xmm2

vpsllq            $1, %xmm0, %xmm2
vpsllq            %xmm0, %xmm1, %xmm2
vpsllq            (%rax), %xmm1, %xmm2

vpsllw            $1, %xmm0, %xmm2
vpsllw            %xmm0, %xmm1, %xmm2
vpsllw            (%rax), %xmm1, %xmm2

vpsrad            $1, %xmm0, %xmm2
vpsrad            %xmm0, %xmm1, %xmm2
vpsrad            (%rax), %xmm1, %xmm2

vpsraw            $1, %xmm0, %xmm2
vpsraw            %xmm0, %xmm1, %xmm2
vpsraw            (%rax), %xmm1, %xmm2

vpsrld            $1, %xmm0, %xmm2
vpsrld            %xmm0, %xmm1, %xmm2
vpsrld            (%rax), %xmm1, %xmm2

vpsrldq           $1, %xmm1, %xmm2

vpsrlq            $1, %xmm0, %xmm2
vpsrlq            %xmm0, %xmm1, %xmm2
vpsrlq            (%rax), %xmm1, %xmm2

vpsrlw            $1, %xmm0, %xmm2
vpsrlw            %xmm0, %xmm1, %xmm2
vpsrlw            (%rax), %xmm1, %xmm2

vpsubb            %xmm0, %xmm1, %xmm2
vpsubb            (%rax), %xmm1, %xmm2

vpsubd            %xmm0, %xmm1, %xmm2
vpsubd            (%rax), %xmm1, %xmm2

vpsubq            %xmm0, %xmm1, %xmm2
vpsubq            (%rax), %xmm1, %xmm2

vpsubsb           %xmm0, %xmm1, %xmm2
vpsubsb           (%rax), %xmm1, %xmm2

vpsubsw           %xmm0, %xmm1, %xmm2
vpsubsw           (%rax), %xmm1, %xmm2

vpsubusb          %xmm0, %xmm1, %xmm2
vpsubusb          (%rax), %xmm1, %xmm2

vpsubusw          %xmm0, %xmm1, %xmm2
vpsubusw          (%rax), %xmm1, %xmm2

vpsubw            %xmm0, %xmm1, %xmm2
vpsubw            (%rax), %xmm1, %xmm2

vptest            %xmm0, %xmm1
vptest            (%rax), %xmm1

vptest            %ymm0, %ymm1
vptest            (%rax), %ymm1

vpunpckhbw        %xmm0, %xmm1, %xmm2
vpunpckhbw        (%rax), %xmm1, %xmm2

vpunpckhdq        %xmm0, %xmm1, %xmm2
vpunpckhdq        (%rax), %xmm1, %xmm2

vpunpckhqdq       %xmm0, %xmm1, %xmm2
vpunpckhqdq       (%rax), %xmm1, %xmm2

vpunpckhwd        %xmm0, %xmm1, %xmm2
vpunpckhwd        (%rax), %xmm1, %xmm2

vpunpcklbw        %xmm0, %xmm1, %xmm2
vpunpcklbw        (%rax), %xmm1, %xmm2

vpunpckldq        %xmm0, %xmm1, %xmm2
vpunpckldq        (%rax), %xmm1, %xmm2

vpunpcklqdq       %xmm0, %xmm1, %xmm2
vpunpcklqdq       (%rax), %xmm1, %xmm2

vpunpcklwd        %xmm0, %xmm1, %xmm2
vpunpcklwd        (%rax), %xmm1, %xmm2

vpxor             %xmm0, %xmm1, %xmm2
vpxor             (%rax), %xmm1, %xmm2

vrcpps            %xmm0, %xmm2
vrcpps            (%rax), %xmm2

vrcpps            %ymm0, %ymm2
vrcpps            (%rax), %ymm2

vrcpss            %xmm0, %xmm1, %xmm2
vrcpss            (%rax), %xmm1, %xmm2

vroundpd          $1, %xmm0, %xmm2
vroundpd          $1, (%rax), %xmm2

vroundpd          $1, %ymm0, %ymm2
vroundpd          $1, (%rax), %ymm2

vroundps          $1, %xmm0, %xmm2
vroundps          $1, (%rax), %xmm2

vroundps          $1, %ymm0, %ymm2
vroundps          $1, (%rax), %ymm2

vroundsd          $1, %xmm0, %xmm1, %xmm2
vroundsd          $1, (%rax), %xmm1, %xmm2

vroundss          $1, %xmm0, %xmm1, %xmm2
vroundss          $1, (%rax), %xmm1, %xmm2

vrsqrtps          %xmm0, %xmm2
vrsqrtps          (%rax), %xmm2

vrsqrtps          %ymm0, %ymm2
vrsqrtps          (%rax), %ymm2

vrsqrtss          %xmm0, %xmm1, %xmm2
vrsqrtss          (%rax), %xmm1, %xmm2

vshufpd           $1, %xmm0, %xmm1, %xmm2
vshufpd           $1, (%rax), %xmm1, %xmm2

vshufpd           $1, %ymm0, %ymm1, %ymm2
vshufpd           $1, (%rax), %ymm1, %ymm2

vshufps           $1, %xmm0, %xmm1, %xmm2
vshufps           $1, (%rax), %xmm1, %xmm2

vshufps           $1, %ymm0, %ymm1, %ymm2
vshufps           $1, (%rax), %ymm1, %ymm2

vsqrtpd           %xmm0, %xmm2
vsqrtpd           (%rax), %xmm2

vsqrtpd           %ymm0, %ymm2
vsqrtpd           (%rax), %ymm2

vsqrtps           %xmm0, %xmm2
vsqrtps           (%rax), %xmm2

vsqrtps           %ymm0, %ymm2
vsqrtps           (%rax), %ymm2

vsqrtsd           %xmm0, %xmm1, %xmm2
vsqrtsd           (%rax), %xmm1, %xmm2

vsqrtss           %xmm0, %xmm1, %xmm2
vsqrtss           (%rax), %xmm1, %xmm2

vstmxcsr          (%rax)

vsubpd            %xmm0, %xmm1, %xmm2
vsubpd            (%rax), %xmm1, %xmm2

vsubpd            %ymm0, %ymm1, %ymm2
vsubpd            (%rax), %ymm1, %ymm2

vsubps            %xmm0, %xmm1, %xmm2
vsubps            (%rax), %xmm1, %xmm2

vsubps            %ymm0, %ymm1, %ymm2
vsubps            (%rax), %ymm1, %ymm2

vsubsd            %xmm0, %xmm1, %xmm2
vsubsd            (%rax), %xmm1, %xmm2

vsubss            %xmm0, %xmm1, %xmm2
vsubss            (%rax), %xmm1, %xmm2

vtestpd          %xmm0, %xmm1
vtestpd          (%rax), %xmm1

vtestpd          %ymm0, %ymm1
vtestpd          (%rax), %ymm1

vtestps          %xmm0, %xmm1
vtestps          (%rax), %xmm1

vtestps          %ymm0, %ymm1
vtestps          (%rax), %ymm1

vucomisd          %xmm0, %xmm1
vucomisd          (%rax), %xmm1

vucomiss          %xmm0, %xmm1
vucomiss          (%rax), %xmm1

vunpckhpd         %xmm0, %xmm1, %xmm2
vunpckhpd         (%rax), %xmm1, %xmm2

vunpckhpd         %ymm0, %ymm1, %ymm2
vunpckhpd         (%rax), %ymm1, %ymm2

vunpckhps         %xmm0, %xmm1, %xmm2
vunpckhps         (%rax), %xmm1, %xmm2

vunpckhps         %ymm0, %ymm1, %ymm2
vunpckhps         (%rax), %ymm1, %ymm2

vunpcklpd         %xmm0, %xmm1, %xmm2
vunpcklpd         (%rax), %xmm1, %xmm2

vunpcklpd         %ymm0, %ymm1, %ymm2
vunpcklpd         (%rax), %ymm1, %ymm2

vunpcklps         %xmm0, %xmm1, %xmm2
vunpcklps         (%rax), %xmm1, %xmm2

vunpcklps         %ymm0, %ymm1, %ymm2
vunpcklps         (%rax), %ymm1, %ymm2

vxorpd            %xmm0, %xmm1, %xmm2
vxorpd            (%rax), %xmm1, %xmm2

vxorpd            %ymm0, %ymm1, %ymm2
vxorpd            (%rax), %ymm1, %ymm2

vxorps            %xmm0, %xmm1, %xmm2
vxorps            (%rax), %xmm1, %xmm2

vxorps            %ymm0, %ymm1, %ymm2
vxorps            (%rax), %ymm1, %ymm2

vzeroall
vzeroupper

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        vaddpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vaddpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vaddpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vaddps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vaddps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vaddps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vaddsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.50                        vaddss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.50                        vaddsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vaddsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vaddsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vaddsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vaddsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vaddsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vaddsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      4     0.50                        vaesdec	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaesdec	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     0.50                        vaesdeclast	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaesdeclast	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     0.50                        vaesenc	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaesenc	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     0.50                        vaesenclast	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaesenclast	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     0.50                        vaesimc	%xmm0, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaesimc	(%rax), %xmm2
# CHECK-NEXT:  1      4     0.50                        vaeskeygenassist	$22, %xmm0, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vaeskeygenassist	$22, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vandnpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vandnpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vandnpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vandnpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vandnps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vandnps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vandnps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vandnps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vandpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vandpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vandpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vandpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vandps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vandps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vandps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vandps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vblendpd	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vblendpd	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vblendpd	$11, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      8     0.50    *                   vblendpd	$11, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vblendps	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vblendps	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vblendps	$11, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      8     0.50    *                   vblendps	$11, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vblendvpd	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vblendvpd	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vblendvpd	%ymm3, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vblendvpd	%ymm3, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vblendvps	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vblendvps	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vblendvps	%ymm3, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vblendvps	%ymm3, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vbroadcastf128	(%rax), %ymm2
# CHECK-NEXT:  1      8     0.50    *                   vbroadcastsd	(%rax), %ymm2
# CHECK-NEXT:  1      8     0.50    *                   vbroadcastss	(%rax), %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vbroadcastss	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.50                        vcmpeqpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vcmpeqpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vcmpeqpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vcmpeqpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vcmpeqps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vcmpeqps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vcmpeqps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vcmpeqps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vcmpeqsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vcmpeqsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vcmpeqss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vcmpeqss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vcomisd	%xmm0, %xmm1
# CHECK-NEXT:  2      10    1.00    *                   vcomisd	(%rax), %xmm1
# CHECK-NEXT:  2      3     1.00                        vcomiss	%xmm0, %xmm1
# CHECK-NEXT:  2      10    1.00    *                   vcomiss	(%rax), %xmm1
# CHECK-NEXT:  1      5     1.00                        vcvtdq2pd	%xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtdq2pd	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtdq2pd	%xmm0, %ymm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtdq2pd	(%rax), %ymm2
# CHECK-NEXT:  1      5     1.00                        vcvtdq2ps	%xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtdq2ps	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtdq2ps	%ymm0, %ymm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtdq2ps	(%rax), %ymm2
# CHECK-NEXT:  1      5     1.00                        vcvtpd2dq	%xmm0, %xmm2
# CHECK-NEXT:  2      12    1.00    *                   vcvtpd2dqx	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtpd2dq	%ymm0, %xmm2
# CHECK-NEXT:  2      12    1.00    *                   vcvtpd2dqy	(%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        vcvtpd2ps	%xmm0, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vcvtpd2psx	(%rax), %xmm2
# CHECK-NEXT:  2      5     2.00                        vcvtpd2ps	%ymm0, %xmm2
# CHECK-NEXT:  2      11    2.00    *                   vcvtpd2psy	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtps2dq	%xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtps2dq	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtps2dq	%ymm0, %ymm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtps2dq	(%rax), %ymm2
# CHECK-NEXT:  1      3     1.00                        vcvtps2pd	%xmm0, %xmm2
# CHECK-NEXT:  2      10    1.00    *                   vcvtps2pd	(%rax), %xmm2
# CHECK-NEXT:  1      3     1.00                        vcvtps2pd	%xmm0, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vcvtps2pd	(%rax), %ymm2
# CHECK-NEXT:  1      5     1.00                        vcvtsd2si	%xmm0, %ecx
# CHECK-NEXT:  1      5     1.00                        vcvtsd2si	%xmm0, %rcx
# CHECK-NEXT:  1      12    1.00    *                   vcvtsd2si	(%rax), %ecx
# CHECK-NEXT:  1      12    1.00    *                   vcvtsd2si	(%rax), %rcx
# CHECK-NEXT:  1      4     1.00                        vcvtsd2ss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vcvtsd2ss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtsi2sd	%ecx, %xmm0, %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtsi2sd	%rcx, %xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtsi2sdl	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtsi2sdq	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtsi2ss	%ecx, %xmm0, %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtsi2ss	%rcx, %xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtsi2ssl	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvtsi2ssq	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  1      4     1.00                        vcvtss2sd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  2      11    2.00    *                   vcvtss2sd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvtss2si	%xmm0, %ecx
# CHECK-NEXT:  1      5     1.00                        vcvtss2si	%xmm0, %rcx
# CHECK-NEXT:  2      12    1.00    *                   vcvtss2si	(%rax), %ecx
# CHECK-NEXT:  2      12    1.00    *                   vcvtss2si	(%rax), %rcx
# CHECK-NEXT:  1      5     1.00                        vcvttpd2dq	%xmm0, %xmm2
# CHECK-NEXT:  2      12    1.00    *                   vcvttpd2dqx	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvttpd2dq	%ymm0, %xmm2
# CHECK-NEXT:  2      12    1.00    *                   vcvttpd2dqy	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvttps2dq	%xmm0, %xmm2
# CHECK-NEXT:  1      12    1.00    *                   vcvttps2dq	(%rax), %xmm2
# CHECK-NEXT:  1      5     1.00                        vcvttps2dq	%ymm0, %ymm2
# CHECK-NEXT:  1      12    1.00    *                   vcvttps2dq	(%rax), %ymm2
# CHECK-NEXT:  1      5     1.00                        vcvttsd2si	%xmm0, %ecx
# CHECK-NEXT:  1      5     1.00                        vcvttsd2si	%xmm0, %rcx
# CHECK-NEXT:  1      12    1.00    *                   vcvttsd2si	(%rax), %ecx
# CHECK-NEXT:  1      12    1.00    *                   vcvttsd2si	(%rax), %rcx
# CHECK-NEXT:  1      5     1.00                        vcvttss2si	%xmm0, %ecx
# CHECK-NEXT:  1      5     1.00                        vcvttss2si	%xmm0, %rcx
# CHECK-NEXT:  2      12    1.00    *                   vcvttss2si	(%rax), %ecx
# CHECK-NEXT:  2      12    1.00    *                   vcvttss2si	(%rax), %rcx
# CHECK-NEXT:  1      13    5.00                        vdivpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      20    5.00    *                   vdivpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      15    9.00                        vdivpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      22    9.00    *                   vdivpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      10    3.00                        vdivps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      17    3.00    *                   vdivps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      10    6.00                        vdivps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      17    6.00    *                   vdivps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      13    5.00                        vdivsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      20    5.00    *                   vdivsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      10    3.00                        vdivss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      17    3.00    *                   vdivss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vdppd	$22, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vdppd	$22, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vdpps	$22, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vdpps	$22, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vdpps	$22, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      100   0.25    *                   vdpps	$22, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.33                        vextractf128	$1, %ymm0, %xmm2
# CHECK-NEXT:  2      8     0.50           *            vextractf128	$1, %ymm0, (%rax)
# CHECK-NEXT:  2      2     2.00                        vextractps	$1, %xmm0, %ecx
# CHECK-NEXT:  2      5     2.50           *            vextractps	$1, %xmm0, (%rax)
# CHECK-NEXT:  1      7     0.25                        vhaddpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      14    0.50    *                   vhaddpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      7     0.25                        vhaddpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      14    0.50    *                   vhaddpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      7     0.25                        vhaddps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      14    0.50    *                   vhaddps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      7     0.25                        vhaddps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      14    0.50    *                   vhaddps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      7     0.25                        vhsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      14    0.50    *                   vhsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      7     0.25                        vhsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      14    0.50    *                   vhsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      7     0.25                        vhsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      14    0.50    *                   vhsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      7     0.25                        vhsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      14    0.50    *                   vhsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      2     0.67                        vinsertf128	$1, %xmm0, %ymm1, %ymm2
# CHECK-NEXT:  2      9     0.67    *                   vinsertf128	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vinsertps	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vinsertps	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vlddqu	(%rax), %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vlddqu	(%rax), %ymm2
# CHECK-NEXT:  1      100   0.25    *      *      U     vldmxcsr	(%rax)
# CHECK-NEXT:  1      100   0.25    *      *      U     vmaskmovdqu	%xmm0, %xmm1
# CHECK-NEXT:  1      8     0.50    *                   vmaskmovpd	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  2      8     1.00    *                   vmaskmovpd	(%rax), %ymm0, %ymm2
# CHECK-NEXT:  1      4     0.50    *      *            vmaskmovpd	%xmm0, %xmm1, (%rax)
# CHECK-NEXT:  2      5     1.00    *      *            vmaskmovpd	%ymm0, %ymm1, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmaskmovps	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  2      8     1.00    *                   vmaskmovps	(%rax), %ymm0, %ymm2
# CHECK-NEXT:  1      4     0.50    *      *            vmaskmovps	%xmm0, %xmm1, (%rax)
# CHECK-NEXT:  2      5     1.00    *      *            vmaskmovps	%ymm0, %ymm1, (%rax)
# CHECK-NEXT:  1      1     0.50                        vmaxpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmaxpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vmaxpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vmaxpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vmaxps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmaxps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vmaxps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vmaxps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vmaxsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmaxsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vmaxss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmaxss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vminpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vminpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vminpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vminpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vminps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vminps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vminps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vminps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vminsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vminsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vminss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vminss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovapd	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovapd	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovapd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovapd	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovapd	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovapd	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.25                        vmovaps	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovaps	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovaps	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovaps	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovaps	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovaps	(%rax), %ymm2
# CHECK-NEXT:  1      3     1.00                        vmovd	%eax, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovd	(%rax), %xmm2
# CHECK-NEXT:  1      2     1.00                        vmovd	%xmm0, %ecx
# CHECK-NEXT:  1      1     0.50           *            vmovd	%xmm0, (%rax)
# CHECK-NEXT:  1      1     0.50                        vmovddup	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovddup	(%rax), %xmm2
# CHECK-NEXT:  2      1     1.00                        vmovddup	%ymm0, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vmovddup	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.25                        vmovdqa	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovdqa	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovdqa	(%rax), %xmm2
# CHECK-NEXT:  2      2     0.25                        vmovdqa	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovdqa	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovdqa	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.25                        vmovdqu	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovdqu	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu	(%rax), %xmm2
# CHECK-NEXT:  2      2     0.25                        vmovdqu	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovdqu	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovdqu	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.50                        vmovhlps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vmovlhps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovhpd	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovhpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovhps	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovhps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovlpd	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovlpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovlps	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovlps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vmovmskpd	%xmm0, %ecx
# CHECK-NEXT:  1      1     1.00                        vmovmskpd	%ymm0, %ecx
# CHECK-NEXT:  1      1     1.00                        vmovmskps	%xmm0, %ecx
# CHECK-NEXT:  1      1     1.00                        vmovmskps	%ymm0, %ecx
# CHECK-NEXT:  1      1     0.50           *            vmovntdq	%xmm0, (%rax)
# CHECK-NEXT:  1      1     0.50           *            vmovntdq	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovntdqa	(%rax), %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovntdqa	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovntpd	%xmm0, (%rax)
# CHECK-NEXT:  1      1     0.50           *            vmovntpd	%ymm0, (%rax)
# CHECK-NEXT:  1      1     0.50           *            vmovntps	%xmm0, (%rax)
# CHECK-NEXT:  1      1     0.50           *            vmovntps	%ymm0, (%rax)
# CHECK-NEXT:  1      1     0.25                        vmovq	%xmm0, %xmm2
# CHECK-NEXT:  1      3     1.00                        vmovq	%rax, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovq	(%rax), %xmm2
# CHECK-NEXT:  1      2     1.00                        vmovq	%xmm0, %rcx
# CHECK-NEXT:  1      1     0.50           *            vmovq	%xmm0, (%rax)
# CHECK-NEXT:  1      1     0.50                        vmovsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovsd	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovsd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vmovshdup	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovshdup	(%rax), %xmm2
# CHECK-NEXT:  2      1     1.00                        vmovshdup	%ymm0, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vmovshdup	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.50                        vmovsldup	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vmovsldup	(%rax), %xmm2
# CHECK-NEXT:  2      1     1.00                        vmovsldup	%ymm0, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vmovsldup	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.50                        vmovss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovss	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovss	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovupd	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovupd	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovupd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovupd	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovupd	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovupd	(%rax), %ymm2
# CHECK-NEXT:  1      1     0.25                        vmovups	%xmm0, %xmm2
# CHECK-NEXT:  1      1     0.50           *            vmovups	%xmm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovups	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.25                        vmovups	%ymm0, %ymm2
# CHECK-NEXT:  1      1     0.50           *            vmovups	%ymm0, (%rax)
# CHECK-NEXT:  1      8     0.50    *                   vmovups	(%rax), %ymm2
# CHECK-NEXT:  1      100   0.25                        vmpsadbw	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vmpsadbw	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     0.50                        vmulpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vmulpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      4     1.00                        vmulpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      11    1.00    *                   vmulpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vmulps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vmulps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vmulps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      4     0.50                        vmulsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    0.50    *                   vmulsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.50                        vmulss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vmulss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vorpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vorpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vorpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vorpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vorps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vorps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vorps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vorps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.33                        vpabsb	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpabsb	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.33                        vpabsd	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpabsd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.33                        vpabsw	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpabsw	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpackssdw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpackssdw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpacksswb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpacksswb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpackusdw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpackusdw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpackuswb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpackuswb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddusb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddusb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddusw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddusw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpaddw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpaddw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpalignr	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpalignr	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpand	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpand	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpandn	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpandn	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpavgb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpavgb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpavgw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpavgw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpblendvb	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpblendvb	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpblendw	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpblendw	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vpclmulqdq	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vpclmulqdq	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpeqb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpeqd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpeqq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpeqw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpeqw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vpcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vpcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT:  1      100   0.25                        vpcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vpcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpgtb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpgtd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpcmpgtq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpcmpgtw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpcmpgtw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25                        vpcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vpcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT:  1      100   0.25                        vpcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      100   0.25    *                   vpcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  1      100   0.25                        vperm2f128	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  1      100   0.25    *                   vperm2f128	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vpermilpd	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpermilpd	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpermilpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpermilpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vpermilpd	$1, %ymm0, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vpermilpd	$1, (%rax), %ymm2
# CHECK-NEXT:  2      1     1.00                        vpermilpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vpermilpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vpermilps	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpermilps	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpermilps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpermilps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vpermilps	$1, %ymm0, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vpermilps	$1, (%rax), %ymm2
# CHECK-NEXT:  2      1     1.00                        vpermilps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vpermilps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      2     2.00                        vpextrb	$1, %xmm0, %ecx
# CHECK-NEXT:  2      5     3.00           *            vpextrb	$1, %xmm0, (%rax)
# CHECK-NEXT:  1      2     2.00                        vpextrd	$1, %xmm0, %ecx
# CHECK-NEXT:  2      5     3.00           *            vpextrd	$1, %xmm0, (%rax)
# CHECK-NEXT:  1      2     2.00                        vpextrq	$1, %xmm0, %rcx
# CHECK-NEXT:  2      5     3.00           *            vpextrq	$1, %xmm0, (%rax)
# CHECK-NEXT:  1      2     2.00                        vpextrw	$1, %xmm0, %ecx
# CHECK-NEXT:  2      5     3.00           *            vpextrw	$1, %xmm0, (%rax)
# CHECK-NEXT:  1      3     0.25                        vphaddd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphaddd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.25                        vphaddsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphaddsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.25                        vphaddw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphaddw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vphminposuw	%xmm0, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vphminposuw	(%rax), %xmm2
# CHECK-NEXT:  1      3     0.25                        vphsubd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphsubd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.25                        vphsubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphsubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.25                        vphsubw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vphsubw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpinsrb	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpinsrb	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpinsrd	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpinsrd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpinsrq	$1, %rax, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpinsrq	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpinsrw	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpinsrw	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmaddubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmaddubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmaddwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmaddwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxub	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxub	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxud	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxud	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpmaxuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmaxuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminub	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminub	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminud	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminud	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpminuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpminuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpmovmskb	%xmm0, %ecx
# CHECK-NEXT:  1      1     0.50                        vpmovsxbd	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxbd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovsxbq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxbq	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovsxbw	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxbw	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovsxdq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxdq	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovsxwd	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxwd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovsxwq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovsxwq	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxbd	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxbd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxbq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxbq	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxbw	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxbw	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxdq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxdq	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxwd	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxwd	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpmovzxwq	%xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpmovzxwq	(%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmuldq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmuldq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmulhrsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmulhrsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmulhuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmulhuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmulhw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmulhw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     2.00                        vpmulld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    2.00    *                   vpmulld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmullw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmullw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vpmuludq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      11    1.00    *                   vpmuludq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpor	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpor	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     1.00                        vpsadbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    1.00    *                   vpsadbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpshufb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpshufb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpshufd	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpshufd	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpshufhw	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpshufhw	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        vpshuflw	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpshuflw	$1, (%rax), %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsignb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsignb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsignd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsignd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsignw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsignw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpslld	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpslld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpslld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpslldq	$1, %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsllq	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsllq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsllq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsllw	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsllw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsllw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrad	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrad	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsrad	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsraw	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsraw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsraw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrld	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsrld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpsrldq	$1, %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrlq	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrlq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsrlq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrlw	$1, %xmm0, %xmm2
# CHECK-NEXT:  1      1     1.00                        vpsrlw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     1.00    *                   vpsrlw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubusb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubusb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubusw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubusw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.33                        vpsubw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpsubw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      2     1.00                        vptest	%xmm0, %xmm1
# CHECK-NEXT:  2      9     1.00    *                   vptest	(%rax), %xmm1
# CHECK-NEXT:  3      4     2.00                        vptest	%ymm0, %ymm1
# CHECK-NEXT:  5      11    2.00    *                   vptest	(%rax), %ymm1
# CHECK-NEXT:  1      1     0.50                        vpunpckhbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpckhbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpckhdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpckhdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpckhqdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpckhqdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpckhwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpckhwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpcklbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpcklbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpckldq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpckldq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpcklqdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpcklqdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vpunpcklwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpunpcklwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.25                        vpxor	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vpxor	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      5     0.50                        vrcpps	%xmm0, %xmm2
# CHECK-NEXT:  1      12    0.50    *                   vrcpps	(%rax), %xmm2
# CHECK-NEXT:  2      5     1.00                        vrcpps	%ymm0, %ymm2
# CHECK-NEXT:  2      12    1.00    *                   vrcpps	(%rax), %ymm2
# CHECK-NEXT:  1      5     0.50                        vrcpss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      12    0.50    *                   vrcpss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vroundpd	$1, %xmm0, %xmm2
# CHECK-NEXT:  2      11    1.00    *                   vroundpd	$1, (%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        vroundpd	$1, %ymm0, %ymm2
# CHECK-NEXT:  2      11    1.00    *                   vroundpd	$1, (%rax), %ymm2
# CHECK-NEXT:  1      4     1.00                        vroundps	$1, %xmm0, %xmm2
# CHECK-NEXT:  2      11    1.00    *                   vroundps	$1, (%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        vroundps	$1, %ymm0, %ymm2
# CHECK-NEXT:  2      11    1.00    *                   vroundps	$1, (%rax), %ymm2
# CHECK-NEXT:  1      4     1.00                        vroundsd	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  2      11    1.00    *                   vroundsd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      4     1.00                        vroundss	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  2      11    1.00    *                   vroundss	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      5     0.50                        vrsqrtps	%xmm0, %xmm2
# CHECK-NEXT:  1      12    0.50    *                   vrsqrtps	(%rax), %xmm2
# CHECK-NEXT:  2      5     1.00                        vrsqrtps	%ymm0, %ymm2
# CHECK-NEXT:  2      12    1.00    *                   vrsqrtps	(%rax), %ymm2
# CHECK-NEXT:  1      5     0.50                        vrsqrtss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      12    0.50    *                   vrsqrtss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      1     0.50                        vshufpd	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vshufpd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vshufpd	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vshufpd	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vshufps	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vshufps	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vshufps	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vshufps	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      20    8.00                        vsqrtpd	%xmm0, %xmm2
# CHECK-NEXT:  1      27    8.00    *                   vsqrtpd	(%rax), %xmm2
# CHECK-NEXT:  2      20    16.00                       vsqrtpd	%ymm0, %ymm2
# CHECK-NEXT:  2      27    16.00   *                   vsqrtpd	(%rax), %ymm2
# CHECK-NEXT:  1      14    5.00                        vsqrtps	%xmm0, %xmm2
# CHECK-NEXT:  1      21    5.00    *                   vsqrtps	(%rax), %xmm2
# CHECK-NEXT:  2      14    10.00                       vsqrtps	%ymm0, %ymm2
# CHECK-NEXT:  2      21    10.00   *                   vsqrtps	(%rax), %ymm2
# CHECK-NEXT:  1      20    8.00                        vsqrtsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      27    8.00    *                   vsqrtsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      14    5.00                        vsqrtss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      21    5.00    *                   vsqrtss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      100   0.25           *      U     vstmxcsr	(%rax)
# CHECK-NEXT:  1      3     0.50                        vsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      3     1.00                        vsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      10    1.00    *                   vsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      3     0.50                        vsubsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vsubsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      3     0.50                        vsubss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      10    0.50    *                   vsubss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  1      2     1.00                        vtestpd	%xmm0, %xmm1
# CHECK-NEXT:  2      9     1.00    *                   vtestpd	(%rax), %xmm1
# CHECK-NEXT:  3      4     2.00                        vtestpd	%ymm0, %ymm1
# CHECK-NEXT:  5      11    2.00    *                   vtestpd	(%rax), %ymm1
# CHECK-NEXT:  1      2     1.00                        vtestps	%xmm0, %xmm1
# CHECK-NEXT:  2      9     1.00    *                   vtestps	(%rax), %xmm1
# CHECK-NEXT:  3      4     2.00                        vtestps	%ymm0, %ymm1
# CHECK-NEXT:  5      11    2.00    *                   vtestps	(%rax), %ymm1
# CHECK-NEXT:  2      3     1.00                        vucomisd	%xmm0, %xmm1
# CHECK-NEXT:  2      10    1.00    *                   vucomisd	(%rax), %xmm1
# CHECK-NEXT:  2      3     1.00                        vucomiss	%xmm0, %xmm1
# CHECK-NEXT:  2      10    1.00    *                   vucomiss	(%rax), %xmm1
# CHECK-NEXT:  1      1     0.50                        vunpckhpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vunpckhpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vunpckhpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vunpckhpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vunpckhps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vunpckhps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vunpckhps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vunpckhps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vunpcklpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vunpcklpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vunpcklpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vunpcklpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.50                        vunpcklps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vunpcklps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     1.00                        vunpcklps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     1.00    *                   vunpcklps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vxorpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vxorpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vxorpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vxorpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      1     0.25                        vxorps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  1      8     0.50    *                   vxorps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  2      1     0.50                        vxorps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT:  2      8     0.50    *                   vxorps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  1      100   0.25                  U     vzeroall
# CHECK-NEXT:  1      100   0.25                  U     vzeroupper

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ZnAGU0
# CHECK-NEXT: [1]   - ZnAGU1
# CHECK-NEXT: [2]   - ZnALU0
# CHECK-NEXT: [3]   - ZnALU1
# CHECK-NEXT: [4]   - ZnALU2
# CHECK-NEXT: [5]   - ZnALU3
# CHECK-NEXT: [6]   - ZnDivider
# CHECK-NEXT: [7]   - ZnFPU0
# CHECK-NEXT: [8]   - ZnFPU1
# CHECK-NEXT: [9]   - ZnFPU2
# CHECK-NEXT: [10]  - ZnFPU3
# CHECK-NEXT: [11]  - ZnMultiplier

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]
# CHECK-NEXT: 175.00 175.00  -      -      -      -      -     144.25 227.25 223.75 315.75  -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vaddpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vaddpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vaddps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vaddps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vaddsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vaddsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vaddsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vaddsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vaddsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vaddsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaesdec	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaesdec	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaesdeclast	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaesdeclast	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaesenc	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaesenc	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaesenclast	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaesenclast	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaesimc	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaesimc	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vaeskeygenassist	$22, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vaeskeygenassist	$22, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandnpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandnpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandnpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandnpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandnps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandnps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandnps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandnps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vandps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vandps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendpd	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendpd	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendpd	$11, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendpd	$11, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendps	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendps	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendps	$11, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendps	$11, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendvpd	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendvpd	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vblendvpd	%ymm3, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vblendvpd	%ymm3, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vblendvps	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vblendvps	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vblendvps	%ymm3, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vblendvps	%ymm3, (%rax), %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50    -     0.50    -     vbroadcastf128	(%rax), %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vbroadcastsd	(%rax), %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vbroadcastss	(%rax), %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vbroadcastss	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vcmpeqpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vcmpeqpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vcmpeqps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vcmpeqps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vcmpeqss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   1.00    -      -     vcomisd	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   1.00    -      -     vcomisd	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   1.00    -      -     vcomiss	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   1.00    -      -     vcomiss	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtdq2pd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtdq2pd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtdq2pd	%xmm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtdq2pd	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtdq2ps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtdq2ps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtdq2ps	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtdq2ps	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtpd2dq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtpd2dqx	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtpd2dq	%ymm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtpd2dqy	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtpd2ps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtpd2psx	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     2.00    -     vcvtpd2ps	%ymm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     2.00    -     vcvtpd2psy	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtps2dq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtps2dq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtps2dq	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtps2dq	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtps2pd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtps2pd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtps2pd	%xmm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtps2pd	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vcvtsd2si	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vcvtsd2si	%xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vcvtsd2si	(%rax), %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vcvtsd2si	(%rax), %rcx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtsd2ss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtsd2ss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     1.33    -     vcvtsi2sd	%ecx, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     1.33    -     vcvtsi2sd	%rcx, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtsi2sdl	(%rax), %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtsi2sdq	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtsi2ss	%ecx, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtsi2ss	%rcx, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtsi2ssl	(%rax), %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvtsi2ssq	(%rax), %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvtss2sd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     2.00    -     vcvtss2sd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtss2si	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtss2si	%xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtss2si	(%rax), %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvtss2si	(%rax), %rcx
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttpd2dq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttpd2dqx	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttpd2dq	%ymm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttpd2dqy	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvttps2dq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvttps2dq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vcvttps2dq	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vcvttps2dq	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vcvttsd2si	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vcvttsd2si	%xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vcvttsd2si	(%rax), %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vcvttsd2si	(%rax), %rcx
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttss2si	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttss2si	%xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttss2si	(%rax), %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50   1.00    -     vcvttss2si	(%rax), %rcx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     5.00    -     vdivpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     5.00    -     vdivpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     9.00    -     vdivpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     9.00    -     vdivpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     3.00    -     vdivps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     3.00    -     vdivps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     6.00    -     vdivps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     6.00    -     vdivps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     5.00    -     vdivsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     5.00    -     vdivsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     3.00    -     vdivss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     3.00    -     vdivss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdppd	$22, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdppd	$22, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdpps	$22, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdpps	$22, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdpps	$22, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vdpps	$22, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vextractf128	$1, %ymm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vextractf128	$1, %ymm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   2.50    -      -     vextractps	$1, %xmm0, %ecx
# CHECK-NEXT: 2.50   2.50    -      -      -      -      -      -     0.50   2.50    -      -     vextractps	$1, %xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhaddpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhaddpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhaddpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhaddpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhaddps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhaddps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhaddps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhaddps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vhsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vhsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.67   0.67    -     0.67    -     vinsertf128	$1, %xmm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.67   0.67    -     0.67    -     vinsertf128	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vinsertps	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vinsertps	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vlddqu	(%rax), %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vlddqu	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vldmxcsr	(%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vmaskmovdqu	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaskmovpd	(%rax), %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaskmovpd	(%rax), %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaskmovpd	%xmm0, %xmm1, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaskmovpd	%ymm0, %ymm1, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaskmovps	(%rax), %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaskmovps	(%rax), %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaskmovps	%xmm0, %xmm1, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaskmovps	%ymm0, %ymm1, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmaxpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaxpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vmaxpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaxpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmaxps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaxps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vmaxps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmaxps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmaxsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaxsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmaxss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmaxss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vminpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vminpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vminpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vminpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vminps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vminps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vminps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vminps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vminsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vminsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vminss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vminss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovapd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovapd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovapd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovapd	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovapd	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovapd	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovaps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovaps	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovaps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovaps	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovaps	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovaps	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovd	%eax, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovd	%xmm0, %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovd	%xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovddup	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovddup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vmovddup	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vmovddup	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovdqa	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqa	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqa	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovdqa	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqa	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqa	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovdqu	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqu	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqu	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovdqu	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqu	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovdqu	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovhlps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovlhps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovhpd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovhpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovhps	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovhps	(%rax), %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovlpd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovlpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovlps	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovlps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovmskpd	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovmskpd	%ymm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovmskps	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovmskps	%ymm0, %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntdq	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntdq	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntdqa	(%rax), %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntdqa	(%rax), %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntpd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntpd	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntps	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovntps	%ymm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovq	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovq	%rax, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vmovq	%xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovq	%xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovsd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovsd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovshdup	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovshdup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vmovshdup	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vmovshdup	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovsldup	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vmovsldup	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vmovsldup	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vmovsldup	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vmovss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovss	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovss	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovupd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovupd	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovupd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovupd	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovupd	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovupd	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovups	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovups	%xmm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovups	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vmovups	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovups	%ymm0, (%rax)
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vmovups	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vmpsadbw	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vmpsadbw	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmulpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmulpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vmulpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmulpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmulps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmulps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vmulps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vmulps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmulsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmulsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmulss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vmulss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vorpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vorpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vorpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vorpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vorps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vorps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vorps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vorps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsb	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsb	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsw	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpabsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpackssdw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpackssdw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpacksswb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpacksswb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpackusdw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpackusdw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpackuswb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpackuswb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddusb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddusb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddusw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddusw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpaddw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpalignr	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpalignr	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpand	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpand	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpandn	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpandn	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpavgb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpavgb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpavgw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpavgw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpblendvb	%xmm3, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpblendvb	%xmm3, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpblendw	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpblendw	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpclmulqdq	$11, %xmm0, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpclmulqdq	$11, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpeqw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50    -      -     0.50    -     vpcmpgtq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50    -      -     0.50    -     vpcmpgtq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpcmpgtw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vpcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vperm2f128	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vperm2f128	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpermilpd	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpermilpd	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpermilpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpermilpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vpermilpd	$1, %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vpermilpd	$1, (%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vpermilpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vpermilpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpermilps	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpermilps	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpermilps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpermilps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vpermilps	$1, %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vpermilps	$1, (%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vpermilps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vpermilps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   2.50    -      -     vpextrb	$1, %xmm0, %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   4.00    -      -     vpextrb	$1, %xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   2.50    -      -     vpextrd	$1, %xmm0, %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   4.00    -      -     vpextrd	$1, %xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   2.50    -      -     vpextrq	$1, %xmm0, %rcx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   4.00    -      -     vpextrq	$1, %xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   2.50    -      -     vpextrw	$1, %xmm0, %ecx
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   4.00    -      -     vpextrw	$1, %xmm0, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphaddd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphaddd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphaddsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphaddsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphaddw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphaddw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vphminposuw	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vphminposuw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphsubd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphsubd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphsubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphsubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vphsubw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     vphsubw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrb	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrb	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrd	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrq	$1, %rax, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrq	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrw	$1, %eax, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpinsrw	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmaddubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmaddubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmaddwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmaddwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxub	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxub	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxud	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxud	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpmaxuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminub	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminub	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminud	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminud	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpminuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpminuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpmovmskb	%xmm0, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbw	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxbw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxdq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxdq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxwd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxwd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxwq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovsxwq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbw	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxbw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxdq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxdq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxwd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxwd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxwq	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpmovzxwq	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmuldq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmuldq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmulhrsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmulhrsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmulhuw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmulhuw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmulhw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmulhw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     2.00    -      -      -      -     vpmulld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     2.00    -      -      -      -     vpmulld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmullw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmullw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpmuludq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpmuludq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpor	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpor	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpsadbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00    -      -      -      -     vpsadbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpshufb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpshufb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpshufd	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpshufd	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpshufhw	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpshufhw	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpshuflw	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpshuflw	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsignw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpslld	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpslld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpslld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpslldq	$1, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsllq	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsllq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsllq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsllw	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsllw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsllw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrad	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrad	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsrad	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsraw	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsraw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsraw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrld	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrld	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsrld	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpsrldq	$1, %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrlq	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrlq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsrlq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrlw	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -     vpsrlw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00    -      -     vpsrlw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubsb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubsb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubsw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubsw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubusb	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubusb	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubusw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubusw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.33   0.33    -     0.33    -     vpsubw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vptest	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vptest	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00    -      -     vptest	%ymm0, %ymm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     2.00   2.00    -      -     vptest	(%rax), %ymm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhqdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhqdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpckhwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklbw	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklbw	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpckldq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpckldq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklqdq	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklqdq	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklwd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vpunpcklwd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpxor	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vpxor	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrcpps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vrcpps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vrcpps	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vrcpps	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrcpss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vrcpss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundpd	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundpd	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundpd	$1, %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundpd	$1, (%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundps	$1, %xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundps	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundps	$1, %ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundps	$1, (%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundsd	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundsd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -     vroundss	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     1.00    -     vroundss	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrsqrtps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vrsqrtps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   1.00    -      -      -     vrsqrtps	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     1.00   1.00    -      -      -     vrsqrtps	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -     vrsqrtss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50    -      -      -     vrsqrtss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vshufpd	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vshufpd	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vshufpd	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vshufpd	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vshufps	$1, %xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vshufps	$1, (%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vshufps	$1, %ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vshufps	$1, (%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     8.00    -     vsqrtpd	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     8.00    -     vsqrtpd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     16.00   -     vsqrtpd	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     16.00   -     vsqrtpd	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     5.00    -     vsqrtps	%xmm0, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     5.00    -     vsqrtps	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     10.00   -     vsqrtps	%ymm0, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     10.00   -     vsqrtps	(%rax), %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     8.00    -     vsqrtsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     8.00    -     vsqrtsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     5.00    -     vsqrtss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -     5.00    -     vsqrtss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vstmxcsr	(%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vsubpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vsubpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vsubpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vsubpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vsubps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vsubps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00   1.00    -     vsubps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     1.00   1.00    -     vsubps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vsubsd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vsubsd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     0.50   0.50    -     vsubss	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -     0.50   0.50    -     vsubss	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vtestpd	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vtestpd	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00    -      -     vtestpd	%ymm0, %ymm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     2.00   2.00    -      -     vtestpd	(%rax), %ymm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vtestps	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vtestps	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00    -      -     vtestps	%ymm0, %ymm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     2.00   2.00    -      -     vtestps	(%rax), %ymm1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   1.00    -      -     vucomisd	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   1.00    -      -     vucomisd	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   1.00    -      -     vucomiss	%xmm0, %xmm1
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   1.00    -      -     vucomiss	(%rax), %xmm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vunpckhpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vunpckhpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vunpckhpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vunpckhpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vunpckhps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vunpckhps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vunpckhps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vunpckhps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vunpcklpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vunpcklpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vunpcklpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vunpcklpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.50   0.50    -      -     vunpcklps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     0.50   0.50    -      -     vunpcklps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00   1.00    -      -     vunpcklps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -     1.00   1.00    -      -     vunpcklps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vxorpd	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vxorpd	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vxorpd	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vxorpd	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -     vxorps	%xmm0, %xmm1, %xmm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.25   0.25   0.25   0.25    -     vxorps	(%rax), %xmm1, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50   0.50   0.50    -     vxorps	%ymm0, %ymm1, %ymm2
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -     0.50   0.50   0.50   0.50    -     vxorps	(%rax), %ymm1, %ymm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vzeroall
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     vzeroupper
