/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesAnsibleAPIService RepositoriesAnsibleAPI service
type RepositoriesAnsibleAPIService service

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleAddRoleExecute(r)
}

/*
RepositoriesAnsibleAnsibleAddRole Method for RepositoriesAnsibleAnsibleAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleAddRole(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleAddRoleExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	collectionVersionCopyMove *CollectionVersionCopyMove
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest) CollectionVersionCopyMove(collectionVersionCopyMove CollectionVersionCopyMove) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest {
	r.collectionVersionCopyMove = &collectionVersionCopyMove
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleCopyCollectionVersionExecute(r)
}

/*
RepositoriesAnsibleAnsibleCopyCollectionVersion Method for RepositoriesAnsibleAnsibleCopyCollectionVersion

Trigger an asynchronous task to copy collection versions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleCopyCollectionVersion(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleCopyCollectionVersionExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCopyCollectionVersionRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleCopyCollectionVersion")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}copy_collection_version/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.collectionVersionCopyMove == nil {
		return localVarReturnValue, nil, reportError("collectionVersionCopyMove is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.collectionVersionCopyMove
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepository *AnsibleAnsibleRepository
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest) AnsibleAnsibleRepository(ansibleAnsibleRepository AnsibleAnsibleRepository) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest {
	r.ansibleAnsibleRepository = &ansibleAnsibleRepository
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest) Execute() (*AnsibleAnsibleRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleCreateExecute(r)
}

/*
RepositoriesAnsibleAnsibleCreate Create an ansible repository

ViewSet for Ansible Repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleCreate(ctx context.Context) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AnsibleAnsibleRepositoryResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleCreateExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleCreateRequest) (*AnsibleAnsibleRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleAnsibleRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/ansible/ansible/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleAnsibleRepository == nil {
		return localVarReturnValue, nil, reportError("ansibleAnsibleRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleAnsibleRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleDeleteExecute(r)
}

/*
RepositoriesAnsibleAnsibleDelete Delete an ansible repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleDelete(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleDeleteExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) LatestWithContent(latestWithContent string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Limit(limit int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Name(name string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) NameContains(nameContains string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) NameIcontains(nameIcontains string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) NameIn(nameIn []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) NameStartswith(nameStartswith string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Offset(offset int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Ordering(ordering []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) PulpIdIn(pulpIdIn []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Remote(remote string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) WithContent(withContent string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Fields(fields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) Execute() (*PaginatedansibleAnsibleRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleListExecute(r)
}

/*
RepositoriesAnsibleAnsibleList List ansible repositorys

ViewSet for Ansible Repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleList(ctx context.Context) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleAnsibleRepositoryResponseList
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleListExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRequest) (*PaginatedansibleAnsibleRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleAnsibleRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/ansible/ansible/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest) Fields(fields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleListRolesExecute(r)
}

/*
RepositoriesAnsibleAnsibleListRoles Method for RepositoriesAnsibleAnsibleListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleListRoles(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleListRolesExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleRepositoryMark *AnsibleRepositoryMark
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest) AnsibleRepositoryMark(ansibleRepositoryMark AnsibleRepositoryMark) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest {
	r.ansibleRepositoryMark = &ansibleRepositoryMark
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleMarkExecute(r)
}

/*
RepositoriesAnsibleAnsibleMark Method for RepositoriesAnsibleAnsibleMark

Trigger an asynchronous task to mark Ansible content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMark(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMarkExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMarkRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleMark")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}mark/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositoryMark == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositoryMark is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositoryMark
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	repositoryAddRemoveContent *RepositoryAddRemoveContent
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest) RepositoryAddRemoveContent(repositoryAddRemoveContent RepositoryAddRemoveContent) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest {
	r.repositoryAddRemoveContent = &repositoryAddRemoveContent
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleModifyExecute(r)
}

/*
RepositoriesAnsibleAnsibleModify Modify Repository Content

Trigger an asynchronous task to create a new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleModify(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleModifyExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleModifyRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleModify")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}modify/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositoryAddRemoveContent == nil {
		return localVarReturnValue, nil, reportError("repositoryAddRemoveContent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositoryAddRemoveContent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	collectionVersionCopyMove *CollectionVersionCopyMove
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest) CollectionVersionCopyMove(collectionVersionCopyMove CollectionVersionCopyMove) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest {
	r.collectionVersionCopyMove = &collectionVersionCopyMove
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleMoveCollectionVersionExecute(r)
}

/*
RepositoriesAnsibleAnsibleMoveCollectionVersion Method for RepositoriesAnsibleAnsibleMoveCollectionVersion

Trigger an asynchronous task to move collection versions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMoveCollectionVersion(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMoveCollectionVersionExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMoveCollectionVersionRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleMoveCollectionVersion")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}move_collection_version/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.collectionVersionCopyMove == nil {
		return localVarReturnValue, nil, reportError("collectionVersionCopyMove is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.collectionVersionCopyMove
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest) Fields(fields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleMyPermissionsExecute(r)
}

/*
RepositoriesAnsibleAnsibleMyPermissions Method for RepositoriesAnsibleAnsibleMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMyPermissions(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleMyPermissionsExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	patchedansibleAnsibleRepository *PatchedansibleAnsibleRepository
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest) PatchedansibleAnsibleRepository(patchedansibleAnsibleRepository PatchedansibleAnsibleRepository) RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest {
	r.patchedansibleAnsibleRepository = &patchedansibleAnsibleRepository
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsiblePartialUpdateExecute(r)
}

/*
RepositoriesAnsibleAnsiblePartialUpdate Update an ansible repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsiblePartialUpdate(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsiblePartialUpdateExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsiblePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsiblePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedansibleAnsibleRepository == nil {
		return localVarReturnValue, nil, reportError("patchedansibleAnsibleRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedansibleAnsibleRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest) Fields(fields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest) ExcludeFields(excludeFields []string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest) Execute() (*AnsibleAnsibleRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleReadExecute(r)
}

/*
RepositoriesAnsibleAnsibleRead Inspect an ansible repository

ViewSet for Ansible Repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleRead(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AnsibleAnsibleRepositoryResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleReadExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleReadRequest) (*AnsibleAnsibleRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleAnsibleRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleRepositoryRebuild *AnsibleRepositoryRebuild
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest) AnsibleRepositoryRebuild(ansibleRepositoryRebuild AnsibleRepositoryRebuild) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest {
	r.ansibleRepositoryRebuild = &ansibleRepositoryRebuild
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleRebuildMetadataExecute(r)
}

/*
RepositoriesAnsibleAnsibleRebuildMetadata Method for RepositoriesAnsibleAnsibleRebuildMetadata

Trigger an asynchronous task to rebuild Ansible content meta.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleRebuildMetadata(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleRebuildMetadataExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRebuildMetadataRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleRebuildMetadata")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}rebuild_metadata/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositoryRebuild == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositoryRebuild is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositoryRebuild
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleRemoveRoleExecute(r)
}

/*
RepositoriesAnsibleAnsibleRemoveRole Method for RepositoriesAnsibleAnsibleRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleRemoveRole(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleRemoveRoleExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleRepositorySignature *AnsibleRepositorySignature
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest) AnsibleRepositorySignature(ansibleRepositorySignature AnsibleRepositorySignature) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest {
	r.ansibleRepositorySignature = &ansibleRepositorySignature
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleSignExecute(r)
}

/*
RepositoriesAnsibleAnsibleSign Method for RepositoriesAnsibleAnsibleSign

Trigger an asynchronous task to sign Ansible content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleSign(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleSignExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSignRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleSign")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}sign/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositorySignature == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositorySignature is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositorySignature
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleRepositorySyncURL *AnsibleRepositorySyncURL
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest) AnsibleRepositorySyncURL(ansibleRepositorySyncURL AnsibleRepositorySyncURL) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest {
	r.ansibleRepositorySyncURL = &ansibleRepositorySyncURL
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleSyncExecute(r)
}

/*
RepositoriesAnsibleAnsibleSync Method for RepositoriesAnsibleAnsibleSync

Trigger an asynchronous task to sync Ansible content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleSync(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleSyncExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleRepositoryMark *AnsibleRepositoryMark
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest) AnsibleRepositoryMark(ansibleRepositoryMark AnsibleRepositoryMark) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest {
	r.ansibleRepositoryMark = &ansibleRepositoryMark
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleUnmarkExecute(r)
}

/*
RepositoriesAnsibleAnsibleUnmark Method for RepositoriesAnsibleAnsibleUnmark

Trigger an asynchronous task to unmark Ansible content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleUnmark(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleUnmarkExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUnmarkRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleUnmark")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}unmark/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRepositoryMark == nil {
		return localVarReturnValue, nil, reportError("ansibleRepositoryMark is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRepositoryMark
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAnsibleAPIService
	ansibleAnsibleRepositoryHref string
	ansibleAnsibleRepository *AnsibleAnsibleRepository
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest) AnsibleAnsibleRepository(ansibleAnsibleRepository AnsibleAnsibleRepository) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest {
	r.ansibleAnsibleRepository = &ansibleAnsibleRepository
	return r
}

func (r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesAnsibleAnsibleUpdateExecute(r)
}

/*
RepositoriesAnsibleAnsibleUpdate Update an ansible repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleRepositoryHref
 @return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest
*/
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleUpdate(ctx context.Context, ansibleAnsibleRepositoryHref string) RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest {
	return RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleRepositoryHref: ansibleAnsibleRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAnsibleAPIService) RepositoriesAnsibleAnsibleUpdateExecute(r RepositoriesAnsibleAPIRepositoriesAnsibleAnsibleUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAnsibleAPIService.RepositoriesAnsibleAnsibleUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_repository_href"+"}", parameterValueToString(r.ansibleAnsibleRepositoryHref, "ansibleAnsibleRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleAnsibleRepository == nil {
		return localVarReturnValue, nil, reportError("ansibleAnsibleRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleAnsibleRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
