/****************************/
/* THIS IS OPEN SOURCE CODE */
/****************************/

#ifndef __POWER5_EVENTS_H__
#define __POWER5_EVENTS_H__

/*
* File:    power5_events.h
* CVS:
* Author:  Corey Ashford
*          cjashfor@us.ibm.com
* Mods:    <your name here>
*          <your email address>
*
* (C) Copyright IBM Corporation, 2009.  All Rights Reserved.
* Contributed by Corey Ashford <cjashfor.ibm.com>
*
* Note: This code was automatically generated and should not be modified by
* hand.
*
*/
#define POWER5_PME_PM_LSU_REJECT_RELOAD_CDF 0
#define POWER5_PME_PM_FPU1_SINGLE 1
#define POWER5_PME_PM_L3SB_REF 2
#define POWER5_PME_PM_THRD_PRIO_DIFF_3or4_CYC 3
#define POWER5_PME_PM_INST_FROM_L275_SHR 4
#define POWER5_PME_PM_MRK_DATA_FROM_L375_MOD 5
#define POWER5_PME_PM_DTLB_MISS_4K 6
#define POWER5_PME_PM_CLB_FULL_CYC 7
#define POWER5_PME_PM_MRK_ST_CMPL 8
#define POWER5_PME_PM_LSU_FLUSH_LRQ_FULL 9
#define POWER5_PME_PM_MRK_DATA_FROM_L275_SHR 10
#define POWER5_PME_PM_1INST_CLB_CYC 11
#define POWER5_PME_PM_MEM_SPEC_RD_CANCEL 12
#define POWER5_PME_PM_MRK_DTLB_MISS_16M 13
#define POWER5_PME_PM_FPU_FDIV 14
#define POWER5_PME_PM_FPU_SINGLE 15
#define POWER5_PME_PM_FPU0_FMA 16
#define POWER5_PME_PM_SLB_MISS 17
#define POWER5_PME_PM_LSU1_FLUSH_LRQ 18
#define POWER5_PME_PM_L2SA_ST_HIT 19
#define POWER5_PME_PM_DTLB_MISS 20
#define POWER5_PME_PM_BR_PRED_TA 21
#define POWER5_PME_PM_MRK_DATA_FROM_L375_MOD_CYC 22
#define POWER5_PME_PM_CMPLU_STALL_FXU 23
#define POWER5_PME_PM_EXT_INT 24
#define POWER5_PME_PM_MRK_LSU1_FLUSH_LRQ 25
#define POWER5_PME_PM_LSU1_LDF 26
#define POWER5_PME_PM_MRK_ST_GPS 27
#define POWER5_PME_PM_FAB_CMD_ISSUED 28
#define POWER5_PME_PM_LSU0_SRQ_STFWD 29
#define POWER5_PME_PM_CR_MAP_FULL_CYC 30
#define POWER5_PME_PM_L2SA_RCST_DISP_FAIL_RC_FULL 31
#define POWER5_PME_PM_MRK_LSU0_FLUSH_ULD 32
#define POWER5_PME_PM_LSU_FLUSH_SRQ_FULL 33
#define POWER5_PME_PM_FLUSH_IMBAL 34
#define POWER5_PME_PM_MEM_RQ_DISP_Q16to19 35
#define POWER5_PME_PM_THRD_PRIO_DIFF_minus3or4_CYC 36
#define POWER5_PME_PM_DATA_FROM_L35_MOD 37
#define POWER5_PME_PM_MEM_HI_PRIO_WR_CMPL 38
#define POWER5_PME_PM_FPU1_FDIV 39
#define POWER5_PME_PM_FPU0_FRSP_FCONV 40
#define POWER5_PME_PM_MEM_RQ_DISP 41
#define POWER5_PME_PM_LWSYNC_HELD 42
#define POWER5_PME_PM_FXU_FIN 43
#define POWER5_PME_PM_DSLB_MISS 44
#define POWER5_PME_PM_FXLS1_FULL_CYC 45
#define POWER5_PME_PM_DATA_FROM_L275_SHR 46
#define POWER5_PME_PM_THRD_SEL_T0 47
#define POWER5_PME_PM_PTEG_RELOAD_VALID 48
#define POWER5_PME_PM_LSU_LMQ_LHR_MERGE 49
#define POWER5_PME_PM_MRK_STCX_FAIL 50
#define POWER5_PME_PM_2INST_CLB_CYC 51
#define POWER5_PME_PM_FAB_PNtoVN_DIRECT 52
#define POWER5_PME_PM_PTEG_FROM_L2MISS 53
#define POWER5_PME_PM_CMPLU_STALL_LSU 54
#define POWER5_PME_PM_MRK_DSLB_MISS 55
#define POWER5_PME_PM_LSU_FLUSH_ULD 56
#define POWER5_PME_PM_PTEG_FROM_LMEM 57
#define POWER5_PME_PM_MRK_BRU_FIN 58
#define POWER5_PME_PM_MEM_WQ_DISP_WRITE 59
#define POWER5_PME_PM_MRK_DATA_FROM_L275_MOD_CYC 60
#define POWER5_PME_PM_LSU1_NCLD 61
#define POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_OTHER 62
#define POWER5_PME_PM_SNOOP_PW_RETRY_WQ_PWQ 63
#define POWER5_PME_PM_FPR_MAP_FULL_CYC 64
#define POWER5_PME_PM_FPU1_FULL_CYC 65
#define POWER5_PME_PM_L3SA_ALL_BUSY 66
#define POWER5_PME_PM_3INST_CLB_CYC 67
#define POWER5_PME_PM_MEM_PWQ_DISP_Q2or3 68
#define POWER5_PME_PM_L2SA_SHR_INV 69
#define POWER5_PME_PM_THRESH_TIMEO 70
#define POWER5_PME_PM_L2SA_RC_DISP_FAIL_CO_BUSY_ALL 71
#define POWER5_PME_PM_THRD_SEL_OVER_GCT_IMBAL 72
#define POWER5_PME_PM_FPU_FSQRT 73
#define POWER5_PME_PM_MRK_LSU0_FLUSH_LRQ 74
#define POWER5_PME_PM_PMC1_OVERFLOW 75
#define POWER5_PME_PM_L3SC_SNOOP_RETRY 76
#define POWER5_PME_PM_DATA_TABLEWALK_CYC 77
#define POWER5_PME_PM_THRD_PRIO_6_CYC 78
#define POWER5_PME_PM_FPU_FEST 79
#define POWER5_PME_PM_FAB_M1toP1_SIDECAR_EMPTY 80
#define POWER5_PME_PM_MRK_DATA_FROM_RMEM 81
#define POWER5_PME_PM_MRK_DATA_FROM_L35_MOD_CYC 82
#define POWER5_PME_PM_MEM_PWQ_DISP 83
#define POWER5_PME_PM_FAB_P1toM1_SIDECAR_EMPTY 84
#define POWER5_PME_PM_LD_MISS_L1_LSU0 85
#define POWER5_PME_PM_SNOOP_PARTIAL_RTRY_QFULL 86
#define POWER5_PME_PM_FPU1_STALL3 87
#define POWER5_PME_PM_GCT_USAGE_80to99_CYC 88
#define POWER5_PME_PM_WORK_HELD 89
#define POWER5_PME_PM_INST_CMPL 90
#define POWER5_PME_PM_LSU1_FLUSH_UST 91
#define POWER5_PME_PM_FXU_IDLE 92
#define POWER5_PME_PM_LSU0_FLUSH_ULD 93
#define POWER5_PME_PM_LSU1_REJECT_LMQ_FULL 94
#define POWER5_PME_PM_GRP_DISP_REJECT 95
#define POWER5_PME_PM_L2SA_MOD_INV 96
#define POWER5_PME_PM_PTEG_FROM_L25_SHR 97
#define POWER5_PME_PM_FAB_CMD_RETRIED 98
#define POWER5_PME_PM_L3SA_SHR_INV 99
#define POWER5_PME_PM_L2SB_RC_DISP_FAIL_CO_BUSY_ALL 100
#define POWER5_PME_PM_L2SA_RCST_DISP_FAIL_ADDR 101
#define POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_RC_FULL 102
#define POWER5_PME_PM_PTEG_FROM_L375_MOD 103
#define POWER5_PME_PM_MRK_LSU1_FLUSH_UST 104
#define POWER5_PME_PM_BR_ISSUED 105
#define POWER5_PME_PM_MRK_GRP_BR_REDIR 106
#define POWER5_PME_PM_EE_OFF 107
#define POWER5_PME_PM_MEM_RQ_DISP_Q4to7 108
#define POWER5_PME_PM_MEM_FAST_PATH_RD_DISP 109
#define POWER5_PME_PM_INST_FROM_L3 110
#define POWER5_PME_PM_ITLB_MISS 111
#define POWER5_PME_PM_FXU1_BUSY_FXU0_IDLE 112
#define POWER5_PME_PM_FXLS_FULL_CYC 113
#define POWER5_PME_PM_DTLB_REF_4K 114
#define POWER5_PME_PM_GRP_DISP_VALID 115
#define POWER5_PME_PM_LSU_FLUSH_UST 116
#define POWER5_PME_PM_FXU1_FIN 117
#define POWER5_PME_PM_THRD_PRIO_4_CYC 118
#define POWER5_PME_PM_MRK_DATA_FROM_L35_MOD 119
#define POWER5_PME_PM_4INST_CLB_CYC 120
#define POWER5_PME_PM_MRK_DTLB_REF_16M 121
#define POWER5_PME_PM_INST_FROM_L375_MOD 122
#define POWER5_PME_PM_L2SC_RCST_DISP_FAIL_ADDR 123
#define POWER5_PME_PM_GRP_CMPL 124
#define POWER5_PME_PM_FPU1_1FLOP 125
#define POWER5_PME_PM_FPU_FRSP_FCONV 126
#define POWER5_PME_PM_5INST_CLB_CYC 127
#define POWER5_PME_PM_L3SC_REF 128
#define POWER5_PME_PM_THRD_L2MISS_BOTH_CYC 129
#define POWER5_PME_PM_MEM_PW_GATH 130
#define POWER5_PME_PM_FAB_PNtoNN_SIDECAR 131
#define POWER5_PME_PM_FAB_DCLAIM_ISSUED 132
#define POWER5_PME_PM_GRP_IC_MISS 133
#define POWER5_PME_PM_INST_FROM_L35_SHR 134
#define POWER5_PME_PM_LSU_LMQ_FULL_CYC 135
#define POWER5_PME_PM_MRK_DATA_FROM_L2_CYC 136
#define POWER5_PME_PM_LSU_SRQ_SYNC_CYC 137
#define POWER5_PME_PM_LSU0_BUSY_REJECT 138
#define POWER5_PME_PM_LSU_REJECT_ERAT_MISS 139
#define POWER5_PME_PM_MRK_DATA_FROM_RMEM_CYC 140
#define POWER5_PME_PM_DATA_FROM_L375_SHR 141
#define POWER5_PME_PM_FPU0_FMOV_FEST 142
#define POWER5_PME_PM_PTEG_FROM_L25_MOD 143
#define POWER5_PME_PM_LD_REF_L1_LSU0 144
#define POWER5_PME_PM_THRD_PRIO_7_CYC 145
#define POWER5_PME_PM_LSU1_FLUSH_SRQ 146
#define POWER5_PME_PM_L2SC_RCST_DISP 147
#define POWER5_PME_PM_CMPLU_STALL_DIV 148
#define POWER5_PME_PM_MEM_RQ_DISP_Q12to15 149
#define POWER5_PME_PM_INST_FROM_L375_SHR 150
#define POWER5_PME_PM_ST_REF_L1 151
#define POWER5_PME_PM_L3SB_ALL_BUSY 152
#define POWER5_PME_PM_FAB_P1toVNorNN_SIDECAR_EMPTY 153
#define POWER5_PME_PM_MRK_DATA_FROM_L275_SHR_CYC 154
#define POWER5_PME_PM_FAB_HOLDtoNN_EMPTY 155
#define POWER5_PME_PM_DATA_FROM_LMEM 156
#define POWER5_PME_PM_RUN_CYC 157
#define POWER5_PME_PM_PTEG_FROM_RMEM 158
#define POWER5_PME_PM_L2SC_RCLD_DISP 159
#define POWER5_PME_PM_LSU0_LDF 160
#define POWER5_PME_PM_LSU_LRQ_S0_VALID 161
#define POWER5_PME_PM_PMC3_OVERFLOW 162
#define POWER5_PME_PM_MRK_IMR_RELOAD 163
#define POWER5_PME_PM_MRK_GRP_TIMEO 164
#define POWER5_PME_PM_ST_MISS_L1 165
#define POWER5_PME_PM_STOP_COMPLETION 166
#define POWER5_PME_PM_LSU_BUSY_REJECT 167
#define POWER5_PME_PM_ISLB_MISS 168
#define POWER5_PME_PM_CYC 169
#define POWER5_PME_PM_THRD_ONE_RUN_CYC 170
#define POWER5_PME_PM_GRP_BR_REDIR_NONSPEC 171
#define POWER5_PME_PM_LSU1_SRQ_STFWD 172
#define POWER5_PME_PM_L3SC_MOD_INV 173
#define POWER5_PME_PM_L2_PREF 174
#define POWER5_PME_PM_GCT_NOSLOT_BR_MPRED 175
#define POWER5_PME_PM_MRK_DATA_FROM_L25_MOD 176
#define POWER5_PME_PM_L2SB_MOD_INV 177
#define POWER5_PME_PM_L2SB_ST_REQ 178
#define POWER5_PME_PM_MRK_L1_RELOAD_VALID 179
#define POWER5_PME_PM_L3SB_HIT 180
#define POWER5_PME_PM_L2SB_SHR_MOD 181
#define POWER5_PME_PM_EE_OFF_EXT_INT 182
#define POWER5_PME_PM_1PLUS_PPC_CMPL 183
#define POWER5_PME_PM_L2SC_SHR_MOD 184
#define POWER5_PME_PM_PMC6_OVERFLOW 185
#define POWER5_PME_PM_LSU_LRQ_FULL_CYC 186
#define POWER5_PME_PM_IC_PREF_INSTALL 187
#define POWER5_PME_PM_TLB_MISS 188
#define POWER5_PME_PM_GCT_FULL_CYC 189
#define POWER5_PME_PM_FXU_BUSY 190
#define POWER5_PME_PM_MRK_DATA_FROM_L3_CYC 191
#define POWER5_PME_PM_LSU_REJECT_LMQ_FULL 192
#define POWER5_PME_PM_LSU_SRQ_S0_ALLOC 193
#define POWER5_PME_PM_GRP_MRK 194
#define POWER5_PME_PM_INST_FROM_L25_SHR 195
#define POWER5_PME_PM_FPU1_FIN 196
#define POWER5_PME_PM_DC_PREF_STREAM_ALLOC 197
#define POWER5_PME_PM_BR_MPRED_TA 198
#define POWER5_PME_PM_CRQ_FULL_CYC 199
#define POWER5_PME_PM_L2SA_RCLD_DISP 200
#define POWER5_PME_PM_SNOOP_WR_RETRY_QFULL 201
#define POWER5_PME_PM_MRK_DTLB_REF_4K 202
#define POWER5_PME_PM_LSU_SRQ_S0_VALID 203
#define POWER5_PME_PM_LSU0_FLUSH_LRQ 204
#define POWER5_PME_PM_INST_FROM_L275_MOD 205
#define POWER5_PME_PM_GCT_EMPTY_CYC 206
#define POWER5_PME_PM_LARX_LSU0 207
#define POWER5_PME_PM_THRD_PRIO_DIFF_5or6_CYC 208
#define POWER5_PME_PM_SNOOP_RETRY_1AHEAD 209
#define POWER5_PME_PM_FPU1_FSQRT 210
#define POWER5_PME_PM_MRK_LD_MISS_L1_LSU1 211
#define POWER5_PME_PM_MRK_FPU_FIN 212
#define POWER5_PME_PM_THRD_PRIO_5_CYC 213
#define POWER5_PME_PM_MRK_DATA_FROM_LMEM 214
#define POWER5_PME_PM_FPU1_FRSP_FCONV 215
#define POWER5_PME_PM_SNOOP_TLBIE 216
#define POWER5_PME_PM_L3SB_SNOOP_RETRY 217
#define POWER5_PME_PM_FAB_VBYPASS_EMPTY 218
#define POWER5_PME_PM_MRK_DATA_FROM_L275_MOD 219
#define POWER5_PME_PM_6INST_CLB_CYC 220
#define POWER5_PME_PM_L2SB_RCST_DISP 221
#define POWER5_PME_PM_FLUSH 222
#define POWER5_PME_PM_L2SC_MOD_INV 223
#define POWER5_PME_PM_FPU_DENORM 224
#define POWER5_PME_PM_L3SC_HIT 225
#define POWER5_PME_PM_SNOOP_WR_RETRY_RQ 226
#define POWER5_PME_PM_LSU1_REJECT_SRQ 227
#define POWER5_PME_PM_IC_PREF_REQ 228
#define POWER5_PME_PM_L3SC_ALL_BUSY 229
#define POWER5_PME_PM_MRK_GRP_IC_MISS 230
#define POWER5_PME_PM_GCT_NOSLOT_IC_MISS 231
#define POWER5_PME_PM_MRK_DATA_FROM_L3 232
#define POWER5_PME_PM_GCT_NOSLOT_SRQ_FULL 233
#define POWER5_PME_PM_THRD_SEL_OVER_ISU_HOLD 234
#define POWER5_PME_PM_CMPLU_STALL_DCACHE_MISS 235
#define POWER5_PME_PM_L3SA_MOD_INV 236
#define POWER5_PME_PM_LSU_FLUSH_LRQ 237
#define POWER5_PME_PM_THRD_PRIO_2_CYC 238
#define POWER5_PME_PM_LSU_FLUSH_SRQ 239
#define POWER5_PME_PM_MRK_LSU_SRQ_INST_VALID 240
#define POWER5_PME_PM_L3SA_REF 241
#define POWER5_PME_PM_L2SC_RC_DISP_FAIL_CO_BUSY_ALL 242
#define POWER5_PME_PM_FPU0_STALL3 243
#define POWER5_PME_PM_GPR_MAP_FULL_CYC 244
#define POWER5_PME_PM_TB_BIT_TRANS 245
#define POWER5_PME_PM_MRK_LSU_FLUSH_LRQ 246
#define POWER5_PME_PM_FPU0_STF 247
#define POWER5_PME_PM_MRK_DTLB_MISS 248
#define POWER5_PME_PM_FPU1_FMA 249
#define POWER5_PME_PM_L2SA_MOD_TAG 250
#define POWER5_PME_PM_LSU1_FLUSH_ULD 251
#define POWER5_PME_PM_MRK_LSU0_FLUSH_UST 252
#define POWER5_PME_PM_MRK_INST_FIN 253
#define POWER5_PME_PM_FPU0_FULL_CYC 254
#define POWER5_PME_PM_LSU_LRQ_S0_ALLOC 255
#define POWER5_PME_PM_MRK_LSU1_FLUSH_ULD 256
#define POWER5_PME_PM_MRK_DTLB_REF 257
#define POWER5_PME_PM_BR_UNCOND 258
#define POWER5_PME_PM_THRD_SEL_OVER_L2MISS 259
#define POWER5_PME_PM_L2SB_SHR_INV 260
#define POWER5_PME_PM_MEM_LO_PRIO_WR_CMPL 261
#define POWER5_PME_PM_L3SC_MOD_TAG 262
#define POWER5_PME_PM_MRK_ST_MISS_L1 263
#define POWER5_PME_PM_GRP_DISP_SUCCESS 264
#define POWER5_PME_PM_THRD_PRIO_DIFF_1or2_CYC 265
#define POWER5_PME_PM_IC_DEMAND_L2_BHT_REDIRECT 266
#define POWER5_PME_PM_MEM_WQ_DISP_Q8to15 267
#define POWER5_PME_PM_FPU0_SINGLE 268
#define POWER5_PME_PM_LSU_DERAT_MISS 269
#define POWER5_PME_PM_THRD_PRIO_1_CYC 270
#define POWER5_PME_PM_L2SC_RCST_DISP_FAIL_OTHER 271
#define POWER5_PME_PM_FPU1_FEST 272
#define POWER5_PME_PM_FAB_HOLDtoVN_EMPTY 273
#define POWER5_PME_PM_SNOOP_RD_RETRY_RQ 274
#define POWER5_PME_PM_SNOOP_DCLAIM_RETRY_QFULL 275
#define POWER5_PME_PM_MRK_DATA_FROM_L25_SHR_CYC 276
#define POWER5_PME_PM_MRK_ST_CMPL_INT 277
#define POWER5_PME_PM_FLUSH_BR_MPRED 278
#define POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_ADDR 279
#define POWER5_PME_PM_FPU_STF 280
#define POWER5_PME_PM_CMPLU_STALL_FPU 281
#define POWER5_PME_PM_THRD_PRIO_DIFF_minus1or2_CYC 282
#define POWER5_PME_PM_GCT_NOSLOT_CYC 283
#define POWER5_PME_PM_FXU0_BUSY_FXU1_IDLE 284
#define POWER5_PME_PM_PTEG_FROM_L35_SHR 285
#define POWER5_PME_PM_MRK_LSU_FLUSH_UST 286
#define POWER5_PME_PM_L3SA_HIT 287
#define POWER5_PME_PM_MRK_DATA_FROM_L25_SHR 288
#define POWER5_PME_PM_L2SB_RCST_DISP_FAIL_ADDR 289
#define POWER5_PME_PM_MRK_DATA_FROM_L35_SHR 290
#define POWER5_PME_PM_IERAT_XLATE_WR 291
#define POWER5_PME_PM_L2SA_ST_REQ 292
#define POWER5_PME_PM_THRD_SEL_T1 293
#define POWER5_PME_PM_IC_DEMAND_L2_BR_REDIRECT 294
#define POWER5_PME_PM_INST_FROM_LMEM 295
#define POWER5_PME_PM_FPU0_1FLOP 296
#define POWER5_PME_PM_MRK_DATA_FROM_L35_SHR_CYC 297
#define POWER5_PME_PM_PTEG_FROM_L2 298
#define POWER5_PME_PM_MEM_PW_CMPL 299
#define POWER5_PME_PM_THRD_PRIO_DIFF_minus5or6_CYC 300
#define POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_OTHER 301
#define POWER5_PME_PM_FPU0_FIN 302
#define POWER5_PME_PM_MRK_DTLB_MISS_4K 303
#define POWER5_PME_PM_L3SC_SHR_INV 304
#define POWER5_PME_PM_GRP_BR_REDIR 305
#define POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_RC_FULL 306
#define POWER5_PME_PM_MRK_LSU_FLUSH_SRQ 307
#define POWER5_PME_PM_PTEG_FROM_L275_SHR 308
#define POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_RC_FULL 309
#define POWER5_PME_PM_SNOOP_RD_RETRY_WQ 310
#define POWER5_PME_PM_LSU0_NCLD 311
#define POWER5_PME_PM_FAB_DCLAIM_RETRIED 312
#define POWER5_PME_PM_LSU1_BUSY_REJECT 313
#define POWER5_PME_PM_FXLS0_FULL_CYC 314
#define POWER5_PME_PM_FPU0_FEST 315
#define POWER5_PME_PM_DTLB_REF_16M 316
#define POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_ADDR 317
#define POWER5_PME_PM_LSU0_REJECT_ERAT_MISS 318
#define POWER5_PME_PM_DATA_FROM_L25_MOD 319
#define POWER5_PME_PM_GCT_USAGE_60to79_CYC 320
#define POWER5_PME_PM_DATA_FROM_L375_MOD 321
#define POWER5_PME_PM_LSU_LMQ_SRQ_EMPTY_CYC 322
#define POWER5_PME_PM_LSU0_REJECT_RELOAD_CDF 323
#define POWER5_PME_PM_0INST_FETCH 324
#define POWER5_PME_PM_LSU1_REJECT_RELOAD_CDF 325
#define POWER5_PME_PM_L1_PREF 326
#define POWER5_PME_PM_MEM_WQ_DISP_Q0to7 327
#define POWER5_PME_PM_MRK_DATA_FROM_LMEM_CYC 328
#define POWER5_PME_PM_BRQ_FULL_CYC 329
#define POWER5_PME_PM_GRP_IC_MISS_NONSPEC 330
#define POWER5_PME_PM_PTEG_FROM_L275_MOD 331
#define POWER5_PME_PM_MRK_LD_MISS_L1_LSU0 332
#define POWER5_PME_PM_MRK_DATA_FROM_L375_SHR_CYC 333
#define POWER5_PME_PM_LSU_FLUSH 334
#define POWER5_PME_PM_DATA_FROM_L3 335
#define POWER5_PME_PM_INST_FROM_L2 336
#define POWER5_PME_PM_PMC2_OVERFLOW 337
#define POWER5_PME_PM_FPU0_DENORM 338
#define POWER5_PME_PM_FPU1_FMOV_FEST 339
#define POWER5_PME_PM_INST_FETCH_CYC 340
#define POWER5_PME_PM_LSU_LDF 341
#define POWER5_PME_PM_INST_DISP 342
#define POWER5_PME_PM_DATA_FROM_L25_SHR 343
#define POWER5_PME_PM_L1_DCACHE_RELOAD_VALID 344
#define POWER5_PME_PM_MEM_WQ_DISP_DCLAIM 345
#define POWER5_PME_PM_FPU_FULL_CYC 346
#define POWER5_PME_PM_MRK_GRP_ISSUED 347
#define POWER5_PME_PM_THRD_PRIO_3_CYC 348
#define POWER5_PME_PM_FPU_FMA 349
#define POWER5_PME_PM_INST_FROM_L35_MOD 350
#define POWER5_PME_PM_MRK_CRU_FIN 351
#define POWER5_PME_PM_SNOOP_WR_RETRY_WQ 352
#define POWER5_PME_PM_CMPLU_STALL_REJECT 353
#define POWER5_PME_PM_LSU1_REJECT_ERAT_MISS 354
#define POWER5_PME_PM_MRK_FXU_FIN 355
#define POWER5_PME_PM_L2SB_RCST_DISP_FAIL_OTHER 356
#define POWER5_PME_PM_L2SC_RC_DISP_FAIL_CO_BUSY 357
#define POWER5_PME_PM_PMC4_OVERFLOW 358
#define POWER5_PME_PM_L3SA_SNOOP_RETRY 359
#define POWER5_PME_PM_PTEG_FROM_L35_MOD 360
#define POWER5_PME_PM_INST_FROM_L25_MOD 361
#define POWER5_PME_PM_THRD_SMT_HANG 362
#define POWER5_PME_PM_CMPLU_STALL_ERAT_MISS 363
#define POWER5_PME_PM_L3SA_MOD_TAG 364
#define POWER5_PME_PM_FLUSH_SYNC 365
#define POWER5_PME_PM_INST_FROM_L2MISS 366
#define POWER5_PME_PM_L2SC_ST_HIT 367
#define POWER5_PME_PM_MEM_RQ_DISP_Q8to11 368
#define POWER5_PME_PM_MRK_GRP_DISP 369
#define POWER5_PME_PM_L2SB_MOD_TAG 370
#define POWER5_PME_PM_CLB_EMPTY_CYC 371
#define POWER5_PME_PM_L2SB_ST_HIT 372
#define POWER5_PME_PM_MEM_NONSPEC_RD_CANCEL 373
#define POWER5_PME_PM_BR_PRED_CR_TA 374
#define POWER5_PME_PM_MRK_LSU0_FLUSH_SRQ 375
#define POWER5_PME_PM_MRK_LSU_FLUSH_ULD 376
#define POWER5_PME_PM_INST_DISP_ATTEMPT 377
#define POWER5_PME_PM_INST_FROM_RMEM 378
#define POWER5_PME_PM_ST_REF_L1_LSU0 379
#define POWER5_PME_PM_LSU0_DERAT_MISS 380
#define POWER5_PME_PM_L2SB_RCLD_DISP 381
#define POWER5_PME_PM_FPU_STALL3 382
#define POWER5_PME_PM_BR_PRED_CR 383
#define POWER5_PME_PM_MRK_DATA_FROM_L2 384
#define POWER5_PME_PM_LSU0_FLUSH_SRQ 385
#define POWER5_PME_PM_FAB_PNtoNN_DIRECT 386
#define POWER5_PME_PM_IOPS_CMPL 387
#define POWER5_PME_PM_L2SC_SHR_INV 388
#define POWER5_PME_PM_L2SA_RCST_DISP_FAIL_OTHER 389
#define POWER5_PME_PM_L2SA_RCST_DISP 390
#define POWER5_PME_PM_SNOOP_RETRY_AB_COLLISION 391
#define POWER5_PME_PM_FAB_PNtoVN_SIDECAR 392
#define POWER5_PME_PM_LSU_LMQ_S0_ALLOC 393
#define POWER5_PME_PM_LSU0_REJECT_LMQ_FULL 394
#define POWER5_PME_PM_SNOOP_PW_RETRY_RQ 395
#define POWER5_PME_PM_DTLB_REF 396
#define POWER5_PME_PM_PTEG_FROM_L3 397
#define POWER5_PME_PM_FAB_M1toVNorNN_SIDECAR_EMPTY 398
#define POWER5_PME_PM_LSU_SRQ_EMPTY_CYC 399
#define POWER5_PME_PM_FPU1_STF 400
#define POWER5_PME_PM_LSU_LMQ_S0_VALID 401
#define POWER5_PME_PM_GCT_USAGE_00to59_CYC 402
#define POWER5_PME_PM_DATA_FROM_L2MISS 403
#define POWER5_PME_PM_GRP_DISP_BLK_SB_CYC 404
#define POWER5_PME_PM_FPU_FMOV_FEST 405
#define POWER5_PME_PM_XER_MAP_FULL_CYC 406
#define POWER5_PME_PM_FLUSH_SB 407
#define POWER5_PME_PM_MRK_DATA_FROM_L375_SHR 408
#define POWER5_PME_PM_MRK_GRP_CMPL 409
#define POWER5_PME_PM_SUSPENDED 410
#define POWER5_PME_PM_GRP_IC_MISS_BR_REDIR_NONSPEC 411
#define POWER5_PME_PM_SNOOP_RD_RETRY_QFULL 412
#define POWER5_PME_PM_L3SB_MOD_INV 413
#define POWER5_PME_PM_DATA_FROM_L35_SHR 414
#define POWER5_PME_PM_LD_MISS_L1_LSU1 415
#define POWER5_PME_PM_STCX_FAIL 416
#define POWER5_PME_PM_DC_PREF_DST 417
#define POWER5_PME_PM_GRP_DISP 418
#define POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_ADDR 419
#define POWER5_PME_PM_FPU0_FPSCR 420
#define POWER5_PME_PM_DATA_FROM_L2 421
#define POWER5_PME_PM_FPU1_DENORM 422
#define POWER5_PME_PM_FPU_1FLOP 423
#define POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_OTHER 424
#define POWER5_PME_PM_L2SC_RCST_DISP_FAIL_RC_FULL 425
#define POWER5_PME_PM_FPU0_FSQRT 426
#define POWER5_PME_PM_LD_REF_L1 427
#define POWER5_PME_PM_INST_FROM_L1 428
#define POWER5_PME_PM_TLBIE_HELD 429
#define POWER5_PME_PM_DC_PREF_OUT_OF_STREAMS 430
#define POWER5_PME_PM_MRK_DATA_FROM_L25_MOD_CYC 431
#define POWER5_PME_PM_MRK_LSU1_FLUSH_SRQ 432
#define POWER5_PME_PM_MEM_RQ_DISP_Q0to3 433
#define POWER5_PME_PM_ST_REF_L1_LSU1 434
#define POWER5_PME_PM_MRK_LD_MISS_L1 435
#define POWER5_PME_PM_L1_WRITE_CYC 436
#define POWER5_PME_PM_L2SC_ST_REQ 437
#define POWER5_PME_PM_CMPLU_STALL_FDIV 438
#define POWER5_PME_PM_THRD_SEL_OVER_CLB_EMPTY 439
#define POWER5_PME_PM_BR_MPRED_CR 440
#define POWER5_PME_PM_L3SB_MOD_TAG 441
#define POWER5_PME_PM_MRK_DATA_FROM_L2MISS 442
#define POWER5_PME_PM_LSU_REJECT_SRQ 443
#define POWER5_PME_PM_LD_MISS_L1 444
#define POWER5_PME_PM_INST_FROM_PREF 445
#define POWER5_PME_PM_DC_INV_L2 446
#define POWER5_PME_PM_STCX_PASS 447
#define POWER5_PME_PM_LSU_SRQ_FULL_CYC 448
#define POWER5_PME_PM_FPU_FIN 449
#define POWER5_PME_PM_L2SA_SHR_MOD 450
#define POWER5_PME_PM_LSU_SRQ_STFWD 451
#define POWER5_PME_PM_0INST_CLB_CYC 452
#define POWER5_PME_PM_FXU0_FIN 453
#define POWER5_PME_PM_L2SB_RCST_DISP_FAIL_RC_FULL 454
#define POWER5_PME_PM_THRD_GRP_CMPL_BOTH_CYC 455
#define POWER5_PME_PM_PMC5_OVERFLOW 456
#define POWER5_PME_PM_FPU0_FDIV 457
#define POWER5_PME_PM_PTEG_FROM_L375_SHR 458
#define POWER5_PME_PM_LD_REF_L1_LSU1 459
#define POWER5_PME_PM_L2SA_RC_DISP_FAIL_CO_BUSY 460
#define POWER5_PME_PM_HV_CYC 461
#define POWER5_PME_PM_THRD_PRIO_DIFF_0_CYC 462
#define POWER5_PME_PM_LR_CTR_MAP_FULL_CYC 463
#define POWER5_PME_PM_L3SB_SHR_INV 464
#define POWER5_PME_PM_DATA_FROM_RMEM 465
#define POWER5_PME_PM_DATA_FROM_L275_MOD 466
#define POWER5_PME_PM_LSU0_REJECT_SRQ 467
#define POWER5_PME_PM_LSU1_DERAT_MISS 468
#define POWER5_PME_PM_MRK_LSU_FIN 469
#define POWER5_PME_PM_DTLB_MISS_16M 470
#define POWER5_PME_PM_LSU0_FLUSH_UST 471
#define POWER5_PME_PM_L2SC_MOD_TAG 472
#define POWER5_PME_PM_L2SB_RC_DISP_FAIL_CO_BUSY 473

static const pme_power_entry_t power5_pe[] = {
	[ POWER5_PME_PM_LSU_REJECT_RELOAD_CDF ] = {
		.pme_name = "PM_LSU_REJECT_RELOAD_CDF",
		.pme_code = 0x2c6090,
		.pme_short_desc = "LSU reject due to reload CDF or tag update collision",
		.pme_long_desc = "Total cycles the Load Store Unit is busy rejecting instructions because of Critical Data Forward.  When critical data arrives from the storage system it is formatted and immediately forwarded, bypassing the data cache, to the destination register using the result bus.  Any instruction the requires the result bus in the same cycle is rejected.  Tag update rejects are caused when an instruction requires access to the Dcache directory or ERAT in the same system when they are being updated.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_FPU1_SINGLE ] = {
		.pme_name = "PM_FPU1_SINGLE",
		.pme_code = 0x20e7,
		.pme_short_desc = "FPU1 executed single precision instruction",
		.pme_long_desc = "FPU1 has executed a single precision instruction.",
	},
	[ POWER5_PME_PM_L3SB_REF ] = {
		.pme_name = "PM_L3SB_REF",
		.pme_code = 0x701c4,
		.pme_short_desc = "L3 slice B references",
		.pme_long_desc = "Number of attempts made by this chip cores to find data in the L3. Reported per L3 slice ",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_3or4_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_3or4_CYC",
		.pme_code = 0x430e5,
		.pme_short_desc = "Cycles thread priority difference is 3 or 4",
		.pme_long_desc = "Cycles when this thread's priority is higher than the other thread's priority by 3 or 4.",
	},
	[ POWER5_PME_PM_INST_FROM_L275_SHR ] = {
		.pme_name = "PM_INST_FROM_L275_SHR",
		.pme_code = 0x322096,
		.pme_short_desc = "Instruction fetched from L2.75 shared",
		.pme_long_desc = "An instruction fetch group was fetched with shared (T) data from the L2 on a different module than this processor is located. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L375_MOD ] = {
		.pme_name = "PM_MRK_DATA_FROM_L375_MOD",
		.pme_code = 0x1c70a7,
		.pme_short_desc = "Marked data loaded from L3.75 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified  (M) data from the L3 of a chip on a different module than this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_DTLB_MISS_4K ] = {
		.pme_name = "PM_DTLB_MISS_4K",
		.pme_code = 0xc40c0,
		.pme_short_desc = "Data TLB miss for 4K page",
		.pme_long_desc = "Data TLB references to 4KB pages that missed the TLB. Page size is determined at TLB reload time.",
	},
	[ POWER5_PME_PM_CLB_FULL_CYC ] = {
		.pme_name = "PM_CLB_FULL_CYC",
		.pme_code = 0x220e5,
		.pme_short_desc = "Cycles CLB full",
		.pme_long_desc = "Cycles when both thread's CLB is full.",
	},
	[ POWER5_PME_PM_MRK_ST_CMPL ] = {
		.pme_name = "PM_MRK_ST_CMPL",
		.pme_code = 0x100003,
		.pme_short_desc = "Marked store instruction completed",
		.pme_long_desc = "A sampled store has completed (data home)",
	},
	[ POWER5_PME_PM_LSU_FLUSH_LRQ_FULL ] = {
		.pme_name = "PM_LSU_FLUSH_LRQ_FULL",
		.pme_code = 0x320e7,
		.pme_short_desc = "Flush caused by LRQ full",
		.pme_long_desc = "This thread was flushed at dispatch because its Load Request Queue was full. This allows the other thread to have more machine resources for it to make progress while this thread is stalled.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L275_SHR ] = {
		.pme_name = "PM_MRK_DATA_FROM_L275_SHR",
		.pme_code = 0x3c7097,
		.pme_short_desc = "Marked data loaded from L2.75 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (T) data from the L2 on a different module than this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_1INST_CLB_CYC ] = {
		.pme_name = "PM_1INST_CLB_CYC",
		.pme_code = 0x400c1,
		.pme_short_desc = "Cycles 1 instruction in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_MEM_SPEC_RD_CANCEL ] = {
		.pme_name = "PM_MEM_SPEC_RD_CANCEL",
		.pme_code = 0x721e6,
		.pme_short_desc = "Speculative memory read cancelled",
		.pme_long_desc = "Speculative memory read cancelled (i.e. cresp = sourced by L2/L3)",
	},
	[ POWER5_PME_PM_MRK_DTLB_MISS_16M ] = {
		.pme_name = "PM_MRK_DTLB_MISS_16M",
		.pme_code = 0xc40c5,
		.pme_short_desc = "Marked Data TLB misses for 16M page",
		.pme_long_desc = "Marked Data TLB misses for 16M page",
	},
	[ POWER5_PME_PM_FPU_FDIV ] = {
		.pme_name = "PM_FPU_FDIV",
		.pme_code = 0x100088,
		.pme_short_desc = "FPU executed FDIV instruction",
		.pme_long_desc = "The floating point unit has executed a divide instruction. This could be fdiv, fdivs, fdiv., fdivs.. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_FPU_SINGLE ] = {
		.pme_name = "PM_FPU_SINGLE",
		.pme_code = 0x102090,
		.pme_short_desc = "FPU executed single precision instruction",
		.pme_long_desc = "FPU is executing single precision instruction. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_FPU0_FMA ] = {
		.pme_name = "PM_FPU0_FMA",
		.pme_code = 0xc1,
		.pme_short_desc = "FPU0 executed multiply-add instruction",
		.pme_long_desc = "The floating point unit has executed a multiply-add kind of instruction.  This could be fmadd*, fnmadd*, fmsub*, fnmsub* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_SLB_MISS ] = {
		.pme_name = "PM_SLB_MISS",
		.pme_code = 0x280088,
		.pme_short_desc = "SLB misses",
		.pme_long_desc = "Total of all Segment Lookaside Buffer (SLB) misses, Instructions + Data.",
	},
	[ POWER5_PME_PM_LSU1_FLUSH_LRQ ] = {
		.pme_name = "PM_LSU1_FLUSH_LRQ",
		.pme_code = 0xc00c6,
		.pme_short_desc = "LSU1 LRQ flushes",
		.pme_long_desc = "A load was flushed by unit 1 because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.",
	},
	[ POWER5_PME_PM_L2SA_ST_HIT ] = {
		.pme_name = "PM_L2SA_ST_HIT",
		.pme_code = 0x733e0,
		.pme_short_desc = "L2 slice A store hits",
		.pme_long_desc = "A store request made from the core hit in the L2 directory.  This event is provided on each of the three L2 slices A, B, and C.",
	},
	[ POWER5_PME_PM_DTLB_MISS ] = {
		.pme_name = "PM_DTLB_MISS",
		.pme_code = 0x800c4,
		.pme_short_desc = "Data TLB misses",
		.pme_long_desc = "Data TLB misses, all page sizes.",
	},
	[ POWER5_PME_PM_BR_PRED_TA ] = {
		.pme_name = "PM_BR_PRED_TA",
		.pme_code = 0x230e3,
		.pme_short_desc = "A conditional branch was predicted, target prediction",
		.pme_long_desc = "The target address of a branch instruction was predicted.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L375_MOD_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L375_MOD_CYC",
		.pme_code = 0x4c70a7,
		.pme_short_desc = "Marked load latency from L3.75 modified",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_FXU ] = {
		.pme_name = "PM_CMPLU_STALL_FXU",
		.pme_code = 0x211099,
		.pme_short_desc = "Completion stall caused by FXU instruction",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes was a fixed point instruction.",
	},
	[ POWER5_PME_PM_EXT_INT ] = {
		.pme_name = "PM_EXT_INT",
		.pme_code = 0x400003,
		.pme_short_desc = "External interrupts",
		.pme_long_desc = "An interrupt due to an external exception occurred",
	},
	[ POWER5_PME_PM_MRK_LSU1_FLUSH_LRQ ] = {
		.pme_name = "PM_MRK_LSU1_FLUSH_LRQ",
		.pme_code = 0x810c6,
		.pme_short_desc = "LSU1 marked LRQ flushes",
		.pme_long_desc = "A marked load was flushed by unit 1 because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.",
	},
	[ POWER5_PME_PM_LSU1_LDF ] = {
		.pme_name = "PM_LSU1_LDF",
		.pme_code = 0xc50c4,
		.pme_short_desc = "LSU1 executed Floating Point load instruction",
		.pme_long_desc = "A floating point load was executed by LSU1",
	},
	[ POWER5_PME_PM_MRK_ST_GPS ] = {
		.pme_name = "PM_MRK_ST_GPS",
		.pme_code = 0x200003,
		.pme_short_desc = "Marked store sent to GPS",
		.pme_long_desc = "A sampled store has been sent to the memory subsystem",
	},
	[ POWER5_PME_PM_FAB_CMD_ISSUED ] = {
		.pme_name = "PM_FAB_CMD_ISSUED",
		.pme_code = 0x700c7,
		.pme_short_desc = "Fabric command issued",
		.pme_long_desc = "Incremented when a chip issues a command on its SnoopA address bus. Each of the two address busses (SnoopA and SnoopB) is capable of one transaction per fabric cycle (one fabric cycle = 2 cpu cycles in normal 2:1 mode), but each chip can only drive the SnoopA bus, and can only drive one transaction every two fabric cycles (i.e., every four cpu cycles). In MCM-based systems, two chips interleave their accesses to each of the two fabric busses (SnoopA, SnoopB) to reach a peak capability of one transaction per cpu clock cycle. The two chips that drive SnoopB are wired so that the chips refer to the bus as SnoopA but it is connected to the other two chips as SnoopB.  Note that this event will only be recorded by the FBC on the chip that sourced the operation. The signal is delivered at FBC speed and the count must be scaled.",
	},
	[ POWER5_PME_PM_LSU0_SRQ_STFWD ] = {
		.pme_name = "PM_LSU0_SRQ_STFWD",
		.pme_code = 0xc20e0,
		.pme_short_desc = "LSU0 SRQ store forwarded",
		.pme_long_desc = "Data from a store instruction was forwarded to a load on unit 0.  A load that misses L1 but becomes a store forward is treated as a load miss and it causes the DL1 load miss event to be counted.  It does not go into the LMQ. If a load that hits L1 but becomes a store forward, then it's not treated as a load miss.",
	},
	[ POWER5_PME_PM_CR_MAP_FULL_CYC ] = {
		.pme_name = "PM_CR_MAP_FULL_CYC",
		.pme_code = 0x100c4,
		.pme_short_desc = "Cycles CR logical operation mapper full",
		.pme_long_desc = "The Conditional Register mapper cannot accept any more groups. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the mapper was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_L2SA_RCST_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SA_RCST_DISP_FAIL_RC_FULL",
		.pme_code = 0x722e0,
		.pme_short_desc = "L2 slice A RC store dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_MRK_LSU0_FLUSH_ULD ] = {
		.pme_name = "PM_MRK_LSU0_FLUSH_ULD",
		.pme_code = 0x810c0,
		.pme_short_desc = "LSU0 marked unaligned load flushes",
		.pme_long_desc = "A marked load was flushed from unit 0 because it was unaligned (crossed a 64byte boundary, or 32 byte if it missed the L1)",
	},
	[ POWER5_PME_PM_LSU_FLUSH_SRQ_FULL ] = {
		.pme_name = "PM_LSU_FLUSH_SRQ_FULL",
		.pme_code = 0x330e0,
		.pme_short_desc = "Flush caused by SRQ full",
		.pme_long_desc = "This thread was flushed at dispatch because its Store Request Queue was full. This allows the other thread to have more machine resources for it to make progress while this thread is stalled.",
	},
	[ POWER5_PME_PM_FLUSH_IMBAL ] = {
		.pme_name = "PM_FLUSH_IMBAL",
		.pme_code = 0x330e3,
		.pme_short_desc = "Flush caused by thread GCT imbalance",
		.pme_long_desc = "This thread has been flushed at dispatch because it is stalled and a GCT imbalance exists.  GCT thresholds are set in the TSCR register. This allows the other thread to have more machine resources for it to make progress while this thread is stalled.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP_Q16to19 ] = {
		.pme_name = "PM_MEM_RQ_DISP_Q16to19",
		.pme_code = 0x727e6,
		.pme_short_desc = "Memory read queue dispatched to queues 16-19",
		.pme_long_desc = "A memory operation was dispatched to read queue 16,17,18 or 19. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_minus3or4_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_minus3or4_CYC",
		.pme_code = 0x430e1,
		.pme_short_desc = "Cycles thread priority difference is -3 or -4",
		.pme_long_desc = "Cycles when this thread's priority is lower than the other thread's priority by 3 or 4.",
	},
	[ POWER5_PME_PM_DATA_FROM_L35_MOD ] = {
		.pme_name = "PM_DATA_FROM_L35_MOD",
		.pme_code = 0x2c309e,
		.pme_short_desc = "Data loaded from L3.5 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L3 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_MEM_HI_PRIO_WR_CMPL ] = {
		.pme_name = "PM_MEM_HI_PRIO_WR_CMPL",
		.pme_code = 0x726e6,
		.pme_short_desc = "High priority write completed",
		.pme_long_desc = "A memory write,  which was upgraded to high priority, completed.  Writes can be upgraded to high priority to ensure that read traffic does not lock out writes. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FPU1_FDIV ] = {
		.pme_name = "PM_FPU1_FDIV",
		.pme_code = 0xc4,
		.pme_short_desc = "FPU1 executed FDIV instruction",
		.pme_long_desc = "FPU1 has executed a divide instruction.  This could be fdiv, fdivs, fdiv. fdivs.",
	},
	[ POWER5_PME_PM_FPU0_FRSP_FCONV ] = {
		.pme_name = "PM_FPU0_FRSP_FCONV",
		.pme_code = 0x10c1,
		.pme_short_desc = "FPU0 executed FRSP or FCONV instructions",
		.pme_long_desc = "FPU0 has executed a frsp or convert kind of instruction. This could be frsp*, fcfid*, fcti* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP ] = {
		.pme_name = "PM_MEM_RQ_DISP",
		.pme_code = 0x701c6,
		.pme_short_desc = "Memory read queue dispatched",
		.pme_long_desc = "A memory read was dispatched. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LWSYNC_HELD ] = {
		.pme_name = "PM_LWSYNC_HELD",
		.pme_code = 0x130e0,
		.pme_short_desc = "LWSYNC held at dispatch",
		.pme_long_desc = "Cycles a LWSYNC instruction was held at dispatch. LWSYNC instructions are held at dispatch until all previous loads are done and all previous stores have issued. LWSYNC enters the Store Request Queue and is sent to the storage subsystem but does not wait for a response.",
	},
	[ POWER5_PME_PM_FXU_FIN ] = {
		.pme_name = "PM_FXU_FIN",
		.pme_code = 0x313088,
		.pme_short_desc = "FXU produced a result",
		.pme_long_desc = "The fixed point unit (Unit 0 + Unit 1) finished an instruction. Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_DSLB_MISS ] = {
		.pme_name = "PM_DSLB_MISS",
		.pme_code = 0x800c5,
		.pme_short_desc = "Data SLB misses",
		.pme_long_desc = "A SLB miss for a data request occurred. SLB misses trap to the operating system to resolve.",
	},
	[ POWER5_PME_PM_FXLS1_FULL_CYC ] = {
		.pme_name = "PM_FXLS1_FULL_CYC",
		.pme_code = 0x110c4,
		.pme_short_desc = "Cycles FXU1/LS1 queue full",
		.pme_long_desc = "The issue queue that feeds the Fixed Point unit 1 / Load Store Unit 1 is full. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the queue was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_DATA_FROM_L275_SHR ] = {
		.pme_name = "PM_DATA_FROM_L275_SHR",
		.pme_code = 0x3c3097,
		.pme_short_desc = "Data loaded from L2.75 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (T) data from the L2 on a different module than this processor is located due to a demand load. ",
	},
	[ POWER5_PME_PM_THRD_SEL_T0 ] = {
		.pme_name = "PM_THRD_SEL_T0",
		.pme_code = 0x410c0,
		.pme_short_desc = "Decode selected thread 0",
		.pme_long_desc = "Thread selection picked thread 0 for decode.",
	},
	[ POWER5_PME_PM_PTEG_RELOAD_VALID ] = {
		.pme_name = "PM_PTEG_RELOAD_VALID",
		.pme_code = 0x830e4,
		.pme_short_desc = "PTEG reload valid",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB.",
	},
	[ POWER5_PME_PM_LSU_LMQ_LHR_MERGE ] = {
		.pme_name = "PM_LSU_LMQ_LHR_MERGE",
		.pme_code = 0xc70e5,
		.pme_short_desc = "LMQ LHR merges",
		.pme_long_desc = "A data cache miss occurred for the same real cache line address as an earlier request already in the Load Miss Queue and was merged into the LMQ entry.",
	},
	[ POWER5_PME_PM_MRK_STCX_FAIL ] = {
		.pme_name = "PM_MRK_STCX_FAIL",
		.pme_code = 0x820e6,
		.pme_short_desc = "Marked STCX failed",
		.pme_long_desc = "A marked stcx (stwcx or stdcx) failed",
	},
	[ POWER5_PME_PM_2INST_CLB_CYC ] = {
		.pme_name = "PM_2INST_CLB_CYC",
		.pme_code = 0x400c2,
		.pme_short_desc = "Cycles 2 instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_FAB_PNtoVN_DIRECT ] = {
		.pme_name = "PM_FAB_PNtoVN_DIRECT",
		.pme_code = 0x723e7,
		.pme_short_desc = "PN to VN beat went straight to its destination",
		.pme_long_desc = "Fabric Data beats that the base chip takes the inbound PN data and passes it through to the outbound VN bus without going into a sidecar. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L2MISS ] = {
		.pme_name = "PM_PTEG_FROM_L2MISS",
		.pme_code = 0x38309b,
		.pme_short_desc = "PTEG loaded from L2 miss",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB but not from the local L2.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_LSU ] = {
		.pme_name = "PM_CMPLU_STALL_LSU",
		.pme_code = 0x211098,
		.pme_short_desc = "Completion stall caused by LSU instruction",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes was a load/store instruction.",
	},
	[ POWER5_PME_PM_MRK_DSLB_MISS ] = {
		.pme_name = "PM_MRK_DSLB_MISS",
		.pme_code = 0xc50c7,
		.pme_short_desc = "Marked Data SLB misses",
		.pme_long_desc = "A Data SLB miss was caused by a marked instruction.",
	},
	[ POWER5_PME_PM_LSU_FLUSH_ULD ] = {
		.pme_name = "PM_LSU_FLUSH_ULD",
		.pme_code = 0x1c0088,
		.pme_short_desc = "LRQ unaligned load flushes",
		.pme_long_desc = "A load was flushed because it was unaligned (crossed a 64byte boundary, or 32 byte if it missed the L1).  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_PTEG_FROM_LMEM ] = {
		.pme_name = "PM_PTEG_FROM_LMEM",
		.pme_code = 0x283087,
		.pme_short_desc = "PTEG loaded from local memory",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB from memory attached to the same module this proccessor is located on.",
	},
	[ POWER5_PME_PM_MRK_BRU_FIN ] = {
		.pme_name = "PM_MRK_BRU_FIN",
		.pme_code = 0x200005,
		.pme_short_desc = "Marked instruction BRU processing finished",
		.pme_long_desc = "The branch unit finished a marked instruction. Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_MEM_WQ_DISP_WRITE ] = {
		.pme_name = "PM_MEM_WQ_DISP_WRITE",
		.pme_code = 0x703c6,
		.pme_short_desc = "Memory write queue dispatched due to write",
		.pme_long_desc = "A memory write was dispatched to a write queue. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L275_MOD_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L275_MOD_CYC",
		.pme_code = 0x4c70a3,
		.pme_short_desc = "Marked load latency from L2.75 modified",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_LSU1_NCLD ] = {
		.pme_name = "PM_LSU1_NCLD",
		.pme_code = 0xc50c5,
		.pme_short_desc = "LSU1 non-cacheable loads",
		.pme_long_desc = "A non-cacheable load was executed by Unit 0.",
	},
	[ POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SA_RCLD_DISP_FAIL_OTHER",
		.pme_code = 0x731e0,
		.pme_short_desc = "L2 slice A RC load dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a load failed for some reason other than Full or Collision conditions.",
	},
	[ POWER5_PME_PM_SNOOP_PW_RETRY_WQ_PWQ ] = {
		.pme_name = "PM_SNOOP_PW_RETRY_WQ_PWQ",
		.pme_code = 0x717c6,
		.pme_short_desc = "Snoop partial-write retry due to collision with active write or partial-write queue",
		.pme_long_desc = "A snoop request for a partial write to memory was retried because it matched the cache line of an active write or partial write.  When this happens the snoop request is retried and the active write is changed to high priority.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FPR_MAP_FULL_CYC ] = {
		.pme_name = "PM_FPR_MAP_FULL_CYC",
		.pme_code = 0x100c1,
		.pme_short_desc = "Cycles FPR mapper full",
		.pme_long_desc = "The floating point unit has executed an add, mult, sub, compare, fsel, fneg, fabs, fnabs, fres, or frsqrte kind of instruction.  These are single FLOP operations. ",
	},
	[ POWER5_PME_PM_FPU1_FULL_CYC ] = {
		.pme_name = "PM_FPU1_FULL_CYC",
		.pme_code = 0x100c7,
		.pme_short_desc = "Cycles FPU1 issue queue full",
		.pme_long_desc = "The issue queue for FPU1 cannot accept any more instructions. Dispatch to this issue queue is stopped",
	},
	[ POWER5_PME_PM_L3SA_ALL_BUSY ] = {
		.pme_name = "PM_L3SA_ALL_BUSY",
		.pme_code = 0x721e3,
		.pme_short_desc = "L3 slice A active for every cycle all CI/CO machines busy",
		.pme_long_desc = "Cycles All Castin/Castout machines are busy.",
	},
	[ POWER5_PME_PM_3INST_CLB_CYC ] = {
		.pme_name = "PM_3INST_CLB_CYC",
		.pme_code = 0x400c3,
		.pme_short_desc = "Cycles 3 instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_MEM_PWQ_DISP_Q2or3 ] = {
		.pme_name = "PM_MEM_PWQ_DISP_Q2or3",
		.pme_code = 0x734e6,
		.pme_short_desc = "Memory partial-write queue dispatched to Write Queue 2 or 3",
		.pme_long_desc = "Memory partial-write queue dispatched to Write Queue 2 or 3. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_L2SA_SHR_INV ] = {
		.pme_name = "PM_L2SA_SHR_INV",
		.pme_code = 0x710c0,
		.pme_short_desc = "L2 slice A transition from shared to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L, or Tagged) to the Invalid state. This transition was caused by any external snoop request. The event is provided on each of the three slices A, B, and C. NOTE: For this event to be useful the tablewalk duration event should also be counted.",
	},
	[ POWER5_PME_PM_THRESH_TIMEO ] = {
		.pme_name = "PM_THRESH_TIMEO",
		.pme_code = 0x30000b,
		.pme_short_desc = "Threshold timeout",
		.pme_long_desc = "The threshold timer expired",
	},
	[ POWER5_PME_PM_L2SA_RC_DISP_FAIL_CO_BUSY_ALL ] = {
		.pme_name = "PM_L2SA_RC_DISP_FAIL_CO_BUSY_ALL",
		.pme_code = 0x713c0,
		.pme_short_desc = "L2 slice A RC dispatch attempt failed due to all CO busy",
		.pme_long_desc = "A Read/Claim dispatch was rejected because all Castout machines were busy.",
	},
	[ POWER5_PME_PM_THRD_SEL_OVER_GCT_IMBAL ] = {
		.pme_name = "PM_THRD_SEL_OVER_GCT_IMBAL",
		.pme_code = 0x410c4,
		.pme_short_desc = "Thread selection overrides caused by GCT imbalance",
		.pme_long_desc = "Thread selection was overridden because of a GCT imbalance.",
	},
	[ POWER5_PME_PM_FPU_FSQRT ] = {
		.pme_name = "PM_FPU_FSQRT",
		.pme_code = 0x200090,
		.pme_short_desc = "FPU executed FSQRT instruction",
		.pme_long_desc = "The floating point unit has executed a square root instruction. This could be fsqrt* where XYZ* means XYZ, XYZs, XYZ., XYZs. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_MRK_LSU0_FLUSH_LRQ ] = {
		.pme_name = "PM_MRK_LSU0_FLUSH_LRQ",
		.pme_code = 0x810c2,
		.pme_short_desc = "LSU0 marked LRQ flushes",
		.pme_long_desc = "A marked load was flushed by unit 0 because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.",
	},
	[ POWER5_PME_PM_PMC1_OVERFLOW ] = {
		.pme_name = "PM_PMC1_OVERFLOW",
		.pme_code = 0x20000a,
		.pme_short_desc = "PMC1 Overflow",
		.pme_long_desc = "Overflows from PMC1 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_L3SC_SNOOP_RETRY ] = {
		.pme_name = "PM_L3SC_SNOOP_RETRY",
		.pme_code = 0x731e5,
		.pme_short_desc = "L3 slice C snoop retries",
		.pme_long_desc = "Number of times an L3 retried a snoop because it got two in at the same time (one on snp_a, one on snp_b)",
	},
	[ POWER5_PME_PM_DATA_TABLEWALK_CYC ] = {
		.pme_name = "PM_DATA_TABLEWALK_CYC",
		.pme_code = 0x800c7,
		.pme_short_desc = "Cycles doing data tablewalks",
		.pme_long_desc = "Cycles a translation tablewalk is active.  While a tablewalk is active any request attempting to access the TLB will be rejected and retried.",
	},
	[ POWER5_PME_PM_THRD_PRIO_6_CYC ] = {
		.pme_name = "PM_THRD_PRIO_6_CYC",
		.pme_code = 0x420e5,
		.pme_short_desc = "Cycles thread running at priority level 6",
		.pme_long_desc = "Cycles this thread was running at priority level 6.",
	},
	[ POWER5_PME_PM_FPU_FEST ] = {
		.pme_name = "PM_FPU_FEST",
		.pme_code = 0x401090,
		.pme_short_desc = "FPU executed FEST instruction",
		.pme_long_desc = "The floating point unit has executed an estimate instructions. This could be fres* or frsqrte* where XYZ* means XYZ or  XYZ.   Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_FAB_M1toP1_SIDECAR_EMPTY ] = {
		.pme_name = "PM_FAB_M1toP1_SIDECAR_EMPTY",
		.pme_code = 0x702c7,
		.pme_short_desc = "M1 to P1 sidecar empty",
		.pme_long_desc = "Fabric cycles when the Minus-1 hip/hop sidecars (sidecars for chip to chip data transfer) are empty. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_RMEM ] = {
		.pme_name = "PM_MRK_DATA_FROM_RMEM",
		.pme_code = 0x1c70a1,
		.pme_short_desc = "Marked data loaded from remote memory",
		.pme_long_desc = "The processor's Data Cache was reloaded due to a marked load from memory attached to a different module than this proccessor is located on.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L35_MOD_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L35_MOD_CYC",
		.pme_code = 0x4c70a6,
		.pme_short_desc = "Marked load latency from L3.5 modified",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_MEM_PWQ_DISP ] = {
		.pme_name = "PM_MEM_PWQ_DISP",
		.pme_code = 0x704c6,
		.pme_short_desc = "Memory partial-write queue dispatched",
		.pme_long_desc = "Number of Partial Writes dispatched.  The MC provides resources to gather partial cacheline writes (Partial line DMA writes & CI-stores) to up to four different cachelines at a time.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FAB_P1toM1_SIDECAR_EMPTY ] = {
		.pme_name = "PM_FAB_P1toM1_SIDECAR_EMPTY",
		.pme_code = 0x701c7,
		.pme_short_desc = "P1 to M1 sidecar empty",
		.pme_long_desc = "Fabric cycles when the Plus-1 hip/hop sidecars (sidecars for chip to chip data transfer) are empty. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LD_MISS_L1_LSU0 ] = {
		.pme_name = "PM_LD_MISS_L1_LSU0",
		.pme_code = 0xc10c2,
		.pme_short_desc = "LSU0 L1 D cache load misses",
		.pme_long_desc = "Load references that miss the Level 1 Data cache, by unit 0.",
	},
	[ POWER5_PME_PM_SNOOP_PARTIAL_RTRY_QFULL ] = {
		.pme_name = "PM_SNOOP_PARTIAL_RTRY_QFULL",
		.pme_code = 0x730e6,
		.pme_short_desc = "Snoop partial write retry due to partial-write queues full",
		.pme_long_desc = "A snoop request for a partial write to memory was retried because the write queues that handle partial writes were full. When this happens the active writes are changed to high priority. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FPU1_STALL3 ] = {
		.pme_name = "PM_FPU1_STALL3",
		.pme_code = 0x20e5,
		.pme_short_desc = "FPU1 stalled in pipe3",
		.pme_long_desc = "FPU1 has generated a stall in pipe3 due to overflow, underflow, massive cancel, convert to integer (sometimes), or convert from integer (always).",
	},
	[ POWER5_PME_PM_GCT_USAGE_80to99_CYC ] = {
		.pme_name = "PM_GCT_USAGE_80to99_CYC",
		.pme_code = 0x30001f,
		.pme_short_desc = "Cycles GCT 80-99% full",
		.pme_long_desc = "Cycles when the Global Completion Table has between 80% and 99% of its slots used.  The GCT has 20 entries shared between threads",
	},
	[ POWER5_PME_PM_WORK_HELD ] = {
		.pme_name = "PM_WORK_HELD",
		.pme_code = 0x40000c,
		.pme_short_desc = "Work held",
		.pme_long_desc = "RAS Unit has signaled completion to stop and there are groups waiting to complete",
	},
	[ POWER5_PME_PM_INST_CMPL ] = {
		.pme_name = "PM_INST_CMPL",
		.pme_code = 0x100009,
		.pme_short_desc = "Instructions completed",
		.pme_long_desc = "Number of PowerPC instructions that completed. ",
	},
	[ POWER5_PME_PM_LSU1_FLUSH_UST ] = {
		.pme_name = "PM_LSU1_FLUSH_UST",
		.pme_code = 0xc00c5,
		.pme_short_desc = "LSU1 unaligned store flushes",
		.pme_long_desc = "A store was flushed from unit 1 because it was unaligned (crossed a 4K boundary)",
	},
	[ POWER5_PME_PM_FXU_IDLE ] = {
		.pme_name = "PM_FXU_IDLE",
		.pme_code = 0x100012,
		.pme_short_desc = "FXU idle",
		.pme_long_desc = "FXU0 and FXU1 are both idle.",
	},
	[ POWER5_PME_PM_LSU0_FLUSH_ULD ] = {
		.pme_name = "PM_LSU0_FLUSH_ULD",
		.pme_code = 0xc00c0,
		.pme_short_desc = "LSU0 unaligned load flushes",
		.pme_long_desc = "A load was flushed from unit 0 because it was unaligned (crossed a 64 byte boundary, or 32 byte if it missed the L1)",
	},
	[ POWER5_PME_PM_LSU1_REJECT_LMQ_FULL ] = {
		.pme_name = "PM_LSU1_REJECT_LMQ_FULL",
		.pme_code = 0xc60e5,
		.pme_short_desc = "LSU1 reject due to LMQ full or missed data coming",
		.pme_long_desc = "Total cycles the Load Store Unit 1 is busy rejecting instructions because the Load Miss Queue was full. The LMQ has eight entries.  If all eight entries are full, subsequent load instructions are rejected.",
	},
	[ POWER5_PME_PM_GRP_DISP_REJECT ] = {
		.pme_name = "PM_GRP_DISP_REJECT",
		.pme_code = 0x120e4,
		.pme_short_desc = "Group dispatch rejected",
		.pme_long_desc = "A group that previously attempted dispatch was rejected.",
	},
	[ POWER5_PME_PM_L2SA_MOD_INV ] = {
		.pme_name = "PM_L2SA_MOD_INV",
		.pme_code = 0x730e0,
		.pme_short_desc = "L2 slice A transition from modified to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Invalid state. This transition was caused by any RWITM snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L25_SHR ] = {
		.pme_name = "PM_PTEG_FROM_L25_SHR",
		.pme_code = 0x183097,
		.pme_short_desc = "PTEG loaded from L2.5 shared",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with shared  (T or SL) data from the L2 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_FAB_CMD_RETRIED ] = {
		.pme_name = "PM_FAB_CMD_RETRIED",
		.pme_code = 0x710c7,
		.pme_short_desc = "Fabric command retried",
		.pme_long_desc = "Incremented when a command issued by a chip on its SnoopA address bus is retried for any reason. The overwhelming majority of retries are due to running out of memory controller queues but retries can also be caused by trying to reference addresses that are in a transient cache state -- e.g. a line is transient after issuing a DCLAIM instruction to a shared line but before the associated store completes.  Each chip reports its own counts.  The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_L3SA_SHR_INV ] = {
		.pme_name = "PM_L3SA_SHR_INV",
		.pme_code = 0x710c3,
		.pme_short_desc = "L3 slice A transition from shared to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is Sx in this L3(i.e. invalidate hit SX and dispatched).",
	},
	[ POWER5_PME_PM_L2SB_RC_DISP_FAIL_CO_BUSY_ALL ] = {
		.pme_name = "PM_L2SB_RC_DISP_FAIL_CO_BUSY_ALL",
		.pme_code = 0x713c1,
		.pme_short_desc = "L2 slice B RC dispatch attempt failed due to all CO busy",
		.pme_long_desc = "A Read/Claim dispatch was rejected because all Castout machines were busy.",
	},
	[ POWER5_PME_PM_L2SA_RCST_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SA_RCST_DISP_FAIL_ADDR",
		.pme_code = 0x712c0,
		.pme_short_desc = "L2 slice A RC store dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SA_RCLD_DISP_FAIL_RC_FULL",
		.pme_code = 0x721e0,
		.pme_short_desc = "L2 slice A RC load dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L375_MOD ] = {
		.pme_name = "PM_PTEG_FROM_L375_MOD",
		.pme_code = 0x1830a7,
		.pme_short_desc = "PTEG loaded from L3.75 modified",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with modified  (M) data from the L3 of a chip on a different module than this processor is located, due to a demand load.",
	},
	[ POWER5_PME_PM_MRK_LSU1_FLUSH_UST ] = {
		.pme_name = "PM_MRK_LSU1_FLUSH_UST",
		.pme_code = 0x810c5,
		.pme_short_desc = "LSU1 marked unaligned store flushes",
		.pme_long_desc = "A marked store was flushed from unit 1 because it was unaligned (crossed a 4k boundary)",
	},
	[ POWER5_PME_PM_BR_ISSUED ] = {
		.pme_name = "PM_BR_ISSUED",
		.pme_code = 0x230e4,
		.pme_short_desc = "Branches issued",
		.pme_long_desc = "A branch instruction was issued to the branch unit.  A branch that was incorrectly predicted may issue and execute multiple times.",
	},
	[ POWER5_PME_PM_MRK_GRP_BR_REDIR ] = {
		.pme_name = "PM_MRK_GRP_BR_REDIR",
		.pme_code = 0x212091,
		.pme_short_desc = "Group experienced marked branch redirect",
		.pme_long_desc = "A group containing a marked (sampled) instruction experienced a branch redirect.",
	},
	[ POWER5_PME_PM_EE_OFF ] = {
		.pme_name = "PM_EE_OFF",
		.pme_code = 0x130e3,
		.pme_short_desc = "Cycles MSR(EE) bit off",
		.pme_long_desc = "Cycles MSR(EE) bit was off indicating that interrupts due to external exceptions were masked.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP_Q4to7 ] = {
		.pme_name = "PM_MEM_RQ_DISP_Q4to7",
		.pme_code = 0x712c6,
		.pme_short_desc = "Memory read queue dispatched to queues 4-7",
		.pme_long_desc = "A memory operation was dispatched to read queue 4,5,6 or 7. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MEM_FAST_PATH_RD_DISP ] = {
		.pme_name = "PM_MEM_FAST_PATH_RD_DISP",
		.pme_code = 0x713e6,
		.pme_short_desc = "Fast path memory read dispatched",
		.pme_long_desc = "Fast path memory read dispatched",
	},
	[ POWER5_PME_PM_INST_FROM_L3 ] = {
		.pme_name = "PM_INST_FROM_L3",
		.pme_code = 0x12208d,
		.pme_short_desc = "Instruction fetched from L3",
		.pme_long_desc = "An instruction fetch group was fetched from the local L3. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_ITLB_MISS ] = {
		.pme_name = "PM_ITLB_MISS",
		.pme_code = 0x800c0,
		.pme_short_desc = "Instruction TLB misses",
		.pme_long_desc = "A TLB miss for an Instruction Fetch has occurred",
	},
	[ POWER5_PME_PM_FXU1_BUSY_FXU0_IDLE ] = {
		.pme_name = "PM_FXU1_BUSY_FXU0_IDLE",
		.pme_code = 0x400012,
		.pme_short_desc = "FXU1 busy FXU0 idle",
		.pme_long_desc = "FXU0 was idle while FXU1 was busy.",
	},
	[ POWER5_PME_PM_FXLS_FULL_CYC ] = {
		.pme_name = "PM_FXLS_FULL_CYC",
		.pme_code = 0x411090,
		.pme_short_desc = "Cycles FXLS queue is full",
		.pme_long_desc = "Cycles when the issue queues for one or both FXU/LSU units is full.  Use with caution since this is the sum of cycles when Unit 0 was full plus Unit 1 full.  It does not indicate when both units were full.",
	},
	[ POWER5_PME_PM_DTLB_REF_4K ] = {
		.pme_name = "PM_DTLB_REF_4K",
		.pme_code = 0xc40c2,
		.pme_short_desc = "Data TLB reference for 4K page",
		.pme_long_desc = "Data TLB references for 4KB pages. Includes hits + misses.",
	},
	[ POWER5_PME_PM_GRP_DISP_VALID ] = {
		.pme_name = "PM_GRP_DISP_VALID",
		.pme_code = 0x120e3,
		.pme_short_desc = "Group dispatch valid",
		.pme_long_desc = "A group is available for dispatch.  This does not mean it was successfully dispatched.",
	},
	[ POWER5_PME_PM_LSU_FLUSH_UST ] = {
		.pme_name = "PM_LSU_FLUSH_UST",
		.pme_code = 0x2c0088,
		.pme_short_desc = "SRQ unaligned store flushes",
		.pme_long_desc = "A store was flushed because it was unaligned (crossed a 4K boundary).  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_FXU1_FIN ] = {
		.pme_name = "PM_FXU1_FIN",
		.pme_code = 0x130e6,
		.pme_short_desc = "FXU1 produced a result",
		.pme_long_desc = "The Fixed Point unit 1 finished an instruction and produced a result.  Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_THRD_PRIO_4_CYC ] = {
		.pme_name = "PM_THRD_PRIO_4_CYC",
		.pme_code = 0x420e3,
		.pme_short_desc = "Cycles thread running at priority level 4",
		.pme_long_desc = "Cycles this thread was running at priority level 4.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L35_MOD ] = {
		.pme_name = "PM_MRK_DATA_FROM_L35_MOD",
		.pme_code = 0x2c709e,
		.pme_short_desc = "Marked data loaded from L3.5 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L3 of a chip on the same module as this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_4INST_CLB_CYC ] = {
		.pme_name = "PM_4INST_CLB_CYC",
		.pme_code = 0x400c4,
		.pme_short_desc = "Cycles 4 instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_MRK_DTLB_REF_16M ] = {
		.pme_name = "PM_MRK_DTLB_REF_16M",
		.pme_code = 0xc40c7,
		.pme_short_desc = "Marked Data TLB reference for 16M page",
		.pme_long_desc = "Data TLB references by a marked instruction for 16MB pages.",
	},
	[ POWER5_PME_PM_INST_FROM_L375_MOD ] = {
		.pme_name = "PM_INST_FROM_L375_MOD",
		.pme_code = 0x42209d,
		.pme_short_desc = "Instruction fetched from L3.75 modified",
		.pme_long_desc = "An instruction fetch group was fetched with modified  (M) data from the L3 of a chip on a different module than this processor is located. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_L2SC_RCST_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SC_RCST_DISP_FAIL_ADDR",
		.pme_code = 0x712c2,
		.pme_short_desc = "L2 slice C RC store dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_GRP_CMPL ] = {
		.pme_name = "PM_GRP_CMPL",
		.pme_code = 0x300013,
		.pme_short_desc = "Group completed",
		.pme_long_desc = "A group completed. Microcoded instructions that span multiple groups will generate this event once per group.",
	},
	[ POWER5_PME_PM_FPU1_1FLOP ] = {
		.pme_name = "PM_FPU1_1FLOP",
		.pme_code = 0xc7,
		.pme_short_desc = "FPU1 executed add, mult, sub, cmp or sel instruction",
		.pme_long_desc = "The floating point unit has executed an add, mult, sub, compare, fsel, fneg, fabs, fnabs, fres, or frsqrte kind of instruction.  These are single FLOP operations.",
	},
	[ POWER5_PME_PM_FPU_FRSP_FCONV ] = {
		.pme_name = "PM_FPU_FRSP_FCONV",
		.pme_code = 0x301090,
		.pme_short_desc = "FPU executed FRSP or FCONV instructions",
		.pme_long_desc = "The floating point unit has executed a frsp or convert kind of instruction.  This could be frsp*, fcfid*, fcti* where XYZ* means XYZ, XYZs, XYZ., XYZs. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_5INST_CLB_CYC ] = {
		.pme_name = "PM_5INST_CLB_CYC",
		.pme_code = 0x400c5,
		.pme_short_desc = "Cycles 5 instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_L3SC_REF ] = {
		.pme_name = "PM_L3SC_REF",
		.pme_code = 0x701c5,
		.pme_short_desc = "L3 slice C references",
		.pme_long_desc = "Number of attempts made by this chip cores to find data in the L3. Reported per L3 slice.",
	},
	[ POWER5_PME_PM_THRD_L2MISS_BOTH_CYC ] = {
		.pme_name = "PM_THRD_L2MISS_BOTH_CYC",
		.pme_code = 0x410c7,
		.pme_short_desc = "Cycles both threads in L2 misses",
		.pme_long_desc = "Cycles that both threads have L2 miss pending.  If only one thread has a L2 miss pending the other thread is given priority at decode.  If both threads have L2 miss pending decode priority is determined by the number of GCT entries used.",
	},
	[ POWER5_PME_PM_MEM_PW_GATH ] = {
		.pme_name = "PM_MEM_PW_GATH",
		.pme_code = 0x714c6,
		.pme_short_desc = "Memory partial-write gathered",
		.pme_long_desc = "Two or more partial-writes have been merged into a single memory write. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FAB_PNtoNN_SIDECAR ] = {
		.pme_name = "PM_FAB_PNtoNN_SIDECAR",
		.pme_code = 0x713c7,
		.pme_short_desc = "PN to NN beat went to sidecar first",
		.pme_long_desc = "Fabric Data beats that the base chip takes the inbound PN data and forwards it on to the outbound NN data bus after going into a sidecar first. The signal is delivered at FBC speed and the count must be scaled.",
	},
	[ POWER5_PME_PM_FAB_DCLAIM_ISSUED ] = {
		.pme_name = "PM_FAB_DCLAIM_ISSUED",
		.pme_code = 0x720e7,
		.pme_short_desc = "dclaim issued",
		.pme_long_desc = "A DCLAIM command was issued. Each chip reports its own counts.  The signal is delivered at FBC speed and the count must be scaled accordingly.  ",
	},
	[ POWER5_PME_PM_GRP_IC_MISS ] = {
		.pme_name = "PM_GRP_IC_MISS",
		.pme_code = 0x120e7,
		.pme_short_desc = "Group experienced I cache miss",
		.pme_long_desc = "Number of groups, counted at dispatch, that have encountered an icache miss redirect.  Every group constructed from a fetch group that missed the instruction cache will count.",
	},
	[ POWER5_PME_PM_INST_FROM_L35_SHR ] = {
		.pme_name = "PM_INST_FROM_L35_SHR",
		.pme_code = 0x12209d,
		.pme_short_desc = "Instruction fetched from L3.5 shared",
		.pme_long_desc = "An instruction fetch group was fetched with shared (S) data from the L3 of a chip on the same module as this processor is located. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_LSU_LMQ_FULL_CYC ] = {
		.pme_name = "PM_LSU_LMQ_FULL_CYC",
		.pme_code = 0xc30e7,
		.pme_short_desc = "Cycles LMQ full",
		.pme_long_desc = "The Load Miss Queue was full.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L2_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L2_CYC",
		.pme_code = 0x2c70a0,
		.pme_short_desc = "Marked load latency from L2",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_LSU_SRQ_SYNC_CYC ] = {
		.pme_name = "PM_LSU_SRQ_SYNC_CYC",
		.pme_code = 0x830e5,
		.pme_short_desc = "SRQ sync duration",
		.pme_long_desc = "Cycles that a sync instruction is active in the Store Request Queue.",
	},
	[ POWER5_PME_PM_LSU0_BUSY_REJECT ] = {
		.pme_name = "PM_LSU0_BUSY_REJECT",
		.pme_code = 0xc20e3,
		.pme_short_desc = "LSU0 busy due to reject",
		.pme_long_desc = "Total cycles the Load Store Unit 0 is busy rejecting instructions. ",
	},
	[ POWER5_PME_PM_LSU_REJECT_ERAT_MISS ] = {
		.pme_name = "PM_LSU_REJECT_ERAT_MISS",
		.pme_code = 0x1c6090,
		.pme_short_desc = "LSU reject due to ERAT miss",
		.pme_long_desc = "Total cycles the Load Store Unit is busy rejecting instructions due to an ERAT miss. Combined unit 0 + 1. Requests that miss the Derat are rejected and retried until the request hits in the Erat.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_RMEM_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_RMEM_CYC",
		.pme_code = 0x4c70a1,
		.pme_short_desc = "Marked load latency from remote memory",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_DATA_FROM_L375_SHR ] = {
		.pme_name = "PM_DATA_FROM_L375_SHR",
		.pme_code = 0x3c309e,
		.pme_short_desc = "Data loaded from L3.75 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (S) data from the L3 of a chip on a different module than this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_FPU0_FMOV_FEST ] = {
		.pme_name = "PM_FPU0_FMOV_FEST",
		.pme_code = 0x10c0,
		.pme_short_desc = "FPU0 executed FMOV or FEST instructions",
		.pme_long_desc = "FPU0 has executed a move kind of instruction or one of the estimate instructions.  This could be fmr*, fneg*, fabs*, fnabs* , fres* or frsqrte* where XYZ* means XYZ or XYZ.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L25_MOD ] = {
		.pme_name = "PM_PTEG_FROM_L25_MOD",
		.pme_code = 0x283097,
		.pme_short_desc = "PTEG loaded from L2.5 modified",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with modified (M) data from the L2 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_LD_REF_L1_LSU0 ] = {
		.pme_name = "PM_LD_REF_L1_LSU0",
		.pme_code = 0xc10c0,
		.pme_short_desc = "LSU0 L1 D cache load references",
		.pme_long_desc = "Load references to Level 1 Data Cache, by unit 0.",
	},
	[ POWER5_PME_PM_THRD_PRIO_7_CYC ] = {
		.pme_name = "PM_THRD_PRIO_7_CYC",
		.pme_code = 0x420e6,
		.pme_short_desc = "Cycles thread running at priority level 7",
		.pme_long_desc = "Cycles this thread was running at priority level 7.",
	},
	[ POWER5_PME_PM_LSU1_FLUSH_SRQ ] = {
		.pme_name = "PM_LSU1_FLUSH_SRQ",
		.pme_code = 0xc00c7,
		.pme_short_desc = "LSU1 SRQ lhs flushes",
		.pme_long_desc = "A store was flushed because younger load hits and older store that is already in the SRQ or in the same group. ",
	},
	[ POWER5_PME_PM_L2SC_RCST_DISP ] = {
		.pme_name = "PM_L2SC_RCST_DISP",
		.pme_code = 0x702c2,
		.pme_short_desc = "L2 slice C RC store dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Store was attempted.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_DIV ] = {
		.pme_name = "PM_CMPLU_STALL_DIV",
		.pme_code = 0x411099,
		.pme_short_desc = "Completion stall caused by DIV instruction",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes was a fixed point divide instruction. This is a subset of PM_CMPLU_STALL_FXU.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP_Q12to15 ] = {
		.pme_name = "PM_MEM_RQ_DISP_Q12to15",
		.pme_code = 0x732e6,
		.pme_short_desc = "Memory read queue dispatched to queues 12-15",
		.pme_long_desc = "A memory operation was dispatched to read queue 12,13,14 or 15. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_INST_FROM_L375_SHR ] = {
		.pme_name = "PM_INST_FROM_L375_SHR",
		.pme_code = 0x32209d,
		.pme_short_desc = "Instruction fetched from L3.75 shared",
		.pme_long_desc = "An instruction fetch group was fetched with shared  (S) data from the L3 of a chip on a different module than this processor is located.  Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_ST_REF_L1 ] = {
		.pme_name = "PM_ST_REF_L1",
		.pme_code = 0x3c1090,
		.pme_short_desc = "L1 D cache store references",
		.pme_long_desc = "Store references to the Data Cache. Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_L3SB_ALL_BUSY ] = {
		.pme_name = "PM_L3SB_ALL_BUSY",
		.pme_code = 0x721e4,
		.pme_short_desc = "L3 slice B active for every cycle all CI/CO machines busy",
		.pme_long_desc = "Cycles All Castin/Castout machines are busy.",
	},
	[ POWER5_PME_PM_FAB_P1toVNorNN_SIDECAR_EMPTY ] = {
		.pme_name = "PM_FAB_P1toVNorNN_SIDECAR_EMPTY",
		.pme_code = 0x711c7,
		.pme_short_desc = "P1 to VN/NN sidecar empty",
		.pme_long_desc = "Fabric cycles when the Plus-1 jump sidecar (sidecars for mcm to mcm data transfer) is empty. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L275_SHR_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L275_SHR_CYC",
		.pme_code = 0x2c70a3,
		.pme_short_desc = "Marked load latency from L2.75 shared",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_FAB_HOLDtoNN_EMPTY ] = {
		.pme_name = "PM_FAB_HOLDtoNN_EMPTY",
		.pme_code = 0x722e7,
		.pme_short_desc = "Hold buffer to NN empty",
		.pme_long_desc = "Fabric cyles when the Next Node out hold-buffers are emtpy.  The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_DATA_FROM_LMEM ] = {
		.pme_name = "PM_DATA_FROM_LMEM",
		.pme_code = 0x2c3087,
		.pme_short_desc = "Data loaded from local memory",
		.pme_long_desc = "The processor's Data Cache was reloaded from memory attached to the same module this proccessor is located on.",
	},
	[ POWER5_PME_PM_RUN_CYC ] = {
		.pme_name = "PM_RUN_CYC",
		.pme_code = 0x100005,
		.pme_short_desc = "Run cycles",
		.pme_long_desc = "Processor Cycles gated by the run latch.  Operating systems use the run latch to indicate when they are doing useful work.  The run latch is typically cleared in the OS idle loop.  Gating by the run latch filters out the idle loop.",
	},
	[ POWER5_PME_PM_PTEG_FROM_RMEM ] = {
		.pme_name = "PM_PTEG_FROM_RMEM",
		.pme_code = 0x1830a1,
		.pme_short_desc = "PTEG loaded from remote memory",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB from memory attached to a different module than this proccessor is located on.",
	},
	[ POWER5_PME_PM_L2SC_RCLD_DISP ] = {
		.pme_name = "PM_L2SC_RCLD_DISP",
		.pme_code = 0x701c2,
		.pme_short_desc = "L2 slice C RC load dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Load was attempted",
	},
	[ POWER5_PME_PM_LSU0_LDF ] = {
		.pme_name = "PM_LSU0_LDF",
		.pme_code = 0xc50c0,
		.pme_short_desc = "LSU0 executed Floating Point load instruction",
		.pme_long_desc = "A floating point load was executed by LSU0",
	},
	[ POWER5_PME_PM_LSU_LRQ_S0_VALID ] = {
		.pme_name = "PM_LSU_LRQ_S0_VALID",
		.pme_code = 0xc20e2,
		.pme_short_desc = "LRQ slot 0 valid",
		.pme_long_desc = "This signal is asserted every cycle that the Load Request Queue slot zero is valid. The SRQ is 32 entries long and is allocated round-robin.  In SMT mode the LRQ is split between the two threads (16 entries each).",
	},
	[ POWER5_PME_PM_PMC3_OVERFLOW ] = {
		.pme_name = "PM_PMC3_OVERFLOW",
		.pme_code = 0x40000a,
		.pme_short_desc = "PMC3 Overflow",
		.pme_long_desc = "Overflows from PMC3 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_MRK_IMR_RELOAD ] = {
		.pme_name = "PM_MRK_IMR_RELOAD",
		.pme_code = 0x820e2,
		.pme_short_desc = "Marked IMR reloaded",
		.pme_long_desc = "A DL1 reload occurred due to marked load",
	},
	[ POWER5_PME_PM_MRK_GRP_TIMEO ] = {
		.pme_name = "PM_MRK_GRP_TIMEO",
		.pme_code = 0x40000b,
		.pme_short_desc = "Marked group completion timeout",
		.pme_long_desc = "The sampling timeout expired indicating that the previously sampled instruction is no longer in the processor",
	},
	[ POWER5_PME_PM_ST_MISS_L1 ] = {
		.pme_name = "PM_ST_MISS_L1",
		.pme_code = 0xc10c3,
		.pme_short_desc = "L1 D cache store misses",
		.pme_long_desc = "A store missed the dcache.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_STOP_COMPLETION ] = {
		.pme_name = "PM_STOP_COMPLETION",
		.pme_code = 0x300018,
		.pme_short_desc = "Completion stopped",
		.pme_long_desc = "RAS Unit has signaled completion to stop",
	},
	[ POWER5_PME_PM_LSU_BUSY_REJECT ] = {
		.pme_name = "PM_LSU_BUSY_REJECT",
		.pme_code = 0x1c2090,
		.pme_short_desc = "LSU busy due to reject",
		.pme_long_desc = "Total cycles the Load Store Unit is busy rejecting instructions. Combined unit 0 + 1.",
	},
	[ POWER5_PME_PM_ISLB_MISS ] = {
		.pme_name = "PM_ISLB_MISS",
		.pme_code = 0x800c1,
		.pme_short_desc = "Instruction SLB misses",
		.pme_long_desc = "A SLB miss for an instruction fetch as occurred",
	},
	[ POWER5_PME_PM_CYC ] = {
		.pme_name = "PM_CYC",
		.pme_code = 0xf,
		.pme_short_desc = "Processor cycles",
		.pme_long_desc = "Processor cycles",
	},
	[ POWER5_PME_PM_THRD_ONE_RUN_CYC ] = {
		.pme_name = "PM_THRD_ONE_RUN_CYC",
		.pme_code = 0x10000b,
		.pme_short_desc = "One of the threads in run cycles",
		.pme_long_desc = "At least one thread has set its run latch. Operating systems use the run latch to indicate when they are doing useful work.  The run latch is typically cleared in the OS idle loop. This event does not respect FCWAIT.",
	},
	[ POWER5_PME_PM_GRP_BR_REDIR_NONSPEC ] = {
		.pme_name = "PM_GRP_BR_REDIR_NONSPEC",
		.pme_code = 0x112091,
		.pme_short_desc = "Group experienced non-speculative branch redirect",
		.pme_long_desc = "Number of groups, counted at completion, that have encountered a branch redirect.",
	},
	[ POWER5_PME_PM_LSU1_SRQ_STFWD ] = {
		.pme_name = "PM_LSU1_SRQ_STFWD",
		.pme_code = 0xc20e4,
		.pme_short_desc = "LSU1 SRQ store forwarded",
		.pme_long_desc = "Data from a store instruction was forwarded to a load on unit 1.  A load that misses L1 but becomes a store forward is treated as a load miss and it causes the DL1 load miss event to be counted.  It does not go into the LMQ. If a load that hits L1 but becomes a store forward, then it's not treated as a load miss.",
	},
	[ POWER5_PME_PM_L3SC_MOD_INV ] = {
		.pme_name = "PM_L3SC_MOD_INV",
		.pme_code = 0x730e5,
		.pme_short_desc = "L3 slice C transition from modified to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is truly M in this L3 (i.e. L3 going M=>I)  Mu|Me are not included since they are formed due to a previous read op Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_L2_PREF ] = {
		.pme_name = "PM_L2_PREF",
		.pme_code = 0xc50c3,
		.pme_short_desc = "L2 cache prefetches",
		.pme_long_desc = "A request to prefetch data into L2 was made",
	},
	[ POWER5_PME_PM_GCT_NOSLOT_BR_MPRED ] = {
		.pme_name = "PM_GCT_NOSLOT_BR_MPRED",
		.pme_code = 0x41009c,
		.pme_short_desc = "No slot in GCT caused by branch mispredict",
		.pme_long_desc = "Cycles when the Global Completion Table has no slots from this thread because of a branch misprediction.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L25_MOD ] = {
		.pme_name = "PM_MRK_DATA_FROM_L25_MOD",
		.pme_code = 0x2c7097,
		.pme_short_desc = "Marked data loaded from L2.5 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L2 of a chip on the same module as this processor is located  due to a marked load.",
	},
	[ POWER5_PME_PM_L2SB_MOD_INV ] = {
		.pme_name = "PM_L2SB_MOD_INV",
		.pme_code = 0x730e1,
		.pme_short_desc = "L2 slice B transition from modified to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Invalid state. This transition was caused by any RWITM snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_L2SB_ST_REQ ] = {
		.pme_name = "PM_L2SB_ST_REQ",
		.pme_code = 0x723e1,
		.pme_short_desc = "L2 slice B store requests",
		.pme_long_desc = "A store request as seen at the L2 directory has been made from the core. Stores are counted after gathering in the L2 store queues. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_MRK_L1_RELOAD_VALID ] = {
		.pme_name = "PM_MRK_L1_RELOAD_VALID",
		.pme_code = 0xc70e4,
		.pme_short_desc = "Marked L1 reload data source valid",
		.pme_long_desc = "The source information is valid and is for a marked load",
	},
	[ POWER5_PME_PM_L3SB_HIT ] = {
		.pme_name = "PM_L3SB_HIT",
		.pme_code = 0x711c4,
		.pme_short_desc = "L3 slice B hits",
		.pme_long_desc = "Number of attempts made by this chip cores that resulted in an L3 hit.  Reported per L3 slice",
	},
	[ POWER5_PME_PM_L2SB_SHR_MOD ] = {
		.pme_name = "PM_L2SB_SHR_MOD",
		.pme_code = 0x700c1,
		.pme_short_desc = "L2 slice B transition from shared to modified",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L , or Tagged) to the Modified state. This transition was caused by a store from either of the two local CPUs to a cache line in any of the Shared states. The event is provided on each of the three slices A, B, and C. ",
	},
	[ POWER5_PME_PM_EE_OFF_EXT_INT ] = {
		.pme_name = "PM_EE_OFF_EXT_INT",
		.pme_code = 0x130e7,
		.pme_short_desc = "Cycles MSR(EE) bit off and external interrupt pending",
		.pme_long_desc = "Cycles when an interrupt due to an external exception is pending but external exceptions were masked.",
	},
	[ POWER5_PME_PM_1PLUS_PPC_CMPL ] = {
		.pme_name = "PM_1PLUS_PPC_CMPL",
		.pme_code = 0x100013,
		.pme_short_desc = "One or more PPC instruction completed",
		.pme_long_desc = "A group containing at least one PPC instruction completed. For microcoded instructions that span multiple groups, this will only occur once.",
	},
	[ POWER5_PME_PM_L2SC_SHR_MOD ] = {
		.pme_name = "PM_L2SC_SHR_MOD",
		.pme_code = 0x700c2,
		.pme_short_desc = "L2 slice C transition from shared to modified",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L , or Tagged) to the Modified state. This transition was caused by a store from either of the two local CPUs to a cache line in any of the Shared states. The event is provided on each of the three slices A, B, and C. ",
	},
	[ POWER5_PME_PM_PMC6_OVERFLOW ] = {
		.pme_name = "PM_PMC6_OVERFLOW",
		.pme_code = 0x30001a,
		.pme_short_desc = "PMC6 Overflow",
		.pme_long_desc = "Overflows from PMC6 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_LSU_LRQ_FULL_CYC ] = {
		.pme_name = "PM_LSU_LRQ_FULL_CYC",
		.pme_code = 0x110c2,
		.pme_short_desc = "Cycles LRQ full",
		.pme_long_desc = "Cycles when the LRQ is full.",
	},
	[ POWER5_PME_PM_IC_PREF_INSTALL ] = {
		.pme_name = "PM_IC_PREF_INSTALL",
		.pme_code = 0x210c7,
		.pme_short_desc = "Instruction prefetched installed in prefetch buffer",
		.pme_long_desc = "A prefetch buffer entry (line) is allocated but the request is not a demand fetch.",
	},
	[ POWER5_PME_PM_TLB_MISS ] = {
		.pme_name = "PM_TLB_MISS",
		.pme_code = 0x180088,
		.pme_short_desc = "TLB misses",
		.pme_long_desc = "Total of Data TLB mises + Instruction TLB misses",
	},
	[ POWER5_PME_PM_GCT_FULL_CYC ] = {
		.pme_name = "PM_GCT_FULL_CYC",
		.pme_code = 0x100c0,
		.pme_short_desc = "Cycles GCT full",
		.pme_long_desc = "The Global Completion Table is completely full.",
	},
	[ POWER5_PME_PM_FXU_BUSY ] = {
		.pme_name = "PM_FXU_BUSY",
		.pme_code = 0x200012,
		.pme_short_desc = "FXU busy",
		.pme_long_desc = "Cycles when both FXU0 and FXU1 are busy.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L3_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L3_CYC",
		.pme_code = 0x2c70a4,
		.pme_short_desc = "Marked load latency from L3",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_LSU_REJECT_LMQ_FULL ] = {
		.pme_name = "PM_LSU_REJECT_LMQ_FULL",
		.pme_code = 0x2c6088,
		.pme_short_desc = "LSU reject due to LMQ full or missed data coming",
		.pme_long_desc = "Total cycles the Load Store Unit is busy rejecting instructions because the Load Miss Queue was full. The LMQ has eight entries.  If all the eight entries are full, subsequent load instructions are rejected. Combined unit 0 + 1.",
	},
	[ POWER5_PME_PM_LSU_SRQ_S0_ALLOC ] = {
		.pme_name = "PM_LSU_SRQ_S0_ALLOC",
		.pme_code = 0xc20e5,
		.pme_short_desc = "SRQ slot 0 allocated",
		.pme_long_desc = "SRQ Slot zero was allocated",
	},
	[ POWER5_PME_PM_GRP_MRK ] = {
		.pme_name = "PM_GRP_MRK",
		.pme_code = 0x100014,
		.pme_short_desc = "Group marked in IDU",
		.pme_long_desc = "A group was sampled (marked).  The group is called a marked group.  One instruction within the group is tagged for detailed monitoring.  The sampled instruction is called a marked instructions.  Events associated with the marked instruction are annotated with the marked term.",
	},
	[ POWER5_PME_PM_INST_FROM_L25_SHR ] = {
		.pme_name = "PM_INST_FROM_L25_SHR",
		.pme_code = 0x122096,
		.pme_short_desc = "Instruction fetched from L2.5 shared",
		.pme_long_desc = "An instruction fetch group was fetched with shared  (T or SL) data from the L2 of a chip on the same module as this processor is located. Fetch groups can contain up to 8 instructions.",
	},
	[ POWER5_PME_PM_FPU1_FIN ] = {
		.pme_name = "PM_FPU1_FIN",
		.pme_code = 0x10c7,
		.pme_short_desc = "FPU1 produced a result",
		.pme_long_desc = "FPU1 finished, produced a result.  This only indicates finish,  not completion. Floating Point Stores are included in this count but not Floating Point Loads., , ",
	},
	[ POWER5_PME_PM_DC_PREF_STREAM_ALLOC ] = {
		.pme_name = "PM_DC_PREF_STREAM_ALLOC",
		.pme_code = 0x830e7,
		.pme_short_desc = "D cache new prefetch stream allocated",
		.pme_long_desc = "A new Prefetch Stream was allocated.",
	},
	[ POWER5_PME_PM_BR_MPRED_TA ] = {
		.pme_name = "PM_BR_MPRED_TA",
		.pme_code = 0x230e6,
		.pme_short_desc = "Branch mispredictions due to target address",
		.pme_long_desc = "A branch instruction target was incorrectly predicted. This will result in a branch mispredict flush unless a flush is detected from an older instruction.",
	},
	[ POWER5_PME_PM_CRQ_FULL_CYC ] = {
		.pme_name = "PM_CRQ_FULL_CYC",
		.pme_code = 0x110c1,
		.pme_short_desc = "Cycles CR issue queue full",
		.pme_long_desc = "The issue queue that feeds the Conditional Register unit is full. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the queue was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_L2SA_RCLD_DISP ] = {
		.pme_name = "PM_L2SA_RCLD_DISP",
		.pme_code = 0x701c0,
		.pme_short_desc = "L2 slice A RC load dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Load was attempted",
	},
	[ POWER5_PME_PM_SNOOP_WR_RETRY_QFULL ] = {
		.pme_name = "PM_SNOOP_WR_RETRY_QFULL",
		.pme_code = 0x710c6,
		.pme_short_desc = "Snoop read retry due to read queue full",
		.pme_long_desc = "A snoop request for a write to memory was retried because the write queues were full.  When this happens the snoop request is retried and the writes in the write reorder queue are changed to high priority.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DTLB_REF_4K ] = {
		.pme_name = "PM_MRK_DTLB_REF_4K",
		.pme_code = 0xc40c3,
		.pme_short_desc = "Marked Data TLB reference for 4K page",
		.pme_long_desc = "Data TLB references by a marked instruction for 4KB pages.",
	},
	[ POWER5_PME_PM_LSU_SRQ_S0_VALID ] = {
		.pme_name = "PM_LSU_SRQ_S0_VALID",
		.pme_code = 0xc20e1,
		.pme_short_desc = "SRQ slot 0 valid",
		.pme_long_desc = "This signal is asserted every cycle that the Store Request Queue slot zero is valid. The SRQ is 32 entries long and is allocated round-robin.  In SMT mode the SRQ is split between the two threads (16 entries each).",
	},
	[ POWER5_PME_PM_LSU0_FLUSH_LRQ ] = {
		.pme_name = "PM_LSU0_FLUSH_LRQ",
		.pme_code = 0xc00c2,
		.pme_short_desc = "LSU0 LRQ flushes",
		.pme_long_desc = "A load was flushed by unit 0 because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.",
	},
	[ POWER5_PME_PM_INST_FROM_L275_MOD ] = {
		.pme_name = "PM_INST_FROM_L275_MOD",
		.pme_code = 0x422096,
		.pme_short_desc = "Instruction fetched from L2.75 modified",
		.pme_long_desc = "An instruction fetch group was fetched with modified (M) data from the L2 on a different module than this processor is located.  Fetch groups can contain up to 8 instructions ",
	},
	[ POWER5_PME_PM_GCT_EMPTY_CYC ] = {
		.pme_name = "PM_GCT_EMPTY_CYC",
		.pme_code = 0x200004,
		.pme_short_desc = "Cycles GCT empty",
		.pme_long_desc = "The Global Completion Table is completely empty",
	},
	[ POWER5_PME_PM_LARX_LSU0 ] = {
		.pme_name = "PM_LARX_LSU0",
		.pme_code = 0x820e7,
		.pme_short_desc = "Larx executed on LSU0",
		.pme_long_desc = "A larx (lwarx or ldarx) was executed on side 0 (there is no corresponding unit 1 event since larx instructions can only execute on unit 0)",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_5or6_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_5or6_CYC",
		.pme_code = 0x430e6,
		.pme_short_desc = "Cycles thread priority difference is 5 or 6",
		.pme_long_desc = "Cycles when this thread's priority is higher than the other thread's priority by 5 or 6.",
	},
	[ POWER5_PME_PM_SNOOP_RETRY_1AHEAD ] = {
		.pme_name = "PM_SNOOP_RETRY_1AHEAD",
		.pme_code = 0x725e6,
		.pme_short_desc = "Snoop retry due to one ahead collision",
		.pme_long_desc = "Snoop retry due to one ahead collision",
	},
	[ POWER5_PME_PM_FPU1_FSQRT ] = {
		.pme_name = "PM_FPU1_FSQRT",
		.pme_code = 0xc6,
		.pme_short_desc = "FPU1 executed FSQRT instruction",
		.pme_long_desc = "FPU1 has executed a square root instruction. This could be fsqrt* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_MRK_LD_MISS_L1_LSU1 ] = {
		.pme_name = "PM_MRK_LD_MISS_L1_LSU1",
		.pme_code = 0x820e4,
		.pme_short_desc = "LSU1 marked L1 D cache load misses",
		.pme_long_desc = "Load references that miss the Level 1 Data cache, by LSU1.",
	},
	[ POWER5_PME_PM_MRK_FPU_FIN ] = {
		.pme_name = "PM_MRK_FPU_FIN",
		.pme_code = 0x300014,
		.pme_short_desc = "Marked instruction FPU processing finished",
		.pme_long_desc = "One of the Floating Point Units finished a marked instruction. Instructions that finish may not necessary complete",
	},
	[ POWER5_PME_PM_THRD_PRIO_5_CYC ] = {
		.pme_name = "PM_THRD_PRIO_5_CYC",
		.pme_code = 0x420e4,
		.pme_short_desc = "Cycles thread running at priority level 5",
		.pme_long_desc = "Cycles this thread was running at priority level 5.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_LMEM ] = {
		.pme_name = "PM_MRK_DATA_FROM_LMEM",
		.pme_code = 0x2c7087,
		.pme_short_desc = "Marked data loaded from local memory",
		.pme_long_desc = "The processor's Data Cache was reloaded due to a marked load from memory attached to the same module this proccessor is located on.",
	},
	[ POWER5_PME_PM_FPU1_FRSP_FCONV ] = {
		.pme_name = "PM_FPU1_FRSP_FCONV",
		.pme_code = 0x10c5,
		.pme_short_desc = "FPU1 executed FRSP or FCONV instructions",
		.pme_long_desc = "FPU1 has executed a frsp or convert kind of instruction.  This could be frsp*, fcfid*, fcti* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_SNOOP_TLBIE ] = {
		.pme_name = "PM_SNOOP_TLBIE",
		.pme_code = 0x800c3,
		.pme_short_desc = "Snoop TLBIE",
		.pme_long_desc = "A tlbie was snooped from another processor.",
	},
	[ POWER5_PME_PM_L3SB_SNOOP_RETRY ] = {
		.pme_name = "PM_L3SB_SNOOP_RETRY",
		.pme_code = 0x731e4,
		.pme_short_desc = "L3 slice B snoop retries",
		.pme_long_desc = "Number of times an L3 retried a snoop because it got two in at the same time (one on snp_a, one on snp_b)",
	},
	[ POWER5_PME_PM_FAB_VBYPASS_EMPTY ] = {
		.pme_name = "PM_FAB_VBYPASS_EMPTY",
		.pme_code = 0x731e7,
		.pme_short_desc = "Vertical bypass buffer empty",
		.pme_long_desc = "Fabric cycles when the Middle Bypass sidecar is empty. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L275_MOD ] = {
		.pme_name = "PM_MRK_DATA_FROM_L275_MOD",
		.pme_code = 0x1c70a3,
		.pme_short_desc = "Marked data loaded from L2.75 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L2 on a different module than this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_6INST_CLB_CYC ] = {
		.pme_name = "PM_6INST_CLB_CYC",
		.pme_code = 0x400c6,
		.pme_short_desc = "Cycles 6 instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_L2SB_RCST_DISP ] = {
		.pme_name = "PM_L2SB_RCST_DISP",
		.pme_code = 0x702c1,
		.pme_short_desc = "L2 slice B RC store dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Store was attempted.",
	},
	[ POWER5_PME_PM_FLUSH ] = {
		.pme_name = "PM_FLUSH",
		.pme_code = 0x110c7,
		.pme_short_desc = "Flushes",
		.pme_long_desc = "Flushes occurred including LSU and Branch flushes.",
	},
	[ POWER5_PME_PM_L2SC_MOD_INV ] = {
		.pme_name = "PM_L2SC_MOD_INV",
		.pme_code = 0x730e2,
		.pme_short_desc = "L2 slice C transition from modified to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Invalid state. This transition was caused by any RWITM snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_FPU_DENORM ] = {
		.pme_name = "PM_FPU_DENORM",
		.pme_code = 0x102088,
		.pme_short_desc = "FPU received denormalized data",
		.pme_long_desc = "The floating point unit has encountered a denormalized operand.  Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_L3SC_HIT ] = {
		.pme_name = "PM_L3SC_HIT",
		.pme_code = 0x711c5,
		.pme_short_desc = "L3 slice C hits",
		.pme_long_desc = "Number of attempts made by this chip cores that resulted in an L3 hit.  Reported per L3 Slice",
	},
	[ POWER5_PME_PM_SNOOP_WR_RETRY_RQ ] = {
		.pme_name = "PM_SNOOP_WR_RETRY_RQ",
		.pme_code = 0x706c6,
		.pme_short_desc = "Snoop write/dclaim retry due to collision with active read queue",
		.pme_long_desc = "A snoop request for a write or dclaim to memory was retried because it matched the cacheline of an active read.  This event is sent from the Memory Controller clock domain and must be scaled accordingly",
	},
	[ POWER5_PME_PM_LSU1_REJECT_SRQ ] = {
		.pme_name = "PM_LSU1_REJECT_SRQ",
		.pme_code = 0xc60e4,
		.pme_short_desc = "LSU1 SRQ lhs rejects",
		.pme_long_desc = "Total cycles the Load Store Unit 1 is busy rejecting instructions because of Load Hit Store conditions.  Loads are rejected when data is needed from a previous store instruction but store forwarding is not possible because the data is not fully contained in the Store Data Queue or is not yet available in the Store Data Queue.",
	},
	[ POWER5_PME_PM_IC_PREF_REQ ] = {
		.pme_name = "PM_IC_PREF_REQ",
		.pme_code = 0x220e6,
		.pme_short_desc = "Instruction prefetch requests",
		.pme_long_desc = "An instruction prefetch request has been made.",
	},
	[ POWER5_PME_PM_L3SC_ALL_BUSY ] = {
		.pme_name = "PM_L3SC_ALL_BUSY",
		.pme_code = 0x721e5,
		.pme_short_desc = "L3 slice C active for every cycle all CI/CO machines busy",
		.pme_long_desc = "Cycles All Castin/Castout machines are busy.",
	},
	[ POWER5_PME_PM_MRK_GRP_IC_MISS ] = {
		.pme_name = "PM_MRK_GRP_IC_MISS",
		.pme_code = 0x412091,
		.pme_short_desc = "Group experienced marked I cache miss",
		.pme_long_desc = "A group containing a marked (sampled) instruction experienced an instruction cache miss.",
	},
	[ POWER5_PME_PM_GCT_NOSLOT_IC_MISS ] = {
		.pme_name = "PM_GCT_NOSLOT_IC_MISS",
		.pme_code = 0x21009c,
		.pme_short_desc = "No slot in GCT caused by I cache miss",
		.pme_long_desc = "Cycles when the Global Completion Table has no slots from this thread because of an Instruction Cache miss.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L3 ] = {
		.pme_name = "PM_MRK_DATA_FROM_L3",
		.pme_code = 0x1c708e,
		.pme_short_desc = "Marked data loaded from L3",
		.pme_long_desc = "The processor's Data Cache was reloaded from the local L3 due to a marked load.",
	},
	[ POWER5_PME_PM_GCT_NOSLOT_SRQ_FULL ] = {
		.pme_name = "PM_GCT_NOSLOT_SRQ_FULL",
		.pme_code = 0x310084,
		.pme_short_desc = "No slot in GCT caused by SRQ full",
		.pme_long_desc = "Cycles when the Global Completion Table has no slots from this thread because the Store Request Queue (SRQ)  is full.  This happens when the storage subsystem can not process the stores in the SRQ.  Groups can not be dispatched until a SRQ entry is available.",
	},
	[ POWER5_PME_PM_THRD_SEL_OVER_ISU_HOLD ] = {
		.pme_name = "PM_THRD_SEL_OVER_ISU_HOLD",
		.pme_code = 0x410c5,
		.pme_short_desc = "Thread selection overrides caused by ISU holds",
		.pme_long_desc = "Thread selection was overridden because of an ISU hold.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_DCACHE_MISS ] = {
		.pme_name = "PM_CMPLU_STALL_DCACHE_MISS",
		.pme_code = 0x21109a,
		.pme_short_desc = "Completion stall caused by D cache miss",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes suffered a Data Cache Miss. Data Cache Miss has higher priority than any other Load/Store delay, so if an instruction encounters multiple delays only the Data Cache Miss will be reported and the entire delay period will be charged to Data Cache Miss. This is a subset of PM_CMPLU_STALL_LSU.",
	},
	[ POWER5_PME_PM_L3SA_MOD_INV ] = {
		.pme_name = "PM_L3SA_MOD_INV",
		.pme_code = 0x730e3,
		.pme_short_desc = "L3 slice A transition from modified to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is truly M in this L3 (i.e. L3 going M=>I)  Mu|Me are not included since they are formed due to a prev read op.  Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_LSU_FLUSH_LRQ ] = {
		.pme_name = "PM_LSU_FLUSH_LRQ",
		.pme_code = 0x2c0090,
		.pme_short_desc = "LRQ flushes",
		.pme_long_desc = "A load was flushed because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.  Combined Units 0 and 1.",
	},
	[ POWER5_PME_PM_THRD_PRIO_2_CYC ] = {
		.pme_name = "PM_THRD_PRIO_2_CYC",
		.pme_code = 0x420e1,
		.pme_short_desc = "Cycles thread running at priority level 2",
		.pme_long_desc = "Cycles this thread was running at priority level 2.",
	},
	[ POWER5_PME_PM_LSU_FLUSH_SRQ ] = {
		.pme_name = "PM_LSU_FLUSH_SRQ",
		.pme_code = 0x1c0090,
		.pme_short_desc = "SRQ flushes",
		.pme_long_desc = "A store was flushed because younger load hits and older store that is already in the SRQ or in the same group.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_MRK_LSU_SRQ_INST_VALID ] = {
		.pme_name = "PM_MRK_LSU_SRQ_INST_VALID",
		.pme_code = 0xc70e6,
		.pme_short_desc = "Marked instruction valid in SRQ",
		.pme_long_desc = "This signal is asserted every cycle when a marked request is resident in the Store Request Queue",
	},
	[ POWER5_PME_PM_L3SA_REF ] = {
		.pme_name = "PM_L3SA_REF",
		.pme_code = 0x701c3,
		.pme_short_desc = "L3 slice A references",
		.pme_long_desc = "Number of attempts made by this chip cores to find data in the L3. Reported per L3 slice ",
	},
	[ POWER5_PME_PM_L2SC_RC_DISP_FAIL_CO_BUSY_ALL ] = {
		.pme_name = "PM_L2SC_RC_DISP_FAIL_CO_BUSY_ALL",
		.pme_code = 0x713c2,
		.pme_short_desc = "L2 slice C RC dispatch attempt failed due to all CO busy",
		.pme_long_desc = "A Read/Claim dispatch was rejected because all Castout machines were busy.",
	},
	[ POWER5_PME_PM_FPU0_STALL3 ] = {
		.pme_name = "PM_FPU0_STALL3",
		.pme_code = 0x20e1,
		.pme_short_desc = "FPU0 stalled in pipe3",
		.pme_long_desc = "FPU0 has generated a stall in pipe3 due to overflow, underflow, massive cancel, convert to integer (sometimes), or convert from integer (always).",
	},
	[ POWER5_PME_PM_GPR_MAP_FULL_CYC ] = {
		.pme_name = "PM_GPR_MAP_FULL_CYC",
		.pme_code = 0x130e5,
		.pme_short_desc = "Cycles GPR mapper full",
		.pme_long_desc = "The General Purpose Register mapper cannot accept any more groups. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the mapper was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_TB_BIT_TRANS ] = {
		.pme_name = "PM_TB_BIT_TRANS",
		.pme_code = 0x100018,
		.pme_short_desc = "Time Base bit transition",
		.pme_long_desc = "When the selected time base bit (as specified in MMCR0[TBSEL])transitions from 0 to 1 ",
	},
	[ POWER5_PME_PM_MRK_LSU_FLUSH_LRQ ] = {
		.pme_name = "PM_MRK_LSU_FLUSH_LRQ",
		.pme_code = 0x381088,
		.pme_short_desc = "Marked LRQ flushes",
		.pme_long_desc = "A marked load was flushed because a younger load executed before an older store executed and they had overlapping data OR two loads executed out of order and they have byte overlap and there was a snoop in between to an overlapped byte.",
	},
	[ POWER5_PME_PM_FPU0_STF ] = {
		.pme_name = "PM_FPU0_STF",
		.pme_code = 0x20e2,
		.pme_short_desc = "FPU0 executed store instruction",
		.pme_long_desc = "FPU0 has executed a Floating Point Store instruction.",
	},
	[ POWER5_PME_PM_MRK_DTLB_MISS ] = {
		.pme_name = "PM_MRK_DTLB_MISS",
		.pme_code = 0xc50c6,
		.pme_short_desc = "Marked Data TLB misses",
		.pme_long_desc = "Data TLB references by a marked instruction that missed the TLB (all page sizes).",
	},
	[ POWER5_PME_PM_FPU1_FMA ] = {
		.pme_name = "PM_FPU1_FMA",
		.pme_code = 0xc5,
		.pme_short_desc = "FPU1 executed multiply-add instruction",
		.pme_long_desc = "The floating point unit has executed a multiply-add kind of instruction. This could be fmadd*, fnmadd*, fmsub*, fnmsub* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_L2SA_MOD_TAG ] = {
		.pme_name = "PM_L2SA_MOD_TAG",
		.pme_code = 0x720e0,
		.pme_short_desc = "L2 slice A transition from modified to tagged",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Tagged state. This transition was caused by a read snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_LSU1_FLUSH_ULD ] = {
		.pme_name = "PM_LSU1_FLUSH_ULD",
		.pme_code = 0xc00c4,
		.pme_short_desc = "LSU1 unaligned load flushes",
		.pme_long_desc = "A load was flushed from unit 1 because it was unaligned (crossed a 64 byte boundary, or 32 byte if it missed the L1).",
	},
	[ POWER5_PME_PM_MRK_LSU0_FLUSH_UST ] = {
		.pme_name = "PM_MRK_LSU0_FLUSH_UST",
		.pme_code = 0x810c1,
		.pme_short_desc = "LSU0 marked unaligned store flushes",
		.pme_long_desc = "A marked store was flushed from unit 0 because it was unaligned",
	},
	[ POWER5_PME_PM_MRK_INST_FIN ] = {
		.pme_name = "PM_MRK_INST_FIN",
		.pme_code = 0x300005,
		.pme_short_desc = "Marked instruction finished",
		.pme_long_desc = "One of the execution units finished a marked instruction.  Instructions that finish may not necessary complete",
	},
	[ POWER5_PME_PM_FPU0_FULL_CYC ] = {
		.pme_name = "PM_FPU0_FULL_CYC",
		.pme_code = 0x100c3,
		.pme_short_desc = "Cycles FPU0 issue queue full",
		.pme_long_desc = "The issue queue for FPU0 cannot accept any more instruction. Dispatch to this issue queue is stopped.",
	},
	[ POWER5_PME_PM_LSU_LRQ_S0_ALLOC ] = {
		.pme_name = "PM_LSU_LRQ_S0_ALLOC",
		.pme_code = 0xc20e6,
		.pme_short_desc = "LRQ slot 0 allocated",
		.pme_long_desc = "LRQ slot zero was allocated",
	},
	[ POWER5_PME_PM_MRK_LSU1_FLUSH_ULD ] = {
		.pme_name = "PM_MRK_LSU1_FLUSH_ULD",
		.pme_code = 0x810c4,
		.pme_short_desc = "LSU1 marked unaligned load flushes",
		.pme_long_desc = "A marked load was flushed from unit 1 because it was unaligned (crossed a 64byte boundary, or 32 byte if it missed the L1)",
	},
	[ POWER5_PME_PM_MRK_DTLB_REF ] = {
		.pme_name = "PM_MRK_DTLB_REF",
		.pme_code = 0x1c4090,
		.pme_short_desc = "Marked Data TLB reference",
		.pme_long_desc = "Total number of Data TLB references by a marked instruction for all page sizes. Page size is determined at TLB reload time.",
	},
	[ POWER5_PME_PM_BR_UNCOND ] = {
		.pme_name = "PM_BR_UNCOND",
		.pme_code = 0x123087,
		.pme_short_desc = "Unconditional branch",
		.pme_long_desc = "An unconditional branch was executed.",
	},
	[ POWER5_PME_PM_THRD_SEL_OVER_L2MISS ] = {
		.pme_name = "PM_THRD_SEL_OVER_L2MISS",
		.pme_code = 0x410c3,
		.pme_short_desc = "Thread selection overrides caused by L2 misses",
		.pme_long_desc = "Thread selection was overridden because one thread was had a L2 miss pending.",
	},
	[ POWER5_PME_PM_L2SB_SHR_INV ] = {
		.pme_name = "PM_L2SB_SHR_INV",
		.pme_code = 0x710c1,
		.pme_short_desc = "L2 slice B transition from shared to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L, or Tagged) to the Invalid state. This transition was caused by any external snoop request. The event is provided on each of the three slices A, B, and C. NOTE: For this event to be useful the tablewalk duration event should also be counted.",
	},
	[ POWER5_PME_PM_MEM_LO_PRIO_WR_CMPL ] = {
		.pme_name = "PM_MEM_LO_PRIO_WR_CMPL",
		.pme_code = 0x736e6,
		.pme_short_desc = "Low priority write completed",
		.pme_long_desc = "A memory write,  which was not upgraded to high priority, completed.  This event is sent from the Memory Controller clock domain and must be scaled accordingly",
	},
	[ POWER5_PME_PM_L3SC_MOD_TAG ] = {
		.pme_name = "PM_L3SC_MOD_TAG",
		.pme_code = 0x720e5,
		.pme_short_desc = "L3 slice C transition from modified to TAG",
		.pme_long_desc = "L3 snooper detects someone doing a read to a line that is truly M in this L3(i.e. L3 going M->T or M->I(go_Mu case); Mu|Me are not included since they are formed due to a prev read op).  Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_MRK_ST_MISS_L1 ] = {
		.pme_name = "PM_MRK_ST_MISS_L1",
		.pme_code = 0x820e3,
		.pme_short_desc = "Marked L1 D cache store misses",
		.pme_long_desc = "A marked store missed the dcache",
	},
	[ POWER5_PME_PM_GRP_DISP_SUCCESS ] = {
		.pme_name = "PM_GRP_DISP_SUCCESS",
		.pme_code = 0x300002,
		.pme_short_desc = "Group dispatch success",
		.pme_long_desc = "Number of groups sucessfully dispatched (not rejected)",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_1or2_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_1or2_CYC",
		.pme_code = 0x430e4,
		.pme_short_desc = "Cycles thread priority difference is 1 or 2",
		.pme_long_desc = "Cycles when this thread's priority is higher than the other thread's priority by 1 or 2.",
	},
	[ POWER5_PME_PM_IC_DEMAND_L2_BHT_REDIRECT ] = {
		.pme_name = "PM_IC_DEMAND_L2_BHT_REDIRECT",
		.pme_code = 0x230e0,
		.pme_short_desc = "L2 I cache demand request due to BHT redirect",
		.pme_long_desc = "A demand (not prefetch) miss to the instruction cache was sent to the L2 as a result of a branch prediction redirect (CR mispredict).",
	},
	[ POWER5_PME_PM_MEM_WQ_DISP_Q8to15 ] = {
		.pme_name = "PM_MEM_WQ_DISP_Q8to15",
		.pme_code = 0x733e6,
		.pme_short_desc = "Memory write queue dispatched to queues 8-15",
		.pme_long_desc = "A memory operation was dispatched to a write queue in the range between 8 and 15. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FPU0_SINGLE ] = {
		.pme_name = "PM_FPU0_SINGLE",
		.pme_code = 0x20e3,
		.pme_short_desc = "FPU0 executed single precision instruction",
		.pme_long_desc = "FPU0 has executed a single precision instruction.",
	},
	[ POWER5_PME_PM_LSU_DERAT_MISS ] = {
		.pme_name = "PM_LSU_DERAT_MISS",
		.pme_code = 0x280090,
		.pme_short_desc = "DERAT misses",
		.pme_long_desc = "Total D-ERAT Misses.  Requests that miss the Derat are rejected and retried until the request hits in the Erat. This may result in multiple erat misses for the same instruction.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_THRD_PRIO_1_CYC ] = {
		.pme_name = "PM_THRD_PRIO_1_CYC",
		.pme_code = 0x420e0,
		.pme_short_desc = "Cycles thread running at priority level 1",
		.pme_long_desc = "Cycles this thread was running at priority level 1. Priority level 1 is the lowest and indicates the thread is sleeping.",
	},
	[ POWER5_PME_PM_L2SC_RCST_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SC_RCST_DISP_FAIL_OTHER",
		.pme_code = 0x732e2,
		.pme_short_desc = "L2 slice C RC store dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a store  failed for some reason other than Full or Collision conditions.  Rejected dispatches do not count because they have not yet been attempted.",
	},
	[ POWER5_PME_PM_FPU1_FEST ] = {
		.pme_name = "PM_FPU1_FEST",
		.pme_code = 0x10c6,
		.pme_short_desc = "FPU1 executed FEST instruction",
		.pme_long_desc = "FPU1 has executed an estimate instructions.  This could be fres* or frsqrte* where XYZ* means XYZ or XYZ.",
	},
	[ POWER5_PME_PM_FAB_HOLDtoVN_EMPTY ] = {
		.pme_name = "PM_FAB_HOLDtoVN_EMPTY",
		.pme_code = 0x721e7,
		.pme_short_desc = "Hold buffer to VN empty",
		.pme_long_desc = "Fabric cycles when the Vertical Node out hold-buffers are emtpy. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_SNOOP_RD_RETRY_RQ ] = {
		.pme_name = "PM_SNOOP_RD_RETRY_RQ",
		.pme_code = 0x705c6,
		.pme_short_desc = "Snoop read retry due to collision with active read queue",
		.pme_long_desc = "A snoop request for a read from memory was retried because it matched the cache line of an active read.  The snoop request is retried because the L2 may be able to source data via intervention for the 2nd read faster than the MC.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_SNOOP_DCLAIM_RETRY_QFULL ] = {
		.pme_name = "PM_SNOOP_DCLAIM_RETRY_QFULL",
		.pme_code = 0x720e6,
		.pme_short_desc = "Snoop dclaim/flush retry due to write/dclaim queues full",
		.pme_long_desc = "The memory controller A memory write was dispatched to a write queue. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L25_SHR_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L25_SHR_CYC",
		.pme_code = 0x2c70a2,
		.pme_short_desc = "Marked load latency from L2.5 shared",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_MRK_ST_CMPL_INT ] = {
		.pme_name = "PM_MRK_ST_CMPL_INT",
		.pme_code = 0x300003,
		.pme_short_desc = "Marked store completed with intervention",
		.pme_long_desc = "A marked store previously sent to the memory subsystem completed (data home) after requiring intervention",
	},
	[ POWER5_PME_PM_FLUSH_BR_MPRED ] = {
		.pme_name = "PM_FLUSH_BR_MPRED",
		.pme_code = 0x110c6,
		.pme_short_desc = "Flush caused by branch mispredict",
		.pme_long_desc = "A flush was caused by a branch mispredict.",
	},
	[ POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SB_RCLD_DISP_FAIL_ADDR",
		.pme_code = 0x711c1,
		.pme_short_desc = "L2 slice B RC load dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_FPU_STF ] = {
		.pme_name = "PM_FPU_STF",
		.pme_code = 0x202090,
		.pme_short_desc = "FPU executed store instruction",
		.pme_long_desc = "FPU has executed a store instruction. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_FPU ] = {
		.pme_name = "PM_CMPLU_STALL_FPU",
		.pme_code = 0x411098,
		.pme_short_desc = "Completion stall caused by FPU instruction",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes was a floating point instruction.",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_minus1or2_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_minus1or2_CYC",
		.pme_code = 0x430e2,
		.pme_short_desc = "Cycles thread priority difference is -1 or -2",
		.pme_long_desc = "Cycles when this thread's priority is lower than the other thread's priority by 1 or 2.",
	},
	[ POWER5_PME_PM_GCT_NOSLOT_CYC ] = {
		.pme_name = "PM_GCT_NOSLOT_CYC",
		.pme_code = 0x100004,
		.pme_short_desc = "Cycles no GCT slot allocated",
		.pme_long_desc = "Cycles when the Global Completion Table has no slots from this thread.",
	},
	[ POWER5_PME_PM_FXU0_BUSY_FXU1_IDLE ] = {
		.pme_name = "PM_FXU0_BUSY_FXU1_IDLE",
		.pme_code = 0x300012,
		.pme_short_desc = "FXU0 busy FXU1 idle",
		.pme_long_desc = "FXU0 is busy while FXU1 was idle",
	},
	[ POWER5_PME_PM_PTEG_FROM_L35_SHR ] = {
		.pme_name = "PM_PTEG_FROM_L35_SHR",
		.pme_code = 0x18309e,
		.pme_short_desc = "PTEG loaded from L3.5 shared",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with shared (S) data from the L3 of a chip on the same module as this processor is located, due to a demand load.",
	},
	[ POWER5_PME_PM_MRK_LSU_FLUSH_UST ] = {
		.pme_name = "PM_MRK_LSU_FLUSH_UST",
		.pme_code = 0x381090,
		.pme_short_desc = "Marked unaligned store flushes",
		.pme_long_desc = "A marked store was flushed because it was unaligned",
	},
	[ POWER5_PME_PM_L3SA_HIT ] = {
		.pme_name = "PM_L3SA_HIT",
		.pme_code = 0x711c3,
		.pme_short_desc = "L3 slice A hits",
		.pme_long_desc = "Number of attempts made by this chip cores that resulted in an L3 hit.  Reported per L3 slice",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L25_SHR ] = {
		.pme_name = "PM_MRK_DATA_FROM_L25_SHR",
		.pme_code = 0x1c7097,
		.pme_short_desc = "Marked data loaded from L2.5 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared  (T or SL) data from the L2 of a chip on the same module as this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_L2SB_RCST_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SB_RCST_DISP_FAIL_ADDR",
		.pme_code = 0x712c1,
		.pme_short_desc = "L2 slice B RC store dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L35_SHR ] = {
		.pme_name = "PM_MRK_DATA_FROM_L35_SHR",
		.pme_code = 0x1c709e,
		.pme_short_desc = "Marked data loaded from L3.5 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (S) data from the L3 of a chip on the same module as this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_IERAT_XLATE_WR ] = {
		.pme_name = "PM_IERAT_XLATE_WR",
		.pme_code = 0x220e7,
		.pme_short_desc = "Translation written to ierat",
		.pme_long_desc = "An entry was written into the IERAT as a result of an IERAT miss.  This event can be used to count IERAT misses.  An ERAT miss that are later ignored will not be counted unless the ERAT is written before the instruction stream is changed.",
	},
	[ POWER5_PME_PM_L2SA_ST_REQ ] = {
		.pme_name = "PM_L2SA_ST_REQ",
		.pme_code = 0x723e0,
		.pme_short_desc = "L2 slice A store requests",
		.pme_long_desc = "A store request as seen at the L2 directory has been made from the core. Stores are counted after gathering in the L2 store queues. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_THRD_SEL_T1 ] = {
		.pme_name = "PM_THRD_SEL_T1",
		.pme_code = 0x410c1,
		.pme_short_desc = "Decode selected thread 1",
		.pme_long_desc = "Thread selection picked thread 1 for decode.",
	},
	[ POWER5_PME_PM_IC_DEMAND_L2_BR_REDIRECT ] = {
		.pme_name = "PM_IC_DEMAND_L2_BR_REDIRECT",
		.pme_code = 0x230e1,
		.pme_short_desc = "L2 I cache demand request due to branch redirect",
		.pme_long_desc = "A demand (not prefetch) miss to the instruction cache was sent to the L2 as a result of a branch prediction redirect (either ALL mispredicted or Target).",
	},
	[ POWER5_PME_PM_INST_FROM_LMEM ] = {
		.pme_name = "PM_INST_FROM_LMEM",
		.pme_code = 0x222086,
		.pme_short_desc = "Instruction fetched from local memory",
		.pme_long_desc = "An instruction fetch group was fetched from memory attached to the same module this proccessor is located on.  Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_FPU0_1FLOP ] = {
		.pme_name = "PM_FPU0_1FLOP",
		.pme_code = 0xc3,
		.pme_short_desc = "FPU0 executed add, mult, sub, cmp or sel instruction",
		.pme_long_desc = "The floating point unit has executed an add, mult, sub, compare, fsel, fneg, fabs, fnabs, fres, or frsqrte kind of instruction.  These are single FLOP operations.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L35_SHR_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L35_SHR_CYC",
		.pme_code = 0x2c70a6,
		.pme_short_desc = "Marked load latency from L3.5 shared",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L2 ] = {
		.pme_name = "PM_PTEG_FROM_L2",
		.pme_code = 0x183087,
		.pme_short_desc = "PTEG loaded from L2",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB from the local L2 due to a demand load",
	},
	[ POWER5_PME_PM_MEM_PW_CMPL ] = {
		.pme_name = "PM_MEM_PW_CMPL",
		.pme_code = 0x724e6,
		.pme_short_desc = "Memory partial-write completed",
		.pme_long_desc = "Number of Partial Writes completed.   This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_minus5or6_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_minus5or6_CYC",
		.pme_code = 0x430e0,
		.pme_short_desc = "Cycles thread priority difference is -5 or -6",
		.pme_long_desc = "Cycles when this thread's priority is lower than the other thread's priority by 5 or 6.",
	},
	[ POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SB_RCLD_DISP_FAIL_OTHER",
		.pme_code = 0x731e1,
		.pme_short_desc = "L2 slice B RC load dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a load failed for some reason other than Full or Collision conditions.",
	},
	[ POWER5_PME_PM_FPU0_FIN ] = {
		.pme_name = "PM_FPU0_FIN",
		.pme_code = 0x10c3,
		.pme_short_desc = "FPU0 produced a result",
		.pme_long_desc = "FPU0 finished, produced a result.  This only indicates finish,  not completion. Floating Point Stores are included in this count but not Floating Point Loads.",
	},
	[ POWER5_PME_PM_MRK_DTLB_MISS_4K ] = {
		.pme_name = "PM_MRK_DTLB_MISS_4K",
		.pme_code = 0xc40c1,
		.pme_short_desc = "Marked Data TLB misses for 4K page",
		.pme_long_desc = "Data TLB references to 4KB pages by a marked instruction that missed the TLB. Page size is determined at TLB reload time.",
	},
	[ POWER5_PME_PM_L3SC_SHR_INV ] = {
		.pme_name = "PM_L3SC_SHR_INV",
		.pme_code = 0x710c5,
		.pme_short_desc = "L3 slice C transition from shared to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is Sx in this L3(i.e. invalidate hit SX and dispatched).",
	},
	[ POWER5_PME_PM_GRP_BR_REDIR ] = {
		.pme_name = "PM_GRP_BR_REDIR",
		.pme_code = 0x120e6,
		.pme_short_desc = "Group experienced branch redirect",
		.pme_long_desc = "Number of groups, counted at dispatch, that have encountered a branch redirect.  Every group constructed from a fetch group that has been redirected will count.",
	},
	[ POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SC_RCLD_DISP_FAIL_RC_FULL",
		.pme_code = 0x721e2,
		.pme_short_desc = "L2 slice C RC load dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_MRK_LSU_FLUSH_SRQ ] = {
		.pme_name = "PM_MRK_LSU_FLUSH_SRQ",
		.pme_code = 0x481088,
		.pme_short_desc = "Marked SRQ lhs flushes",
		.pme_long_desc = "A marked store was flushed because younger load hits and older store that is already in the SRQ or in the same group.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L275_SHR ] = {
		.pme_name = "PM_PTEG_FROM_L275_SHR",
		.pme_code = 0x383097,
		.pme_short_desc = "PTEG loaded from L2.75 shared",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with shared (T) data from the L2 on a different module than this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_L2SB_RCLD_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SB_RCLD_DISP_FAIL_RC_FULL",
		.pme_code = 0x721e1,
		.pme_short_desc = "L2 slice B RC load dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_SNOOP_RD_RETRY_WQ ] = {
		.pme_name = "PM_SNOOP_RD_RETRY_WQ",
		.pme_code = 0x715c6,
		.pme_short_desc = "Snoop read retry due to collision with active write queue",
		.pme_long_desc = "A snoop request for a read from memory was retried because it matched the cache line of an active write. The snoop request is retried and the active write is changed to high priority.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LSU0_NCLD ] = {
		.pme_name = "PM_LSU0_NCLD",
		.pme_code = 0xc50c1,
		.pme_short_desc = "LSU0 non-cacheable loads",
		.pme_long_desc = "A non-cacheable load was executed by unit 0.",
	},
	[ POWER5_PME_PM_FAB_DCLAIM_RETRIED ] = {
		.pme_name = "PM_FAB_DCLAIM_RETRIED",
		.pme_code = 0x730e7,
		.pme_short_desc = "dclaim retried",
		.pme_long_desc = "A DCLAIM command was retried.  Each chip reports its own counts.  The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LSU1_BUSY_REJECT ] = {
		.pme_name = "PM_LSU1_BUSY_REJECT",
		.pme_code = 0xc20e7,
		.pme_short_desc = "LSU1 busy due to reject",
		.pme_long_desc = "Total cycles the Load Store Unit 1 is busy rejecting instructions.",
	},
	[ POWER5_PME_PM_FXLS0_FULL_CYC ] = {
		.pme_name = "PM_FXLS0_FULL_CYC",
		.pme_code = 0x110c0,
		.pme_short_desc = "Cycles FXU0/LS0 queue full",
		.pme_long_desc = "The issue queue that feeds the Fixed Point unit 0 / Load Store Unit 0 is full. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the queue was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_FPU0_FEST ] = {
		.pme_name = "PM_FPU0_FEST",
		.pme_code = 0x10c2,
		.pme_short_desc = "FPU0 executed FEST instruction",
		.pme_long_desc = "FPU0 has executed an estimate instructions. This could be fres* or frsqrte* where XYZ* means XYZ or XYZ. ",
	},
	[ POWER5_PME_PM_DTLB_REF_16M ] = {
		.pme_name = "PM_DTLB_REF_16M",
		.pme_code = 0xc40c6,
		.pme_short_desc = "Data TLB reference for 16M page",
		.pme_long_desc = "Data TLB references for 16MB pages. Includes hits + misses.",
	},
	[ POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SC_RCLD_DISP_FAIL_ADDR",
		.pme_code = 0x711c2,
		.pme_short_desc = "L2 slice C RC load dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_LSU0_REJECT_ERAT_MISS ] = {
		.pme_name = "PM_LSU0_REJECT_ERAT_MISS",
		.pme_code = 0xc60e3,
		.pme_short_desc = "LSU0 reject due to ERAT miss",
		.pme_long_desc = "Total cycles the Load Store Unit 0 is busy rejecting instructions due to an ERAT miss.  Requests that miss the Derat are rejected and retried until the request hits in the Erat.",
	},
	[ POWER5_PME_PM_DATA_FROM_L25_MOD ] = {
		.pme_name = "PM_DATA_FROM_L25_MOD",
		.pme_code = 0x2c3097,
		.pme_short_desc = "Data loaded from L2.5 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L2 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_GCT_USAGE_60to79_CYC ] = {
		.pme_name = "PM_GCT_USAGE_60to79_CYC",
		.pme_code = 0x20001f,
		.pme_short_desc = "Cycles GCT 60-79% full",
		.pme_long_desc = "Cycles when the Global Completion Table has between 60% and 70% of its slots used.  The GCT has 20 entries shared between threads.",
	},
	[ POWER5_PME_PM_DATA_FROM_L375_MOD ] = {
		.pme_name = "PM_DATA_FROM_L375_MOD",
		.pme_code = 0x1c30a7,
		.pme_short_desc = "Data loaded from L3.75 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L3 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_LSU_LMQ_SRQ_EMPTY_CYC ] = {
		.pme_name = "PM_LSU_LMQ_SRQ_EMPTY_CYC",
		.pme_code = 0x200015,
		.pme_short_desc = "Cycles LMQ and SRQ empty",
		.pme_long_desc = "Cycles when both the LMQ and SRQ are empty (LSU is idle)",
	},
	[ POWER5_PME_PM_LSU0_REJECT_RELOAD_CDF ] = {
		.pme_name = "PM_LSU0_REJECT_RELOAD_CDF",
		.pme_code = 0xc60e2,
		.pme_short_desc = "LSU0 reject due to reload CDF or tag update collision",
		.pme_long_desc = "Total cycles the Load Store Unit 0 is busy rejecting instructions because of Critical Data Forward.  When critical data arrives from the storage system it is formatted and immediately forwarded, bypassing the data cache, to the destination register using the result bus.  Any instruction the requires the result bus in the same cycle is rejected.  Tag update rejects are caused when an instruction requires access to the Dcache directory or ERAT in the same system when they are being updated.",
	},
	[ POWER5_PME_PM_0INST_FETCH ] = {
		.pme_name = "PM_0INST_FETCH",
		.pme_code = 0x42208d,
		.pme_short_desc = "No instructions fetched",
		.pme_long_desc = "No instructions were fetched this cycles (due to IFU hold, redirect, or icache miss)",
	},
	[ POWER5_PME_PM_LSU1_REJECT_RELOAD_CDF ] = {
		.pme_name = "PM_LSU1_REJECT_RELOAD_CDF",
		.pme_code = 0xc60e6,
		.pme_short_desc = "LSU1 reject due to reload CDF or tag update collision",
		.pme_long_desc = "Total cycles the Load Store Unit 1 is busy rejecting instructions because of Critical Data Forward.  When critical data arrives from the storage system it is formatted and immediately forwarded, bypassing the data cache, to the destination register using the result bus.  Any instruction the requires the result bus in the same cycle is rejected.  Tag update rejects are caused when an instruction requires access to the Dcache directory or ERAT in the same system when they are being updated.",
	},
	[ POWER5_PME_PM_L1_PREF ] = {
		.pme_name = "PM_L1_PREF",
		.pme_code = 0xc70e7,
		.pme_short_desc = "L1 cache data prefetches",
		.pme_long_desc = "A request to prefetch data into the L1 was made",
	},
	[ POWER5_PME_PM_MEM_WQ_DISP_Q0to7 ] = {
		.pme_name = "PM_MEM_WQ_DISP_Q0to7",
		.pme_code = 0x723e6,
		.pme_short_desc = "Memory write queue dispatched to queues 0-7",
		.pme_long_desc = "A memory operation was dispatched to a write queue in the range between 0 and 7. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_LMEM_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_LMEM_CYC",
		.pme_code = 0x4c70a0,
		.pme_short_desc = "Marked load latency from local memory",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_BRQ_FULL_CYC ] = {
		.pme_name = "PM_BRQ_FULL_CYC",
		.pme_code = 0x100c5,
		.pme_short_desc = "Cycles branch queue full",
		.pme_long_desc = "Cycles when the issue queue that feeds the branch unit is full. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the queue was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_GRP_IC_MISS_NONSPEC ] = {
		.pme_name = "PM_GRP_IC_MISS_NONSPEC",
		.pme_code = 0x112099,
		.pme_short_desc = "Group experienced non-speculative I cache miss",
		.pme_long_desc = "Number of groups, counted at completion, that have encountered an instruction cache miss.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L275_MOD ] = {
		.pme_name = "PM_PTEG_FROM_L275_MOD",
		.pme_code = 0x1830a3,
		.pme_short_desc = "PTEG loaded from L2.75 modified",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with modified (M) data from the L2 on a different module than this processor is located due to a demand load. ",
	},
	[ POWER5_PME_PM_MRK_LD_MISS_L1_LSU0 ] = {
		.pme_name = "PM_MRK_LD_MISS_L1_LSU0",
		.pme_code = 0x820e0,
		.pme_short_desc = "LSU0 marked L1 D cache load misses",
		.pme_long_desc = "Load references that miss the Level 1 Data cache, by LSU0.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L375_SHR_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L375_SHR_CYC",
		.pme_code = 0x2c70a7,
		.pme_short_desc = "Marked load latency from L3.75 shared",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_LSU_FLUSH ] = {
		.pme_name = "PM_LSU_FLUSH",
		.pme_code = 0x110c5,
		.pme_short_desc = "Flush initiated by LSU",
		.pme_long_desc = "A flush was initiated by the Load Store Unit",
	},
	[ POWER5_PME_PM_DATA_FROM_L3 ] = {
		.pme_name = "PM_DATA_FROM_L3",
		.pme_code = 0x1c308e,
		.pme_short_desc = "Data loaded from L3",
		.pme_long_desc = "The processor's Data Cache was reloaded from the local L3 due to a demand load.",
	},
	[ POWER5_PME_PM_INST_FROM_L2 ] = {
		.pme_name = "PM_INST_FROM_L2",
		.pme_code = 0x122086,
		.pme_short_desc = "Instruction fetched from L2",
		.pme_long_desc = "An instruction fetch group was fetched from L2. Fetch Groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_PMC2_OVERFLOW ] = {
		.pme_name = "PM_PMC2_OVERFLOW",
		.pme_code = 0x30000a,
		.pme_short_desc = "PMC2 Overflow",
		.pme_long_desc = "Overflows from PMC2 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_FPU0_DENORM ] = {
		.pme_name = "PM_FPU0_DENORM",
		.pme_code = 0x20e0,
		.pme_short_desc = "FPU0 received denormalized data",
		.pme_long_desc = "FPU0 has encountered a denormalized operand.  ",
	},
	[ POWER5_PME_PM_FPU1_FMOV_FEST ] = {
		.pme_name = "PM_FPU1_FMOV_FEST",
		.pme_code = 0x10c4,
		.pme_short_desc = "FPU1 executed FMOV or FEST instructions",
		.pme_long_desc = "FPU1 has executed a move kind of instruction or one of the estimate instructions.  This could be fmr*, fneg*, fabs*, fnabs* , fres* or frsqrte* where XYZ* means XYZ or XYZ.",
	},
	[ POWER5_PME_PM_INST_FETCH_CYC ] = {
		.pme_name = "PM_INST_FETCH_CYC",
		.pme_code = 0x220e4,
		.pme_short_desc = "Cycles at least 1 instruction fetched",
		.pme_long_desc = "Cycles when at least one instruction was sent from the fetch unit to the decode unit.",
	},
	[ POWER5_PME_PM_LSU_LDF ] = {
		.pme_name = "PM_LSU_LDF",
		.pme_code = 0x4c5090,
		.pme_short_desc = "LSU executed Floating Point load instruction",
		.pme_long_desc = "LSU executed Floating Point load instruction.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_INST_DISP ] = {
		.pme_name = "PM_INST_DISP",
		.pme_code = 0x300009,
		.pme_short_desc = "Instructions dispatched",
		.pme_long_desc = "Number of PowerPC instructions successfully dispatched.",
	},
	[ POWER5_PME_PM_DATA_FROM_L25_SHR ] = {
		.pme_name = "PM_DATA_FROM_L25_SHR",
		.pme_code = 0x1c3097,
		.pme_short_desc = "Data loaded from L2.5 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (T or SL) data from the L2 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_L1_DCACHE_RELOAD_VALID ] = {
		.pme_name = "PM_L1_DCACHE_RELOAD_VALID",
		.pme_code = 0xc30e4,
		.pme_short_desc = "L1 reload data source valid",
		.pme_long_desc = "The data source information is valid,the data cache has been reloaded.  Prior to POWER5+ this included data cache reloads due to prefetch activity.  With POWER5+ this now only includes reloads due to demand loads.",
	},
	[ POWER5_PME_PM_MEM_WQ_DISP_DCLAIM ] = {
		.pme_name = "PM_MEM_WQ_DISP_DCLAIM",
		.pme_code = 0x713c6,
		.pme_short_desc = "Memory write queue dispatched due to dclaim/flush",
		.pme_long_desc = "A memory dclaim or flush operation was dispatched to a write queue. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_FPU_FULL_CYC ] = {
		.pme_name = "PM_FPU_FULL_CYC",
		.pme_code = 0x110090,
		.pme_short_desc = "Cycles FPU issue queue full",
		.pme_long_desc = "Cycles when one or both FPU issue queues are full.  Combined Unit 0 + 1.  Use with caution since this is the sum of cycles when Unit 0 was full plus Unit 1 full.  It does not indicate when both units were full.",
	},
	[ POWER5_PME_PM_MRK_GRP_ISSUED ] = {
		.pme_name = "PM_MRK_GRP_ISSUED",
		.pme_code = 0x100015,
		.pme_short_desc = "Marked group issued",
		.pme_long_desc = "A sampled instruction was issued.",
	},
	[ POWER5_PME_PM_THRD_PRIO_3_CYC ] = {
		.pme_name = "PM_THRD_PRIO_3_CYC",
		.pme_code = 0x420e2,
		.pme_short_desc = "Cycles thread running at priority level 3",
		.pme_long_desc = "Cycles this thread was running at priority level 3.",
	},
	[ POWER5_PME_PM_FPU_FMA ] = {
		.pme_name = "PM_FPU_FMA",
		.pme_code = 0x200088,
		.pme_short_desc = "FPU executed multiply-add instruction",
		.pme_long_desc = "This signal is active for one cycle when FPU is executing multiply-add kind of instruction. This could be fmadd*, fnmadd*, fmsub*, fnmsub* where XYZ* means XYZ, XYZs, XYZ., XYZs. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_INST_FROM_L35_MOD ] = {
		.pme_name = "PM_INST_FROM_L35_MOD",
		.pme_code = 0x22209d,
		.pme_short_desc = "Instruction fetched from L3.5 modified",
		.pme_long_desc = "An instruction fetch group was fetched with modified (M) data from the L3 of a chip on the same module as this processor is located. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_MRK_CRU_FIN ] = {
		.pme_name = "PM_MRK_CRU_FIN",
		.pme_code = 0x400005,
		.pme_short_desc = "Marked instruction CRU processing finished",
		.pme_long_desc = "The Condition Register Unit finished a marked instruction. Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_SNOOP_WR_RETRY_WQ ] = {
		.pme_name = "PM_SNOOP_WR_RETRY_WQ",
		.pme_code = 0x716c6,
		.pme_short_desc = "Snoop write/dclaim retry due to collision with active write queue",
		.pme_long_desc = "A snoop request for a write or dclaim to memory was retried because it matched the cache line of an active write.  The snoop request is retried and the active write is changed to high priority.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_REJECT ] = {
		.pme_name = "PM_CMPLU_STALL_REJECT",
		.pme_code = 0x41109a,
		.pme_short_desc = "Completion stall caused by reject",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes suffered a load/store reject. This is a subset of PM_CMPLU_STALL_LSU.",
	},
	[ POWER5_PME_PM_LSU1_REJECT_ERAT_MISS ] = {
		.pme_name = "PM_LSU1_REJECT_ERAT_MISS",
		.pme_code = 0xc60e7,
		.pme_short_desc = "LSU1 reject due to ERAT miss",
		.pme_long_desc = "Total cycles the Load Store Unit 1 is busy rejecting instructions due to an ERAT miss.  Requests that miss the Derat are rejected and retried until the request hits in the Erat.",
	},
	[ POWER5_PME_PM_MRK_FXU_FIN ] = {
		.pme_name = "PM_MRK_FXU_FIN",
		.pme_code = 0x200014,
		.pme_short_desc = "Marked instruction FXU processing finished",
		.pme_long_desc = "One of the Fixed Point Units finished a marked instruction.  Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_L2SB_RCST_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SB_RCST_DISP_FAIL_OTHER",
		.pme_code = 0x732e1,
		.pme_short_desc = "L2 slice B RC store dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a store  failed for some reason other than Full or Collision conditions.  Rejected dispatches do not count because they have not yet been attempted.",
	},
	[ POWER5_PME_PM_L2SC_RC_DISP_FAIL_CO_BUSY ] = {
		.pme_name = "PM_L2SC_RC_DISP_FAIL_CO_BUSY",
		.pme_code = 0x703c2,
		.pme_short_desc = "L2 slice C RC dispatch attempt failed due to RC/CO pair chosen was miss and CO already busy",
		.pme_long_desc = "A Read/Claim  Dispatch was rejected at dispatch because the Castout Machine was busy.  In the case of an RC starting up on a miss and the victim is valid, the CO machine must be available for the RC to process the access. If the CO is still busy working on an old castout, then the RC must not-ack the access if it is a miss(re-issued by the CIU). If it is a miss and the CO is available to process the castout, the RC will accept the access. Once the RC has finished, it can restart and process new accesses that result in a hit (or miss that doesn't need a CO) even though the CO is still processing a castout from a previous access.",
	},
	[ POWER5_PME_PM_PMC4_OVERFLOW ] = {
		.pme_name = "PM_PMC4_OVERFLOW",
		.pme_code = 0x10000a,
		.pme_short_desc = "PMC4 Overflow",
		.pme_long_desc = "Overflows from PMC4 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_L3SA_SNOOP_RETRY ] = {
		.pme_name = "PM_L3SA_SNOOP_RETRY",
		.pme_code = 0x731e3,
		.pme_short_desc = "L3 slice A snoop retries",
		.pme_long_desc = "Number of times an L3 retried a snoop because it got two in at the same time (one on snp_a, one on snp_b)",
	},
	[ POWER5_PME_PM_PTEG_FROM_L35_MOD ] = {
		.pme_name = "PM_PTEG_FROM_L35_MOD",
		.pme_code = 0x28309e,
		.pme_short_desc = "PTEG loaded from L3.5 modified",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB with modified (M) data from the L3 of a chip on the same module as this processor is located, due to a demand load.",
	},
	[ POWER5_PME_PM_INST_FROM_L25_MOD ] = {
		.pme_name = "PM_INST_FROM_L25_MOD",
		.pme_code = 0x222096,
		.pme_short_desc = "Instruction fetched from L2.5 modified",
		.pme_long_desc = "An instruction fetch group was fetched with modified (M) data from the L2 of a chip on the same module as this processor is located.  Fetch groups can contain up to 8 instructions.",
	},
	[ POWER5_PME_PM_THRD_SMT_HANG ] = {
		.pme_name = "PM_THRD_SMT_HANG",
		.pme_code = 0x330e7,
		.pme_short_desc = "SMT hang detected",
		.pme_long_desc = "A hung thread was detected",
	},
	[ POWER5_PME_PM_CMPLU_STALL_ERAT_MISS ] = {
		.pme_name = "PM_CMPLU_STALL_ERAT_MISS",
		.pme_code = 0x41109b,
		.pme_short_desc = "Completion stall caused by ERAT miss",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes suffered an ERAT miss. This is a subset of  PM_CMPLU_STALL_REJECT.",
	},
	[ POWER5_PME_PM_L3SA_MOD_TAG ] = {
		.pme_name = "PM_L3SA_MOD_TAG",
		.pme_code = 0x720e3,
		.pme_short_desc = "L3 slice A transition from modified to TAG",
		.pme_long_desc = "L3 snooper detects someone doing a read to a line that is truly M in this L3(i.e. L3 going M->T or M->I(go_Mu case) Mu|Me are not included since they are formed due to a prev read op).  Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_FLUSH_SYNC ] = {
		.pme_name = "PM_FLUSH_SYNC",
		.pme_code = 0x330e1,
		.pme_short_desc = "Flush caused by sync",
		.pme_long_desc = "This thread has been flushed at dispatch due to a sync, lwsync, ptesync, or tlbsync instruction.  This allows the other thread to have more machine resources for it to make progress until the sync finishes.",
	},
	[ POWER5_PME_PM_INST_FROM_L2MISS ] = {
		.pme_name = "PM_INST_FROM_L2MISS",
		.pme_code = 0x12209b,
		.pme_short_desc = "Instruction fetched missed L2",
		.pme_long_desc = "An instruction fetch group was fetched from beyond the local L2.",
	},
	[ POWER5_PME_PM_L2SC_ST_HIT ] = {
		.pme_name = "PM_L2SC_ST_HIT",
		.pme_code = 0x733e2,
		.pme_short_desc = "L2 slice C store hits",
		.pme_long_desc = "A store request made from the core hit in the L2 directory.  The event is provided on each of the  three slices A, B, and C.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP_Q8to11 ] = {
		.pme_name = "PM_MEM_RQ_DISP_Q8to11",
		.pme_code = 0x722e6,
		.pme_short_desc = "Memory read queue dispatched to queues 8-11",
		.pme_long_desc = "A memory operation was dispatched to read queue 8,9,10 or 11. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_MRK_GRP_DISP ] = {
		.pme_name = "PM_MRK_GRP_DISP",
		.pme_code = 0x100002,
		.pme_short_desc = "Marked group dispatched",
		.pme_long_desc = "A group containing a sampled instruction was dispatched",
	},
	[ POWER5_PME_PM_L2SB_MOD_TAG ] = {
		.pme_name = "PM_L2SB_MOD_TAG",
		.pme_code = 0x720e1,
		.pme_short_desc = "L2 slice B transition from modified to tagged",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Tagged state. This transition was caused by a read snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_CLB_EMPTY_CYC ] = {
		.pme_name = "PM_CLB_EMPTY_CYC",
		.pme_code = 0x410c6,
		.pme_short_desc = "Cycles CLB empty",
		.pme_long_desc = "Cycles when both thread's CLB is completely empty.",
	},
	[ POWER5_PME_PM_L2SB_ST_HIT ] = {
		.pme_name = "PM_L2SB_ST_HIT",
		.pme_code = 0x733e1,
		.pme_short_desc = "L2 slice B store hits",
		.pme_long_desc = "A store request made from the core hit in the L2 directory.  This event is provided on each of the three L2 slices A, B and C.",
	},
	[ POWER5_PME_PM_MEM_NONSPEC_RD_CANCEL ] = {
		.pme_name = "PM_MEM_NONSPEC_RD_CANCEL",
		.pme_code = 0x711c6,
		.pme_short_desc = "Non speculative memory read cancelled",
		.pme_long_desc = "A non-speculative read was cancelled because the combined response indicated it was sourced from aother L2 or L3.   This event is sent from the Memory Controller clock domain and must be scaled accordingly",
	},
	[ POWER5_PME_PM_BR_PRED_CR_TA ] = {
		.pme_name = "PM_BR_PRED_CR_TA",
		.pme_code = 0x423087,
		.pme_short_desc = "A conditional branch was predicted, CR and target prediction",
		.pme_long_desc = "Both the condition (taken or not taken) and the target address of a branch instruction was predicted.",
	},
	[ POWER5_PME_PM_MRK_LSU0_FLUSH_SRQ ] = {
		.pme_name = "PM_MRK_LSU0_FLUSH_SRQ",
		.pme_code = 0x810c3,
		.pme_short_desc = "LSU0 marked SRQ lhs flushes",
		.pme_long_desc = "A marked store was flushed because younger load hits and older store that is already in the SRQ or in the same group.",
	},
	[ POWER5_PME_PM_MRK_LSU_FLUSH_ULD ] = {
		.pme_name = "PM_MRK_LSU_FLUSH_ULD",
		.pme_code = 0x481090,
		.pme_short_desc = "Marked unaligned load flushes",
		.pme_long_desc = "A marked load was flushed because it was unaligned (crossed a 64byte boundary, or 32 byte if it missed the L1)",
	},
	[ POWER5_PME_PM_INST_DISP_ATTEMPT ] = {
		.pme_name = "PM_INST_DISP_ATTEMPT",
		.pme_code = 0x120e1,
		.pme_short_desc = "Instructions dispatch attempted",
		.pme_long_desc = "Number of PowerPC Instructions dispatched (attempted, not filtered by success.",
	},
	[ POWER5_PME_PM_INST_FROM_RMEM ] = {
		.pme_name = "PM_INST_FROM_RMEM",
		.pme_code = 0x422086,
		.pme_short_desc = "Instruction fetched from remote memory",
		.pme_long_desc = "An instruction fetch group was fetched from memory attached to a different module than this proccessor is located on.  Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_ST_REF_L1_LSU0 ] = {
		.pme_name = "PM_ST_REF_L1_LSU0",
		.pme_code = 0xc10c1,
		.pme_short_desc = "LSU0 L1 D cache store references",
		.pme_long_desc = "Store references to the Data Cache by LSU0.",
	},
	[ POWER5_PME_PM_LSU0_DERAT_MISS ] = {
		.pme_name = "PM_LSU0_DERAT_MISS",
		.pme_code = 0x800c2,
		.pme_short_desc = "LSU0 DERAT misses",
		.pme_long_desc = "Total D-ERAT Misses by LSU0.   Requests that miss the Derat are rejected and retried until the request hits in the Erat. This may result in multiple erat misses for the same instruction.",
	},
	[ POWER5_PME_PM_L2SB_RCLD_DISP ] = {
		.pme_name = "PM_L2SB_RCLD_DISP",
		.pme_code = 0x701c1,
		.pme_short_desc = "L2 slice B RC load dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Load was attempted",
	},
	[ POWER5_PME_PM_FPU_STALL3 ] = {
		.pme_name = "PM_FPU_STALL3",
		.pme_code = 0x202088,
		.pme_short_desc = "FPU stalled in pipe3",
		.pme_long_desc = "FPU has generated a stall in pipe3 due to overflow, underflow, massive cancel, convert to integer (sometimes), or convert from integer (always). This signal is active during the entire duration of the stall. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_BR_PRED_CR ] = {
		.pme_name = "PM_BR_PRED_CR",
		.pme_code = 0x230e2,
		.pme_short_desc = "A conditional branch was predicted, CR prediction",
		.pme_long_desc = "A conditional branch instruction was predicted as taken or not taken.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L2 ] = {
		.pme_name = "PM_MRK_DATA_FROM_L2",
		.pme_code = 0x1c7087,
		.pme_short_desc = "Marked data loaded from L2",
		.pme_long_desc = "The processor's Data Cache was reloaded from the local L2 due to a marked load.",
	},
	[ POWER5_PME_PM_LSU0_FLUSH_SRQ ] = {
		.pme_name = "PM_LSU0_FLUSH_SRQ",
		.pme_code = 0xc00c3,
		.pme_short_desc = "LSU0 SRQ lhs flushes",
		.pme_long_desc = "A store was flushed by unit 0 because younger load hits and older store that is already in the SRQ or in the same group.",
	},
	[ POWER5_PME_PM_FAB_PNtoNN_DIRECT ] = {
		.pme_name = "PM_FAB_PNtoNN_DIRECT",
		.pme_code = 0x703c7,
		.pme_short_desc = "PN to NN beat went straight to its destination",
		.pme_long_desc = "Fabric Data beats that the base chip takes the inbound PN data and passes it through to the outbound NN bus without going into a sidecar. The signal is delivered at FBC speed and the count must be scaled.",
	},
	[ POWER5_PME_PM_IOPS_CMPL ] = {
		.pme_name = "PM_IOPS_CMPL",
		.pme_code = 0x1,
		.pme_short_desc = "Internal operations completed",
		.pme_long_desc = "Number of internal operations that completed.",
	},
	[ POWER5_PME_PM_L2SC_SHR_INV ] = {
		.pme_name = "PM_L2SC_SHR_INV",
		.pme_code = 0x710c2,
		.pme_short_desc = "L2 slice C transition from shared to invalid",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L, or Tagged) to the Invalid state. This transition was caused by any external snoop request. The event is provided on each of the three slices A, B, and C. NOTE: For this event to be useful the tablewalk duration event should also be counted.",
	},
	[ POWER5_PME_PM_L2SA_RCST_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SA_RCST_DISP_FAIL_OTHER",
		.pme_code = 0x732e0,
		.pme_short_desc = "L2 slice A RC store dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a store failed for some reason other than Full or Collision conditions.  Rejected dispatches do not count because they have not yet been attempted.",
	},
	[ POWER5_PME_PM_L2SA_RCST_DISP ] = {
		.pme_name = "PM_L2SA_RCST_DISP",
		.pme_code = 0x702c0,
		.pme_short_desc = "L2 slice A RC store dispatch attempt",
		.pme_long_desc = "A Read/Claim dispatch for a Store was attempted.",
	},
	[ POWER5_PME_PM_SNOOP_RETRY_AB_COLLISION ] = {
		.pme_name = "PM_SNOOP_RETRY_AB_COLLISION",
		.pme_code = 0x735e6,
		.pme_short_desc = "Snoop retry due to a b collision",
		.pme_long_desc = "Snoop retry due to a b collision",
	},
	[ POWER5_PME_PM_FAB_PNtoVN_SIDECAR ] = {
		.pme_name = "PM_FAB_PNtoVN_SIDECAR",
		.pme_code = 0x733e7,
		.pme_short_desc = "PN to VN beat went to sidecar first",
		.pme_long_desc = "Fabric data beats that the base chip takes the inbound PN data and forwards it on to the outbound VN data bus after going into a sidecar first. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LSU_LMQ_S0_ALLOC ] = {
		.pme_name = "PM_LSU_LMQ_S0_ALLOC",
		.pme_code = 0xc30e6,
		.pme_short_desc = "LMQ slot 0 allocated",
		.pme_long_desc = "The first entry in the LMQ was allocated.",
	},
	[ POWER5_PME_PM_LSU0_REJECT_LMQ_FULL ] = {
		.pme_name = "PM_LSU0_REJECT_LMQ_FULL",
		.pme_code = 0xc60e1,
		.pme_short_desc = "LSU0 reject due to LMQ full or missed data coming",
		.pme_long_desc = "Total cycles the Load Store Unit 0 is busy rejecting instructions because the Load Miss Queue was full. The LMQ has eight entries.  If all eight entries are full, subsequent load instructions are rejected.",
	},
	[ POWER5_PME_PM_SNOOP_PW_RETRY_RQ ] = {
		.pme_name = "PM_SNOOP_PW_RETRY_RQ",
		.pme_code = 0x707c6,
		.pme_short_desc = "Snoop partial-write retry due to collision with active read queue",
		.pme_long_desc = "A snoop request for a partial write to memory was retried because it matched the cache line of an active read.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_DTLB_REF ] = {
		.pme_name = "PM_DTLB_REF",
		.pme_code = 0x2c4090,
		.pme_short_desc = "Data TLB references",
		.pme_long_desc = "Total number of Data TLB references for all page sizes. Page size is determined at TLB reload time.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L3 ] = {
		.pme_name = "PM_PTEG_FROM_L3",
		.pme_code = 0x18308e,
		.pme_short_desc = "PTEG loaded from L3",
		.pme_long_desc = "A Page Table Entry was loaded into the TLB from the local L3 due to a demand load.",
	},
	[ POWER5_PME_PM_FAB_M1toVNorNN_SIDECAR_EMPTY ] = {
		.pme_name = "PM_FAB_M1toVNorNN_SIDECAR_EMPTY",
		.pme_code = 0x712c7,
		.pme_short_desc = "M1 to VN/NN sidecar empty",
		.pme_long_desc = "Fabric cycles when the Minus-1 jump sidecar (sidecars for mcm to mcm data transfer) is empty. The signal is delivered at FBC speed and the count must be scaled accordingly.",
	},
	[ POWER5_PME_PM_LSU_SRQ_EMPTY_CYC ] = {
		.pme_name = "PM_LSU_SRQ_EMPTY_CYC",
		.pme_code = 0x400015,
		.pme_short_desc = "Cycles SRQ empty",
		.pme_long_desc = "Cycles the Store Request Queue is empty",
	},
	[ POWER5_PME_PM_FPU1_STF ] = {
		.pme_name = "PM_FPU1_STF",
		.pme_code = 0x20e6,
		.pme_short_desc = "FPU1 executed store instruction",
		.pme_long_desc = "FPU1 has executed a Floating Point Store instruction.",
	},
	[ POWER5_PME_PM_LSU_LMQ_S0_VALID ] = {
		.pme_name = "PM_LSU_LMQ_S0_VALID",
		.pme_code = 0xc30e5,
		.pme_short_desc = "LMQ slot 0 valid",
		.pme_long_desc = "This signal is asserted every cycle when the first entry in the LMQ is valid. The LMQ had eight entries that are allocated FIFO",
	},
	[ POWER5_PME_PM_GCT_USAGE_00to59_CYC ] = {
		.pme_name = "PM_GCT_USAGE_00to59_CYC",
		.pme_code = 0x10001f,
		.pme_short_desc = "Cycles GCT less than 60% full",
		.pme_long_desc = "Cycles when the Global Completion Table has fewer than 60% of its slots used.  The GCT has 20 entries shared between threads.",
	},
	[ POWER5_PME_PM_DATA_FROM_L2MISS ] = {
		.pme_name = "PM_DATA_FROM_L2MISS",
		.pme_code = 0x3c309b,
		.pme_short_desc = "Data loaded missed L2",
		.pme_long_desc = "The processor's Data Cache was reloaded but not from the local L2.",
	},
	[ POWER5_PME_PM_GRP_DISP_BLK_SB_CYC ] = {
		.pme_name = "PM_GRP_DISP_BLK_SB_CYC",
		.pme_code = 0x130e1,
		.pme_short_desc = "Cycles group dispatch blocked by scoreboard",
		.pme_long_desc = "A scoreboard operation on a non-renamed resource has blocked dispatch.",
	},
	[ POWER5_PME_PM_FPU_FMOV_FEST ] = {
		.pme_name = "PM_FPU_FMOV_FEST",
		.pme_code = 0x301088,
		.pme_short_desc = "FPU executed FMOV or FEST instructions",
		.pme_long_desc = "The floating point unit has executed a move kind of instruction or one of the estimate instructions. This could be fmr*, fneg*, fabs*, fnabs* , fres* or frsqrte* where XYZ* means XYZ or XYZ.. Combined Unit 0 + Unit 1.",
	},
	[ POWER5_PME_PM_XER_MAP_FULL_CYC ] = {
		.pme_name = "PM_XER_MAP_FULL_CYC",
		.pme_code = 0x100c2,
		.pme_short_desc = "Cycles XER mapper full",
		.pme_long_desc = "The XER mapper cannot accept any more groups. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the mapper was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_FLUSH_SB ] = {
		.pme_name = "PM_FLUSH_SB",
		.pme_code = 0x330e2,
		.pme_short_desc = "Flush caused by scoreboard operation",
		.pme_long_desc = "This thread has been flushed at dispatch because its scoreboard bit is set indicating that a non-renamed resource is being updated. This allows the other thread to have more machine resources for it to make progress while this thread is stalled.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L375_SHR ] = {
		.pme_name = "PM_MRK_DATA_FROM_L375_SHR",
		.pme_code = 0x3c709e,
		.pme_short_desc = "Marked data loaded from L3.75 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (S) data from the L3 of a chip on a different module than this processor is located due to a marked load.",
	},
	[ POWER5_PME_PM_MRK_GRP_CMPL ] = {
		.pme_name = "PM_MRK_GRP_CMPL",
		.pme_code = 0x400013,
		.pme_short_desc = "Marked group completed",
		.pme_long_desc = "A group containing a sampled instruction completed.  Microcoded instructions that span multiple groups will generate this event once per group.",
	},
	[ POWER5_PME_PM_SUSPENDED ] = {
		.pme_name = "PM_SUSPENDED",
		.pme_code = 0x0,
		.pme_short_desc = "Suspended",
		.pme_long_desc = "The counter is suspended (does not count).",
	},
	[ POWER5_PME_PM_GRP_IC_MISS_BR_REDIR_NONSPEC ] = {
		.pme_name = "PM_GRP_IC_MISS_BR_REDIR_NONSPEC",
		.pme_code = 0x120e5,
		.pme_short_desc = "Group experienced non-speculative I cache miss or branch redirect",
		.pme_long_desc = "Group experienced non-speculative I cache miss or branch redirect",
	},
	[ POWER5_PME_PM_SNOOP_RD_RETRY_QFULL ] = {
		.pme_name = "PM_SNOOP_RD_RETRY_QFULL",
		.pme_code = 0x700c6,
		.pme_short_desc = "Snoop read retry due to read queue full",
		.pme_long_desc = "A snoop request for a read from memory was retried because the read queues were full.  This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_L3SB_MOD_INV ] = {
		.pme_name = "PM_L3SB_MOD_INV",
		.pme_code = 0x730e4,
		.pme_short_desc = "L3 slice B transition from modified to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is truly M in this L3 (i.e. L3 going M=>I).  Mu|Me are not included since they are formed due to a prev read op.  Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_DATA_FROM_L35_SHR ] = {
		.pme_name = "PM_DATA_FROM_L35_SHR",
		.pme_code = 0x1c309e,
		.pme_short_desc = "Data loaded from L3.5 shared",
		.pme_long_desc = "The processor's Data Cache was reloaded with shared (S) data from the L3 of a chip on the same module as this processor is located due to a demand load.",
	},
	[ POWER5_PME_PM_LD_MISS_L1_LSU1 ] = {
		.pme_name = "PM_LD_MISS_L1_LSU1",
		.pme_code = 0xc10c6,
		.pme_short_desc = "LSU1 L1 D cache load misses",
		.pme_long_desc = "Load references that miss the Level 1 Data cache, by unit 1.",
	},
	[ POWER5_PME_PM_STCX_FAIL ] = {
		.pme_name = "PM_STCX_FAIL",
		.pme_code = 0x820e1,
		.pme_short_desc = "STCX failed",
		.pme_long_desc = "A stcx (stwcx or stdcx) failed",
	},
	[ POWER5_PME_PM_DC_PREF_DST ] = {
		.pme_name = "PM_DC_PREF_DST",
		.pme_code = 0x830e6,
		.pme_short_desc = "DST (Data Stream Touch) stream start",
		.pme_long_desc = "A prefetch stream was started using the DST instruction.",
	},
	[ POWER5_PME_PM_GRP_DISP ] = {
		.pme_name = "PM_GRP_DISP",
		.pme_code = 0x200002,
		.pme_short_desc = "Group dispatches",
		.pme_long_desc = "A group was dispatched",
	},
	[ POWER5_PME_PM_L2SA_RCLD_DISP_FAIL_ADDR ] = {
		.pme_name = "PM_L2SA_RCLD_DISP_FAIL_ADDR",
		.pme_code = 0x711c0,
		.pme_short_desc = "L2 slice A RC load dispatch attempt failed due to address collision with RC/CO/SN/SQ",
		.pme_long_desc = "A Read/Claim dispatch for a load failed because of an address conflict.  Two RC machines will never both work on the same line or line in the same congruence class at the same time.",
	},
	[ POWER5_PME_PM_FPU0_FPSCR ] = {
		.pme_name = "PM_FPU0_FPSCR",
		.pme_code = 0x30e0,
		.pme_short_desc = "FPU0 executed FPSCR instruction",
		.pme_long_desc = "FPU0 has executed FPSCR move related instruction. This could be mtfsfi*, mtfsb0*, mtfsb1*, mffs*, mtfsf*, mcrsf* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_DATA_FROM_L2 ] = {
		.pme_name = "PM_DATA_FROM_L2",
		.pme_code = 0x1c3087,
		.pme_short_desc = "Data loaded from L2",
		.pme_long_desc = "The processor's Data Cache was reloaded from the local L2 due to a demand load.",
	},
	[ POWER5_PME_PM_FPU1_DENORM ] = {
		.pme_name = "PM_FPU1_DENORM",
		.pme_code = 0x20e4,
		.pme_short_desc = "FPU1 received denormalized data",
		.pme_long_desc = "FPU1 has encountered a denormalized operand.",
	},
	[ POWER5_PME_PM_FPU_1FLOP ] = {
		.pme_name = "PM_FPU_1FLOP",
		.pme_code = 0x100090,
		.pme_short_desc = "FPU executed one flop instruction",
		.pme_long_desc = "The floating point unit has executed an add, mult, sub, compare, fsel, fneg, fabs, fnabs, fres, or frsqrte kind of instruction.  These are single FLOP operations.",
	},
	[ POWER5_PME_PM_L2SC_RCLD_DISP_FAIL_OTHER ] = {
		.pme_name = "PM_L2SC_RCLD_DISP_FAIL_OTHER",
		.pme_code = 0x731e2,
		.pme_short_desc = "L2 slice C RC load dispatch attempt failed due to other reasons",
		.pme_long_desc = "A Read/Claim dispatch for a load failed for some reason other than Full or Collision conditions.",
	},
	[ POWER5_PME_PM_L2SC_RCST_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SC_RCST_DISP_FAIL_RC_FULL",
		.pme_code = 0x722e2,
		.pme_short_desc = "L2 slice C RC store dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_FPU0_FSQRT ] = {
		.pme_name = "PM_FPU0_FSQRT",
		.pme_code = 0xc2,
		.pme_short_desc = "FPU0 executed FSQRT instruction",
		.pme_long_desc = "FPU0 has executed a square root instruction. This could be fsqrt* where XYZ* means XYZ, XYZs, XYZ., XYZs.",
	},
	[ POWER5_PME_PM_LD_REF_L1 ] = {
		.pme_name = "PM_LD_REF_L1",
		.pme_code = 0x4c1090,
		.pme_short_desc = "L1 D cache load references",
		.pme_long_desc = "Load references to the Level 1 Data Cache. Combined unit 0 + 1.",
	},
	[ POWER5_PME_PM_INST_FROM_L1 ] = {
		.pme_name = "PM_INST_FROM_L1",
		.pme_code = 0x22208d,
		.pme_short_desc = "Instruction fetched from L1",
		.pme_long_desc = "An instruction fetch group was fetched from L1. Fetch Groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_TLBIE_HELD ] = {
		.pme_name = "PM_TLBIE_HELD",
		.pme_code = 0x130e4,
		.pme_short_desc = "TLBIE held at dispatch",
		.pme_long_desc = "Cycles a TLBIE instruction was held at dispatch.",
	},
	[ POWER5_PME_PM_DC_PREF_OUT_OF_STREAMS ] = {
		.pme_name = "PM_DC_PREF_OUT_OF_STREAMS",
		.pme_code = 0xc50c2,
		.pme_short_desc = "D cache out of prefetch streams",
		.pme_long_desc = "A new prefetch stream was detected but no more stream entries were available.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L25_MOD_CYC ] = {
		.pme_name = "PM_MRK_DATA_FROM_L25_MOD_CYC",
		.pme_code = 0x4c70a2,
		.pme_short_desc = "Marked load latency from L2.5 modified",
		.pme_long_desc = "Cycles a marked load waited for data from this level of the storage system.  Counting begins when a marked load misses the data cache and ends when the data is reloaded into the data cache.  To calculate average latency divide this count by the number of marked misses to the same level.",
	},
	[ POWER5_PME_PM_MRK_LSU1_FLUSH_SRQ ] = {
		.pme_name = "PM_MRK_LSU1_FLUSH_SRQ",
		.pme_code = 0x810c7,
		.pme_short_desc = "LSU1 marked SRQ lhs flushes",
		.pme_long_desc = "A marked store was flushed because younger load hits and older store that is already in the SRQ or in the same group.",
	},
	[ POWER5_PME_PM_MEM_RQ_DISP_Q0to3 ] = {
		.pme_name = "PM_MEM_RQ_DISP_Q0to3",
		.pme_code = 0x702c6,
		.pme_short_desc = "Memory read queue dispatched to queues 0-3",
		.pme_long_desc = "A memory operation was dispatched to read queue 0,1,2, or 3. This event is sent from the Memory Controller clock domain and must be scaled accordingly.",
	},
	[ POWER5_PME_PM_ST_REF_L1_LSU1 ] = {
		.pme_name = "PM_ST_REF_L1_LSU1",
		.pme_code = 0xc10c5,
		.pme_short_desc = "LSU1 L1 D cache store references",
		.pme_long_desc = "Store references to the Data Cache by LSU1.",
	},
	[ POWER5_PME_PM_MRK_LD_MISS_L1 ] = {
		.pme_name = "PM_MRK_LD_MISS_L1",
		.pme_code = 0x182088,
		.pme_short_desc = "Marked L1 D cache load misses",
		.pme_long_desc = "Marked L1 D cache load misses",
	},
	[ POWER5_PME_PM_L1_WRITE_CYC ] = {
		.pme_name = "PM_L1_WRITE_CYC",
		.pme_code = 0x230e7,
		.pme_short_desc = "Cycles writing to instruction L1",
		.pme_long_desc = "Cycles that a cache line was written to the instruction cache.",
	},
	[ POWER5_PME_PM_L2SC_ST_REQ ] = {
		.pme_name = "PM_L2SC_ST_REQ",
		.pme_code = 0x723e2,
		.pme_short_desc = "L2 slice C store requests",
		.pme_long_desc = "A store request as seen at the L2 directory has been made from the core. Stores are counted after gathering in the L2 store queues. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_CMPLU_STALL_FDIV ] = {
		.pme_name = "PM_CMPLU_STALL_FDIV",
		.pme_code = 0x21109b,
		.pme_short_desc = "Completion stall caused by FDIV or FQRT instruction",
		.pme_long_desc = "Following a completion stall (any period when no groups completed) the last instruction to finish before completion resumes was a floating point divide or square root instruction. This is a subset of PM_CMPLU_STALL_FPU.",
	},
	[ POWER5_PME_PM_THRD_SEL_OVER_CLB_EMPTY ] = {
		.pme_name = "PM_THRD_SEL_OVER_CLB_EMPTY",
		.pme_code = 0x410c2,
		.pme_short_desc = "Thread selection overrides caused by CLB empty",
		.pme_long_desc = "Thread selection was overridden because one thread's CLB was empty.",
	},
	[ POWER5_PME_PM_BR_MPRED_CR ] = {
		.pme_name = "PM_BR_MPRED_CR",
		.pme_code = 0x230e5,
		.pme_short_desc = "Branch mispredictions due to CR bit setting",
		.pme_long_desc = "A conditional branch instruction was incorrectly predicted as taken or not taken.  The branch execution unit detects a branch mispredict because the CR value is opposite of the predicted value. This will result in a branch redirect flush if not overfidden by a flush of an older instruction.",
	},
	[ POWER5_PME_PM_L3SB_MOD_TAG ] = {
		.pme_name = "PM_L3SB_MOD_TAG",
		.pme_code = 0x720e4,
		.pme_short_desc = "L3 slice B transition from modified to TAG",
		.pme_long_desc = "L3 snooper detects someone doing a read to a line that is truly M in this L3(i.e. L3 going M->T or M->I(go_Mu case); Mu|Me are not included since they are formed due to a prev read op).  Tx is not included since it is considered shared at this point.",
	},
	[ POWER5_PME_PM_MRK_DATA_FROM_L2MISS ] = {
		.pme_name = "PM_MRK_DATA_FROM_L2MISS",
		.pme_code = 0x3c709b,
		.pme_short_desc = "Marked data loaded missed L2",
		.pme_long_desc = "DL1 was reloaded from beyond L2 due to a marked demand load.",
	},
	[ POWER5_PME_PM_LSU_REJECT_SRQ ] = {
		.pme_name = "PM_LSU_REJECT_SRQ",
		.pme_code = 0x1c6088,
		.pme_short_desc = "LSU SRQ lhs rejects",
		.pme_long_desc = "Total cycles the Load Store Unit is busy rejecting instructions because of Load Hit Store conditions.  Loads are rejected when data is needed from a previous store instruction but store forwarding is not possible because the data is not fully contained in the Store Data Queue or is not yet available in the Store Data Queue.  Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_LD_MISS_L1 ] = {
		.pme_name = "PM_LD_MISS_L1",
		.pme_code = 0x3c1088,
		.pme_short_desc = "L1 D cache load misses",
		.pme_long_desc = "Load references that miss the Level 1 Data cache. Combined unit 0 + 1.",
	},
	[ POWER5_PME_PM_INST_FROM_PREF ] = {
		.pme_name = "PM_INST_FROM_PREF",
		.pme_code = 0x32208d,
		.pme_short_desc = "Instruction fetched from prefetch",
		.pme_long_desc = "An instruction fetch group was fetched from the prefetch buffer. Fetch groups can contain up to 8 instructions",
	},
	[ POWER5_PME_PM_DC_INV_L2 ] = {
		.pme_name = "PM_DC_INV_L2",
		.pme_code = 0xc10c7,
		.pme_short_desc = "L1 D cache entries invalidated from L2",
		.pme_long_desc = "A dcache invalidated was received from the L2 because a line in L2 was castout.",
	},
	[ POWER5_PME_PM_STCX_PASS ] = {
		.pme_name = "PM_STCX_PASS",
		.pme_code = 0x820e5,
		.pme_short_desc = "Stcx passes",
		.pme_long_desc = "A stcx (stwcx or stdcx) instruction was successful",
	},
	[ POWER5_PME_PM_LSU_SRQ_FULL_CYC ] = {
		.pme_name = "PM_LSU_SRQ_FULL_CYC",
		.pme_code = 0x110c3,
		.pme_short_desc = "Cycles SRQ full",
		.pme_long_desc = "Cycles the Store Request Queue is full.",
	},
	[ POWER5_PME_PM_FPU_FIN ] = {
		.pme_name = "PM_FPU_FIN",
		.pme_code = 0x401088,
		.pme_short_desc = "FPU produced a result",
		.pme_long_desc = "FPU finished, produced a result.  This only indicates finish,  not completion. Combined Unit 0 + Unit 1.  Floating Point Stores are included in this count but not Floating Point Loads., , , XYZs",
	},
	[ POWER5_PME_PM_L2SA_SHR_MOD ] = {
		.pme_name = "PM_L2SA_SHR_MOD",
		.pme_code = 0x700c0,
		.pme_short_desc = "L2 slice A transition from shared to modified",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from Shared (Shared, Shared L , or Tagged) to the Modified state. This transition was caused by a store from either of the two local CPUs to a cache line in any of the Shared states. The event is provided on each of the three slices A, B, and C. ",
	},
	[ POWER5_PME_PM_LSU_SRQ_STFWD ] = {
		.pme_name = "PM_LSU_SRQ_STFWD",
		.pme_code = 0x1c2088,
		.pme_short_desc = "SRQ store forwarded",
		.pme_long_desc = "Data from a store instruction was forwarded to a load.  A load that misses L1 but becomes a store forward is treated as a load miss and it causes the DL1 load miss event to be counted.  It does not go into the LMQ. If a load that hits L1 but becomes a store forward, then it's not treated as a load miss. Combined Unit 0 + 1.",
	},
	[ POWER5_PME_PM_0INST_CLB_CYC ] = {
		.pme_name = "PM_0INST_CLB_CYC",
		.pme_code = 0x400c0,
		.pme_short_desc = "Cycles no instructions in CLB",
		.pme_long_desc = "The cache line buffer (CLB) is a 6-deep, 4-wide instruction buffer. Fullness is reported on a cycle basis with each event representing the number of cycles the CLB had the corresponding number of entries occupied.  These events give a real time history of the number of instruction buffers used, but not the number of PowerPC instructions within those buffers.  Each thread has its own set of CLB; these events are thread specific.",
	},
	[ POWER5_PME_PM_FXU0_FIN ] = {
		.pme_name = "PM_FXU0_FIN",
		.pme_code = 0x130e2,
		.pme_short_desc = "FXU0 produced a result",
		.pme_long_desc = "The Fixed Point unit 0 finished an instruction and produced a result.  Instructions that finish may not necessary complete.",
	},
	[ POWER5_PME_PM_L2SB_RCST_DISP_FAIL_RC_FULL ] = {
		.pme_name = "PM_L2SB_RCST_DISP_FAIL_RC_FULL",
		.pme_code = 0x722e1,
		.pme_short_desc = "L2 slice B RC store dispatch attempt failed due to all RC full",
		.pme_long_desc = "A Read/Claim dispatch for a store failed because all RC machines are busy.",
	},
	[ POWER5_PME_PM_THRD_GRP_CMPL_BOTH_CYC ] = {
		.pme_name = "PM_THRD_GRP_CMPL_BOTH_CYC",
		.pme_code = 0x200013,
		.pme_short_desc = "Cycles group completed by both threads",
		.pme_long_desc = "Cycles that both threads completed.",
	},
	[ POWER5_PME_PM_PMC5_OVERFLOW ] = {
		.pme_name = "PM_PMC5_OVERFLOW",
		.pme_code = 0x10001a,
		.pme_short_desc = "PMC5 Overflow",
		.pme_long_desc = "Overflows from PMC5 are counted.  This effectively widens the PMC. The Overflow from the original PMC will not trigger an exception even if the PMU is configured to generate exceptions on overflow.",
	},
	[ POWER5_PME_PM_FPU0_FDIV ] = {
		.pme_name = "PM_FPU0_FDIV",
		.pme_code = 0xc0,
		.pme_short_desc = "FPU0 executed FDIV instruction",
		.pme_long_desc = "FPU0 has executed a divide instruction. This could be fdiv, fdivs, fdiv. fdivs.",
	},
	[ POWER5_PME_PM_PTEG_FROM_L375_SHR ] = {
		.pme_name = "PM_PTEG_FROM_L375_SHR",
		.pme_code = 0x38309e,
		.pme_short_desc = "PTEG loaded from L3.75 shared",
		.pme_long_desc = "A Page Table Entry  was loaded into the TLB with shared (S) data from the L3 of a chip on a different module than this processor is located, due to a demand load.",
	},
	[ POWER5_PME_PM_LD_REF_L1_LSU1 ] = {
		.pme_name = "PM_LD_REF_L1_LSU1",
		.pme_code = 0xc10c4,
		.pme_short_desc = "LSU1 L1 D cache load references",
		.pme_long_desc = "Load references to Level 1 Data Cache, by unit 1.",
	},
	[ POWER5_PME_PM_L2SA_RC_DISP_FAIL_CO_BUSY ] = {
		.pme_name = "PM_L2SA_RC_DISP_FAIL_CO_BUSY",
		.pme_code = 0x703c0,
		.pme_short_desc = "L2 slice A RC dispatch attempt failed due to RC/CO pair chosen was miss and CO already busy",
		.pme_long_desc = "A Read/Claim  Dispatch was rejected at dispatch because the Castout Machine was busy.  In the case of an RC starting up on a miss and the victim is valid, the CO machine must be available for the RC to process the access. If the CO is still busy working on an old castout, then the RC must not-ack the access if it is a miss(re-issued by the CIU). If it is a miss and the CO is available to process the castout, the RC will accept the access. Once the RC has finished, it can restart and process new accesses that result in a hit (or miss that doesn't need a CO) even though the CO is still processing a castout from a previous access.",
	},
	[ POWER5_PME_PM_HV_CYC ] = {
		.pme_name = "PM_HV_CYC",
		.pme_code = 0x20000b,
		.pme_short_desc = "Hypervisor Cycles",
		.pme_long_desc = "Cycles when the processor is executing in Hypervisor (MSR[HV] = 1 and MSR[PR]=0)",
	},
	[ POWER5_PME_PM_THRD_PRIO_DIFF_0_CYC ] = {
		.pme_name = "PM_THRD_PRIO_DIFF_0_CYC",
		.pme_code = 0x430e3,
		.pme_short_desc = "Cycles no thread priority difference",
		.pme_long_desc = "Cycles when this thread's priority is equal to the other thread's priority.",
	},
	[ POWER5_PME_PM_LR_CTR_MAP_FULL_CYC ] = {
		.pme_name = "PM_LR_CTR_MAP_FULL_CYC",
		.pme_code = 0x100c6,
		.pme_short_desc = "Cycles LR/CTR mapper full",
		.pme_long_desc = "The LR/CTR mapper cannot accept any more groups. This condition will prevent dispatch groups from being dispatched.  This event only indicates that the mapper was full, not that dispatch was prevented.",
	},
	[ POWER5_PME_PM_L3SB_SHR_INV ] = {
		.pme_name = "PM_L3SB_SHR_INV",
		.pme_code = 0x710c4,
		.pme_short_desc = "L3 slice B transition from shared to invalid",
		.pme_long_desc = "L3 snooper detects someone doing a store to a line that is Sx in this L3(i.e. invalidate hit SX and dispatched).",
	},
	[ POWER5_PME_PM_DATA_FROM_RMEM ] = {
		.pme_name = "PM_DATA_FROM_RMEM",
		.pme_code = 0x1c30a1,
		.pme_short_desc = "Data loaded from remote memory",
		.pme_long_desc = "The processor's Data Cache was reloaded from memory attached to a different module than this proccessor is located on.",
	},
	[ POWER5_PME_PM_DATA_FROM_L275_MOD ] = {
		.pme_name = "PM_DATA_FROM_L275_MOD",
		.pme_code = 0x1c30a3,
		.pme_short_desc = "Data loaded from L2.75 modified",
		.pme_long_desc = "The processor's Data Cache was reloaded with modified (M) data from the L2 on a different module than this processor is located due to a demand load. ",
	},
	[ POWER5_PME_PM_LSU0_REJECT_SRQ ] = {
		.pme_name = "PM_LSU0_REJECT_SRQ",
		.pme_code = 0xc60e0,
		.pme_short_desc = "LSU0 SRQ lhs rejects",
		.pme_long_desc = "Total cycles the Load Store Unit 0 is busy rejecting instructions because of Load Hit Store conditions.  Loads are rejected when data is needed from a previous store instruction but store forwarding is not possible because the data is not fully contained in the Store Data Queue or is not yet available in the Store Data Queue.",
	},
	[ POWER5_PME_PM_LSU1_DERAT_MISS ] = {
		.pme_name = "PM_LSU1_DERAT_MISS",
		.pme_code = 0x800c6,
		.pme_short_desc = "LSU1 DERAT misses",
		.pme_long_desc = "A data request (load or store) from LSU Unit 1 missed the ERAT and resulted in an ERAT reload. Multiple instructions may miss the ERAT entry for the same 4K page, but only one reload will occur.",
	},
	[ POWER5_PME_PM_MRK_LSU_FIN ] = {
		.pme_name = "PM_MRK_LSU_FIN",
		.pme_code = 0x400014,
		.pme_short_desc = "Marked instruction LSU processing finished",
		.pme_long_desc = "One of the Load/Store Units finished a marked instruction. Instructions that finish may not necessary complete",
	},
	[ POWER5_PME_PM_DTLB_MISS_16M ] = {
		.pme_name = "PM_DTLB_MISS_16M",
		.pme_code = 0xc40c4,
		.pme_short_desc = "Data TLB miss for 16M page",
		.pme_long_desc = "Data TLB references to 16MB pages that missed the TLB. Page size is determined at TLB reload time.",
	},
	[ POWER5_PME_PM_LSU0_FLUSH_UST ] = {
		.pme_name = "PM_LSU0_FLUSH_UST",
		.pme_code = 0xc00c1,
		.pme_short_desc = "LSU0 unaligned store flushes",
		.pme_long_desc = "A store was flushed from unit 0 because it was unaligned (crossed a 4K boundary).",
	},
	[ POWER5_PME_PM_L2SC_MOD_TAG ] = {
		.pme_name = "PM_L2SC_MOD_TAG",
		.pme_code = 0x720e2,
		.pme_short_desc = "L2 slice C transition from modified to tagged",
		.pme_long_desc = "A cache line in the local L2 directory made a state transition from the Modified state to the Tagged state. This transition was caused by a read snoop request that hit against a modified entry in the local L2. The event is provided on each of the three slices A, B, and C.",
	},
	[ POWER5_PME_PM_L2SB_RC_DISP_FAIL_CO_BUSY ] = {
		.pme_name = "PM_L2SB_RC_DISP_FAIL_CO_BUSY",
		.pme_code = 0x703c1,
		.pme_short_desc = "L2 slice B RC dispatch attempt failed due to RC/CO pair chosen was miss and CO already busy",
		.pme_long_desc = "A Read/Claim  Dispatch was rejected at dispatch because the Castout Machine was busy.  In the case of an RC starting up on a miss and the victim is valid, the CO machine must be available for the RC to process the access. If the CO is still busy working on an old castout, then the RC must not-ack the access if it is a miss(re-issued by the CIU). If it is a miss and the CO is available to process the castout, the RC will accept the access. Once the RC has finished, it can restart and process new accesses that result in a hit (or miss that doesn't need a CO) even though the CO is still processing a castout from a previous access.",
	}
};
#endif

