/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertRetrievalRequest
implements JSONSerializer {
    protected CertId certId;
    public RequestId requestId;

    public CertRetrievalRequest() {
    }

    public CertRetrievalRequest(CertId certId) {
        this.certId = certId;
    }

    public CertId getCertId() {
        return this.certId;
    }

    protected void setCertId(CertId certId) {
        this.certId = certId;
    }

    protected void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    public Element toDOM(Document document) {
        Element issuerDNElement;
        Element requestElement = document.createElement("CertRetrievalRequest");
        if (this.certId != null) {
            issuerDNElement = document.createElement("certId");
            issuerDNElement.appendChild(document.createTextNode(this.certId.toHexString()));
            requestElement.appendChild(issuerDNElement);
        }
        if (this.requestId != null) {
            issuerDNElement = document.createElement("requestId");
            issuerDNElement.appendChild(document.createTextNode(this.requestId.toString()));
            requestElement.appendChild(issuerDNElement);
        }
        return requestElement;
    }

    public static CertRetrievalRequest fromDOM(Element requestElement) {
        NodeList requestIdList;
        CertRetrievalRequest request = new CertRetrievalRequest();
        NodeList certIdList = requestElement.getElementsByTagName("certId");
        if (certIdList.getLength() > 0) {
            String value = certIdList.item(0).getTextContent();
            request.setCertId(new CertId(value));
        }
        if ((requestIdList = requestElement.getElementsByTagName("requestId")).getLength() > 0) {
            String value = requestIdList.item(0).getTextContent();
            request.setRequestId(new RequestId(value));
        }
        return request;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element requestElement = this.toDOM(document);
        document.appendChild(requestElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CertRetrievalRequest fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element requestElement = document.getDocumentElement();
        return CertRetrievalRequest.fromDOM(requestElement);
    }

    public int hashCode() {
        return Objects.hash(this.certId, this.requestId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertRetrievalRequest other = (CertRetrievalRequest)obj;
        return Objects.equals(this.certId, other.certId) && Objects.equals(this.requestId, other.requestId);
    }
}

