/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.OCSPResponseStatus;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class OCSPResponse
implements ASN1Value {
    private OCSPResponseStatus responseStatus = null;
    private ResponseBytes responseBytes = null;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OCSPResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public ResponseBytes getResponseBytes() {
        return this.responseBytes;
    }

    public OCSPResponse(OCSPResponseStatus responseStatus, ResponseBytes responseBytes) {
        this.responseStatus = responseStatus;
        this.sequence.addElement((ASN1Value)responseStatus);
        this.responseBytes = responseBytes;
        this.sequence.addElement((ASN1Value)new EXPLICIT(Tag.get((long)0L), (ASN1Value)responseBytes));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OCSPResponseStatus.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new ResponseBytes.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            OCSPResponseStatus rs = (OCSPResponseStatus)seq.elementAt(0);
            ResponseBytes rb = null;
            ASN1Value val = seq.elementAt(1);
            if (val instanceof EXPLICIT) {
                EXPLICIT exp = (EXPLICIT)val;
                rb = (ResponseBytes)exp.getContent();
            } else {
                rb = (ResponseBytes)val;
            }
            return new OCSPResponse(rs, rb);
        }
    }
}

