/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMEMetadata {
    private String termsOfService;
    private String website;
    private String[] caaIdentities;
    private Boolean externalAccountRequired;

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public void setTermsOfService(String termsOfService) {
        this.termsOfService = termsOfService;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String[] getCaaIdentities() {
        return this.caaIdentities;
    }

    public void setCaaIdentities(String[] caaIdentities) {
        this.caaIdentities = caaIdentities;
    }

    public Boolean getExternalAccountRequired() {
        return this.externalAccountRequired;
    }

    public void setExternalAccountRequired(Boolean externalAccountRequired) {
        this.externalAccountRequired = externalAccountRequired;
    }

    public String toJSON() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static ACMEMetadata fromJSON(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (ACMEMetadata)mapper.readValue(json, ACMEMetadata.class);
    }

    public static ACMEMetadata fromProperties(Properties props) throws Exception {
        ACMEMetadata metadata = new ACMEMetadata();
        metadata.setTermsOfService(props.getProperty("termsOfService"));
        metadata.setWebsite(props.getProperty("website"));
        String[] caaIdentities = props.getProperty("caaIdentities", "").split("\\s*,\\s*");
        metadata.setCaaIdentities(caaIdentities);
        String externalAccountRequired = props.getProperty("externalAccountRequired");
        metadata.setExternalAccountRequired(externalAccountRequired == null ? null : Boolean.valueOf(externalAccountRequired));
        return metadata;
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

