/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.main.TPSBuffer;

public class CreateObjectAPDU
extends APDU {
    public CreateObjectAPDU(byte[] object_id, byte[] permissions, int len) {
        if (object_id.length != 4) {
            return;
        }
        if (permissions.length != 6) {
            return;
        }
        this.setCLA((byte)-124);
        this.setINS((byte)90);
        this.setP1((byte)0);
        this.setP2((byte)0);
        this.data = new TPSBuffer();
        this.data.add(object_id[0]);
        this.data.add(object_id[1]);
        this.data.add(object_id[2]);
        this.data.add(object_id[3]);
        this.data.add((byte)(len >> 24));
        this.data.add((byte)(len >> 16 & 0xFF));
        this.data.add((byte)(len >> 8 & 0xFF));
        this.data.add((byte)(len & 0xFF));
        this.data.add(permissions[0]);
        this.data.add(permissions[1]);
        this.data.add(permissions[2]);
        this.data.add(permissions[3]);
        this.data.add(permissions[4]);
        this.data.add(permissions[5]);
    }

    @Override
    public APDU.Type getType() {
        return APDU.Type.APDU_CREATE_OBJECT;
    }

    public static void main(String[] args) {
        byte[] object_id = new byte[]{1, 2, 3, 4};
        byte[] permisisons = new byte[]{1, 2, 3, 4, 5, 6};
        CreateObjectAPDU apdu = new CreateObjectAPDU(object_id, permisisons, 56);
        if (apdu != null) {
            apdu.dump();
        }
    }
}

