/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMECertificate;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.database.ACMEDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDatabase
extends ACMEDatabase {
    public static Logger logger = LoggerFactory.getLogger(InMemoryDatabase.class);
    private Map<String, ACMENonce> nonces = new ConcurrentHashMap<String, ACMENonce>();
    private Map<String, ACMEAccount> accounts = new ConcurrentHashMap<String, ACMEAccount>();
    private Map<String, ACMEOrder> orders = new ConcurrentHashMap<String, ACMEOrder>();
    private Map<String, ACMEAuthorization> authorizations = new ConcurrentHashMap<String, ACMEAuthorization>();
    private Map<String, ACMECertificate> certificates = new ConcurrentHashMap<String, ACMECertificate>();

    @Override
    public void init() throws Exception {
        logger.info("Initializing in-memory database");
    }

    @Override
    public void addNonce(ACMENonce nonce) throws Exception {
        this.nonces.put(nonce.getID(), nonce);
    }

    @Override
    public ACMENonce removeNonce(String nonceID) throws Exception {
        return this.nonces.remove(nonceID);
    }

    @Override
    public void removeExpiredNonces(Date currentTime) throws Exception {
        this.nonces.values().removeIf(n -> !currentTime.before(n.getExpirationTime()));
    }

    @Override
    public ACMEAccount getAccount(String accountID) throws Exception {
        return this.accounts.get(accountID);
    }

    @Override
    public void addAccount(ACMEAccount account) throws Exception {
        this.accounts.put(account.getID(), account);
    }

    @Override
    public void updateAccount(ACMEAccount account) throws Exception {
    }

    @Override
    public ACMEOrder getOrder(String orderID) throws Exception {
        return this.orders.get(orderID);
    }

    @Override
    public Collection<ACMEOrder> getOrdersByAccount(String accountID) throws Exception {
        ArrayList<ACMEOrder> results = new ArrayList<ACMEOrder>();
        for (ACMEOrder order : this.orders.values()) {
            if (!order.getAccountID().equals(accountID)) continue;
            results.add(order);
        }
        return results;
    }

    @Override
    public Collection<ACMEOrder> getOrdersByAuthorizationAndStatus(String authzID, String status) throws Exception {
        ArrayList<ACMEOrder> results = new ArrayList<ACMEOrder>();
        block0: for (ACMEOrder order : this.orders.values()) {
            if (!order.getStatus().equals(status) || order.getAuthzIDs() == null) continue;
            for (String orderAuthzID : order.getAuthzIDs()) {
                if (!orderAuthzID.equals(authzID)) continue;
                results.add(order);
                continue block0;
            }
        }
        return results;
    }

    @Override
    public ACMEOrder getOrderByCertificate(String certID) throws Exception {
        for (ACMEOrder order : this.orders.values()) {
            if (!certID.equals(order.getCertID())) continue;
            return order;
        }
        return null;
    }

    @Override
    public void addOrder(ACMEOrder order) throws Exception {
        this.orders.put(order.getID(), order);
    }

    @Override
    public void updateOrder(ACMEOrder order) throws Exception {
        this.orders.put(order.getID(), order);
    }

    @Override
    public void removeExpiredOrders(Date currentTime) throws Exception {
        this.orders.values().removeIf(n -> n.getExpirationTime() != null && !currentTime.before(n.getExpirationTime()));
    }

    @Override
    public ACMEAuthorization getAuthorization(String authzID) throws Exception {
        return this.authorizations.get(authzID);
    }

    @Override
    public ACMEAuthorization getAuthorizationByChallenge(String challengeID) throws Exception {
        for (ACMEAuthorization authorization : this.authorizations.values()) {
            if (authorization.getChallenge(challengeID) == null) continue;
            return authorization;
        }
        return null;
    }

    @Override
    public Collection<ACMEAuthorization> getRevocationAuthorizations(String accountID, Date time) throws Exception {
        ArrayList<ACMEAuthorization> results = new ArrayList<ACMEAuthorization>();
        for (ACMEAuthorization authorization : this.authorizations.values()) {
            if (!authorization.getAccountID().equals(accountID)) continue;
            String status = authorization.getStatus();
            if (!"valid".equals(status)) {
                logger.info("Authorization " + authorization.getID() + " is " + status);
                continue;
            }
            Date expirationTime = authorization.getExpirationTime();
            if (expirationTime != null && !expirationTime.after(time)) {
                logger.info("Authorization " + authorization.getID() + " has expired");
                continue;
            }
            results.add(authorization);
        }
        return results;
    }

    @Override
    public boolean hasRevocationAuthorization(String accountID, Date time, ACMEIdentifier identifier) throws Exception {
        for (ACMEAuthorization authorization : this.authorizations.values()) {
            if (!authorization.getAccountID().equals(accountID)) continue;
            String status = authorization.getStatus();
            if (!"valid".equals(status)) {
                logger.info("Authorization " + authorization.getID() + " is " + status);
                continue;
            }
            Date expirationTime = authorization.getExpirationTime();
            if (expirationTime != null && !expirationTime.after(time)) {
                logger.info("Authorization " + authorization.getID() + " has expired");
                continue;
            }
            ACMEIdentifier authzIdentifier = authorization.getIdentifier();
            String type = authzIdentifier.getType();
            if ("dns".equals(type) && authorization.getWildcard().booleanValue()) {
                String value = "*." + authzIdentifier.getValue();
                authzIdentifier = new ACMEIdentifier();
                authzIdentifier.setType(type);
                authzIdentifier.setValue(value);
            }
            if (!authzIdentifier.equals((Object)identifier)) {
                logger.info("Authorization " + authorization.getID() + " does not match " + identifier);
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addAuthorization(ACMEAuthorization authorization) throws Exception {
        this.authorizations.put(authorization.getID(), authorization);
    }

    @Override
    public void updateAuthorization(ACMEAuthorization authorization) throws Exception {
        this.authorizations.put(authorization.getID(), authorization);
    }

    @Override
    public void removeExpiredAuthorizations(Date currentTime) throws Exception {
        this.authorizations.values().removeIf(n -> n.getExpirationTime() != null && !currentTime.before(n.getExpirationTime()));
    }

    @Override
    public ACMECertificate getCertificate(String certID) throws Exception {
        return this.certificates.get(certID);
    }

    @Override
    public void addCertificate(String certID, ACMECertificate certificate) throws Exception {
        this.certificates.put(certID, certificate);
    }

    @Override
    public void removeExpiredCertificates(Date currentTime) throws Exception {
        this.certificates.values().removeIf(n -> n.getExpirationTime() != null && !currentTime.before(n.getExpirationTime()));
    }
}

